/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.plugins.structure;

import com.inet.annotations.InternalApi;
import com.inet.cache.internal.HardDiskExternalDataWriterFactory;
import com.inet.classloader.LoaderUtils;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigurationManager;
import com.inet.config.structure.ConfigStructure;
import com.inet.config.structure.model.BooleanConfigProperty;
import com.inet.config.structure.model.ConfigAction;
import com.inet.config.structure.model.ConfigCategory;
import com.inet.config.structure.model.ConfigCondition;
import com.inet.config.structure.model.ConfigConditionAction;
import com.inet.config.structure.model.ConfigGroup;
import com.inet.config.structure.model.ConfigProperty;
import com.inet.config.structure.model.ConfigPropertyGroup;
import com.inet.config.structure.model.ConfigValidationMsg;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.config.structure.model.UnitConfigProperty;
import com.inet.config.structure.provider.AbstractStructureProvider;
import com.inet.config.structure.provider.ConditionGenerator;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.config.structure.provider.ConfigValidator;
import com.inet.font.AllFontsFontProvider;
import com.inet.font.FontFamily;
import com.inet.lib.json.Json;
import com.inet.lib.util.Encryption;
import com.inet.lib.util.IOFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.LogManager;
import com.inet.plugin.ServerPluginManager;
import com.inet.report.BaseUtils;
import com.inet.report.PropertiesChecker;
import com.inet.report.ReportException;
import com.inet.report.cache.Cache;
import com.inet.report.config.util.RepoDatabaseValidator;
import com.inet.report.renderer.api.RendererFactory;
import com.inet.report.renderer.api.RendererFactoryManager;
import com.inet.report.renderer.doc.CellDistribution;
import jakarta.servlet.Filter;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

@InternalApi
public class ReportingStructureProvider
extends AbstractStructureProvider {
    public void addGroupsTo(@Nonnull Set<ConfigGroup> groups, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        groups.add(new ConfigGroup(300, "categorygroup.report", this.translate(settings, "categorygroup.report", new Object[0]), ((Object)((Object)this)).getClass().getResource("server_categorygroup_reports_48.png")));
    }

    public void addCategoriesTo(@Nonnull Set<ConfigCategory> categories, @Nonnull String groupKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        switch (groupKey) {
            case "categorygroup.report": {
                categories.add(new ConfigCategory(100, "category.font", this.translate(settings, "category.font", new Object[0]), "report-font"));
                categories.add(new ConfigCategory(200, "category.behavior", this.translate(settings, "category.behavior", new Object[0]), "report-behavior"));
                if (!advanced) break;
                categories.add(new ConfigCategory(300, "category.layout", this.translate(settings, "category.layout", new Object[0]), "report-layout"));
                categories.add(new ConfigCategory(400, "category.performance", this.translate(settings, "category.performance", new Object[0]), "report-performance"));
                categories.add(new ConfigCategory(500, "category.custom", this.translate(settings, "category.custom", new Object[0]), "report-customization"));
                categories.add(new ConfigCategory(600, "category.cache", this.translate(settings, "category.cache", new Object[0]), "report-cache-index"));
                categories.add(new ConfigCategory(700, "category.pdfExport", this.translate(settings, "category.pdfExport", new Object[0]), "report-export-pdf"));
                categories.add(new ConfigCategory(800, "category.postScriptExport", this.translate(settings, "category.postScriptExport", new Object[0]), "report-export-ps"));
                categories.add(new ConfigCategory(900, "category.richTextFormatExport", this.translate(settings, "category.richTextFormatExport", new Object[0]), "report-export-rtf"));
                categories.add(new ConfigCategory(1000, "category.msExcel", this.translate(settings, "category.msExcel", new Object[0]), "report-export-xls"));
                categories.add(new ConfigCategory(1100, "category.textExport", this.translate(settings, "category.textExport", new Object[0]), "report-export-txt"));
                break;
            }
            case "categorygroup.security": {
                if (!advanced) break;
                categories.add(new ConfigCategory(400, "category.reportLocations", this.translate(settings, "category.reportLocations", new Object[0]), "security-report-locations"));
                categories.add(new ConfigCategory(500, "category.urlParameter", this.translate(settings, "category.urlParameter", new Object[0]), "security-report-url-parameter"));
                break;
            }
        }
    }

    public URL getCategoryIcon(@Nonnull String categoryKey) {
        switch (categoryKey) {
            case "category.font": {
                return ((Object)((Object)this)).getClass().getResource("font_48.png");
            }
            case "category.layout": {
                return ((Object)((Object)this)).getClass().getResource("layout_48.png");
            }
            case "category.behavior": {
                return ((Object)((Object)this)).getClass().getResource("behavior_48.png");
            }
            case "category.performance": {
                return ((Object)((Object)this)).getClass().getResource("performance_48.png");
            }
            case "category.custom": {
                return ((Object)((Object)this)).getClass().getResource("custom_48.png");
            }
            case "category.cache": {
                return ((Object)((Object)this)).getClass().getResource("cache_48.png");
            }
            case "category.pdfExport": {
                return ((Object)((Object)this)).getClass().getResource("export_pdf_48.png");
            }
            case "category.postScriptExport": {
                return ((Object)((Object)this)).getClass().getResource("export_ps_48.png");
            }
            case "category.richTextFormatExport": {
                return ((Object)((Object)this)).getClass().getResource("export_rtf_48.png");
            }
            case "category.msExcel": {
                return ((Object)((Object)this)).getClass().getResource("export_xls_48.png");
            }
            case "category.textExport": {
                return ((Object)((Object)this)).getClass().getResource("export_txt_48.png");
            }
            case "category.reportLocations": {
                return ((Object)((Object)this)).getClass().getResource("reportLocation_48.png");
            }
            case "category.urlParameter": {
                return ((Object)((Object)this)).getClass().getResource("urlparam_48.png");
            }
        }
        return null;
    }

    public void addPropertyGroupsTo(@Nonnull Set<ConfigPropertyGroup> propertyGroups, @Nonnull String categoryKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        switch (categoryKey) {
            case "category.font": {
                propertyGroups.add(new ConfigPropertyGroup(100, "group.font"));
                break;
            }
            case "category.layout": {
                propertyGroups.add(new ConfigPropertyGroup(200, "group.layout"));
                break;
            }
            case "category.behavior": {
                propertyGroups.add(new ConfigPropertyGroup(100, "group.generalBehavior", this.translate(settings, "group.generalBehavior", new Object[0])));
                if (!advanced) break;
                propertyGroups.add(new ConfigPropertyGroup(200, "group.CompatibilitySettings", this.translate(settings, "group.CompatibilitySettings", new Object[0])));
                propertyGroups.add(new ConfigPropertyGroup(300, "group.ErrorHandling", this.translate(settings, "group.ErrorHandling", new Object[0])));
                break;
            }
            case "category.performance": {
                propertyGroups.add(new ConfigPropertyGroup(300, "group.performance.database", this.translate(settings, "group.performance.database", new Object[0])));
                propertyGroups.add(new ConfigPropertyGroup(400, "group.performance.report", this.translate(settings, "group.performance.report", new Object[0])));
                break;
            }
            case "category.custom": {
                propertyGroups.add(new ConfigPropertyGroup(100, "group.custom"));
                if (ServerPluginManager.getInstance().get(Collator.class).size() != 0) break;
                propertyGroups.add(new ConfigPropertyGroup(200, "group.collation", this.translate(settings, "group.collation", new Object[0])));
                break;
            }
            case "category.cache": {
                ConfigAction configAction;
                ConfigAction configAction2 = configAction = settings.getConfiguration() == ConfigurationManager.getInstance().getCurrent() ? new ConfigAction("action.clear.cache", this.translate(settings, "action.clear.cache", new Object[0])) : null;
                if (!ReportingStructureProvider.isDesigner()) {
                    propertyGroups.add(new ConfigPropertyGroup(100, "group.cache.report", this.translate(settings, "group.cache.report", new Object[0]), configAction));
                    propertyGroups.add(new ConfigPropertyGroup(200, "group.cache.db", this.translate(settings, "group.cache.db", new Object[0]), new ConfigAction("action.db.validate", this.translate(settings, "validate", new Object[0]))));
                    propertyGroups.add(new ConfigPropertyGroup(300, "group.cache.hd", this.translate(settings, "group.cache.hd", new Object[0])));
                }
                propertyGroups.add(new ConfigPropertyGroup(400, "group.cache.rowsource", this.translate(settings, "group.cache.rowsource", new Object[0])));
                break;
            }
            case "category.pdfExport": {
                propertyGroups.add(new ConfigPropertyGroup(100, "group.pdfExport"));
                propertyGroups.add(new ConfigPropertyGroup(200, "group.pdf.fontReplace", this.translate(settings, "group.pdf.fontReplace", new Object[0])));
                if (!settings.isPlus()) break;
                propertyGroups.add(new ConfigPropertyGroup(300, "group.pdfSigning", this.translate(settings, "group.pdfSigning", new Object[0]), new ConfigAction("action.pdf.keystroke", this.translate(settings, "validate", new Object[0]))));
                break;
            }
            case "category.postScriptExport": {
                propertyGroups.add(new ConfigPropertyGroup(100, "group.ps"));
                propertyGroups.add(new ConfigPropertyGroup(200, "group.fontmapping.ps", this.translate(settings, "group.fontmapping.ps", new Object[0])));
                break;
            }
            case "category.richTextFormatExport": {
                propertyGroups.add(new ConfigPropertyGroup(100, "group.fontmapping.rtf", this.translate(settings, "group.fontmapping.rtf", new Object[0])));
                break;
            }
            case "category.msExcel": {
                propertyGroups.add(new ConfigPropertyGroup(100, "group.fontmapping.xls", this.translate(settings, "group.fontmapping.xls", new Object[0])));
                propertyGroups.add(new ConfigPropertyGroup(200, "group.xls", this.translate(settings, "xls.cells", new Object[0])));
                break;
            }
            case "category.textExport": {
                propertyGroups.add(new ConfigPropertyGroup(100, "group.textExport"));
                break;
            }
            case "category.reportLocations": {
                propertyGroups.add(new ConfigPropertyGroup(100, "group.reportLocations"));
                propertyGroups.add(new ConfigPropertyGroup(200, "reportlocations.group.permitted", this.translate(settings, "reportlocations.group.permitted", new Object[0])));
                break;
            }
            case "category.urlParameter": {
                ConfigPropertyGroup configPropertyGroup = new ConfigPropertyGroup(100, "group.urlParameter.column1");
                configPropertyGroup.setColumnSet(ConfigPropertyGroup.COLUMN_SET.twoColumns);
                propertyGroups.add(configPropertyGroup);
                ConfigPropertyGroup configPropertyGroup2 = new ConfigPropertyGroup(200, "group.urlParameter.column2");
                configPropertyGroup2.setColumnSet(ConfigPropertyGroup.COLUMN_SET.twoColumns);
                propertyGroups.add(configPropertyGroup2);
                break;
            }
        }
    }

    public void addConditionsTo(@Nonnull List<ConfigConditionAction> actions, @Nonnull String categoryKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        ConditionGenerator conditionGenerator = new ConditionGenerator();
        switch (categoryKey) {
            case "category.behavior": {
                if (!advanced) break;
                ConfigCondition configCondition = conditionGenerator.createCondition().property(ConfigKey.TOLERATE_ERRORS).equals().value((Object)Boolean.FALSE);
                actions.add(conditionGenerator.enableActionFor(configCondition, ConfigKey.MAXIMUM_ERRORS));
                break;
            }
            case "category.performance": {
                ConfigCondition configCondition = conditionGenerator.createCondition().property(ConfigKey.METADATACACHE_ENABLED).equals().value((Object)Boolean.TRUE);
                actions.add(conditionGenerator.enableActionFor(configCondition, ConfigKey.METADATACACHE_TIMEOUT));
                break;
            }
            case "category.custom": {
                ConfigCondition configCondition = conditionGenerator.createCondition().property(ConfigKey.COLLATION_DEFAULTCOLLATION).equals().value((Object)Boolean.FALSE);
                actions.add(conditionGenerator.enableActionFor(configCondition, ConfigKey.COLLATION_LOCALE));
                actions.add(conditionGenerator.enableActionFor(configCondition, ConfigKey.COLLATION_STRENGTH));
                break;
            }
            case "category.cache": {
                ConfigCondition configCondition = conditionGenerator.createCondition().property(ConfigKey.CACHE_TYPE).equals().value((Object)"1");
                actions.add(conditionGenerator.visibleActionFor(configCondition, "group.cache.db"));
                ConfigCondition configCondition2 = conditionGenerator.createCondition().property(ConfigKey.CACHE_TYPE).equals().value((Object)"2");
                actions.add(conditionGenerator.visibleActionFor(configCondition2, "group.cache.hd"));
                ConfigCondition configCondition3 = conditionGenerator.createCondition().property(ConfigKey.ROWSOURCE_CACHE_ENABLED).equals().value((Object)Boolean.TRUE);
                actions.add(conditionGenerator.enableActionFor(configCondition3, ConfigKey.ROWSOURCE_CACHE_TIME_TO_LIVE));
                break;
            }
            case "category.pdfExport": {
                ConfigCondition configCondition;
                if (settings.isPlus()) {
                    configCondition = conditionGenerator.createCondition().property(ConfigKey.SIGN_PDF_ENABLED).equals().value((Object)Boolean.TRUE);
                    actions.add(conditionGenerator.enableActionFor(configCondition, ConfigKey.SIGN_KEYSTORE_TYPE));
                    actions.add(conditionGenerator.enableActionFor(configCondition, ConfigKey.SIGN_KEYSTORE_FILE));
                    actions.add(conditionGenerator.enableActionFor(configCondition, ConfigKey.SIGN_KEYSTORE_PASSWORD));
                    actions.add(conditionGenerator.enableActionFor(configCondition, ConfigKey.SIGN_KEY_NAME));
                    actions.add(conditionGenerator.enableActionFor(configCondition, ConfigKey.SIGN_KEY_PASSWORD));
                    actions.add(conditionGenerator.enableActionFor(configCondition, "action.pdf.keystroke"));
                }
                configCondition = conditionGenerator.createCondition().property(ConfigKey.PDF_REPLACE_NOT_EMBEDDED_FONTS).equals().value((Object)Boolean.TRUE);
                actions.add(conditionGenerator.enableActionFor(configCondition, ConfigKey.PDF_SANSSERIF_FONT_LIST));
                actions.add(conditionGenerator.enableActionFor(configCondition, ConfigKey.PDF_SERIF_FONT_LIST));
                actions.add(conditionGenerator.enableActionFor(configCondition, ConfigKey.PDF_MONOSPACED_FONT_LIST));
                break;
            }
            case "category.reportLocations": {
                ConfigCondition configCondition = conditionGenerator.createCondition().property(ConfigKey.REPOSITORY_ENABLED).equals().value((Object)Boolean.TRUE);
                actions.add(conditionGenerator.enableActionFor(configCondition, ConfigKey.FILELOCATION_ENABLED));
                actions.add(conditionGenerator.enableActionFor(configCondition, ConfigKey.JNDILOCATION_ENABLED));
                if (settings.isPlus() && ServerPluginManager.getInstance().isPluginLoaded("drive")) {
                    actions.add(conditionGenerator.enableActionFor(configCondition, ConfigKey.REPOLOCATION_ENABLED));
                }
                actions.add(conditionGenerator.enableActionFor(configCondition, ConfigKey.LOCALHOST_ENABLED));
                actions.add(conditionGenerator.enableActionFor(configCondition, ConfigKey.REPOSITORY));
                break;
            }
        }
    }

    public void addPropertiesTo(@Nonnull Set<ConfigProperty> configProperties, @Nonnull String propertyGroupKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        switch (propertyGroupKey) {
            case "group.font": {
                this.addTo(configProperties, ConfigKey.USE_NATIVE_FONTS, settings);
                this.addTo(configProperties, ConfigKey.FONT_AUTO_SCALING, settings);
                if (advanced) {
                    this.addTo(configProperties, ConfigKey.COMPRESS_FONT_VIEWER, settings);
                }
                ConfigAction[] configActionArray = new ConfigAction[]{new ConfigAction(this.translate(settings, ConfigKey.FONT_PATH.getKey() + ".add", new Object[0]))};
                this.a(configProperties, settings, ConfigKey.FONT_PATH, "Directory", this.translate(settings, ConfigKey.FONT_PATH.getKey() + ".placeholder", new Object[0]), configActionArray);
                break;
            }
            case "group.layout": {
                ArrayList<LocalizedKey> arrayList = new ArrayList<LocalizedKey>();
                arrayList.add(new LocalizedKey("1", this.translate(settings, "Portrait", new Object[0])));
                arrayList.add(new LocalizedKey("2", this.translate(settings, "Landscape", new Object[0])));
                this.addSelectTo(configProperties, ConfigKey.DEFAULT_ORIENTATION, settings, arrayList);
                arrayList = new ArrayList();
                String string = "default_PaperSize.";
                arrayList.add(new LocalizedKey("1", this.translate(settings, string + "Letter_8_1/2_x_11_in", new Object[0])));
                arrayList.add(new LocalizedKey("2", this.translate(settings, string + "Letter_Small_8_1/2_x_11_in", new Object[0])));
                arrayList.add(new LocalizedKey("3", this.translate(settings, string + "Tabloid_11_x_17_in", new Object[0])));
                arrayList.add(new LocalizedKey("4", this.translate(settings, string + "Ledger_17_x_11_in", new Object[0])));
                arrayList.add(new LocalizedKey("5", this.translate(settings, string + "Legal_8_1/2_x_14_in", new Object[0])));
                arrayList.add(new LocalizedKey("6", this.translate(settings, string + "Statement_5_1/2_x_8_1/2_in", new Object[0])));
                arrayList.add(new LocalizedKey("7", this.translate(settings, string + "Executive_7_1/4_x_10_1/2_in", new Object[0])));
                arrayList.add(new LocalizedKey("8", this.translate(settings, string + "A3_297_x_420_mm", new Object[0])));
                arrayList.add(new LocalizedKey("9", this.translate(settings, string + "A4_210_x_297_mm", new Object[0])));
                arrayList.add(new LocalizedKey("10", this.translate(settings, string + "A4_Small_210_x_297_mm", new Object[0])));
                arrayList.add(new LocalizedKey("11", this.translate(settings, string + "A5_148_x_210_mm", new Object[0])));
                arrayList.add(new LocalizedKey("12", this.translate(settings, string + "B4_(JIS)_257_x_364_mm", new Object[0])));
                arrayList.add(new LocalizedKey("13", this.translate(settings, string + "B5_(JIS)_182_x_257_mm", new Object[0])));
                this.addSelectTo(configProperties, ConfigKey.DEFAULT_PAPERSIZE, settings, arrayList);
                break;
            }
            case "group.generalBehavior": {
                if (!ReportingStructureProvider.isDesigner()) {
                    ArrayList<LocalizedKey> arrayList = new ArrayList<LocalizedKey>();
                    Set<Map.Entry<String, RendererFactory>> set = RendererFactoryManager.getInstance().getDocumentRenderer();
                    for (Map.Entry<String, RendererFactory> entry : set) {
                        String string = entry.getKey();
                        RendererFactory rendererFactory = entry.getValue();
                        String string2 = rendererFactory.getDisplayName(string);
                        if (StringFunctions.isEmpty((String)string2)) continue;
                        arrayList.add(new LocalizedKey(string, rendererFactory.getDisplayName(string)));
                    }
                    arrayList.sort((localizedKey, localizedKey2) -> localizedKey.getDisplayName().compareTo(localizedKey2.getDisplayName()));
                    this.addSelectTo(configProperties, ConfigKey.DEFAULT_RENDERING_FORMAT, settings, arrayList);
                }
                this.addTo(configProperties, ConfigKey.PERMISSION_ALLOW_UNKNOWN_DATASOURCE, settings);
                if (!ReportingStructureProvider.isDesigner()) {
                    this.addTo(configProperties, ConfigKey.USE_CLIENT_LOCALE, settings);
                }
                if (!advanced) break;
                if (!ReportingStructureProvider.isDesigner()) {
                    this.addTo(configProperties, ConfigKey.USE_CLIENT_TIMEZONE, settings);
                }
                this.addTo(configProperties, ConfigKey.HAS_GROUP_TREE, settings);
                this.addTo(configProperties, ConfigKey.ONERROR_EXECUTESQL_WITHOUTSF, settings);
                break;
            }
            case "group.CompatibilitySettings": {
                ArrayList<LocalizedKey> arrayList = new ArrayList<LocalizedKey>();
                arrayList.add(new LocalizedKey("VALUES_MUST_BE_EXPLICITLY_SET", this.translate(settings, "VALUES_MUST_BE_EXPLICITLY_SET", new Object[0])));
                arrayList.add(new LocalizedKey("TAKE_VALUE_FROM_DEFAULT_VALUES", this.translate(settings, "TAKE_VALUE_FROM_DEFAULT_VALUES", new Object[0])));
                arrayList.add(new LocalizedKey("NEVER_PROMPT", this.translate(settings, "NEVER_PROMPT", new Object[0])));
                this.addSelectTo(configProperties, ConfigKey.PROMPT_BEHAVIOR, settings, arrayList);
                arrayList = new ArrayList();
                arrayList.add(new LocalizedKey(String.valueOf(Integer.MAX_VALUE), this.translate(settings, "compatibilityLevel.default", new Object[0])));
                arrayList.add(new LocalizedKey("23", this.translate(settings, "compatibilityLevel.23_x_compliant", new Object[0])));
                arrayList.add(new LocalizedKey("22", this.translate(settings, "compatibilityLevel.22_x_compliant", new Object[0])));
                arrayList.add(new LocalizedKey("20", this.translate(settings, "compatibilityLevel.20_x_compliant", new Object[0])));
                arrayList.add(new LocalizedKey("19", this.translate(settings, "compatibilityLevel.19_x_compliant", new Object[0])));
                arrayList.add(new LocalizedKey("12", this.translate(settings, "compatibilityLevel.12_x_compliant", new Object[0])));
                arrayList.add(new LocalizedKey("9", this.translate(settings, "compatibilityLevel.9_x_compliant", new Object[0])));
                arrayList.add(new LocalizedKey("8", this.translate(settings, "compatibilityLevel.8_x_compliant", new Object[0])));
                arrayList.add(new LocalizedKey("7", this.translate(settings, "compatibilityLevel.7_x_compliant", new Object[0])));
                this.addSelectTo(configProperties, ConfigKey.COMPATIBILITY_LEVEL, settings, arrayList);
                break;
            }
            case "group.ErrorHandling": {
                this.addTo(configProperties, ConfigKey.TOLERATE_ERRORS, settings);
                this.addTo(configProperties, ConfigKey.MAXIMUM_ERRORS, settings);
                break;
            }
            case "group.performance.database": {
                this.addTo(configProperties, ConfigKey.MAX_CONNECTIONS, settings);
                this.addUnitTo(configProperties, ConfigKey.CONNECTION_POOL_TIMEOUT, settings, this.a(settings));
                this.addUnitTo(configProperties, ConfigKey.LOGIN_TIMEOUT, settings, this.b(settings));
                this.addUnitTo(configProperties, ConfigKey.QUERY_TIMEOUT, settings, this.b(settings));
                this.addTo(configProperties, ConfigKey.METADATACACHE_ENABLED, settings);
                this.addUnitTo(configProperties, ConfigKey.METADATACACHE_TIMEOUT, settings, this.a(settings));
                break;
            }
            case "group.performance.report": {
                this.addTo(configProperties, ConfigKey.STOP_AFTER_PAGE, settings);
                this.addTo(configProperties, ConfigKey.ROW_LIMIT, settings);
                this.addTo(configProperties, ConfigKey.CROSSTAB_CELL_LIMIT, settings);
                break;
            }
            case "group.custom": {
                ConfigAction[] configActionArray;
                if (!ReportingStructureProvider.isDesigner()) {
                    configActionArray = new ConfigAction[]{new ConfigAction(this.translate(settings, ConfigKey.LIB_DIRECTORY.getKey() + ".add", new Object[0]))};
                    this.a(configProperties, settings, ConfigKey.LIB_DIRECTORY, "Directory", this.translate(settings, ConfigKey.LIB_DIRECTORY.getKey() + ".placeholder", new Object[0]), configActionArray);
                }
                configActionArray = new ConfigAction[]{new ConfigAction(this.translate(settings, ConfigKey.FORMULA_EXPANDER_CLASS.getKey() + ".add", new Object[0]))};
                this.a(configProperties, settings, ConfigKey.FORMULA_EXPANDER_CLASS, "SimpleText", this.translate(settings, ConfigKey.FORMULA_EXPANDER_CLASS.getKey() + ".placeholder", new Object[0]), configActionArray);
                if (!ReportingStructureProvider.isDesigner()) {
                    this.addTo(configProperties, ConfigKey.PROPERTY_CHECKER, settings);
                }
                if (!ReportingStructureProvider.isDesigner()) {
                    ConfigAction[] configActionArray2 = new ConfigAction[]{new ConfigAction(this.translate(settings, ConfigKey.SERVLET_FILTER.getKey() + ".add", new Object[0]))};
                    this.a(configProperties, settings, ConfigKey.SERVLET_FILTER, "SimpleText", this.translate(settings, ConfigKey.SERVLET_FILTER.getKey() + ".placeholder", new Object[0]), configActionArray2);
                }
                this.addTo(configProperties, ConfigKey.LANGUAGE_RESOURCE, settings);
                break;
            }
            case "group.collation": {
                this.addTo(configProperties, ConfigKey.COLLATION_DEFAULTCOLLATION, settings);
                this.addTo(configProperties, ConfigKey.COLLATION_LOCALE, settings);
                ArrayList<LocalizedKey> arrayList = new ArrayList<LocalizedKey>();
                arrayList.add(new LocalizedKey("PRIMARY", "Primary"));
                arrayList.add(new LocalizedKey("SECONDARY", "Secondary"));
                arrayList.add(new LocalizedKey("TERTIARY", "Tertiary"));
                arrayList.add(new LocalizedKey("IDENTICAL", "Identical"));
                this.addSelectTo(configProperties, ConfigKey.COLLATION_STRENGTH, settings, arrayList);
                break;
            }
            case "group.cache.report": {
                ArrayList<LocalizedKey> arrayList = new ArrayList<LocalizedKey>();
                arrayList.add(new LocalizedKey("0", this.translate(settings, "MemoryCache", new Object[0])));
                String string = settings.getValue(ConfigKey.CACHE_TYPE);
                if (settings.isPlus() & !ReportingStructureProvider.isDesigner()) {
                    arrayList.add(new LocalizedKey("1", this.translate(settings, "DBCache", new Object[0])));
                    arrayList.add(new LocalizedKey("2", this.translate(settings, "HDCache", new Object[0])));
                    arrayList.add(new LocalizedKey("3", this.translate(settings, "ExtDBCache", new Object[0])));
                } else if (!string.equals("0") && !settings.keySet().contains(ConfigKey.CACHE_TYPE.getKey())) {
                    string = "0";
                } else {
                    String string3 = ", " + this.translate(settings, "disabledNeedPlus", new Object[0]);
                    switch (string) {
                        case "1": {
                            arrayList.add(new LocalizedKey("1", this.translate(settings, "DBCache", new Object[0]) + string3));
                            break;
                        }
                        case "2": {
                            arrayList.add(new LocalizedKey("2", this.translate(settings, "HDCache", new Object[0]) + string3));
                            break;
                        }
                        case "3": {
                            arrayList.add(new LocalizedKey("3", this.translate(settings, "ExtDBCache", new Object[0]) + string3));
                        }
                    }
                }
                this.addSelectTo(configProperties, ConfigKey.CACHE_TYPE, string, settings, arrayList);
                this.addUnitTo(configProperties, ConfigKey.ENGINE_CACHE_TIMEOUT, settings, this.a(settings));
                this.addTo(configProperties, ConfigKey.RELOAD_ON_NEW_REQUEST, settings);
                break;
            }
            case "group.cache.db": {
                this.addTo(configProperties, ConfigKey.CACHE_DB_URL, settings);
                this.addTo(configProperties, ConfigKey.CACHE_DB_USERNAME, settings);
                this.addTo(configProperties, ConfigKey.CACHE_DB_PASSWORD, "Password", settings);
                this.addTo(configProperties, ConfigKey.CACHE_DB_DRIVERCLASS, settings);
                break;
            }
            case "group.cache.hd": {
                this.addTo(configProperties, ConfigKey.CACHE_HD_ROOT_DIRECTORY, "Directory", settings, HardDiskExternalDataWriterFactory.getDefaultDir().toString());
                break;
            }
            case "group.cache.rowsource": {
                this.addTo(configProperties, ConfigKey.ROWSOURCE_CACHE_ENABLED, settings);
                this.addUnitTo(configProperties, ConfigKey.ROWSOURCE_CACHE_TIME_TO_LIVE, settings, this.b(settings));
                break;
            }
            case "group.pdfExport": {
                ArrayList<LocalizedKey> arrayList = new ArrayList<LocalizedKey>();
                arrayList.add(new LocalizedKey("932", this.translate(settings, "japanese", new Object[0])));
                arrayList.add(new LocalizedKey("936", this.translate(settings, "simplifiedChinese", new Object[0])));
                arrayList.add(new LocalizedKey("950", this.translate(settings, "traditionalChinese", new Object[0])));
                this.addSelectTo(configProperties, ConfigKey.PDF_ASIAN_FONT_ENCODING, settings, arrayList);
                this.addTo(configProperties, ConfigKey.MAP_TO_ADOBE_FONTS, settings);
                this.addTo(configProperties, ConfigKey.PDF_REPLACE_MISSING_CHAR, settings);
                this.addTo(configProperties, ConfigKey.COMPRESSED_PDF, settings);
                this.addTo(configProperties, ConfigKey.TAGGED_PDF, settings);
                break;
            }
            case "group.pdf.fontReplace": {
                this.addTo(configProperties, ConfigKey.PDF_REPLACE_NOT_EMBEDDED_FONTS, settings);
                this.a(configProperties, settings, ConfigKey.PDF_SANSSERIF_FONT_LIST, this.getListOfPreferredSansSerifFontNames(settings));
                this.a(configProperties, settings, ConfigKey.PDF_SERIF_FONT_LIST, this.getListOfPreferredSerifFontNames(settings));
                this.a(configProperties, settings, ConfigKey.PDF_MONOSPACED_FONT_LIST, this.getListOfPreferredMonospacedFontNames(settings));
                break;
            }
            case "group.pdfSigning": {
                this.addTo(configProperties, ConfigKey.SIGN_PDF_ENABLED, settings);
                ArrayList<LocalizedKey> arrayList = new ArrayList<LocalizedKey>();
                arrayList.add(new LocalizedKey("JKS", null));
                arrayList.add(new LocalizedKey("JCEKS", null));
                arrayList.add(new LocalizedKey("PKCS12", null));
                this.addSelectTo(configProperties, ConfigKey.SIGN_KEYSTORE_TYPE, settings, arrayList);
                this.addTo(configProperties, ConfigKey.SIGN_KEYSTORE_FILE, "File", settings);
                this.addPasswordTo(configProperties, ConfigKey.SIGN_KEYSTORE_PASSWORD, Encryption.decrypt((String)settings.getValue(ConfigKey.SIGN_KEYSTORE_PASSWORD)), settings);
                this.addTo(configProperties, ConfigKey.SIGN_KEY_NAME, settings);
                this.addPasswordTo(configProperties, ConfigKey.SIGN_KEY_PASSWORD, Encryption.decrypt((String)settings.getValue(ConfigKey.SIGN_KEY_PASSWORD)), settings);
                break;
            }
            case "group.ps": {
                this.addTo(configProperties, ConfigKey.USE_SET_PAGE_DEVICE, settings);
                this.addTo(configProperties, ConfigKey.USE_IMAGE_COMPRESSION, settings);
                break;
            }
            case "group.fontmapping.ps": {
                this.addTo(configProperties, ConfigKey.FONTMAPPING_PS_SERIF, "SelectEdit", settings, ConfigKey.FONTMAPPING_PS_SERIF.getDefault());
                this.addTo(configProperties, ConfigKey.FONTMAPPING_PS_SANSSERIF, "SelectEdit", settings, ConfigKey.FONTMAPPING_PS_SANSSERIF.getDefault());
                this.addTo(configProperties, ConfigKey.FONTMAPPING_PS_MONOSPACED, "SelectEdit", settings, ConfigKey.FONTMAPPING_PS_MONOSPACED.getDefault());
                break;
            }
            case "group.fontmapping.rtf": {
                this.addTo(configProperties, ConfigKey.FONTMAPPING_DOCUMENT_SERIF, "SelectEdit", settings, ConfigKey.FONTMAPPING_DOCUMENT_SERIF.getDefault());
                this.addTo(configProperties, ConfigKey.FONTMAPPING_DOCUMENT_SANSSERIF, "SelectEdit", settings, ConfigKey.FONTMAPPING_DOCUMENT_SANSSERIF.getDefault());
                this.addTo(configProperties, ConfigKey.FONTMAPPING_DOCUMENT_MONOSPACED, "SelectEdit", settings, ConfigKey.FONTMAPPING_DOCUMENT_MONOSPACED.getDefault());
                break;
            }
            case "group.fontmapping.xls": {
                this.addTo(configProperties, ConfigKey.FONTMAPPING_XLS_SERIF, "SelectEdit", settings, ConfigKey.FONTMAPPING_XLS_SERIF.getDefault());
                this.addTo(configProperties, ConfigKey.FONTMAPPING_XLS_SANSSERIF, "SelectEdit", settings, ConfigKey.FONTMAPPING_XLS_SANSSERIF.getDefault());
                this.addTo(configProperties, ConfigKey.FONTMAPPING_XLS_MONOSPACED, "SelectEdit", settings, ConfigKey.FONTMAPPING_XLS_MONOSPACED.getDefault());
                break;
            }
            case "group.xls": {
                ArrayList<LocalizedKey> arrayList = new ArrayList<LocalizedKey>();
                String string = ConfigKey.XLS_CELLDISTRIBUTION.getKey() + ".";
                for (CellDistribution cellDistribution : CellDistribution.values()) {
                    arrayList.add(new LocalizedKey(cellDistribution.name(), this.translate(settings, string + String.valueOf((Object)cellDistribution), new Object[0])));
                }
                this.addSelectTo(configProperties, ConfigKey.XLS_CELLDISTRIBUTION, settings, arrayList);
                this.addTo(configProperties, ConfigKey.XLS_CELLTRUNCATE, settings);
                break;
            }
            case "group.textExport": {
                this.addTo(configProperties, ConfigKey.TXT_FONTNAME, "SelectEdit", settings, ConfigKey.TXT_FONTNAME.getDefault());
                ArrayList<UnitConfigProperty.Unit> arrayList = new ArrayList<UnitConfigProperty.Unit>();
                arrayList.add(new UnitConfigProperty.Unit(0.010416666666666666, this.translate(settings, "inch", new Object[0])));
                arrayList.add(new UnitConfigProperty.Unit(0.026455026455026454, this.translate(settings, "cm", new Object[0])));
                arrayList.add(new UnitConfigProperty.Unit(0.26455026455026454, this.translate(settings, "mm", new Object[0])));
                arrayList.add(new UnitConfigProperty.Unit(0.75, this.translate(settings, "points", new Object[0])));
                arrayList.add(new UnitConfigProperty.Unit(1.0, this.translate(settings, "pixel", new Object[0])));
                arrayList.add(new UnitConfigProperty.Unit(15.0, this.translate(settings, "twips", new Object[0])));
                this.addUnitTo(configProperties, ConfigKey.TXT_FONTSIZE, settings, arrayList);
                break;
            }
            case "group.reportLocations": {
                this.addTo(configProperties, ConfigKey.REPOSITORY_ENABLED, settings);
                break;
            }
            case "reportlocations.group.permitted": {
                this.addTo(configProperties, ConfigKey.FILELOCATION_ENABLED, settings);
                this.addTo(configProperties, ConfigKey.JNDILOCATION_ENABLED, settings);
                if (settings.isPlus() && ServerPluginManager.getInstance().isPluginLoaded("drive")) {
                    this.addTo(configProperties, ConfigKey.REPOLOCATION_ENABLED, settings);
                }
                this.addTo(configProperties, ConfigKey.LOCALHOST_ENABLED, settings);
                ConfigAction[] configActionArray = new ConfigAction[]{new ConfigAction(this.translate(settings, "repository.add", new Object[0]))};
                this.a(configProperties, settings, ConfigKey.REPOSITORY, "SimpleText", this.translate(settings, "repository.placeholder", new Object[0]), configActionArray);
                break;
            }
            case "group.urlParameter.column1": {
                this.a(configProperties, ConfigKey.ALLOW_PARAM_DATASOURCE, settings);
                this.a(configProperties, ConfigKey.ALLOW_PARAM_PASSWORD, settings);
                this.a(configProperties, ConfigKey.ALLOW_PARAM_PROMPT, settings);
                this.a(configProperties, ConfigKey.ALLOW_PARAM_INIT, settings);
                break;
            }
            case "group.urlParameter.column2": {
                this.a(configProperties, ConfigKey.ALLOW_PARAM_SF, settings);
                this.a(configProperties, ConfigKey.ALLOW_PARAM_GF, settings);
                this.a(configProperties, ConfigKey.ALLOW_PARAM_STOPAFTERPAGE, settings);
                break;
            }
        }
    }

    private void a(Set<ConfigProperty> set, ConfigKey configKey, ConfigStructureSettings configStructureSettings) {
        set.add((ConfigProperty)new BooleanConfigProperty(set.size() * 100, configKey.getKey(), this.translate(configStructureSettings, configKey.getKey(), new Object[0]), null, this.translate(configStructureSettings, configKey.getKey() + ".tooltip", new Object[0]), (Object)configStructureSettings.getValue(configKey)));
    }

    private void a(Set<ConfigProperty> set, ConfigStructureSettings configStructureSettings, ConfigKey configKey, List<String> list) {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        if (list != null) {
            for (String configActionArray2 : list) {
                arrayList.add(new String[]{configActionArray2});
            }
        }
        ConfigProperty configProperty = new ConfigProperty(100, configKey.getKey(), "SelectEdit", null, (Object)"", null, null);
        ConfigAction[] configActionArray = new ConfigAction[]{new ConfigAction(this.translate(configStructureSettings, configKey.getKey() + ".add", new Object[0]))};
        this.addTableTo(set, configKey.getKey(), "SimpleText", configStructureSettings, arrayList, configActionArray, new ConfigProperty[]{configProperty});
    }

    @Nullable
    public List<String> getListOfPreferredSerifFontNames(ConfigStructureSettings settings) {
        String string = settings.getValue(ConfigKey.PDF_SERIF_FONT_LIST.getKey());
        String[] stringArray = (String[])new Json().fromJson(string, String[].class);
        return Arrays.asList(stringArray);
    }

    @Nullable
    public List<String> getListOfPreferredSansSerifFontNames(ConfigStructureSettings settings) {
        String string = settings.getValue(ConfigKey.PDF_SANSSERIF_FONT_LIST.getKey());
        String[] stringArray = (String[])new Json().fromJson(string, String[].class);
        return Arrays.asList(stringArray);
    }

    @Nullable
    public List<String> getListOfPreferredMonospacedFontNames(ConfigStructureSettings settings) {
        String string = settings.getValue(ConfigKey.PDF_MONOSPACED_FONT_LIST.getKey());
        String[] stringArray = (String[])new Json().fromJson(string, String[].class);
        return Arrays.asList(stringArray);
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="file use for checkings")
    public void validate(@Nullable String categoryKey, @Nonnull ArrayList<ConfigValidationMsg> messages, @Nonnull ArrayList<ConfigConditionAction> conditions, @Nonnull ConfigStructureSettings settings) {
        Object object;
        ConfigValidator configValidator = new ConfigValidator(messages, settings);
        if (categoryKey == null || categoryKey.equals("category.performance")) {
            object = this.translate(settings, "Minutes", new Object[0]);
            String object2 = this.translate(settings, "Seconds", new Object[0]);
            configValidator.validateNumberRange(ConfigKey.MAX_CONNECTIONS, 0L, 1000L);
            configValidator.validateUnitNumberRange(ConfigKey.CONNECTION_POOL_TIMEOUT, 0.0, 1000.0, (String)object);
            configValidator.validateUnitNumberRange(ConfigKey.LOGIN_TIMEOUT, 0.0, 10000.0, object2);
            configValidator.validateUnitNumberRange(ConfigKey.QUERY_TIMEOUT, 0.0, 10000.0, object2);
            configValidator.validateUnitNumberRange(ConfigKey.METADATACACHE_TIMEOUT, 0.0, 10000.0, (String)object);
            configValidator.validateNumberRange(ConfigKey.STOP_AFTER_PAGE, 0L, 100000L);
            configValidator.validateNumberRange(ConfigKey.ROW_LIMIT, 0L, Integer.MAX_VALUE);
            configValidator.validateNumberRange(ConfigKey.CROSSTAB_CELL_LIMIT, 0L, 10000L);
        }
        if ((categoryKey == null || categoryKey.equals("category.font")) && (object = (String[][])settings.getChangedValue(ConfigKey.FONT_PATH, String[][].class)) != null) {
            for (Object object2 : object) {
                configValidator.checkDirectoryExists(ConfigKey.FONT_PATH, object2[0].trim());
            }
        }
        if (categoryKey == null || categoryKey.equals("category.behavior")) {
            if ("false".equals(settings.getValue(ConfigKey.TOLERATE_ERRORS))) {
                configValidator.validateNumberRange(ConfigKey.MAXIMUM_ERRORS, 0L, 10000L);
            }
            if ("true".equals(settings.getValue(ConfigKey.PERMISSION_ALLOW_UNKNOWN_DATASOURCE)) && "false".equals(settings.getOriginalValue(ConfigKey.PERMISSION_ALLOW_UNKNOWN_DATASOURCE))) {
                messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Confirmation, this.translate(settings, "permission.allowunknowndatasource.warning", new Object[0]), ConfigKey.PERMISSION_ALLOW_UNKNOWN_DATASOURCE));
            }
        }
        if (categoryKey == null || categoryKey.equals("category.custom")) {
            if (!ReportingStructureProvider.isDesigner()) {
                configValidator.checkNeedRestart(ConfigKey.LIB_DIRECTORY);
                this.a(messages, settings);
            }
            configValidator.validateClassName(ConfigKey.FORMULA_EXPANDER_CLASS, true);
            if (!ReportingStructureProvider.isDesigner()) {
                configValidator.validateClassName(ConfigKey.PROPERTY_CHECKER, false, PropertiesChecker.class);
                configValidator.validateClassName(ConfigKey.SERVLET_FILTER, true, Filter.class);
            }
            if (!((String)(object = settings.getValue(ConfigKey.LANGUAGE_RESOURCE))).isEmpty()) {
                try {
                    LoaderUtils.getBundle((String)object, (Locale)Locale.getDefault(), (Object)((Object)this));
                }
                catch (Throwable throwable) {
                    messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "error.validator.resourcebundle.notfound", new Object[]{object}), ConfigKey.LANGUAGE_RESOURCE));
                }
            }
            if (settings.isValidatable(ConfigKey.COLLATION_LOCALE, conditions)) {
                configValidator.validateLocale(ConfigKey.COLLATION_LOCALE);
            }
        }
        if (categoryKey == null || categoryKey.equals("category.cache")) {
            if (!ReportingStructureProvider.isDesigner() && settings.isValidatable(ConfigKey.CACHE_HD_ROOT_DIRECTORY, conditions)) {
                configValidator.checkDirectoryExists(ConfigKey.CACHE_HD_ROOT_DIRECTORY);
            }
            configValidator.validateUnitNumberRange(ConfigKey.ENGINE_CACHE_TIMEOUT, 0.0, 10000.0, this.translate(settings, "Minutes", new Object[0]));
            if (settings.isValidatable(ConfigKey.ROWSOURCE_CACHE_TIME_TO_LIVE, conditions)) {
                configValidator.validateUnitNumberRange(ConfigKey.ROWSOURCE_CACHE_TIME_TO_LIVE, 0.0, 2.147483647E9, this.translate(settings, "Seconds", new Object[0]));
            }
        }
        if ((categoryKey == null || categoryKey.equals("category.pdfExport")) && settings.isPlus() && settings.isValidatable(ConfigKey.SIGN_KEYSTORE_FILE, conditions)) {
            configValidator.validateFileOrHttpURL(ConfigKey.SIGN_KEYSTORE_FILE);
        }
        if (categoryKey == null || categoryKey.equals("category.textExport")) {
            this.a(ConfigKey.TXT_FONTNAME, messages, settings);
            configValidator.validateUnitNumberRange(ConfigKey.TXT_FONTSIZE, 3.0, 600.0, this.translate(settings, "pixel", new Object[0]));
        }
        if ((categoryKey == null || categoryKey.equals("category.reportLocations")) && Boolean.parseBoolean(settings.getValue(ConfigKey.REPOSITORY_ENABLED))) {
            object = (String[][])settings.getChangedValue(ConfigKey.REPOSITORY, String[][].class);
            if (object == null) {
                object = (String[][])this.ca(settings.getOriginalValue(ConfigKey.REPOSITORY)).toArray((T[])new String[0][0]);
            }
            for (Object object2 : object) {
                String string = object2[0];
                if (new File(string).exists()) continue;
                configValidator.validateURL(string, ConfigKey.REPOSITORY);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="file used for checkings")
    private void a(@Nonnull ArrayList<ConfigValidationMsg> arrayList, @Nonnull ConfigStructureSettings configStructureSettings) {
        Object object;
        HashSet<String> hashSet = new HashSet<String>();
        String[][] stringArray = (String[][])configStructureSettings.getChangedValue(ConfigKey.LIB_DIRECTORY, String[][].class);
        if (stringArray != null) {
            void stringArray2;
            object = stringArray;
            int n2 = ((String[][])object).length;
            boolean bl2 = false;
            while (stringArray2 < n2) {
                String[] stringArray3 = object[stringArray2];
                String string = stringArray3[0].trim();
                if (string.length() > 0) {
                    hashSet.add(string);
                }
                ++stringArray2;
            }
        } else {
            object = configStructureSettings.getValue(ConfigKey.LIB_DIRECTORY);
            for (String[] string : this.ca((String)object)) {
                String string3 = string[0];
                string3 = string3.trim();
                if (string3.length() <= 0) continue;
                hashSet.add(string3);
            }
        }
        object = new StringBuilder();
        for (String string : hashSet) {
            if (string.contains(",")) {
                arrayList.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(configStructureSettings, "error.validator.libDirectories.invalidChar", new Object[]{",", string}), ConfigKey.LIB_DIRECTORY));
                return;
            }
            if (string.contains(";")) {
                arrayList.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(configStructureSettings, "error.validator.libDirectories.invalidChar", new Object[]{";", string}), ConfigKey.LIB_DIRECTORY));
                return;
            }
            File file = new File(string);
            if (file.isFile()) {
                if (string.endsWith(".jar") || string.endsWith(".zip") || string.endsWith(".dll") || string.endsWith(".exe")) continue;
                if (((StringBuilder)object).length() > 0) {
                    ((StringBuilder)object).append(", ");
                }
                ((StringBuilder)object).append(string);
                continue;
            }
            if (file.isDirectory()) continue;
            if (string.endsWith(".jar") || string.endsWith(".zip") || string.endsWith(".dll") || string.endsWith(".exe")) {
                try {
                    new URL(string);
                    continue;
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (((StringBuilder)object).length() > 0) {
                ((StringBuilder)object).append(", ");
            }
            ((StringBuilder)object).append(string);
        }
        if (((StringBuilder)object).length() > 0) {
            arrayList.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(configStructureSettings, "error.validator.libDirectories.notfound", new Object[]{object}), ConfigKey.LIB_DIRECTORY));
        }
    }

    public void action(String actionKey, @Nonnull ArrayList<ConfigValidationMsg> messages, @Nonnull ConfigStructureSettings settings) {
        switch (actionKey) {
            case "action.pdf.keystroke": {
                String string = settings.getValue(ConfigKey.SIGN_KEYSTORE_TYPE);
                String string2 = settings.getValue(ConfigKey.SIGN_KEYSTORE_FILE);
                String string3 = Encryption.decrypt((String)settings.getValue(ConfigKey.SIGN_KEYSTORE_PASSWORD));
                String string4 = settings.getValue(ConfigKey.SIGN_KEY_NAME);
                String string5 = Encryption.decrypt((String)settings.getValue(ConfigKey.SIGN_KEY_PASSWORD));
                String string6 = BaseUtils.validateKeyStore(string, string2, string3, string4, string5);
                if (string6 != null) {
                    messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, string6, (String)null));
                    break;
                }
                messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Valid, this.translate(settings, "pdfKeystoreValidateValid", new Object[0]), (String)null));
                break;
            }
            case "action.clear.cache": {
                Cache cache = Cache.getCache();
                try {
                    cache.clear();
                    messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Valid, this.translate(settings, "action.clear.cache.ok", new Object[0]), "action.clear.cache"));
                }
                catch (ReportException reportException) {
                    LogManager.getConfigLogger().error((Throwable)reportException);
                    messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, StringFunctions.getUserFriendlyErrorMessage((Throwable)reportException), "action.clear.cache"));
                }
                break;
            }
            case "action.db.validate": {
                String string = settings.getValue(ConfigKey.CACHE_DB_URL);
                String string7 = settings.getValue(ConfigKey.CACHE_DB_USERNAME);
                String string8 = settings.getValue(ConfigKey.CACHE_DB_PASSWORD);
                String string9 = settings.getValue(ConfigKey.CACHE_DB_DRIVERCLASS);
                String string10 = new RepoDatabaseValidator(string, string7, string8, string9, null).validateSettings();
                if (string10 == null) {
                    messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Valid, this.translate(settings, "cacheDbValidateValid", new Object[0]), "action.db.validate"));
                    break;
                }
                messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, string10, "action.db.validate"));
                break;
            }
        }
    }

    public ConfigStructure.SaveState save(String key, String value, @Nonnull ConfigStructureSettings settings) {
        switch (key) {
            case "FontPath": 
            case "libDirectory": 
            case "formulaExpanderClass": 
            case "servlet.filter": {
                settings.save(key, this.g(value, false));
                return ConfigStructure.SaveState.SAVE;
            }
            case "repository": {
                settings.save(key, this.g(value, true));
                return ConfigStructure.SaveState.SAVE;
            }
            case "sign.keystore.password": 
            case "sign.key.password": {
                settings.save(key, Encryption.encrypt((String)value));
                return ConfigStructure.SaveState.SAVE;
            }
            case "fontmapping.pdf.sansserifFontList": 
            case "fontmapping.pdf.serifFontList": 
            case "fontmapping.pdf.monospacedFontList": {
                settings.save(key, this.bZ(value));
                return ConfigStructure.SaveState.SAVE;
            }
        }
        return ConfigStructure.SaveState.NONE;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="file used for checkings")
    private String g(String string, boolean bl2) {
        String[][] stringArray = (String[][])new Json().fromJson(string, String[][].class);
        StringBuilder stringBuilder = new StringBuilder();
        for (String[] stringArray2 : stringArray) {
            String string2 = stringArray2[0];
            if (bl2 && new File(string2).exists()) {
                try {
                    string2 = IOFunctions.getFileURL((String)string2).toString();
                }
                catch (MalformedURLException malformedURLException) {
                    LogManager.getConfigLogger().error((Throwable)malformedURLException);
                }
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    private String bZ(String string) {
        String[][] stringArray = (String[][])new Json().fromJson(string, String[][].class);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String[] stringArray2 : stringArray) {
            arrayList.add(stringArray2[0]);
        }
        return new Json().toJson(arrayList);
    }

    private List<UnitConfigProperty.Unit> a(@Nonnull ConfigStructureSettings configStructureSettings) {
        ArrayList<UnitConfigProperty.Unit> arrayList = new ArrayList<UnitConfigProperty.Unit>();
        arrayList.add(new UnitConfigProperty.Unit(0.016666666666666666, this.translate(configStructureSettings, "Hours", new Object[0])));
        arrayList.add(new UnitConfigProperty.Unit(1.0, this.translate(configStructureSettings, "Minutes", new Object[0])));
        arrayList.add(new UnitConfigProperty.Unit(60.0, this.translate(configStructureSettings, "Seconds", new Object[0])));
        return arrayList;
    }

    private List<UnitConfigProperty.Unit> b(@Nonnull ConfigStructureSettings configStructureSettings) {
        ArrayList<UnitConfigProperty.Unit> arrayList = new ArrayList<UnitConfigProperty.Unit>();
        arrayList.add(new UnitConfigProperty.Unit(2.777777777777778E-4, this.translate(configStructureSettings, "Hours", new Object[0])));
        arrayList.add(new UnitConfigProperty.Unit(0.016666666666666666, this.translate(configStructureSettings, "Minutes", new Object[0])));
        arrayList.add(new UnitConfigProperty.Unit(1.0, this.translate(configStructureSettings, "Seconds", new Object[0])));
        return arrayList;
    }

    private List<String[]> ca(String string) {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",;");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(new String[]{stringTokenizer.nextToken()});
        }
        return arrayList;
    }

    private void a(@Nonnull Set<ConfigProperty> set, @Nonnull ConfigStructureSettings configStructureSettings, @Nonnull ConfigKey configKey, String string, String string2, ConfigAction[] configActionArray) {
        List<String[]> list = this.ca(configStructureSettings.getValue(configKey));
        ConfigProperty configProperty = new ConfigProperty(0, "", string, null, null, null, string2);
        this.addTableTo(set, configKey.getKey(), string, configStructureSettings, list, configActionArray, new ConfigProperty[]{configProperty});
    }

    private void a(@Nullable ConfigKey configKey, @Nonnull ArrayList<ConfigValidationMsg> arrayList, @Nonnull ConfigStructureSettings configStructureSettings) {
        AllFontsFontProvider allFontsFontProvider;
        List list;
        String string = configStructureSettings.getValue(configKey);
        if (!string.isEmpty() && (list = (allFontsFontProvider = AllFontsFontProvider.getInstance()).getAvailableFonts()) != null) {
            for (FontFamily fontFamily : list) {
                if (!string.equalsIgnoreCase(fontFamily.getName())) continue;
                return;
            }
            arrayList.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(configStructureSettings, "fontmapping.unknown", new Object[]{string}), configKey));
        }
    }

    @Nullable
    public List<LocalizedKey> getSelectValues(@Nonnull String key, String filter, ConfigStructureSettings settings) {
        switch (key) {
            case "txt.fontname": 
            case "fontmapping.ps.serif": 
            case "fontmapping.ps.sansserif": 
            case "fontmapping.ps.monospaced": 
            case "fontmapping.rtf.serif": 
            case "fontmapping.rtf.sansserif": 
            case "fontmapping.rtf.monospaced": 
            case "fontmapping.xls.serif": 
            case "fontmapping.xls.sansserif": 
            case "fontmapping.xls.monospaced": 
            case "fontmapping.pdf.sansserifFontList": 
            case "fontmapping.pdf.serifFontList": 
            case "fontmapping.pdf.monospacedFontList": {
                AllFontsFontProvider allFontsFontProvider = AllFontsFontProvider.getInstance();
                List list = allFontsFontProvider.getAvailableFonts();
                ArrayList<LocalizedKey> arrayList = new ArrayList<LocalizedKey>();
                filter = filter.toLowerCase();
                if (list != null) {
                    for (FontFamily fontFamily : list) {
                        if (!fontFamily.getName().toLowerCase().contains(filter) || ("fontmapping.pdf.sansserifFontList".equals(key) || "fontmapping.pdf.serifFontList".equals(key) || "fontmapping.pdf.monospacedFontList".equals(key)) && !allFontsFontProvider.isEmbeddedFont(fontFamily)) continue;
                        arrayList.add(new LocalizedKey(fontFamily.getName(), fontFamily.hasLocalizedName() ? fontFamily.getLocalizedName() : null));
                    }
                }
                return arrayList;
            }
        }
        return null;
    }
}

