/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.database.csvdata;

import com.inet.report.database.csvdata.DataTypes;
import com.inet.report.database.csvdata.ValueConverter;
import java.text.NumberFormat;
import java.util.Locale;
import javax.annotation.Nullable;

public class NumberValueConverter
implements ValueConverter<Number> {
    private final NumberFormat adn;

    public NumberValueConverter(DataTypes types) {
        switch (types.oo()) {
            case 0: 
            case 1: 
            case 4: 
            case 6: {
                this.adn = NumberFormat.getNumberInstance(Locale.ENGLISH);
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                this.adn = NumberFormat.getNumberInstance(Locale.GERMAN);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid Number Type:" + types.oo());
            }
        }
    }

    @Override
    @Nullable
    public Number convert(String value) throws Exception {
        if (value == null || value.isEmpty() || value.equals("-")) {
            return null;
        }
        return this.adn.parse(value);
    }
}

