/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.database.csvdata;

import com.inet.report.database.csvdata.DataTypes;
import com.inet.report.database.csvdata.ValueConverter;
import com.inet.report.database.csvdata.e;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DateValueConverter
implements ValueConverter<Date> {
    private final boolean adh;
    private final SimpleDateFormat Yf;

    public DateValueConverter(@Nonnull DataTypes types) {
        e e2 = types.getDateTimeScanner();
        e.c c2 = e2.os().get(0);
        if (c2.ov()) {
            this.adh = true;
            this.Yf = null;
        } else {
            String string = c2.getPattern();
            Locale locale = c2.getLocale();
            this.adh = string.indexOf(58) > 0;
            this.Yf = new SimpleDateFormat(string, locale);
        }
    }

    public boolean isDateTime() {
        return this.adh;
    }

    @Override
    @Nullable
    public Date convert(String value) throws Exception {
        if (value == null || value.isEmpty()) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = this.Yf;
        if (simpleDateFormat != null) {
            Date date = simpleDateFormat.parse(value);
            return this.adh ? new Timestamp(date.getTime()) : new java.sql.Date(date.getTime());
        }
        return Timestamp.from(Instant.from(DateTimeFormatter.ISO_INSTANT.parse(value)));
    }
}

