/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.PublicApi;
import com.inet.lib.list.IntList;
import com.inet.lib.list.StringList;
import com.inet.logging.LogManager;
import com.inet.report.Area;
import com.inet.report.BaseUtils;
import com.inet.report.Database;
import com.inet.report.DatabaseField;
import com.inet.report.DatabaseTables;
import com.inet.report.Datasource;
import com.inet.report.Engine;
import com.inet.report.Field;
import com.inet.report.FieldElement;
import com.inet.report.Fields;
import com.inet.report.FormulaField;
import com.inet.report.Join;
import com.inet.report.MissedColumnException;
import com.inet.report.ParameterList;
import com.inet.report.PromptField;
import com.inet.report.ReferenceHolder;
import com.inet.report.ReferencedObject;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.Section;
import com.inet.report.bm;
import com.inet.report.by;
import com.inet.report.database.ColumnInfo;
import com.inet.report.database.DataFactory;
import com.inet.report.database.DatabaseUtils;
import com.inet.report.database.JdbcData;
import com.inet.report.database.a;
import com.inet.report.database.sql.PromptPlaceholderReplacer;
import com.inet.report.database.sql.SqlSyntax;
import com.inet.report.i18n.Msg;
import com.inet.report.i18n.ReportErrorCode;
import com.inet.report.k;
import com.inet.report.list.DatabaseFieldList;
import com.inet.report.parser.FatalParserException;
import com.inet.report.parser.NodeParser;
import com.inet.report.parser.XMLTag;
import com.inet.report.r;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.annotation.Nonnull;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;

@PublicApi
public class TableSource
implements ReferenceHolder,
NodeParser,
Serializable {
    private String PD;
    private String PE;
    private DatabaseFieldList PF = new DatabaseFieldList();
    private String PG;
    private boolean PH = true;
    private Datasource qU;
    private ParameterList PJ;
    private String[] PK;
    public static final int TYPE_TABLE_OR_VIEW = 1;
    public static final int TYPE_PROCEDURE = 2;
    public static final int TYPE_COMMAND = 3;
    public static final String TYPE_NAME_TABLE = "TABLE";
    public static final String TYPE_NAME_VIEW = "VIEW";
    public static final String TYPE_NAME_SYSTEM_TABLE = "SYSTEM TABLE";
    private int type = 0;
    Engine lz;
    private static Set<String> PL = new HashSet<String>();
    private r qj = new r(this);

    TableSource(Engine engine, Datasource ds) {
        this.lz = engine;
        this.qU = ds;
    }

    TableSource(String databaseIdentifier, String aliasName, Engine engine, Datasource ds) throws ReportException {
        this(engine, ds);
        this.as(aliasName);
        this.setDatabaseIdentifierName(databaseIdentifier);
    }

    public int getType() throws ReportException {
        if (this.type == 0) {
            this.kq();
        }
        return this.type;
    }

    private void kq() throws ReportException {
        block10: {
            if (this.PG != null) {
                this.type = 3;
                return;
            }
            this.PJ = new ParameterList();
            try {
                DataFactory dataFactory = this.qU.k(false);
                if (dataFactory instanceof Database) {
                    try (Connection connection = this.qU.getConnection();){
                        this.type = ((Database)dataFactory).scanSourceType(this, this.PJ, true) ? 2 : 1;
                        break block10;
                    }
                }
                this.type = 1;
            }
            catch (SQLException sQLException) {
                throw ReportExceptionFactory.createReportExceptionWithCause(sQLException);
            }
        }
    }

    ParameterList kr() {
        if (this.PJ == null) {
            try {
                this.kq();
            }
            catch (Exception exception) {
                BaseUtils.error("Check type of TableSource is failed");
                BaseUtils.error(exception);
            }
        }
        return this.PJ;
    }

    private void updateReferences() {
        if (this.type == 3) {
            this.resetReferences();
            if (this.PG != null && this.PG.length() > 0) {
                this.setReferences();
            }
        }
    }

    @Nonnull
    public ResultSet getResultSet() throws ReportException, SQLException {
        DataFactory dataFactory = this.qU.getDataFactory();
        if (!DatabaseUtils.useJdbcDriver(dataFactory)) {
            throw ReportExceptionFactory.createReportException(ReportErrorCode.useJDBCIsFalse, dataFactory.getClass().getName());
        }
        try (Connection connection = this.qU.getConnection();){
            Statement statement;
            Database database = (Database)dataFactory;
            switch (this.getType()) {
                case 3: {
                    this.updateReferences();
                    PromptPlaceholderReplacer promptPlaceholderReplacer = new PromptPlaceholderReplacer(database.getSqlSyntax()).setQuoteStringPrompts(this.PH);
                    String string = promptPlaceholderReplacer.replace(this.PG, this.lz.bB.getFields());
                    this.lz.bB.BD = connection.createStatement();
                    bm.a(this.lz.bB, this.lz.bB.BD);
                    ResultSet resultSet = DatabaseUtils.executeQuery(this.lz.bB.BD, string, null);
                    return resultSet;
                }
                case 2: {
                    PromptField[] promptFieldArray = this.lz.bB.iZ();
                    ResultSet resultSet = new a(database, connection, this).a(this.kr()).b(promptFieldArray).nU();
                    return resultSet;
                }
            }
            String string = this.ks();
            if (BaseUtils.isInfo()) {
                BaseUtils.info(string);
            }
            this.lz.bB.BD = statement = connection.createStatement();
            ResultSet resultSet = DatabaseUtils.executeQuery(statement, string, null);
            return resultSet;
        }
    }

    private String ks() throws SQLException, ReportException {
        Object object;
        String string = this.ku();
        DatabaseFieldList databaseFieldList = this.a(null, null);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT ");
        if (databaseFieldList.size() > 0) {
            object = (Database)this.qU.getDataFactory();
            for (int i2 = 0; i2 < databaseFieldList.size(); ++i2) {
                if (i2 > 0) {
                    stringBuilder.append(',').append(' ');
                }
                stringBuilder.append(((Database)object).convertIdentifier(this.qU, databaseFieldList.elementAt(i2).getName()));
            }
        } else {
            stringBuilder.append('1');
        }
        stringBuilder.append(" FROM ").append(string).append(' ');
        object = ((Database)this.qU.getDataFactory()).getConfiguration().getAliasToken();
        if (!((String)object).isEmpty() && !((String)object).equals(" ")) {
            stringBuilder.append((String)object).append(' ');
        }
        stringBuilder.append(this.PD);
        return stringBuilder.toString();
    }

    private String ae(boolean bl2) throws ReportException, SQLException {
        ParameterList parameterList;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.type == 0) {
            this.kq();
        }
        if ((parameterList = this.kr()).hasReturnCursor()) {
            stringBuilder.append("{?=call ");
        } else {
            stringBuilder.append("{call ");
        }
        stringBuilder.append(this.ku());
        int n2 = parameterList.paramCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append(i2 == 0 ? (char)'(' : ',');
            stringBuilder.append((String)(bl2 ? "{?" + parameterList.elementAt(i2).fe() + "}" : "?"));
            if (i2 != n2 - 1) continue;
            stringBuilder.append(')');
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public void checkExistsOnCurrentDatasource() throws ReportException {
        block20: {
            try (Connection connection = this.qU.getConnection();){
                Object object;
                if (this.getType() == 3) {
                    this.refresh();
                    break block20;
                }
                if (this.getType() == 2) {
                    PromptField[] promptFieldArray = this.lz.bB.iZ();
                    try (a a2 = new a((JdbcData)this.qU.getDataFactory(), connection, this);){
                        a2.a(this.kr()).b(promptFieldArray).nU();
                        break block20;
                    }
                }
                DatabaseFieldList databaseFieldList = this.a(null, null);
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("SELECT ");
                Database database = (Database)this.qU.getDataFactory();
                if (databaseFieldList.size() > 0) {
                    for (int i2 = 0; i2 < databaseFieldList.size(); ++i2) {
                        if (i2 > 0) {
                            stringBuilder.append(',').append(' ');
                        }
                        object = database.convertIdentifier(this.qU, databaseFieldList.elementAt(i2).getName());
                        stringBuilder.append((String)object);
                    }
                } else {
                    stringBuilder.append('1');
                }
                stringBuilder.append(" FROM ").append(this.ku()).append(' ').append(database.getConfiguration().getAliasToken()).append(' ').append(this.PD);
                String string = DatabaseTables.changeWhereToNoRows(stringBuilder.toString());
                this.lz.bB.BD = object = connection.createStatement();
                DatabaseUtils.executeQuery((Statement)object, string, null);
            }
            catch (SQLException sQLException) {
                if (this.getSql() != null) {
                    Object[] objectArray = new Object[]{this.getAlias(), sQLException.getLocalizedMessage()};
                    throw ReportExceptionFactory.createReportException(ReportErrorCode.commandDoesNotWorkAnymore, objectArray);
                }
                Object[] objectArray = new Object[]{this.getAlias(), sQLException.getLocalizedMessage()};
                throw ReportExceptionFactory.createReportException(ReportErrorCode.reportDoesNotWorkAnymore, objectArray);
            }
        }
    }

    public void addColumn(String columnName, int columnType) throws ReportException {
        if (!by.bQ(columnType)) {
            throw ReportExceptionFactory.createReportException(ReportErrorCode.InvalidColumnType, new Integer(columnType));
        }
        if (columnName != null) {
            DatabaseField databaseField = this.g(columnName, columnType);
            this.PF.addElement(databaseField);
            this.lz.bB.jd().addElement(databaseField);
            Fields.a(this.lz.bB, databaseField, 0);
        }
    }

    public void addColumn(String columnName, int columnType, String columnLabel) throws ReportException {
        if (!by.bQ(columnType)) {
            throw ReportExceptionFactory.createReportException(ReportErrorCode.InvalidColumnType, new Integer(columnType));
        }
        if (columnName != null) {
            DatabaseField databaseField = this.g(columnName, columnType);
            this.PF.addElement(databaseField);
            this.lz.bB.jd().addElement(databaseField);
            databaseField.setColumnLabel(columnLabel);
            Fields.a(this.lz.bB, databaseField, 0);
        }
    }

    void a(DatabaseField databaseField) {
        databaseField.kU = this;
        this.PF.addElement(databaseField);
        this.lz.bB.jd().addElement(databaseField);
    }

    void b(DatabaseField databaseField) throws ReportException {
        this.c(databaseField);
        this.lz.bB.jd().removeElement(databaseField);
        this.PF.removeElement(databaseField);
    }

    private DatabaseField g(String string, int n2) throws ReportException {
        if (!by.bQ(n2)) {
            throw ReportExceptionFactory.createReportException(ReportErrorCode.InvalidColumnType, new Integer(n2));
        }
        if (string == null || string.length() == 0) {
            throw ReportExceptionFactory.createReportException(ReportErrorCode.InvalidColumnName, string);
        }
        DatabaseField databaseField = new DatabaseField(this.lz.bB);
        databaseField.name = this.PD + "." + string;
        databaseField.kU = this;
        databaseField.valueType = n2;
        databaseField.kW = string;
        return databaseField;
    }

    public DatabaseField getDatabaseField(int idx) {
        return this.PF.elementAt(idx);
    }

    public DatabaseField getDatabaseField(String columnName) {
        int n2 = this.PF.indexOf(this.PD + "." + columnName);
        if (n2 >= 0) {
            return this.PF.elementAt(n2);
        }
        return null;
    }

    public DatabaseField[] getDatabaseFields() {
        return this.PF.toArray();
    }

    public String getColumnName(int idx) {
        return this.PF.elementAt(idx).getShortName();
    }

    public String[] getColumnNames() {
        int n2 = this.getColumnCount();
        String[] stringArray = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            stringArray[i2] = this.getColumnName(i2);
        }
        return stringArray;
    }

    public int[] getColumnTypes() {
        int n2 = this.getColumnCount();
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = this.getColumnType(i2);
        }
        return nArray;
    }

    public int getColumnType(int idx) throws IndexOutOfBoundsException {
        return this.PF.elementAt(idx).getValueType();
    }

    int ar(String string) throws ReportException {
        for (int i2 = 0; i2 < this.PF.size(); ++i2) {
            if (!string.equalsIgnoreCase(this.PF.elementAt(i2).getShortName())) continue;
            return this.PF.elementAt(i2).getValueType();
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i3 = 0; i3 < this.PF.size(); ++i3) {
            if (i3 > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(this.PF.elementAt(i3).getName());
        }
        throw ReportExceptionFactory.createReportException(ReportErrorCode.NoColumn, string, stringBuilder);
    }

    public void removeColumn(String columnName) throws ReportException {
        if (this.PF.indexOf(this.PD + "." + columnName) == -1) {
            return;
        }
        this.canRemoveColumn(columnName);
        Fields fields = this.lz.bB.getFields();
        List<Join> list = this.lz.bB.jc().bN();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            int n2;
            Join join = list.get(i2);
            if (join.getSourceAlias().equals(this.getAlias())) {
                for (n2 = 0; n2 < join.getConditionCount(); ++n2) {
                    if (!join.getConditionSourceColumn(n2).equals(columnName)) continue;
                    join.removeCondition(n2);
                    --n2;
                }
            }
            if (join.getTargetAlias().equals(this.getAlias())) {
                for (n2 = 0; n2 < join.getConditionCount(); ++n2) {
                    if (!join.getConditionTargetColumn(n2).equals(columnName)) continue;
                    join.removeCondition(n2);
                    --n2;
                }
            }
            if (join.getConditionCount() != 0) continue;
            list.remove(i2);
        }
        DatabaseField databaseField = fields.getDatabaseField(this.PD + "." + columnName);
        if (databaseField != null) {
            BaseUtils.info(Msg.getMsg("removing", databaseField.paramString()));
        }
        this.lz.bB.jd().removeElement(databaseField);
        this.PF.removeElement(databaseField);
        if (databaseField != null) {
            this.lz.bB.getFields().a(databaseField, 1);
        }
    }

    public void canRemoveColumn(String columnName) throws ReportException {
        Fields fields = this.lz.bB.getFields();
        DatabaseField databaseField = fields.getDatabaseField(this.PD + "." + columnName);
        if (databaseField == null) {
            return;
        }
        this.c(databaseField);
    }

    private void c(DatabaseField databaseField) throws ReportException {
        if (databaseField.getReferenceHolderCount() > 0) {
            boolean bl2 = true;
            ReferenceHolder[] referenceHolderArray = databaseField.getReferenceHolders();
            for (int i2 = 0; i2 < referenceHolderArray.length; ++i2) {
                if (referenceHolderArray[i2] instanceof Join) continue;
                bl2 = false;
                break;
            }
            if (!bl2) {
                Object object = "";
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(databaseField.getName());
                arrayList.add(this.PD);
                int n2 = 2;
                for (int i3 = 0; i3 < databaseField.getReferenceHolderCount(); ++i3) {
                    Object object2 = databaseField.getReferenceHolders()[i3];
                    if (object2 instanceof Field) {
                        object2 = ((Field)object2).getRefName() + " (" + object2.getClass().getSimpleName() + ")";
                    } else if (object2 instanceof FieldElement) {
                        FieldElement fieldElement = (FieldElement)object2;
                        Section section = (Section)fieldElement.getParent();
                        Object object3 = "";
                        if (section != null) {
                            Area area = (Area)section.getParent();
                            object3 = (String)object3 + area.getTypeAsString();
                            if (area.getSectionCount() > 1) {
                                object3 = (String)object3 + "(" + section.getSectionNameByNumber(section.indexOf()) + ")";
                            }
                        }
                        object2 = Msg.getMsg(ReportErrorCode.DBFieldIsUsedFieldPosition.name(), fieldElement.getX() / 15, fieldElement.getY() / 15, object3);
                    } else {
                        object2 = object2.getClass().getSimpleName();
                    }
                    object = (String)object + String.valueOf(object2) + "\n";
                    ++n2;
                }
                arrayList.add((String)object);
                throw ReportExceptionFactory.createReportException(ReportErrorCode.DBFieldIsUsed, arrayList.toArray());
            }
        }
    }

    private boolean a(PromptField promptField) throws ReportException {
        if (promptField == null) {
            return true;
        }
        return !promptField.isUsed() || promptField.f(this);
    }

    void kt() {
        this.PF.clear();
    }

    void as(String string) throws ReportException {
        if (DatabaseUtils.useJdbcDriver(this.qU.k(false))) {
            TableSource.checkAliasValidity(string);
        } else {
            TableSource.au(string);
        }
        this.PD = string;
    }

    void at(String string) {
        this.PD = string;
    }

    private static String au(String string) throws ReportException {
        if (string == null || string.length() == 0) {
            throw ReportExceptionFactory.createReportException(ReportErrorCode.noEmptyAliasAllowed, new Object[0]);
        }
        if (string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"') {
            string = string.substring(1, string.length() - 1);
        }
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (i2 == 0) {
                if (Character.isLetter(c2) || c2 == '[') continue;
                throw ReportExceptionFactory.createReportException(ReportErrorCode.firstCharIsNotALetter, new Object[0]);
            }
            if (Character.isLetterOrDigit(c2) || c2 == '_' || c2 == ';' || c2 == '-' || c2 == '$' || c2 == ']') continue;
            throw ReportExceptionFactory.createReportException(ReportErrorCode.illegalCharInAliasname, new Character(c2));
        }
        return string;
    }

    public static void checkAliasValidity(String newAlias) throws ReportException {
        if (PL.contains((newAlias = TableSource.au(newAlias)).toUpperCase())) {
            throw ReportExceptionFactory.createReportException(ReportErrorCode.keywordsAsAlias, newAlias);
        }
    }

    public void changeAliasReferences(String newAlias) throws ReportException {
        String string = this.getAlias();
        if (this.lz.bB.jc().s(newAlias)) {
            Object[] objectArray = new Object[]{newAlias};
            throw ReportExceptionFactory.createReportException(ReportErrorCode.DuplicateAliases, objectArray);
        }
        this.as(newAlias);
        this.lz.bB.getFields().changeAllAliases(string, newAlias, this.getDatasource());
    }

    void av(String object) {
        int n2 = ((String)object).toLowerCase().indexOf("proc(");
        if (n2 >= 0) {
            String string = ((String)object).substring(n2 + 5, ((String)object).length() - 1);
            int n3 = string.indexOf(46);
            if (n3 != -1) {
                if (n2 > 0) {
                    --n2;
                }
                object = string.substring(0, n3 + 1) + ((String)object).substring(0, n2) + string.substring(n3, string.length());
            } else {
                object = ((String)object).substring(0, n2) + string;
            }
        }
        this.PE = object;
    }

    public void setDatabaseIdentifierName(String newDatabaseIdentifier) throws ReportException {
        if (newDatabaseIdentifier == null || newDatabaseIdentifier.length() == 0) {
            throw ReportExceptionFactory.createReportException(ReportErrorCode.noEmptyIdentifierNameAllowed, new Object[0]);
        }
        this.av(newDatabaseIdentifier);
    }

    public int getColumnCount() {
        return this.PF.size();
    }

    public String getAlias() {
        return this.PD;
    }

    public String getDatabaseIdentifier() {
        return this.PE;
    }

    String ku() {
        DataFactory dataFactory = this.qU.k(false);
        return ((Database)dataFactory).getSourceNameWithChange(this, dataFactory.getConfiguration().isUseEscapeEverything());
    }

    String kv() {
        int n2;
        Object object = this.ku();
        if (object == null) {
            return null;
        }
        String string = ((Database)this.qU.getDataFactory()).getIdentifierQuoteString();
        if (string == null || string.length() == 0) {
            return object;
        }
        while ((n2 = ((String)object).indexOf(string)) != -1) {
            object = ((String)object).substring(0, n2) + ((String)object).substring(n2 + 1);
        }
        return object;
    }

    public void setLocation(String location, Datasource newDatasource) {
        if (BaseUtils.isDebug()) {
            BaseUtils.debug("[TableSource " + this.getAlias() + " DS#" + this.getDatasource().cb() + "]setLocation " + location + "  new DS#" + String.valueOf(newDatasource));
        }
        this.type = 0;
        if (newDatasource != null && this.qU != newDatasource) {
            this.qU.a(this, newDatasource);
        }
        if (location == null) {
            return;
        }
        int n2 = this.PE.lastIndexOf(46);
        if (n2 == -1) {
            if (location.length() > 0) {
                this.PE = location + "." + this.PE;
            }
            return;
        }
        this.PE = location.length() > 0 ? location + "." + this.PE.substring(n2 + 1, this.PE.length()) : this.PE.substring(n2 + 1, this.PE.length());
    }

    public String toString() {
        return this.PD;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof TableSource)) {
            return false;
        }
        TableSource tableSource = (TableSource)o2;
        if (tableSource.PD == null) {
            return false;
        }
        return tableSource.PD.equals(this.PD);
    }

    public String getSql() {
        return this.PG;
    }

    public String getSqlWithPromptFieldValues() throws ReportException {
        this.updateReferences();
        PromptPlaceholderReplacer promptPlaceholderReplacer = new PromptPlaceholderReplacer(this.qU.getDataFactory().getSqlSyntax());
        promptPlaceholderReplacer.setQuoteStringPrompts(this.PH);
        return promptPlaceholderReplacer.replace(this.PG, this.lz.bB.getFields());
    }

    String af(boolean bl2) throws ReportException, SQLException {
        DataFactory dataFactory = this.qU.getDataFactory();
        if (!DatabaseUtils.useJdbcDriver(dataFactory)) {
            if (BaseUtils.isDebug()) {
                BaseUtils.debug("Call of getDefaultSql from non JDBC database class.");
            }
            return "";
        }
        switch (this.getType()) {
            case 3: {
                if (bl2) {
                    return this.PG;
                }
                SqlSyntax sqlSyntax = dataFactory.getSqlSyntax();
                return new PromptPlaceholderReplacer(sqlSyntax).setQuoteStringPrompts(this.PH).replace(this.PG, this.lz.bB.getFields());
            }
            case 2: {
                return this.ae(bl2);
            }
        }
        return this.ks();
    }

    public void setSql(String newSql) {
        this.resetReferences();
        if (newSql != null && newSql.trim().length() == 0) {
            newSql = null;
        }
        this.PG = newSql;
        this.setReferences();
        this.type = 3;
    }

    public void setQuoteStringPrompts(boolean value) {
        this.PH = value;
    }

    public boolean getQuoteStringPrompts() {
        return this.PH;
    }

    public Datasource getDatasource() {
        return this.qU;
    }

    void setDatasource(Datasource newConnection) {
        this.qU = newConnection;
    }

    String[] kw() {
        return this.PK;
    }

    void b(String[] stringArray) {
        this.PK = stringArray;
    }

    public void setInputParameter(String[] paramNames, int[] paramTypes) throws ReportException {
        this.setInputParameter(paramNames, paramTypes, null);
    }

    public void setInputParameter(String[] paramNames, int[] paramTypes, Object[] values) throws ReportException {
        int n2;
        if (paramNames.length != paramTypes.length) {
            Object[] objectArray = new Object[]{new Integer(paramNames.length), new Integer(paramTypes.length)};
            throw ReportExceptionFactory.createReportException(ReportErrorCode.inputParamsOfDifferentSize, objectArray);
        }
        ArrayList<PromptField> arrayList = new ArrayList<PromptField>();
        Fields fields = this.lz.bB.getFields();
        int n3 = 0;
        block3: for (n2 = 0; n2 < paramNames.length; ++n2) {
            String string = paramNames[n2];
            switch (paramTypes[n2]) {
                case -10: 
                case 1111: {
                    continue block3;
                }
                default: {
                    PromptField promptField = fields.getPromptField(string);
                    if (promptField == null || promptField.yZ != this) {
                        promptField = fields.addPromptField(TableSource.a(string, this.lz.bB.iZ()), "", paramTypes[n2]);
                        promptField.yY = string;
                        promptField.yZ = this;
                    }
                    if (values != null && values[n3] != null) {
                        promptField.setPromptValue(values[n3]);
                    }
                    arrayList.add(promptField);
                    ++n3;
                }
            }
        }
        if (this.type != 3) {
            this.type = 2;
        }
        this.b(paramNames);
        for (n2 = fields.getPromptFieldsCount() - 1; n2 >= 0; --n2) {
            PromptField promptField = fields.getPromptField(n2);
            if (promptField.yZ != this || arrayList.contains(promptField) || !this.a(promptField)) continue;
            promptField.yZ = null;
            promptField.yY = null;
            fields.removePromptField(n2);
        }
    }

    public List<PromptField> getInputParameters() throws ReportException {
        ArrayList<PromptField> arrayList = new ArrayList<PromptField>();
        Fields fields = this.lz.bB.getFields();
        for (int i2 = 0; i2 < fields.getPromptFieldsCount(); ++i2) {
            PromptField promptField = fields.getPromptField(i2);
            if (promptField.yZ != this) continue;
            arrayList.add(promptField);
        }
        return arrayList;
    }

    @Deprecated
    public void setInputParameter_TypesOfSQLType(String[] paramNames, int[] paramTypes) throws ReportException {
        LogManager.deprecatedMessage();
        this.setInputParameter_TypesOfSQLType(paramNames, paramTypes, null);
    }

    @Deprecated
    public void setInputParameter_TypesOfSQLType(String[] paramNames, int[] paramTypes, Object[] values) throws ReportException {
        LogManager.deprecatedMessage();
        if (paramNames.length != paramTypes.length) {
            Object[] objectArray = new Object[]{new Integer(paramNames.length), new Integer(paramTypes.length)};
            throw ReportExceptionFactory.createReportException(ReportErrorCode.inputParamsOfDifferentSize, objectArray);
        }
        block3: for (int i2 = 0; i2 < paramTypes.length; ++i2) {
            int n2 = paramTypes[i2];
            switch (n2) {
                case -10: 
                case 1111: {
                    continue block3;
                }
                default: {
                    int n3 = DatabaseTables.mapSqlTypeToCCType(n2);
                    if (BaseUtils.isDebug()) {
                        BaseUtils.debug("[TableSource " + this.PD + "] parameter " + paramNames[i2] + " map sql type " + n2 + " to " + n3);
                    }
                    paramTypes[i2] = n3;
                }
            }
        }
        this.setInputParameter(paramNames, paramTypes, values);
    }

    private static String a(String string, PromptField[] promptFieldArray) {
        int n2 = 0;
        boolean bl2 = true;
        String string2 = string;
        block0: while (bl2) {
            bl2 = false;
            string2 = n2 == 0 ? string : string + "_" + n2;
            for (int i2 = 0; promptFieldArray != null && i2 < promptFieldArray.length; ++i2) {
                if (!promptFieldArray[i2].name.equalsIgnoreCase(string2)) continue;
                ++n2;
                bl2 = true;
                continue block0;
            }
        }
        return string2;
    }

    DatabaseFieldList a(List<Join> list, ResultSet resultSet) throws ReportException, SQLException {
        if (resultSet != null) {
            DatabaseFieldList databaseFieldList = new DatabaseFieldList(this.PF.size());
            databaseFieldList.setAllowDuplicatedEntries(true);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n2 = resultSetMetaData.getColumnCount();
            for (int i2 = 1; i2 <= n2; ++i2) {
                String string;
                Object object = resultSetMetaData.getColumnName(i2);
                DatabaseField databaseField = this.getDatabaseField(this.a((String)object, string = resultSetMetaData.getColumnLabel(i2), i2 - 1));
                if (databaseField != null) {
                    databaseFieldList.addElement(databaseField);
                    continue;
                }
                databaseField = this.getDatabaseField((String)object);
                if (databaseField != null) {
                    databaseFieldList.addElement(databaseField);
                    continue;
                }
                if (object == null || ((String)object).trim().length() == 0) {
                    object = "EmptyColumnName" + i2;
                }
                if (!((String)object).equalsIgnoreCase(string) && (databaseField = this.getDatabaseField(string)) != null) {
                    databaseFieldList.addElement(databaseField);
                    continue;
                }
                if (BaseUtils.isDebug()) {
                    BaseUtils.debug("Addtional Column: " + (String)object + ", alias: " + string);
                }
                this.addColumn((String)object, 6);
                databaseFieldList.addElement(this.getDatabaseField((String)object));
            }
            return databaseFieldList;
        }
        return this.a(list, true);
    }

    DatabaseFieldList a(List<Join> list, boolean bl2) throws ReportException {
        Serializable serializable;
        DatabaseFieldList databaseFieldList = new DatabaseFieldList();
        if (this.lz.bB.jd() != null) {
            for (int i2 = 0; i2 < this.lz.bB.jd().size(); ++i2) {
                serializable = this.lz.bB.jd().elementAt(i2);
                if (((DatabaseField)serializable).kU != this || !((Field)serializable).isUsed() && (bl2 || !Database.a((DatabaseField)serializable, this.lz.bB))) continue;
                databaseFieldList.addElement((DatabaseField)serializable);
            }
        }
        List<Join> list2 = this.lz.bB.jc().bN();
        serializable = this.lz.bB.jc();
        for (int i3 = 0; i3 < list2.size(); ++i3) {
            Join join = list2.get(i3);
            if (list != null && list.contains(join)) continue;
            TableSource tableSource = ((DatabaseTables)serializable).getTablesource(join.getSourceAlias());
            if (tableSource == this) {
                databaseFieldList.addAll(join.getConditionSourceFields());
                continue;
            }
            TableSource tableSource2 = join.getTargetTableSource();
            if (tableSource2 != this) continue;
            databaseFieldList.addAll(join.getConditionTargetFields());
        }
        return databaseFieldList;
    }

    boolean kx() throws ReportException {
        for (int i2 = 0; i2 < this.PF.size(); ++i2) {
            DatabaseField databaseField = this.lz.bB.getFields().getDatabaseField(this.PD.concat(".").concat(this.getColumnName(i2)));
            if (databaseField == null || databaseField.getRealReferenceCount() <= 0) continue;
            return true;
        }
        return false;
    }

    void d(StringBuilder stringBuilder, int n2) {
        stringBuilder.append(BaseUtils.getIndent(n2));
        stringBuilder.append("<").append("Tablesource").append(k.l("alias", this.PD)).append(k.l("databaseIdentifier", this.PE));
        stringBuilder.append(">\n").append("\n");
        ++n2;
        for (int i2 = 0; i2 < this.PF.size(); ++i2) {
            DatabaseField databaseField = this.PF.elementAt(i2);
            stringBuilder.append(BaseUtils.getIndent(n2));
            stringBuilder.append("<").append("Column").append(k.l("name", databaseField.getShortName())).append(k.l("type", "" + databaseField.getValueType()));
            if (databaseField.hasColumnLabel()) {
                stringBuilder.append(k.l("description", databaseField.getColumnLabel()));
            }
            stringBuilder.append(" />\n");
        }
        if (this.PG != null && this.PG.length() > 0) {
            stringBuilder.append(BaseUtils.getIndent(n2));
            stringBuilder.append("<").append("Sql");
            if (!this.PH) {
                stringBuilder.append(k.l("QuoteStringPrompts", "false"));
            }
            stringBuilder.append(">\n").append("\n");
            stringBuilder.append(BaseUtils.getIndent(++n2)).append(k.h(this.PG)).append("\n").append(BaseUtils.getIndent(--n2));
            stringBuilder.append("<").append("/").append("Sql").append(">\n").append("\n");
        }
        stringBuilder.append(BaseUtils.getIndent(--n2)).append("<").append("/").append("Tablesource").append(">\n").append("\n");
    }

    @Override
    public final void addReferencedObject(ReferencedObject reference) {
        this.qj.addReferencedObject(reference);
    }

    @Override
    public final ReferencedObject[] getReferencedObjects() {
        return this.qj.getReferencedObjects();
    }

    @Override
    public final int getRealReferencedObjectCount() {
        return this.qj.getRealReferencedObjectCount();
    }

    @Override
    public final int getReferencedObjectCount() {
        return this.qj.getReferencedObjectCount();
    }

    @Override
    public final void removeReferencedObject(ReferencedObject reference) {
        this.qj.removeReferencedObject(reference);
    }

    @Override
    public final void setReferences() {
        if (this.PG == null || this.PG.length() == 0) {
            return;
        }
        PromptField[] promptFieldArray = this.lz.bB.iZ();
        if (promptFieldArray != null) {
            for (PromptField object : promptFieldArray) {
                String string = object.getPlaceholderName();
                int n2 = -1;
                while ((n2 = this.PG.indexOf(string, n2 + 1)) != -1) {
                    object.addReferenceHolder(this);
                }
            }
        }
        try {
            Fields fields = this.lz.getFields();
            for (int i2 = 0; i2 < fields.getFormulaFieldsCount(); ++i2) {
                FormulaField formulaField = fields.getFormulaField(i2);
                String string = formulaField.getPlaceholderName();
                int n3 = -1;
                while ((n3 = this.PG.indexOf(string, n3 + 1)) != -1) {
                    formulaField.addReferenceHolder(this);
                }
            }
        }
        catch (ReportException reportException) {
            BaseUtils.error(reportException);
        }
    }

    @Override
    public final void resetReferences() {
        this.qj.resetReferences();
        PromptField[] promptFieldArray = this.lz.bB.iZ();
        if (promptFieldArray != null) {
            for (int i2 = 0; i2 < promptFieldArray.length; ++i2) {
                promptFieldArray[i2].removeReferenceHolder(this);
            }
        }
        if (this.lz.bB.It != null) {
            for (FormulaField formulaField : this.lz.bB.It) {
                formulaField.removeReferenceHolder(this);
            }
        }
    }

    public void refresh() throws ReportException, SQLException {
        try {
            this.ky();
        }
        catch (ReportException reportException) {
            if (BaseUtils.isDebug()) {
                BaseUtils.debug(reportException);
            }
            throw reportException;
        }
    }

    private void ky() throws ReportException, SQLException {
        int n2;
        Field field;
        int n3;
        PromptField[] promptFieldArray;
        if (BaseUtils.isDebug()) {
            BaseUtils.debug("[TableSource " + this.PD + "] start refresh");
        }
        this.kq();
        MissedColumnException missedColumnException = new MissedColumnException();
        DataFactory dataFactory = this.qU.getDataFactory();
        List<ColumnInfo> list = dataFactory.getColumns(this);
        StringList stringList = new StringList();
        IntList intList = new IntList();
        StringList stringList2 = new StringList();
        IntList intList2 = new IntList();
        block12: for (int i2 = 0; i2 < list.size(); ++i2) {
            promptFieldArray = list.get(i2);
            switch (promptFieldArray.getSqlType()) {
                case -10: 
                case 1111: 
                case 2012: {
                    continue block12;
                }
                default: {
                    switch (promptFieldArray.getColumnType()) {
                        case 1: 
                        case 2: 
                        case 4: {
                            stringList2.addElement(promptFieldArray.getName());
                            intList2.addElement(promptFieldArray.getDataType());
                        }
                        case 5: {
                            continue block12;
                        }
                        case 3: {
                            stringList.addElement(promptFieldArray.getName());
                            intList.addElement(promptFieldArray.getDataType());
                        }
                    }
                }
            }
        }
        ArrayList<Field> arrayList = new ArrayList<Field>();
        promptFieldArray = this.lz.bB.iZ();
        for (int i3 = 0; i3 < stringList2.size(); ++i3) {
            boolean bl2 = false;
            String string = stringList2.elementAt(i3);
            int n4 = intList2.elementAt(i3);
            for (n3 = 0; promptFieldArray != null && n3 < promptFieldArray.length; ++n3) {
                field = promptFieldArray[n3];
                if (((PromptField)field).yZ != this || !string.equalsIgnoreCase(((PromptField)field).yY)) {
                    if (((PromptField)field).yZ != this && ((PromptField)field).yZ != null || !string.equalsIgnoreCase(((PromptField)field).name)) continue;
                    ((PromptField)field).yZ = this;
                    ((PromptField)field).yY = string;
                }
                bl2 = true;
                ((PromptField)field).setValueType(n4);
                arrayList.add(field);
                break;
            }
            if (bl2) continue;
            PromptField promptField = this.lz.bB.getFields().addPromptField(TableSource.a(string, this.lz.bB.iZ()), "", n4);
            promptField.yZ = this;
            promptField.yY = string;
            arrayList.add(promptField);
        }
        ArrayList<PromptField> arrayList2 = new ArrayList<PromptField>();
        StringList stringList3 = new StringList();
        for (n2 = 0; n2 < this.getColumnCount(); ++n2) {
            String string = this.getColumnName(n2);
            n3 = stringList.indexOfIgnoreCase(string);
            if (n3 == -1) {
                this.a(string, stringList3, missedColumnException);
                continue;
            }
            field = this.getDatabaseField(string);
            try {
                field.setValueType(intList.elementAt(n3));
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.a(string, stringList3, missedColumnException);
            }
        }
        for (n2 = 0; promptFieldArray != null && n2 < promptFieldArray.length; ++n2) {
            PromptField promptField = promptFieldArray[n2];
            if (promptField.yZ != this || arrayList.contains(promptField)) continue;
            if (this.a(promptField)) {
                arrayList2.add(promptField);
                continue;
            }
            promptField.yZ = null;
            promptField.yY = null;
        }
        for (n2 = 0; n2 < stringList3.size(); ++n2) {
            String string = stringList3.elementAt(n2);
            if (BaseUtils.isDebug()) {
                BaseUtils.debug("[TableSource(SP) " + this.PD + "] remove Column " + string);
            }
            this.removeColumn(string);
        }
        for (n2 = 0; n2 < arrayList2.size(); ++n2) {
            PromptField promptField = (PromptField)arrayList2.get(n2);
            promptField.yZ = null;
            promptField.yY = null;
            if (BaseUtils.isDebug()) {
                BaseUtils.debug("[TableSource(SP) " + this.PD + "]remove PromptField " + promptField.getName());
            }
            this.lz.bB.getFields().removePromptField(promptField.indexOf());
        }
        for (n2 = 0; n2 < stringList.size(); ++n2) {
            String string = stringList.elementAt(n2);
            if (list.contains(this.PD + "." + string)) continue;
            n3 = intList.elementAt(n2);
            if (BaseUtils.isDebug()) {
                BaseUtils.debug("[TableSource(SP) " + this.PD + "]add Column " + string + " " + n3);
            }
            try {
                this.addColumn(string, n3);
                continue;
            }
            catch (ReportException reportException) {
                if (!BaseUtils.isDebug()) continue;
                BaseUtils.debug("[TableSource(Tbl) " + this.PD + "] ignore Column " + string + " because of invalid column type " + n3);
            }
        }
        if (missedColumnException.getColumns().size() > 0) {
            throw missedColumnException;
        }
        if (dataFactory instanceof Database && !this.lz.bB.ji().getFile().endsWith(".dataview")) {
            ((Database)dataFactory).findColumnLabels(this);
        }
    }

    private void a(String string, StringList stringList, MissedColumnException missedColumnException) {
        try {
            this.canRemoveColumn(string);
            stringList.addElement(string);
        }
        catch (ReportException reportException) {
            missedColumnException.addColumn(string);
        }
    }

    void d(DatabaseField databaseField) {
        int n2 = this.PF.indexOf(databaseField);
        if (n2 != -1) {
            this.PF.setElementAt(databaseField, n2);
        } else {
            this.PF.addElement(databaseField);
        }
        n2 = this.lz.bB.jd().indexOf(databaseField);
        if (n2 != -1) {
            this.lz.bB.jd().setElementAt(databaseField, n2);
        }
    }

    @Override
    public boolean isDOMParser() {
        return false;
    }

    @Override
    public void parseDOM(Node node, Map<String, Object> parserMap) throws FatalParserException {
    }

    @Override
    public NodeParser parseElement(XMLTag group, String tag, Attributes atts, Map<String, Object> parserMap) throws FatalParserException {
        try {
            parserMap.remove("TableSourceIsCurrentlySqlTag");
            XMLTag xMLTag = XMLTag.getValueOf(tag);
            switch (xMLTag) {
                case Sql: {
                    parserMap.put("TableSourceIsCurrentlySqlTag", Boolean.TRUE);
                    String string = atts.getValue("QuoteStringPrompts");
                    if (string == null) break;
                    this.PH = Boolean.parseBoolean(string);
                    break;
                }
                case Column: {
                    String string = atts.getValue("name");
                    int n2 = Integer.valueOf(atts.getValue("type").toString());
                    String string2 = atts.getValue("description");
                    this.addColumn(string, n2, string2);
                    break;
                }
            }
        }
        catch (ReportException reportException) {
            BaseUtils.printStackTrace(reportException);
        }
        return null;
    }

    @Override
    public void parseEndElement(XMLTag group, String tag, Map<String, Object> parserMap) throws FatalParserException {
    }

    @Override
    public void parseText(String text, Map<String, Object> parserMap) {
        if (parserMap.get("TableSourceIsCurrentlySqlTag") != null) {
            this.setSql(text);
        }
    }

    int kz() {
        return this.type;
    }

    void e(DatabaseField databaseField) {
        this.PF.removeElement(databaseField);
    }

    String a(String string, String string2, int n2) throws SQLException, ReportException {
        DataFactory dataFactory = this.qU.getDataFactory();
        if (dataFactory instanceof Database) {
            int n3 = -1;
            try (Connection connection = this.qU.getConnection();){
                if (connection != null) {
                    n3 = connection.getMetaData().getDriverMajorVersion();
                }
                String string3 = ((Database)dataFactory).getColumnName(string, string2, n3, this, n2);
                return string3;
            }
        }
        return string;
    }

    public boolean isUsed() throws ReportException {
        try {
            for (int i2 = 0; i2 < this.getColumnCount(); ++i2) {
                this.canRemoveColumn(this.getColumnName(i2));
            }
        }
        catch (ReportException reportException) {
            return true;
        }
        DatabaseTables databaseTables = this.qU.getEngine().getDatabaseTables();
        Vector vector = databaseTables.getJoinsEntries();
        for (Join join : vector) {
            if (!this.equals(join.getSourceTableSource()) && !this.equals(join.getTargetTableSource())) continue;
            return true;
        }
        return false;
    }

    static {
        PL.add("SELECT");
        PL.add("FROM");
        PL.add("ORDER");
        PL.add("GROUP");
        PL.add("BY");
        PL.add("AS");
        PL.add("WHERE");
        PL.add("UNION");
        PL.add("JOIN");
        PL.add("INNER");
        PL.add("OUTER");
        PL.add("LEFT");
        PL.add("RIGHT");
        PL.add("FULL");
        PL.add("AND");
        PL.add("OR");
        PL.add("ON");
        PL.add("DISTINCT");
        PL.add("SOUNDEX");
        PL.add("ALL");
        PL.add("INTO");
        PL.add("AND");
        PL.add("IS");
        PL.add("ANY");
        PL.add("JOIN");
        PL.add("AS");
        PL.add("LEFT");
        PL.add("ASC");
        PL.add("LIKE");
        PL.add("AVG");
        PL.add("LOCAL");
        PL.add("BETWEEN");
        PL.add("MATCH");
        PL.add("BY");
        PL.add("MAX");
        PL.add("CAST");
        PL.add("MIN");
        PL.add("CORRESPONDING");
        PL.add("NATURAL");
        PL.add("COUNT");
        PL.add("NOT");
        PL.add("CREATE");
        PL.add("NULL");
        PL.add("CROSS");
        PL.add("ON");
        PL.add("DELETE");
        PL.add("OR");
        PL.add("DESC");
        PL.add("ORDER");
        PL.add("DISTINCT");
        PL.add("OUTER");
        PL.add("DROP");
        PL.add("RIGHT");
        PL.add("ESCAPE");
        PL.add("SELECT");
        PL.add("EXCEPT");
        PL.add("SET");
        PL.add("EXISTS");
        PL.add("SOME");
        PL.add("FALSE");
        PL.add("SUM");
        PL.add("FROM");
        PL.add(TYPE_NAME_TABLE);
        PL.add("FULL");
        PL.add("TEMPORARY");
        PL.add("GLOBAL");
        PL.add("TRUE");
        PL.add("GROUP");
        PL.add("UNION");
        PL.add("HAVING");
        PL.add("UNIQUE");
        PL.add("IN");
        PL.add("UNKNOWN");
        PL.add("INNER");
        PL.add("UPDATE");
        PL.add("INSERT");
        PL.add("USING");
        PL.add("INTERSECT");
        PL.add("VALUES");
    }
}

