/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.PublicApi;
import com.inet.authentication.LoginProcessor;
import com.inet.lib.util.EncodingFunctions;
import com.inet.lib.util.IOFunctions;
import com.inet.report.Field;
import com.inet.report.ReportDataHandler;
import com.inet.report.ReportException;
import com.inet.report.at;
import com.inet.report.ba;
import com.inet.report.bw;
import com.inet.report.k;
import java.io.PrintWriter;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.util.Locale;
import java.util.TimeZone;

@PublicApi
public class SpecialField
extends Field {
    public static final int PRINT_DATE = 0;
    public static final int PRINT_TIME = 1;
    public static final int MODIFICATION_DATE = 2;
    public static final int MODIFICATION_TIME = 3;
    public static final int DATA_DATE = 4;
    public static final int DATA_TIME = 5;
    public static final int RECORD_NUMBER = 6;
    public static final int PAGE_NUMBER = 7;
    public static final int GROUP_NUMBER = 8;
    public static final int TOTAL_PAGE_COUNT = 9;
    public static final int REPORT_TITLE = 10;
    public static final int REPORT_COMMENTS = 11;
    public static final int RECORD_SELECTION_FORMULA = 12;
    public static final int GROUP_SELECTION_FORMULA = 13;
    public static final int REPORT_FILE = 14;
    public static final int REPORT_AUTHOR = 15;
    public static final int CREATION_DATE = 16;
    public static final int PAGE_N_OF_M = 17;
    public static final int RECORD_COUNT = 18;
    public static final int HORIZONTAL_PAGE_NUMBER = 19;
    public static final int CURRENT_USER_NAME = 20;
    public static final int CURRENT_USER_ID = 21;
    public static final int CURRENT_USER_TIME_ZONE = 22;
    public static final int PRINT_TIME_ZONE = 23;
    public static final int DATA_TIME_ZONE = 24;
    public static final int CONTENT_LOCALE = 25;
    public static final int SELECTION_LOCALE = 26;
    int MZ;

    SpecialField(ba renderer) {
        this.type = 10;
        this.bB = renderer;
    }

    @Override
    public void setName(String newValue) {
        throw new IllegalStateException("A special field does not have a name.");
    }

    public String getOperationName() {
        switch (this.MZ) {
            case 0: {
                return "PrintDate";
            }
            case 1: {
                return "PrintTime";
            }
            case 23: {
                return "PrintTimeZone";
            }
            case 2: {
                return "ModificationDate";
            }
            case 3: {
                return "ModificationTime";
            }
            case 4: {
                return "DataDate";
            }
            case 5: {
                return "DataTime";
            }
            case 24: {
                return "DataTimeZone";
            }
            case 6: {
                return "RecordNumber";
            }
            case 18: {
                return "RecordCount";
            }
            case 7: {
                return "PageNumber";
            }
            case 8: {
                return "GroupNumber";
            }
            case 9: {
                return "TotalPageCount";
            }
            case 10: {
                return "ReportTitle";
            }
            case 11: {
                return "ReportComments";
            }
            case 12: {
                return "RecordSelection";
            }
            case 13: {
                return "GroupSelection";
            }
            case 14: {
                return "Filename";
            }
            case 15: {
                return "FileAuthor";
            }
            case 16: {
                return "FileCreationDate";
            }
            case 17: {
                return "PageNOfM";
            }
            case 19: {
                return "HorizontalPageNumber";
            }
            case 20: {
                return "CurrentUserName";
            }
            case 22: {
                return "CurrentUserTimeZone";
            }
            case 25: {
                return "ContentLocale";
            }
            case 26: {
                return "SelectionLocale";
            }
        }
        return "";
    }

    public void setSpecialType(int type) {
        this.MZ = type;
    }

    public int getSpecialType() {
        return this.MZ;
    }

    @Override
    Field[] D(int n2) {
        return new SpecialField[n2];
    }

    @Override
    protected void p(PrintWriter printWriter, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        k.a(stringBuilder, n2, "Operation", k.z(this.MZ));
        if (stringBuilder.length() > 0) {
            printWriter.print(stringBuilder);
        }
    }

    @Override
    final void a(int n2, String string, at at2) {
        switch (n2) {
            case 176: {
                this.MZ = Integer.parseInt(string);
                break;
            }
            default: {
                super.a(n2, string, at2);
            }
        }
    }

    @Override
    public String getRefName() {
        return "Specialfield:" + this.MZ;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof SpecialField && super.equals(obj) && this.MZ == ((SpecialField)obj).MZ;
    }

    @Override
    public String getName() {
        return this.getOperationName();
    }

    @Override
    Object getValue() throws ReportException {
        ReportDataHandler reportDataHandler = this.bB.gN();
        switch (this.MZ) {
            case 2: {
                return new Date(this.bB.getSummaryInfo().getLastSaved().getTime());
            }
            case 3: {
                return new Time(this.bB.getSummaryInfo().getLastSaved().getTime());
            }
            case 0: 
            case 4: {
                return new Date(this.bB.iU().getTime());
            }
            case 1: 
            case 5: {
                return new Time(this.bB.iU().getTime());
            }
            case 23: 
            case 24: {
                TimeZone timeZone = TimeZone.getDefault();
                boolean bl2 = timeZone.inDaylightTime(this.bB.iU());
                StringBuilder stringBuilder = new StringBuilder(timeZone.getDisplayName(bl2, 0, this.bB.Jd));
                stringBuilder.append(", ").append(timeZone.getDisplayName(bl2, 1, this.bB.Jd));
                stringBuilder.append(", ").append(timeZone.getID());
                return stringBuilder.toString();
            }
            case 6: {
                return new Integer(reportDataHandler.getRowPosition());
            }
            case 18: {
                return new Integer(reportDataHandler.getRowCount());
            }
            case 7: {
                return new Integer(this.bB.IW - this.bB.IX);
            }
            case 8: {
                return new Integer(reportDataHandler.getCurrentGroupNumber());
            }
            case 9: {
                if (!this.bB.gI()) {
                    throw new bw(this.bB);
                }
                return new Integer(this.bB.gJ());
            }
            case 10: {
                return this.bB.getSummaryInfo().getReportTitle();
            }
            case 11: {
                return this.bB.getSummaryInfo().getComments();
            }
            case 12: {
                return this.bB.je() != null ? this.bB.je().getFormula() : null;
            }
            case 13: {
                return this.bB.jf() != null ? this.bB.jf().getFormula() : null;
            }
            case 14: {
                switch (this.bB.IQ.getProtocol()) {
                    case "file": {
                        return IOFunctions.getFileName((URL)this.bB.IQ);
                    }
                    case "repo": 
                    case "drive": 
                    case "jndi": {
                        return EncodingFunctions.decodeUrlPath((String)this.bB.IQ.getPath());
                    }
                }
                return this.bB.IQ.getFile();
            }
            case 15: {
                return this.bB.getSummaryInfo().getAuthor();
            }
            case 16: {
                return new Date(this.bB.getSummaryInfo().getCreated().getTime());
            }
            case 17: {
                return this.bB.fP();
            }
            case 20: {
                LoginProcessor loginProcessor = LoginProcessor.getCurrent();
                if (loginProcessor != null) {
                    return loginProcessor.getLoginID();
                }
                return "";
            }
            case 22: {
                return "";
            }
            case 19: {
                return new Integer(1);
            }
            case 25: {
                return this.bB.Jd;
            }
            case 26: {
                if (this.bB.Jc == null) {
                    return Locale.getDefault();
                }
                return this.bB.Jc;
            }
        }
        return "Unknown SpecialField: " + this.MZ;
    }

    public static final class a
    extends Enum<a> {
        public static final /* enum */ a Nj = new a(0);
        public static final /* enum */ a Nk = new a(1);
        public static final /* enum */ a Nl = new a(2);
        public static final /* enum */ a Nm = new a(3);
        public static final /* enum */ a Nn = new a(4);
        public static final /* enum */ a No = new a(5);
        public static final /* enum */ a Np = new a(6);
        public static final /* enum */ a Nq = new a(7);
        public static final /* enum */ a Nr = new a(8);
        public static final /* enum */ a Ns = new a(9);
        public static final /* enum */ a Nt = new a(10);
        public static final /* enum */ a Nu = new a(11);
        public static final /* enum */ a Nv = new a(12);
        public static final /* enum */ a Nw = new a(13);
        public static final /* enum */ a Nx = new a(14);
        public static final /* enum */ a Ny = new a(15);
        public static final /* enum */ a Nz = new a(16);
        public static final /* enum */ a NA = new a(17);
        public static final /* enum */ a NB = new a(17);
        public static final /* enum */ a NC = new a(18);
        public static final /* enum */ a ND = new a(19);
        public static final /* enum */ a NE = new a(20);
        public static final /* enum */ a NF = new a(22);
        public static final /* enum */ a NG = new a(23);
        public static final /* enum */ a NH = new a(24);
        public static final /* enum */ a NI = new a(25);
        public static final /* enum */ a NJ = new a(26);
        private int gz;
        private static final /* synthetic */ a[] NK;

        public static a[] values() {
            return (a[])NK.clone();
        }

        public static a valueOf(String name) {
            return Enum.valueOf(a.class, name);
        }

        private a(int n3) {
            this.gz = n3;
        }

        int kb() {
            return this.gz;
        }

        private static /* synthetic */ a[] kc() {
            return new a[]{Nj, Nk, Nl, Nm, Nn, No, Np, Nq, Nr, Ns, Nt, Nu, Nv, Nw, Nx, Ny, Nz, NA, NB, NC, ND, NE, NF, NG, NH, NI, NJ};
        }

        static {
            NK = a.kc();
        }
    }
}

