/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.PublicApi;
import com.inet.report.BaseUtils;
import com.inet.report.BorderProperties;
import com.inet.report.Element;
import com.inet.report.Engine;
import com.inet.report.RDC;
import com.inet.report.ReportComponent;
import com.inet.report.Section;
import com.inet.report.SignatureProperties;
import com.inet.report.certificate.CertificateInfo;
import com.inet.report.certificate.CertificateInfoFactory;
import com.inet.report.i18n.Msg;
import com.inet.report.k;
import com.inet.report.parser.FatalParserException;
import com.inet.report.parser.NodeParser;
import com.inet.report.parser.XMLTag;
import java.io.PrintWriter;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import org.xml.sax.Attributes;

@PublicApi
public class SignatureForm
extends Element
implements BorderProperties,
SignatureProperties {
    public static final int INSET_LEFT = 20;
    public static final int INSET_RIGHT = 20;
    public static final int INSET_TOP = 40;
    public static final int INSET_BOTTOM = 20;
    private String Mo;
    private String Mp;
    private String Mq;
    private String Mr;
    private String Ms;
    private String Mt;
    private String Mu;
    private Date Mv;
    private Date Mw;
    private String Mx;
    private String My;
    private boolean Mz;
    private boolean MA;
    private int MB;
    private boolean MC;
    private boolean MD;
    private boolean ME;
    private boolean MF;
    private boolean MG;
    private boolean MH;

    SignatureForm(Engine engine, Section parentSection) {
        super(70, engine.bM(), parentSection);
        this.jN();
    }

    void dF() {
        CertificateInfoFactory certificateInfoFactory = RDC.getCertificateFactory();
        if (certificateInfoFactory == null) {
            throw new IllegalStateException("signature parameters are not defined: please define ceritifate info factory");
        }
        CertificateInfo certificateInfo = certificateInfoFactory.getCertificateInfo(this.getEngine());
        Certificate certificate = certificateInfo.getCertificate();
        if (certificate instanceof X509Certificate) {
            X509Certificate x509Certificate = (X509Certificate)certificate;
            X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
            X500Principal x500Principal2 = x509Certificate.getIssuerX500Principal();
            this.Mv = x509Certificate.getNotBefore();
            this.Mw = x509Certificate.getNotAfter();
            this.Ms = x500Principal2.getName();
            this.Mu = x500Principal.getName();
            if (this.Mu != null) {
                int n2 = this.Mu.indexOf("CN=");
                if (n2 == -1 && ((n2 = this.Mu.indexOf("cn=")) == -1 || n2 + "CN=".length() >= this.Mu.length())) {
                    if (BaseUtils.isWarning()) {
                        BaseUtils.warning("pdf signature: common name is not defined in the certificate");
                    }
                    this.Mt = "";
                    return;
                }
                int n3 = this.Mu.indexOf(44, n2);
                if (n3 == -1) {
                    n3 = this.Mu.length();
                }
                this.Mt = this.Mu.substring(n2 + "CN=".length(), n3);
            } else {
                this.Mt = "";
            }
        }
    }

    @Override
    void k(PrintWriter printWriter, int n2) {
        String string = BaseUtils.getIndent(n2);
        printWriter.print(string + "<Element" + k.l("type", Element.c.nB.name()) + this.cf() + ">\n");
        this.b(printWriter, ++n2, Element.ma);
        this.a(printWriter, n2, Element.ma);
        this.r(printWriter, n2);
        this.y(printWriter, n2);
        printWriter.print(string + "</Element>\n");
    }

    final void y(PrintWriter printWriter, int n2) {
        String string = BaseUtils.getIndent(n2);
        StringBuilder stringBuilder = new StringBuilder();
        k.a(stringBuilder, ++n2, a.MK.name(), k.g(this.getDivideField()));
        k.a(stringBuilder, n2, a.MM.name(), k.g(this.getShowSubjectName()));
        k.a(stringBuilder, n2, a.ML.name(), k.g(this.getWriteCertificateLabels()));
        k.a(stringBuilder, n2, a.MN.name(), k.g(this.getWriteCertificateSubjectName()));
        k.a(stringBuilder, n2, a.MO.name(), k.g(this.getWriteCertificateDistinguishedName()));
        k.a(stringBuilder, n2, a.MP.name(), k.g(this.getWriteCertificateLocation()));
        k.a(stringBuilder, n2, a.MQ.name(), k.g(this.getWriteCertificateReason()));
        k.a(stringBuilder, n2, a.MR.name(), k.g(this.getWriteCertificateDate()));
        k.a(stringBuilder, n2, a.MS.name(), k.z(this.getTextPosition()));
        if (stringBuilder.length() > 0) {
            printWriter.print(string + "<" + XMLTag.SignatureFormProperties.name() + ">\n");
            printWriter.print(stringBuilder.toString());
            printWriter.print(string + "</" + XMLTag.SignatureFormProperties.name() + ">\n");
        }
    }

    @Override
    public NodeParser parseElement(XMLTag group, String tag, Attributes atts, Map<String, Object> parserMap) throws FatalParserException {
        if (group != null) {
            switch (group) {
                case CommonProperties: 
                case BorderProperties: 
                case HyperlinkProperties: {
                    NodeParser nodeParser = super.parseElement(group, tag, atts, parserMap);
                    return nodeParser;
                }
                case SignatureFormProperties: {
                    String string = atts.getValue("value");
                    if (string == null) {
                        return null;
                    }
                    try {
                        this.t(tag, string);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return null;
                }
            }
            return null;
        }
        NodeParser nodeParser = null;
        XMLTag xMLTag = XMLTag.getValueOf(tag);
        switch (xMLTag) {
            // Empty switch
        }
        return nodeParser;
    }

    private void t(String string, String string2) {
        a a2 = a.MJ;
        try {
            a2 = a.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        switch (a2) {
            case MK: {
                this.Mz = Boolean.valueOf(string2);
                break;
            }
            case MM: {
                this.MA = Boolean.valueOf(string2);
                break;
            }
            case MN: {
                this.MH = Boolean.valueOf(string2);
                break;
            }
            case MO: {
                this.MD = Boolean.valueOf(string2);
                break;
            }
            case MP: {
                this.MF = Boolean.valueOf(string2);
                break;
            }
            case MQ: {
                this.MG = Boolean.valueOf(string2);
                break;
            }
            case ML: {
                this.ME = Boolean.valueOf(string2);
                break;
            }
            case MR: {
                this.MC = Boolean.valueOf(string2);
                break;
            }
            case MS: {
                this.setTextPosition(Integer.parseInt(string2));
            }
        }
    }

    @Override
    public boolean getDivideField() {
        return this.Mz;
    }

    @Override
    public boolean getShowSubjectName() {
        return this.MA;
    }

    @Override
    public int getTextPosition() {
        return this.MB;
    }

    @Override
    public boolean getWriteCertificateDate() {
        return this.MC;
    }

    @Override
    public boolean getWriteCertificateDistinguishedName() {
        return this.MD;
    }

    @Override
    public boolean getWriteCertificateLabels() {
        return this.ME;
    }

    @Override
    public boolean getWriteCertificateLocation() {
        return this.MF;
    }

    @Override
    public boolean getWriteCertificateReason() {
        return this.MG;
    }

    @Override
    public boolean getWriteCertificateSubjectName() {
        return this.MH;
    }

    @Override
    public void setDivideField(boolean val) {
        this.Mz = val;
    }

    @Override
    public void setShowSubjectName(boolean val) {
        this.MA = val;
    }

    @Override
    public void setTextPosition(int pos) {
        this.MB = 1;
        if (pos == 0) {
            this.MB = pos;
        }
    }

    @Override
    public void setWriteCertificateDate(boolean val) {
        this.MC = val;
    }

    @Override
    public void setWriteCertificateDistinguishedName(boolean val) {
        this.MD = val;
    }

    @Override
    public void setWriteCertificateLabels(boolean val) {
        this.ME = val;
    }

    @Override
    public void setWriteCertificateLocation(boolean val) {
        this.MF = val;
    }

    @Override
    public void setWriteCertificateReason(boolean val) {
        this.MG = val;
    }

    @Override
    public void setWriteCertificateSubjectName(boolean val) {
        this.MH = val;
    }

    private void jN() {
        this.Mo = Msg.getMsg(this.bB.Jd, "ExportSignSignedby", new Object[0]);
        this.Mp = Msg.getMsg(this.bB.Jd, "ExportSignReason", new Object[0]) + " ";
        this.Mq = Msg.getMsg(this.bB.Jd, "ExportSignLocation", new Object[0]) + " ";
        this.Mr = Msg.getMsg(this.bB.Jd, "ExportSignSignDate", new Object[0]) + " ";
    }

    String jO() {
        return this.Mt;
    }

    String jP() {
        return this.Mu;
    }

    String jQ() {
        return this.Mx;
    }

    String jR() {
        return this.My;
    }

    String jS() {
        return this.Mo;
    }

    String jT() {
        return this.Mp;
    }

    String jU() {
        return this.Mq;
    }

    String jV() {
        return this.Mr;
    }

    @Override
    public List<? extends ReportComponent> getSubComponents() {
        return null;
    }

    public static final class a
    extends Enum<a> {
        public static final /* enum */ a MJ = new a();
        public static final /* enum */ a MK = new a();
        public static final /* enum */ a ML = new a();
        public static final /* enum */ a MM = new a();
        public static final /* enum */ a MN = new a();
        public static final /* enum */ a MO = new a();
        public static final /* enum */ a MP = new a();
        public static final /* enum */ a MQ = new a();
        public static final /* enum */ a MR = new a();
        public static final /* enum */ a MS = new a();
        private static final /* synthetic */ a[] MT;

        public static a[] values() {
            return (a[])MT.clone();
        }

        public static a valueOf(String name) {
            return Enum.valueOf(a.class, name);
        }

        private static /* synthetic */ a[] jW() {
            return new a[]{MJ, MK, ML, MM, MN, MO, MP, MQ, MR, MS};
        }

        static {
            MT = a.jW();
        }
    }
}

