/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.InternalApi;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.lib.list.IntList;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.AccessDeniedException;
import com.inet.report.BaseUtils;
import com.inet.report.BySummaryOrder;
import com.inet.report.Database;
import com.inet.report.DatabaseCore;
import com.inet.report.DatabaseField;
import com.inet.report.DatabaseSetData;
import com.inet.report.DatabaseTables;
import com.inet.report.Datasource;
import com.inet.report.Engine;
import com.inet.report.Field;
import com.inet.report.Fields;
import com.inet.report.FormulaField;
import com.inet.report.Group;
import com.inet.report.GroupField;
import com.inet.report.Join;
import com.inet.report.ReferenceHolder;
import com.inet.report.ReferencedObject;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.ReportProperties;
import com.inet.report.SortField;
import com.inet.report.SpecifiedOrder;
import com.inet.report.SummaryField;
import com.inet.report.Validity;
import com.inet.report.a;
import com.inet.report.aa;
import com.inet.report.ab;
import com.inet.report.ad;
import com.inet.report.ba;
import com.inet.report.bq;
import com.inet.report.bw;
import com.inet.report.database.DataFactory;
import com.inet.report.database.DatabaseUtils;
import com.inet.report.formula.ast.o;
import com.inet.report.formula.ast.y;
import com.inet.report.formula.e;
import com.inet.report.formula.j;
import com.inet.report.formula.k;
import com.inet.report.formula.q;
import com.inet.report.i18n.ReportErrorCode;
import com.inet.report.rowsource.RowSource;
import com.inet.report.rowsource.b;
import com.inet.report.rowsource.cache.c;
import com.inet.report.rowsource.cache.d;
import com.inet.report.rowsource.g;
import com.inet.report.rowsource.m;
import com.inet.report.rowsource.o;
import com.inet.report.rowsource.r;
import com.inet.report.rowsource.t;
import com.inet.report.rowsource.u;
import com.inet.report.summary.ae;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.annotation.SuppressFBWarnings;

@InternalApi
public class ReportDataHandler
extends a {
    private static final ConfigValue<Integer> rv = new ConfigValue(ConfigKey.COMPATIBILITY_LEVEL);
    private static final ConfigValue<Boolean> Jp = new ConfigValue(ConfigKey.HAS_GROUP_TREE);
    private static final ConfigValue<Integer> Jq = new ConfigValue(ConfigKey.ROW_LIMIT);
    private RowSource Jr;
    private boolean Js;
    private boolean Jt;
    private boolean Ju = true;
    private boolean Jv;
    private int Jw = 1;
    private transient FormulaField Jx;
    private transient ArrayList<ab> Jy;
    private transient com.inet.report.summary.b Jz;
    private boolean JA = false;
    private transient Map<y, Object> JB;
    private boolean JC;
    private transient int JD;
    private boolean JE = true;
    private boolean JF = true;
    private boolean JG = true;
    private Set<Join> JH = null;
    private boolean JI;
    private List<Field> JJ;
    private HashSet<c> JK;

    public ReportDataHandler(ba<?> renderer) {
        super(renderer, new Group[0], new SummaryField[0]);
    }

    public void setUseLastValueCache(boolean useLastValueCache) {
        this.Ju = useLastValueCache;
    }

    @Override
    public boolean isUseLastValueCache() {
        return this.Ju;
    }

    protected void setReturnSQLvalues(boolean returnSQLvalues) {
        this.Jv = returnSQLvalues;
    }

    protected boolean getReturnSQLvalues() {
        return this.Jv;
    }

    @Override
    public ab addGroupTreeNodesList(int depth, StringBuilder term, boolean getDataFromTree, Object obj) {
        int n2 = depth + this.getReport().gP();
        if (obj instanceof u) {
            obj = ((u)obj).nl();
        }
        if (obj instanceof t) {
            obj = ((t)obj).nl();
        }
        ab ab2 = new ab(this.getReport(), depth + 1, n2, term, getDataFromTree, obj);
        ab2.aj(this.getRowSource().getRowPosition());
        this.Jy.add(ab2);
        return ab2;
    }

    @Override
    public void addIndentationList(int groupIndex, int indentationCount, int anfang, int ende) {
        Group group = this.getGroup(groupIndex);
        if (group.sx == null) {
            group.sx = new int[this.getRowCount()];
        }
        for (int i2 = anfang; i2 < ende; ++i2) {
            group.sx[i2] = indentationCount * group.getIndentation();
        }
    }

    @Override
    public void addToTerm(Object groupValue, int ebene, StringBuilder buf) throws ReportException {
        Group group = this.getGroup(ebene);
        int n2 = group.getSortDirection();
        if (group.getHierarchicalGrouping()) {
            groupValue = ((g)groupValue).nl();
        }
        if (n2 == 3 && groupValue instanceof com.inet.report.rowsource.q) {
            com.inet.report.rowsource.q q2 = (com.inet.report.rowsource.q)groupValue;
            if (q2.NG()) {
                if (group.getSpecifiedOrder().getCount() != 0) {
                    buf.append('(');
                    group.getSpecifiedOrder().b(buf);
                    buf.append(')');
                }
            } else {
                buf.append('(');
                q2.a(buf, group.getSpecifiedOrder());
                buf.append(')');
            }
            return;
        }
        if (n2 == 4 && this.hasSummaryData() && this.hasBySummaryOrder()) {
            r r2 = (r)groupValue;
            groupValue = r2.nl();
            if (r2.NG()) {
                buf.append('(');
                buf.append(r2.NH());
                buf.append(')');
                return;
            }
        }
        if (n2 == 2 || n2 == 5) {
            groupValue = ((com.inet.report.rowsource.j)groupValue).nl();
        }
        if (groupValue instanceof u) {
            groupValue = ((u)groupValue).nl();
        }
        if (groupValue instanceof t) {
            groupValue = ((t)groupValue).NK();
        }
        if (groupValue != null) {
            buf.append(group.a(true, groupValue));
        } else {
            buf.append("IsNull({");
            buf.append(group.getField().getRefName());
            buf.append("})");
        }
    }

    @Override
    public Object createGroupTreeNode(Object groupValue, int groupIndex, StringBuilder term, StringBuilder overTerm) {
        Object object;
        Object object2 = groupValue;
        if (groupValue instanceof g) {
            object = (g)groupValue;
            this.JD = ((g)object).Ny();
            groupValue = ((g)object).nl();
        }
        if (groupValue instanceof com.inet.report.rowsource.j) {
            groupValue = ((com.inet.report.rowsource.j)groupValue).nl();
        }
        if (groupValue instanceof r && !((r)(object = (r)groupValue)).NG()) {
            groupValue = ((r)object).nl();
        }
        if (overTerm != null) {
            term.append((CharSequence)overTerm);
        }
        if (term.length() != 0) {
            term.append(" AND ");
        }
        try {
            this.addToTerm(object2, groupIndex, term);
        }
        catch (ReportException reportException) {
            // empty catch block
        }
        object = null;
        object = groupValue instanceof com.inet.report.rowsource.q ? this.addGroupTreeNodesList(groupIndex, term, true, groupValue) : (groupValue instanceof r && ((r)groupValue).NG() ? this.addGroupTreeNodesList(groupIndex, term, true, this.getGroupBySummaryOrder(groupIndex).getOtherName()) : (this.isCustomizeGroupNameEnabled(groupIndex) ? this.addGroupTreeNodesList(groupIndex, term, false, null) : (groupValue instanceof t ? this.addGroupTreeNodesList(groupIndex, term, false, null) : this.addGroupTreeNodesList(groupIndex, term, true, groupValue))));
        if (this.JD != 0) {
            ((ab)object).ak(this.JD);
        }
        return object;
    }

    void i(FormulaField formulaField) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Join join : this.JH) {
            StringBuilder stringBuilder2 = stringBuilder;
            if (stringBuilder2 == null) {
                stringBuilder2 = new StringBuilder();
            }
            for (int i2 = 0; i2 < join.getConditionCount(); ++i2) {
                StringBuilder stringBuilder3 = new StringBuilder();
                stringBuilder3.append('(');
                stringBuilder3.append('{');
                stringBuilder3.append(join.getSourceAlias());
                stringBuilder3.append('.');
                stringBuilder3.append(join.getConditionSourceColumn(i2));
                stringBuilder3.append('}');
                switch (join.getConditionLinkType(i2)) {
                    case 1: {
                        stringBuilder3.append(" = ");
                        break;
                    }
                    case 6: {
                        stringBuilder3.append(" <> ");
                        break;
                    }
                    case 2: {
                        stringBuilder3.append(" > ");
                        break;
                    }
                    case 3: {
                        stringBuilder3.append(" >= ");
                        break;
                    }
                    case 4: {
                        stringBuilder3.append(" < ");
                        break;
                    }
                    case 5: {
                        stringBuilder3.append(" <= ");
                    }
                }
                stringBuilder3.append('{');
                stringBuilder3.append(join.getTargetAlias());
                stringBuilder3.append('.');
                stringBuilder3.append(join.getConditionTargetColumn(i2));
                stringBuilder3.append('}');
                stringBuilder3.append(')');
                if (stringBuilder2.length() != 0) {
                    stringBuilder2.append(" AND ");
                }
                stringBuilder2.append((CharSequence)stringBuilder3);
            }
        }
        formulaField.setFormula(stringBuilder.toString());
    }

    @Override
    public boolean filterJoinCycle() {
        Set<Join> set = this.JH;
        if (set != null && set.size() != 0) {
            if (this.Jx == null) {
                this.Jx = new FormulaField(this.getReport());
                this.i(this.Jx);
            }
            return this.j(this.Jx);
        }
        return false;
    }

    @Override
    public boolean filterRecordSelection() {
        FormulaField formulaField = this.getReport().je();
        if (formulaField != null && (this.JE || this.getFilterLater())) {
            return this.j(formulaField);
        }
        return false;
    }

    @Override
    public IntList getColumnsForDistinct() {
        List<Field> list = this.JJ;
        if (list == null) {
            return new IntList(0);
        }
        IntList intList = new IntList(list.size());
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Field field = list.get(i2);
            if (!field.isUsed() || this.a(field)) continue;
            intList.addElement(i2);
        }
        return intList;
    }

    private boolean a(ReferencedObject referencedObject) {
        if (referencedObject.getReferenceHolderCount() > 0) {
            for (ReferenceHolder referenceHolder : referencedObject.getReferenceHolders()) {
                if (!(referenceHolder instanceof FormulaField ? ((FormulaField)referenceHolder).getFormulaType() != 1 && !this.a((FormulaField)referenceHolder) : !(referenceHolder instanceof SortField))) continue;
                return false;
            }
        }
        return true;
    }

    public int getColumnIdx(Field column) throws ReportException {
        ReportException reportException = null;
        List<Field> list = this.JJ;
        try {
            return ReportDataHandler.a(column, list);
        }
        catch (ReportException reportException2) {
            reportException = reportException2;
            if (list == null) {
                Object[] objectArray = new Object[]{this.toString(), reportException.getMessage()};
                throw ReportExceptionFactory.createReportException(ReportErrorCode.NoDataOrColumnsSet, objectArray);
            }
            if (this.getEngine().oi < 10) {
                BaseUtils.info("available columns:");
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    if (list.get(i2) == null) continue;
                    BaseUtils.info(">" + list.get(i2).getName() + "<");
                }
            }
            throw reportException;
        }
    }

    @Override
    public boolean getDistinct() {
        return this.getReport().getReportProperties().isDistinct() && this.JG;
    }

    @Override
    public boolean getFilterLater() {
        if (this.Js && this.getReport().getEngine().isDrillDownEngine()) {
            return true;
        }
        if (this.getReport().getReportProperties().isIgnoreFiltering()) {
            return false;
        }
        return this.Js;
    }

    @Override
    public Group getGroup(int index) {
        return this.getReport().getGroup(index);
    }

    @Override
    public int getGroupCount() {
        return this.getReport().getGroupCount();
    }

    @Override
    public Object getGroupValue(boolean throwException, int groupIndex) throws ReportException {
        int n2;
        Object object;
        Group group = this.getGroup(groupIndex);
        Object object2 = null;
        if (group.isDate()) {
            object = this.getFieldValueByField(throwException, group.getField());
            if (object != null) {
                t t2 = new t();
                e e2 = this.getReport().dC().qS();
                t2.aO(e2.a(group.getSectionWillBePrinted(), object)[0]);
                t2.aQ(this.getFieldValueByField(throwException, group.getGroupNameField()));
                if (object instanceof Number || object instanceof String) {
                    object = e2.k(object);
                }
                t2.o((java.util.Date)object);
                object2 = t2;
            }
        } else {
            object2 = this.getFieldValueByField(throwException, group.getField());
        }
        if (object2 instanceof String && (this.isSortLocally() || this.Jt)) {
            object = new u();
            ((u)object).dC((String)object2);
            object2 = object;
        }
        if ((n2 = group.getSortDirection()) == 3) {
            return this.a(group, this);
        }
        if (n2 == 4 && this.hasSummaryData() && this.hasBySummaryOrder()) {
            return this.a(this, group, groupIndex, object2);
        }
        if (n2 == 2 || n2 == 5) {
            object2 = com.inet.report.rowsource.j.a(n2, object2, this.getRowPosition());
        }
        if (n2 == 16 || n2 == 17) {
            object2 = new o.a(String.valueOf(object2));
        }
        if (group.getHierarchicalGrouping()) {
            return this.a(throwException, object2, groupIndex);
        }
        return object2;
    }

    private Object a(boolean bl2, Object object, int n2) throws ReportException {
        Group group = this.getGroup(n2);
        if (group.getParentField() == null) {
            Object[] objectArray = new Object[]{group.toString()};
            throw ReportExceptionFactory.createReportException(ReportErrorCode.ParentFieldNotFound, objectArray);
        }
        if (!group.getField().getClass().equals(group.getParentField().getClass())) {
            Object[] objectArray = new Object[]{group.toString()};
            throw ReportExceptionFactory.createReportException(ReportErrorCode.InvalidParentOfGroup, objectArray);
        }
        g g2 = new g();
        g2.aO(object);
        g2.aP(this.getFieldValueByField(bl2, group.getParentField()));
        return g2;
    }

    Object a(Group group, ad ad2) throws ReportException {
        int n2;
        SpecifiedOrder specifiedOrder = group.getSpecifiedOrder();
        if (specifiedOrder == null) {
            Object[] objectArray = new Object[]{group.toString()};
            throw ReportExceptionFactory.createReportException(ReportErrorCode.SpecificSortOrderNotDefined, objectArray);
        }
        com.inet.report.rowsource.q q2 = new com.inet.report.rowsource.q();
        for (n2 = 0; n2 < specifiedOrder.getCount(); ++n2) {
            FormulaField formulaField = specifiedOrder.getFormulaField(n2);
            if (formulaField == null) continue;
            com.inet.report.q q3 = new com.inet.report.q(ad2, this.getReport(), formulaField);
            q3.a(formulaField);
            q3.qs();
            Object object = formulaField.a(group.getField(), null, q3);
            if (object == null || !(object instanceof Boolean) || !((Boolean)object).booleanValue()) continue;
            q2.setName(specifiedOrder.getName(n2));
            q2.jf(n2);
            return q2;
        }
        n2 = specifiedOrder.getOtherType();
        if (n2 == 0) {
            if (specifiedOrder.getOtherName() == null) {
                BaseUtils.warning("The name for other elements is null");
            }
            q2.setName(specifiedOrder.getOtherName());
            q2.cz(true);
            return q2;
        }
        if (n2 == 2) {
            return this.getFieldValueByField(false, group.getField());
        }
        return null;
    }

    Object a(m m2, Group group, int n2, Object object) throws ReportException {
        BySummaryOrder bySummaryOrder = group.getBySummaryOrder();
        if (bySummaryOrder == null) {
            Object[] objectArray = new Object[]{group.toString()};
            throw ReportExceptionFactory.createReportException(ReportErrorCode.BySummaryOrderIsNull, objectArray);
        }
        bySummaryOrder.a(m2);
        if (bySummaryOrder.ai() == null) {
            bySummaryOrder.g(n2);
        }
        r r2 = new r();
        r2.aO(object);
        Object object2 = bySummaryOrder.ai()[m2.getRowPosition() - 1];
        if (object2 instanceof Integer) {
            r2.jg((Integer)object2);
        } else {
            if (bySummaryOrder.getOther() == 1) {
                return null;
            }
            r2.cz(true);
            r2.dB((String)object2);
            r2.setOtherName(bySummaryOrder.getOtherName());
        }
        return r2;
    }

    @Override
    public int getRowLimit() {
        return (Integer)Jq.get();
    }

    @Override
    public int getSortOrder(int index) throws ReportException {
        Fields fields = this.getReport().getFields();
        SortField sortField = fields.getSortField(index);
        if (sortField.getSortDirectionFormula() != null) {
            return sortField.jZ();
        }
        return sortField.getSort();
    }

    @Override
    public Object getSortValue(int sortIndex) throws ReportException {
        Fields fields = this.getReport().getFields();
        SortField sortField = fields.getSortField(sortIndex);
        Field field = sortField.getField();
        if (field == null) {
            return this.getFieldValueByName(false, sortField.getName());
        }
        return this.getFieldValueByField(false, field);
    }

    @Override
    public boolean getExecuteLocalFilter() {
        FormulaField formulaField;
        boolean bl2 = this.getReport().getReportProperties().isIgnoreFiltering();
        if (bl2 && BaseUtils.isDebug()) {
            BaseUtils.debug("Property 'ignoreFiltering' was set.");
        }
        if (!bl2 && this.JE && (formulaField = this.getReport().je()) != null) {
            if (formulaField.getFormulaTree() != null) {
                return true;
            }
            Validity validity = formulaField.validate();
            if (validity.getErrorData() == null) {
                formulaField.setFormulaTree(null);
                formulaField.resetReferences();
            }
            return validity.getErrorData() != null;
        }
        return false;
    }

    @Override
    public boolean hasGroupTree() {
        if (this.hasBySummaryOrder() && !this.hasSummaryData()) {
            return false;
        }
        ba ba2 = this.getReport();
        ReportProperties reportProperties = ba2.getReportProperties();
        return ba2.isSupportsGroupTree() && (Boolean)Jp.get() != false && ba2.iT() && (reportProperties.getLabelWidth() == 0 || !reportProperties.isFormatWithMultipleColumns()) && reportProperties.isGroupTreeVisible();
    }

    @Override
    public boolean hasHierarchicalGrouping(int index) {
        return this.getGroup(index).getHierarchicalGrouping();
    }

    public RowSource getOriginalRowSource() {
        return this.Jr;
    }

    public void setOriginalRowSource(RowSource rowSource) {
        this.Jr = rowSource;
    }

    public void setFilterLater(boolean filterLater) {
        this.Js = filterLater;
    }

    public final void sortRowSource(boolean rowSourceHasData) throws ReportException {
        Group group;
        int n2;
        RowSource rowSource;
        BaseUtils.info("Sort checkpoint reached.");
        BaseUtils.debugMemory("beforeSort");
        this.Jt = false;
        if (!rowSourceHasData) {
            this.setRowSource(this.getOriginalRowSource());
        }
        if ((rowSource = this.getRowSource()) == null) {
            throw ReportExceptionFactory.createReportException(ReportErrorCode.NoRowSource, new Object[0]);
        }
        this.Jy = new ArrayList();
        for (n2 = 0; n2 < this.getGroupCount(); ++n2) {
            group = this.getGroup(n2);
            if (group.getHierarchicalGrouping() && group.getGroupDirectionFormula() == null && (group.getSort() == 3 || group.getSort() == 4)) {
                group.ab(0);
            }
            if (group.getSortDirection() == 3) {
                this.Jt = true;
                continue;
            }
            if (group.getSortDirection() == 4) {
                this.setHasBySummaryOrder(true);
                if (!this.hasSummaryData()) continue;
                this.Jt = true;
                if (group.getBySummaryOrder() == null) continue;
                group.getBySummaryOrder().a((Object[])null);
                continue;
            }
            if (!group.getHierarchicalGrouping()) continue;
            this.Jt = true;
        }
        if (this.getReport().getReportProperties().isIgnoreSorting() && BaseUtils.isDebug()) {
            BaseUtils.debug("Property 'ignoreSorting' was set.");
        }
        if (this.shouldSortOnRowSource()) {
            BaseUtils.info("Must sort on RowSource ...");
            if (BaseUtils.isDebug()) {
                for (n2 = 0; n2 < this.getGroupCount(); ++n2) {
                    group = this.getGroup(n2);
                    BaseUtils.debug("Must sort groups: " + group.getField().paramString());
                }
                Fields fields = this.getReport().getFields();
                for (int i2 = 0; i2 < fields.getSortFieldsCount(); ++i2) {
                    SortField sortField = fields.getSortField(i2);
                    BaseUtils.debug("Must sort fields: " + sortField.paramString());
                }
            }
            rowSource.sort();
            BaseUtils.info("Sort on RowSource completed.");
        } else {
            BaseUtils.info("Sort on database succeeded.");
            rowSource.handleSortedData();
        }
        this.setRowPosition(0);
        if (this.hasBySummaryOrder()) {
            if (this.hasSummaryData()) {
                this.jm();
                this.resetSummaryValues();
                this.evaluateWhileReading(true);
            }
        } else {
            this.jm();
            this.evaluateWhileReading(true);
        }
        BaseUtils.debugMemory("afterSort");
    }

    public final void filterGroupSelection(FormulaField formulaField) throws ReportException {
        if (formulaField == null || formulaField.getFormula() == null || FormulaField.c(formulaField).length() == 0 || formulaField.isEmpty()) {
            return;
        }
        this.setCurrentGroupNumber(0);
        IntList intList = new IntList(this.getRowCount());
        this.a(this.getReport().oG.rf());
        RowSource rowSource = this.getRowSource();
        try {
            for (int i2 = 0; i2 < rowSource.getRowCount(); ++i2) {
                rowSource.setRowPosition(i2);
                if (rowSource.getGroupChangeMarksElement(i2) > 0) {
                    this.setCurrentGroupNumber(this.getCurrentGroupNumber() + 1);
                }
                if (!this.j(formulaField)) continue;
                intList.addElement(i2);
            }
            this.setRowPosition(0);
            this.setCurrentGroupNumber(0);
            if (intList.size() != 0) {
                this.Jy = new ArrayList();
                rowSource.removeRows(intList.toArray());
                this.jl();
                rowSource.handleSortedData();
                this.jm();
                this.resetSummaryValues();
                this.evaluateWhileReading(false);
                this.calcSummaryFields();
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw ReportExceptionFactory.createReportExceptionWithCauseOutOfMemoryError("OOM by group selection filter", outOfMemoryError);
        }
        catch (bq bq2) {
            throw new bq(formulaField.getFormula(), "Filter group selection failed", bq2);
        }
        catch (ReportException reportException) {
            throw ReportExceptionFactory.createReportExceptionWithCause(reportException);
        }
    }

    void jl() throws ReportException {
        Fields fields = this.getReport().getFields();
        for (int i2 = 0; i2 < fields.getFormulaFieldsCount(); ++i2) {
            FormulaField formulaField = fields.getFormulaField(i2);
            formulaField.b((Object[])null);
            formulaField.c(formulaField);
        }
    }

    private final boolean j(FormulaField formulaField) throws bq {
        if (formulaField != null && formulaField.getFormula() != null && FormulaField.c(formulaField).length() > 0 && !formulaField.isEmpty()) {
            boolean bl2 = this.Ju;
            this.Ju = false;
            Object object = null;
            try {
                object = formulaField.a(null, (Object)null);
                if (object == null) {
                    object = Boolean.FALSE;
                }
            }
            catch (Throwable throwable) {
                if (!this.JI) {
                    this.JI = true;
                    BaseUtils.info("Could not parse FormulaField.  Please report this bug to ClearReports@inetsoftware.de");
                    BaseUtils.info("FormulaField:" + String.valueOf(formulaField));
                    BaseUtils.printStackTrace(throwable);
                }
                throw new bq(formulaField.getFormula(), throwable);
            }
            if (object != null) {
                if (object instanceof Boolean) {
                    if (!((Boolean)object).booleanValue()) {
                        this.Ju = bl2;
                        return true;
                    }
                } else {
                    throw new bq(formulaField.getFormula(), "Selection Formula did not result in a boolean");
                }
            }
            this.Ju = bl2;
        }
        return false;
    }

    public static void addCCFormatString(Object obj, StringBuilder buf) {
        if (obj == null) {
            buf.append("null");
            return;
        }
        if (obj instanceof Boolean) {
            buf.append((Boolean)obj != false ? "true" : "false");
            return;
        }
        if (obj instanceof Date) {
            Date date = (Date)obj;
            buf.append("Date(").append(1900 + date.getYear()).append(',').append(date.getMonth() + 1).append(',').append(date.getDate()).append(')');
            return;
        }
        if (obj instanceof Time) {
            Time time = (Time)obj;
            buf.append("Time(").append(time.getHours()).append(',').append(time.getMinutes()).append(',').append(time.getSeconds()).append(')');
            return;
        }
        if (obj instanceof java.util.Date) {
            java.util.Date date = (java.util.Date)obj;
            buf.append("DateTime(").append(1900 + date.getYear()).append(',').append(date.getMonth() + 1).append(',').append(date.getDate()).append(',').append(date.getHours()).append(',').append(date.getMinutes()).append(',').append(date.getSeconds()).append(')');
            return;
        }
        if (obj instanceof String) {
            char c2;
            String string = String.valueOf(obj);
            StringTokenizer stringTokenizer = new StringTokenizer(string, String.valueOf(c2 = '\''), true);
            if (stringTokenizer.countTokens() == 0) {
                buf.append(c2).append(c2);
            }
            boolean bl2 = false;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2.equals(String.valueOf(c2))) {
                    if (bl2) {
                        buf.append(string2).append(c2);
                    }
                    bl2 = true;
                    continue;
                }
                buf.append(c2).append(string2).append(c2);
                bl2 = false;
            }
            return;
        }
        buf.append(obj.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Only used for string opertions")
    final void jm() throws ReportException {
        Serializable serializable;
        if (this.hasGroupTree() && this.Jy.size() == 0) {
            this.setRowPosition(1);
            this.setHasBySummaryOrder(false);
            serializable = new StringBuilder();
            for (int i2 = 0; i2 < this.getGroupCount(); ++i2) {
                Object object = this.getGroupValue(true, i2);
                if (((StringBuilder)serializable).length() != 0) {
                    ((StringBuilder)serializable).append(" AND ");
                }
                this.addToTerm(object, i2, (StringBuilder)serializable);
                this.addGroupTreeNodesList(i2, (StringBuilder)serializable, false, null).v(false);
            }
        }
        serializable = this.getEngine();
        ba ba2 = this.getReport();
        int n2 = !((Engine)serializable).isDrillDownEngine() || this.jn() ? 1 : 0;
        aa aa2 = null;
        aa2 = aa.d(this.Jy.size() + n2, ba2.getReportProperties().isShowSuppressedGroupTreeNodes());
        if (n2 == 1) {
            String string = ba2.getSummaryInfo().getReportTitle();
            if (string == null || string.trim().length() == 0) {
                URL uRL = ba2.getEngine().getReportFile();
                string = String.valueOf(new File(String.valueOf(uRL.getFile())).getName());
            }
            aa2.a(0, new ab(ba2, string));
            this.JC = true;
        }
        if (this.hasGroupTree()) {
            for (int i3 = n2; i3 < aa2.getLength(); ++i3) {
                aa2.a(i3, this.Jy.get(i3 - n2));
            }
        }
        ba2.a(aa2);
        this.Jy = null;
        Object object = ((Engine)serializable).nW;
        synchronized (object) {
            ((Engine)serializable).nW.notifyAll();
        }
        this.setRowPosition(0);
    }

    public boolean groupTreeHasAdditionalRoot() {
        return this.JC;
    }

    private boolean jn() {
        if (this.Jy.size() == 0) {
            return false;
        }
        byte by2 = this.Jy.get(0).dz();
        for (int i2 = 1; i2 < this.Jy.size(); ++i2) {
            if (this.Jy.get(i2).dz() != by2) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasSummaryData() {
        return this.hasBySummaryOrder() & super.hasSummaryData();
    }

    public void resetSummaryData() {
        this.setHasSummaryData(false);
        this.setHasBySummaryOrder(false);
    }

    @Override
    public int getCurrentGroupNumber() {
        return this.Jw;
    }

    public void setCurrentGroupNumber(int currentGroupNumber) {
        this.Jw = currentGroupNumber;
    }

    public void calcSummaryFields() throws ReportException {
        Fields fields;
        if (this.Jz == null) {
            this.initSummaryFields();
        }
        if ((fields = this.getReport().getFields()).getSummaryFieldsCount() == 0) {
            return;
        }
        for (int i2 = 0; i2 < fields.getSummaryFieldsCount(); ++i2) {
            this.getSummaryValue(i2, 0);
        }
        this.setHasSummaryData(true);
        this.setRowPosition(0);
    }

    public void initSummaryFields() throws ReportException {
        Fields fields = this.getReport().getFields();
        if (fields.getSummaryFieldsCount() == 0) {
            return;
        }
        this.Jz = new com.inet.report.summary.b(this, this.getRowCount());
        if (BaseUtils.isParanoid()) {
            BaseUtils.paranoid("Initializing Summary Aggregator...");
        }
        for (int i2 = 0; i2 < fields.getSummaryFieldsCount(); ++i2) {
            SummaryField summaryField = fields.getSummaryField(i2);
            this.Jz.a(summaryField, this.getGroupIndex(summaryField.getChangeField()), this.getGroupIndex(summaryField.getResetField()));
        }
        this.setHasSummaryData(true);
    }

    public void resetSummaryValues() {
        if (this.Jz != null) {
            this.Jz.reset();
        }
        if (this.getSummaryResults() != null) {
            Arrays.fill(this.getSummaryResults(), null);
        }
    }

    @Override
    protected int getGroupIndex(Field field) throws ReportException {
        if (!(field instanceof GroupField)) {
            return -1;
        }
        Group group = ((GroupField)field).getGroup();
        int n2 = -1;
        for (int i2 = 0; i2 < this.getGroupCount(); ++i2) {
            if (this.getGroup(i2) != group) continue;
            n2 = i2 + 1;
        }
        if (!this.getReport().getEngine().isDrillDownEngine() && n2 < 0) {
            Object[] objectArray = new Object[]{group.getField().paramString()};
            throw ReportExceptionFactory.createReportException(ReportErrorCode.GroupNotFound, objectArray);
        }
        return n2;
    }

    public final Object getSummaryValue(int summaryIdx, int rowIdx) throws ReportException {
        if (this.Jz == null) {
            this.initSummaryFields();
        }
        Fields fields = this.getReport().getFields();
        if (this.getSummaryResults() == null) {
            this.setSummaryResults(new ae[fields.getSummaryFieldsCount()]);
        }
        SummaryField summaryField = fields.getSummaryField(summaryIdx);
        ae ae2 = this.getSummaryResults()[summaryIdx];
        if (ae2 == null) {
            this.getSummaryResults()[summaryIdx] = ae2 = this.Jz.d(summaryField);
        }
        if (ae2 != null) {
            return ae2.jn(rowIdx);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSummaryInGroupTree() {
        if (this.getSummaryResults() == null) {
            return;
        }
        try {
            for (int i2 = 0; i2 < this.getReport().gO().getLength(); ++i2) {
                ab ab2 = this.getReport().gO().af(i2);
                int n2 = ab2.dy();
                if (n2 == -1) continue;
                this.getRowSource().setRowPosition(n2);
                ab2.v(true);
            }
        }
        catch (Exception exception) {
            if (BaseUtils.isDebug()) {
                BaseUtils.debug("Write Summary to GroupTreeNode failed");
            }
        }
        finally {
            this.setRowPosition(0);
        }
    }

    protected void setEvaluateNewWhileReading(boolean evaluateNewWhileReading) {
        this.JA = evaluateNewWhileReading;
    }

    @Override
    public boolean isEvaluateNewWhileReading() {
        return this.JA;
    }

    public void evaluateWhileReading(boolean resetVariables) throws ReportException {
        Object object;
        if ((Integer)rv.get() < 9) {
            this.setEvaluateNewWhileReading(false);
            return;
        }
        this.setEvaluateNewWhileReading(true);
        boolean bl2 = this.Ju;
        this.Ju = true;
        Fields fields = this.getReport().getFields();
        ArrayList<FormulaField> arrayList = new ArrayList<FormulaField>();
        ArrayList<FormulaField> arrayList2 = new ArrayList<FormulaField>();
        for (int i2 = 0; i2 < fields.getFormulaFieldsCount(); ++i2) {
            String string;
            int n2;
            FormulaField formulaField = fields.getFormulaField(i2);
            if (!formulaField.isUsed() || (object = formulaField.getReferenceHolders()) == null || ((ReferenceHolder[])object).length == 0 || ((ReferenceHolder[])object).length == 1 && object[0] == this.getReport().je()) continue;
            try {
                n2 = formulaField.t(true);
            }
            catch (ReportException reportException) {
                BaseUtils.error(reportException);
                n2 = 2;
            }
            boolean bl3 = false;
            if (n2 == 2) {
                bl3 = formulaField.usesSummaryFields();
            }
            if (n2 != 1 && !bl3 || formulaField.getFormula() == null || (string = FormulaField.c(formulaField)) == null || string.trim().length() == 0) continue;
            formulaField.c(formulaField);
            formulaField.b((Object[])null);
            if (bl3) {
                arrayList2.add(formulaField);
                continue;
            }
            arrayList.add(formulaField);
        }
        if ((arrayList.size() > 0 || arrayList2.size() > 0) && this.getRowCount() > 0) {
            if (resetVariables) {
                this.a(this.getReport().oG.rf());
            }
            this.restoreVariables();
            if (arrayList.size() > 0) {
                this.setRowPosition(0);
                Object[][] objectArray = new Object[arrayList.size()][this.getRowCount()];
                while (this.getRowSource().next()) {
                    for (int i3 = 0; i3 < arrayList.size(); ++i3) {
                        objectArray[i3][this.getRowPosition() - 1] = object = this.getFieldValueByField(false, (Field)arrayList.get(i3));
                    }
                }
                for (int i4 = 0; i4 < arrayList.size(); ++i4) {
                    object = (FormulaField)arrayList.get(i4);
                    object.b(objectArray[i4]);
                }
            }
            if (arrayList2.size() > 0) {
                this.setRowPosition(0);
                Object[][] objectArray = new Object[arrayList2.size()][this.getRowCount()];
                while (this.getRowSource().next()) {
                    for (int i5 = 0; i5 < arrayList2.size(); ++i5) {
                        objectArray[i5][this.getRowPosition() - 1] = object = this.getFieldValueByField(false, (Field)arrayList2.get(i5));
                    }
                }
                for (int i6 = 0; i6 < arrayList2.size(); ++i6) {
                    object = (FormulaField)arrayList2.get(i6);
                    object.b(objectArray[i6]);
                }
            }
        }
        this.setEvaluateNewWhileReading(false);
        this.Ju = bl2;
    }

    public void evaluateBeforeReading() throws ReportException {
        Fields fields = this.getReport().getFields();
        for (int i2 = 0; i2 < fields.getFormulaFieldsCount(); ++i2) {
            String string;
            int n2;
            FormulaField formulaField = fields.getFormulaField(i2);
            if (!formulaField.isUsed()) continue;
            try {
                n2 = formulaField.t(true);
            }
            catch (ReportException reportException) {
                BaseUtils.error(reportException);
                n2 = 2;
            }
            if (n2 != 0 || formulaField.getFormula() == null || (string = FormulaField.c(formulaField)) == null || string.trim().length() == 0) continue;
            formulaField.dl();
            Object object = this.getFieldValueByField(false, formulaField);
            formulaField.c(object);
        }
    }

    public void storeVariables() {
        k k2 = this.getReport().dC().qn();
        this.JB = new HashMap<y, Object>();
        for (y y2 : k2.rf().values()) {
            if (!y2.sH()) continue;
            this.JB.put(y2, y2.c(null));
        }
        for (y y2 : k2.rg().values()) {
            if (!y2.sH()) continue;
            this.JB.put(y2, y2.c(null));
        }
        for (y y2 : k2.rh().values()) {
            if (!y2.sH()) continue;
            this.JB.put(y2, y2.c(null));
        }
    }

    public void restoreVariables() {
        if (this.JB == null || this.JB.size() == 0) {
            return;
        }
        k k2 = this.getReport().dC().qn();
        for (y y2 : k2.rf().values()) {
            if (!this.JB.containsKey(y2)) continue;
            y2.a(this.JB.get(y2), (j)null);
        }
        for (y y2 : k2.rg().values()) {
            if (!this.JB.containsKey(y2)) continue;
            y2.a(this.JB.get(y2), (j)null);
        }
        for (y y2 : k2.rh().values()) {
            if (!this.JB.containsKey(y2)) continue;
            y2.a(this.JB.get(y2), (j)null);
        }
    }

    private void a(q q2) throws ReportException {
        if (q2 != null) {
            for (o o2 : q2.values()) {
                o2.b(this.getReport().dC().qw());
            }
        }
    }

    @Override
    public Object getFieldValueByField(boolean throwException, Field data) throws ReportException {
        try {
            if (data != null) {
                return data.getValue();
            }
        }
        catch (AccessDeniedException | bw | StackOverflowError throwable) {
            throw throwable;
        }
        catch (Throwable throwable) {
            if (throwException) {
                throw ReportExceptionFactory.createReportExceptionWithCause(throwable);
            }
            if (data != null) {
                data.valueType = 11;
            }
            BaseUtils.printStackTrace(throwable);
            this.getEngine().setErrorMsg(throwable.getMessage());
            Object[] objectArray = new Object[]{this.getEngine().getErrorMsg()};
            return ReportErrorCode.FormulaError.getMsg(objectArray);
        }
        return null;
    }

    public final Object getFieldValueByName(boolean throwException, String name) throws ReportException {
        int n2 = ba.W(name);
        if (n2 != 14) {
            name = name.substring(1);
        }
        if (name == null) {
            return Integer.toString(n2);
        }
        if (n2 == 14 && this.getRowSource() == null) {
            Database database;
            Datasource datasource;
            DatabaseField databaseField = (DatabaseField)this.getReport().a(throwException, n2, name);
            if (databaseField.kU != null) {
                datasource = databaseField.kU.getDatasource();
                database = (Database)datasource.getDataFactory();
            } else {
                datasource = this.getReport().jc().getDatasource(0);
                database = (Database)datasource.getDataFactory();
            }
            return database.convertIdentifier(datasource, name);
        }
        Field field = this.getReport().a(throwException, n2, name);
        if (field == null) {
            Object[] objectArray = new Object[]{name, Field.e(n2)};
            ReportException reportException = ReportExceptionFactory.createReportException(ReportErrorCode.FieldNotFound, objectArray);
            if (throwException) {
                throw reportException;
            }
            return reportException.getMessage();
        }
        return this.getFieldValueByField(throwException, field);
    }

    public Object getFieldValueByName(String name) {
        try {
            int n2 = ba.W(name);
            if (n2 != 14) {
                name = name.substring(1);
            }
            if (name == null) {
                return Integer.toString(n2);
            }
            if (n2 == 14 && this.getRowSource() == null) {
                Database database;
                Datasource datasource;
                DatabaseField databaseField = (DatabaseField)this.getReport().a(false, n2, name);
                if (databaseField.kU != null) {
                    datasource = databaseField.kU.getDatasource();
                    database = (Database)databaseField.kU.getDatasource().getDataFactory();
                } else {
                    datasource = this.getReport().jc().getDatasource(0);
                    database = (Database)datasource.getDataFactory();
                }
                return database.convertIdentifier(datasource, name);
            }
            Field field = this.getReport().a(false, n2, name);
            if (field != null) {
                return field.getValue();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static boolean f(Datasource datasource) {
        if (!com.inet.report.rowsource.cache.e.bd()) {
            return false;
        }
        String string = datasource.getDataSourceConfigurationName();
        if ("Core".equals(string) || "".equals(string)) {
            return false;
        }
        DataFactory dataFactory = datasource.k(false);
        return dataFactory == null || dataFactory.getClass() != DatabaseSetData.class;
    }

    public void fetchData(DatabaseTables dbTables, Datasource datasource) throws ReportException {
        try {
            if (ReportDataHandler.f(datasource)) {
                d d2;
                c c2 = com.inet.report.rowsource.cache.e.c(this);
                if (this.JK != null && !this.JK.contains(c2)) {
                    com.inet.report.rowsource.cache.e.b(c2);
                    this.JK.add(c2);
                    d2 = null;
                } else {
                    d2 = com.inet.report.rowsource.cache.e.a(c2);
                }
                if (d2 != null) {
                    if (BaseUtils.isDebug()) {
                        BaseUtils.debug("Use cached report data");
                    }
                    d2.b(this);
                } else {
                    int n2;
                    long l2 = System.nanoTime();
                    this.a(dbTables, datasource);
                    l2 = Math.max(0L, System.nanoTime() - l2 - 5000000L);
                    int n3 = n2 = this.Jr != null ? this.Jr.getRowCount() : 0;
                    if (n2 > 0 && (double)l2 / (double)n2 > 4000.0) {
                        if (BaseUtils.isDebug()) {
                            BaseUtils.debug("Store report data in data cache");
                        }
                        com.inet.report.rowsource.cache.e.a(c2, this);
                    } else if (BaseUtils.isDebug()) {
                        BaseUtils.debug("Caching unnecessary, the data fetching time: " + l2 / 1000000L + "ms");
                    }
                }
            } else {
                this.a(dbTables, datasource);
            }
            if (com.inet.report.database.coredata.d.ob()) {
                DatabaseCore.i(this.getReport());
            }
        }
        catch (ReportException reportException) {
            throw reportException;
        }
        catch (Exception exception) {
            throw ReportExceptionFactory.createReportExceptionWithCause(exception, ReportErrorCode.dataFetching, "\n\n" + StringFunctions.getUserFriendlyErrorMessage((Throwable)exception));
        }
    }

    private void a(DatabaseTables databaseTables, Datasource datasource) throws ReportException {
        ba ba2 = this.getReport();
        if (ba2.iT()) {
            databaseTables.bO();
        } else {
            DatabaseUtils.getReportData(ba2.getEngine());
        }
    }

    public boolean shouldSortOnRowSource() {
        boolean bl2 = true;
        if (!(this.Jt || !this.getReport().getReportProperties().isIgnoreSorting() && this.isSortLocally())) {
            bl2 = false;
        }
        return bl2;
    }

    public void setData(String[] columns, Object[][] data, boolean sortExecutedOnDB, boolean filterLater, boolean distinctExecutedOnDB) {
        this.JG = !distinctExecutedOnDB;
        this.JF = !sortExecutedOnDB;
        this.setFilterLater(filterLater);
        this.a(columns);
        this.setOriginalRowSource(new b(data, this));
    }

    void a(String[] stringArray) {
        this.JJ = ReportDataHandler.createFieldList(stringArray, this.getReport());
    }

    public static List<Field> createFieldList(String[] columns, ba<?> renderer) {
        ArrayList<Field> arrayList = new ArrayList<Field>();
        block2: for (int i2 = 0; i2 < columns.length; ++i2) {
            String string = columns[i2];
            try {
                Field field = renderer.a(false, string);
                if (field != null) {
                    arrayList.add(field);
                    continue;
                }
                int n2 = renderer.jd().indexOfShortName(string);
                if (n2 >= 0) {
                    arrayList.add(renderer.jd().elementAt(n2));
                    continue;
                }
                if (renderer.Iz != null) {
                    for (int i3 = 0; i3 < renderer.Iz.length; ++i3) {
                        if (!string.equalsIgnoreCase(renderer.Iz[i3].getName())) continue;
                        arrayList.add(renderer.Iz[i3]);
                        continue block2;
                    }
                }
                DatabaseField databaseField = new DatabaseField(renderer);
                databaseField.kW = databaseField.name = string;
                arrayList.add(databaseField);
                continue;
            }
            catch (ReportException reportException) {
                BaseUtils.printStackTrace(reportException);
            }
        }
        return arrayList;
    }

    public void deleteCacheReportKey() throws ReportException {
        if (com.inet.report.rowsource.cache.e.bd()) {
            this.JK = new HashSet();
            ba ba2 = this.getReport();
            for (int i2 = 0; i2 < ba2.getSubReportCount(); ++i2) {
                ReportDataHandler reportDataHandler = ba2.bs(i2).gN();
                reportDataHandler.JK = this.JK;
            }
        }
    }

    @Override
    protected void completeGroupsImpl() {
        throw new IllegalStateException("Is for chart or crosstab only.");
    }

    @Override
    protected void setSums(SummaryField[] sums) {
        throw new IllegalStateException("Is for chart or crosstab only.");
    }

    @Override
    protected SummaryField[] getSums() {
        throw new IllegalStateException("Is for chart or crosstab only.");
    }

    private static int a(Field field, List<Field> list) throws ReportException {
        int n2 = list.indexOf(field);
        if (n2 < 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                if (i2 > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(list.get(i2).getName());
            }
            throw ReportExceptionFactory.createReportException(ReportErrorCode.NoColumn, field.getName(), stringBuilder);
        }
        return n2;
    }

    public boolean isSortLocally() {
        return this.JF;
    }

    public void setSortLocally(boolean sortLocally) {
        this.JF = sortLocally;
    }

    public void setFilterLocally(boolean filterLocally) {
        this.JE = filterLocally;
    }

    public void setDistinctLocally(boolean distinctLocally) {
        this.JG = distinctLocally;
    }

    public boolean isDistinctLocally() {
        return this.JG;
    }

    public boolean isFilterSelectionErrorLogged() {
        return this.JI;
    }

    public void setFilterSelectionErrorLogged(boolean filterSelectionErrorLogged) {
        this.JI = filterSelectionErrorLogged;
    }

    public List<Field> getDatabaseColumns() {
        return this.JJ;
    }

    public void setDatabaseColumns(List<Field> databaseColumns) {
        this.JJ = databaseColumns;
    }
}

