/*
 * Decompiled with CFR 0.152.
 */
package com.inet.viewer.widgets;

import com.inet.annotations.InternalApi;
import com.inet.viewer.DateWindow;
import com.inet.viewer.PromptValue;
import com.inet.viewer.ViewerUtils;
import com.inet.viewer.f;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.text.Format;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.MouseInputAdapter;

@InternalApi
public class DateField
extends JFormattedTextField {
    private static Icon icon = ViewerUtils.getImageIcon("date.gif");
    private static Icon bQD = new ImageIcon(GrayFilter.createDisabledImage(((ImageIcon)icon).getImage()));
    private final Color bQE = new Color(255, 179, 179);
    private boolean bQF = true;
    private boolean bQG = false;
    private MouseInputAdapter bQH = new a();
    private boolean bQI = false;

    public DateField() {
        this(false);
    }

    public DateField(boolean withTime) {
        this(withTime ? PromptValue.DATETIMEFORMAT : PromptValue.DATEFORMAT, withTime);
    }

    public DateField(Format format, boolean withTime) {
        super(format);
        if (format instanceof DateFormat) {
            f.b((DateFormat)format);
        }
        this.bQF = withTime;
        this.setColumns(10);
        this.addMouseListener(this.bQH);
        this.addMouseMotionListener(this.bQH);
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e2) {
                if (DateField.this.bQG) {
                    DateField.this.Te();
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e2) {
                if (DateField.this.bQG) {
                    DateField.this.Te();
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e2) {
            }
        });
    }

    public void setBackgroundValidate(boolean b2) {
        if (this.bQG != b2) {
            this.bQG = b2;
            this.Te();
        }
    }

    private void Te() {
        if (this.bQG && this.getDate() == null) {
            this.setBackground(this.bQE);
        } else {
            this.setBackground(this.isEnabled() ? UIManager.getColor("TextField.background") : UIManager.getColor("TextField.inactiveBackground"));
        }
    }

    private boolean b(Point point) {
        return this.getWidth() - point.x <= icon.getIconWidth() + 4;
    }

    @Override
    protected void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        int n2 = this.getWidth() - icon.getIconWidth() - 2;
        int n3 = (this.getHeight() - icon.getIconHeight()) / 2;
        if (this.isEnabled()) {
            icon.paintIcon(this, g2, n2, n3);
        } else {
            bQD.paintIcon(this, g2, n2, n3);
        }
    }

    @Override
    public Insets getInsets() {
        Insets insets = super.getInsets();
        insets.right += icon.getIconWidth() + 2;
        return insets;
    }

    @Override
    public void commitEdit() throws ParseException {
        if (this.getText().trim().length() == 0) {
            this.setValue(null);
        } else {
            super.commitEdit();
        }
    }

    public void setDate(Date date) {
        this.setValue(date);
    }

    public Date getDate() {
        try {
            return (Date)this.getFormatter().stringToValue(this.getText());
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public void validateInput() throws ParseException {
        String string = this.getText();
        if (string != null && string.length() > 0) {
            this.getFormatter().stringToValue(string);
        }
    }

    public void setPrepareToNullTime(boolean prepareToNullTime) {
        this.bQI = prepareToNullTime;
    }

    private class a
    extends MouseInputAdapter {
        private a() {
        }

        @Override
        public void mouseReleased(MouseEvent e2) {
            if (DateField.this.isEnabled() && (e2.getClickCount() > 1 || DateField.this.b(e2.getPoint()))) {
                Comparable<Calendar> comparable;
                Date date;
                Window window = SwingUtilities.getWindowAncestor(e2.getComponent());
                Point point = DateField.this.getLocationOnScreen();
                boolean bl2 = JDialog.isDefaultLookAndFeelDecorated();
                if (bl2) {
                    JDialog.setDefaultLookAndFeelDecorated(false);
                }
                if ((date = DateField.this.getDate()) == null && DateField.this.bQF && DateField.this.bQI) {
                    comparable = new GregorianCalendar();
                    comparable.set(11, 0);
                    comparable.set(12, 0);
                    comparable.set(13, 0);
                    date = comparable.getTime();
                }
                final DateWindow dateWindow = window instanceof Dialog ? new DateWindow((Dialog)window, point.x, point.y + DateField.this.getHeight(), DateField.this.getDate(), true, DateField.this.bQF) : new DateWindow((Frame)window, point.x, point.y + DateField.this.getHeight(), DateField.this.getDate(), true, DateField.this.bQF);
                if (bl2) {
                    JDialog.setDefaultLookAndFeelDecorated(true);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        dateWindow.requestFocusInWindow();
                    }
                });
                comparable = dateWindow.getSelected();
                if (comparable != null) {
                    DateField.this.setValue(comparable);
                    try {
                        DateField.this.commitEdit();
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DateField.this.transferFocus();
                        }
                    });
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e2) {
            if (DateField.this.b(e2.getPoint())) {
                DateField.this.setCursor(Cursor.getDefaultCursor());
            }
            DateField.this.setCursor(DateField.this.b(e2.getPoint()) ? Cursor.getDefaultCursor() : Cursor.getPredefinedCursor(2));
        }
    }
}

