/*
 * Decompiled with CFR 0.152.
 */
package com.inet.viewer;

import com.inet.annotations.InternalApi;
import com.inet.viewer.PromptValue;
import com.inet.viewer.h;
import com.inet.viewer.i18n.a;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Constructor;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.JTextComponent;

@InternalApi
public class RealtimeValidationPopup
implements ActionListener,
FocusListener,
DocumentListener,
PopupMenuListener {
    private JComponent bCQ;
    private int bCK;
    private boolean bCR;
    private Timer bCS;
    private Popup bCT;
    private JLabel bCU;
    private JPanel bCV;
    private boolean bCW;
    private Point bCX;
    private JComboBox bCY;
    private boolean bCZ;
    private boolean bDa;
    private Class bDb;
    private Constructor bDc;
    private Class[] bDd = new Class[]{String.class};
    private Color bDe;
    public static final Color POPUP_BGCOLOR_NORMAL = new Color(255, 255, 225);
    public static final Color POPUP_BGCOLOR_ERROR = new Color(1.0f, 0.7f, 0.7f);
    public static final Color POPUP_BGCOLOR_INCOMPLETE = new Color(255, 227, 119);
    public static final Color LAYOUT_ERROR_BACKGROUND = new Color(1.0f, 0.7f, 0.7f);
    private Format bDf;

    private RealtimeValidationPopup(int promptType) {
        this.bCK = promptType;
        this.bCU = new JLabel();
        this.bCV = new JPanel();
        this.bCV.setOpaque(true);
        this.bCV.add(this.bCU);
        this.bCV.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                RealtimeValidationPopup.this.hidePopup();
                e2.consume();
            }
        });
        this.bCV.setBorder(BorderFactory.createBevelBorder(0, Color.GRAY, Color.BLACK));
        this.bCS = new Timer(5000, this);
    }

    public RealtimeValidationPopup(JTextComponent textcomponent, JComboBox surroundingBox, int promptType, boolean isUSformatted) {
        this(promptType);
        this.initFormats();
        if (this.bDf == null) {
            return;
        }
        this.bCZ = isUSformatted;
        textcomponent.getDocument().addDocumentListener(this);
        if (surroundingBox != null) {
            surroundingBox.addActionListener(this);
            surroundingBox.addPopupMenuListener(this);
            this.bCY = surroundingBox;
        }
        this.bCQ = textcomponent;
        this.bCQ.addFocusListener(this);
        this.bDe = this.bCQ.getBackground();
    }

    private void initFormats() {
        this.bDf = null;
        switch (this.bCK % 128) {
            case 6: 
            case 7: {
                this.bDf = this.bCZ ? NumberFormat.getInstance(Locale.US) : PromptValue.NUMBERFORMAT;
                break;
            }
            case 9: {
                this.bDf = this.bCZ ? DateFormat.getDateInstance(3, Locale.US) : PromptValue.DATEFORMAT;
                break;
            }
            case 15: {
                this.bDf = this.bCZ ? DateFormat.getDateTimeInstance(3, 2, Locale.US) : PromptValue.DATETIMEFORMAT;
                break;
            }
            case 10: {
                this.bDf = this.bCZ ? DateFormat.getTimeInstance(2, Locale.US) : PromptValue.TIMEFORMAT;
                break;
            }
            default: {
                return;
            }
        }
    }

    private void Px() {
        if (this.bCQ instanceof JPasswordField) {
            return;
        }
        Object object = this.getValue();
        String string = object.toString();
        if (!this.bCQ.isEnabled() || !this.bCQ.isShowing() || object.toString().length() == 0 || this.bCQ instanceof JComboBox && ((JComboBox)this.bCQ).isPopupVisible() || (this.bCK % 128 == 6 || this.bCK % 128 == 7) && string.equals("-")) {
            if (!this.bCQ.isEnabled()) {
                this.bCQ.setBackground(UIManager.getDefaults().getColor("TextField.disabledBackground"));
            } else {
                this.bCQ.setBackground(POPUP_BGCOLOR_NORMAL);
            }
            this.hidePopup();
            return;
        }
        try {
            Object object2;
            if (object instanceof PromptValue) {
                if (((PromptValue)object).isOnlyDescription()) {
                    this.hidePopup();
                    return;
                }
                object2 = ((PromptValue)object).getDescription();
                if (object2 != null && ((String)object2).length() > 0) {
                    string = ((PromptValue)object).getValueString();
                }
            }
            object2 = null;
            object2 = this.bDf.parseObject(string);
            String string2 = this.getFormatedText(object2);
            if (this.bDa && this.bDb != null) {
                if (this.bDb == Object.class) {
                    this.bDb = String.class;
                }
                this.bDc = this.bDb.getConstructor(this.bDd);
                this.bDc.newInstance(string);
            }
            this.bCR = false;
            if (string2.equals(string)) {
                this.hidePopup();
            } else {
                Point point = this.bCQ.getLocationOnScreen();
                point.y += this.bCQ.getHeight();
                this.a(string2, POPUP_BGCOLOR_NORMAL, point);
            }
            this.bCQ.invalidate();
            this.bCQ.setBackground(POPUP_BGCOLOR_NORMAL);
        }
        catch (Exception exception) {
            if (this.a(this.bDf, string)) {
                this.showIncompletePopup();
            }
            this.showErrorPopup();
        }
    }

    public String getFormatedText(Object parsedObject) {
        return this.bDf.format(parsedObject);
    }

    private boolean a(Format format, String string) {
        boolean bl2 = false;
        if (format instanceof h) {
            format = ((h)format).Ou();
        }
        if (format instanceof SimpleDateFormat) {
            SimpleDateFormat simpleDateFormat = (SimpleDateFormat)format;
            String string2 = simpleDateFormat.toPattern();
            SimpleDateFormat simpleDateFormat2 = null;
            String string3 = string2;
            block2: for (int i2 = 1; i2 <= string2.length(); ++i2) {
                for (int i3 = 0; i3 <= string2.length() - i2; ++i3) {
                    string3 = string2.substring(i3, i3 + i2);
                    simpleDateFormat2 = new SimpleDateFormat(string3);
                    try {
                        Date date = simpleDateFormat2.parse(string);
                        String string4 = simpleDateFormat2.format(date);
                        String string5 = string.replaceAll("0", "");
                        String string6 = string4.replaceAll("0", "");
                        if (!string.equals(string4) && !string5.equals(string4) && !string.equals(string6) && !string5.equals(string6)) continue;
                        bl2 = true;
                        continue block2;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return bl2;
    }

    public void showErrorPopup() {
        Point point = this.bCQ.getLocationOnScreen();
        point.y += this.bCQ.getHeight();
        this.bCR = true;
        Object object = a.getMsg("prompt.invalid_input");
        object = (String)object + this.Py();
        this.a((String)object, POPUP_BGCOLOR_ERROR, point);
        this.bCQ.setBackground(LAYOUT_ERROR_BACKGROUND);
        this.bCQ.invalidate();
    }

    public void showIncompletePopup() {
        Point point = this.bCQ.getLocationOnScreen();
        point.y += this.bCQ.getHeight();
        this.bCR = true;
        Object object = a.getMsg("prompt.incomplete_input");
        object = (String)object + this.Py();
        this.a((String)object, POPUP_BGCOLOR_INCOMPLETE, point);
        this.bCQ.setBackground(POPUP_BGCOLOR_INCOMPLETE);
        this.bCQ.invalidate();
    }

    private String Py() {
        Format format = switch (this.bCK) {
            case 9 -> PromptValue.DATEFORMAT;
            case 15 -> PromptValue.DATETIMEFORMAT;
            case 10 -> PromptValue.TIMEFORMAT;
            default -> null;
        };
        if (format instanceof SimpleDateFormat) {
            return a.getMsg("prompt.format_must_be", ((SimpleDateFormat)format).toPattern());
        }
        if (this.bCK == 6 || this.bCK == 7) {
            return a.getMsg("prompt.expected_number");
        }
        return "";
    }

    private void a(String string, Color color, Point point) {
        string = this.ec(string);
        this.bCU.setText(string);
        this.bCV.setBackground(color);
        if (!this.bCW) {
            this.bCX = point;
        } else {
            point = this.bCX;
        }
        if (this.bCT != null) {
            this.hidePopup();
        }
        this.bCT = PopupFactory.getSharedInstance().getPopup(this.bCQ, this.bCV, point.x, point.y);
        this.bCT.show();
        this.bCW = true;
        if (this.bCS.isRunning()) {
            this.bCS.restart();
        } else {
            this.bCS.start();
        }
    }

    private String ec(String object) {
        object = this.bCR ? "<html>" + (String)object + "</html>" : a.getMsg("prompt.interpreted_as", object);
        return object;
    }

    private Object getValue() {
        if (this.bCQ instanceof JPasswordField) {
            return new String(((JPasswordField)this.bCQ).getPassword());
        }
        if (this.bCQ instanceof JTextComponent) {
            String string;
            String string2 = ((JTextComponent)this.bCQ).getText();
            if (this.bCY == null) {
                return string2;
            }
            Object object = this.bCY.getSelectedItem();
            if (this.bCQ != null && this.bCY.isEditable() && object != null && !(string = object.toString()).equals(string2)) {
                return string2;
            }
            if (object == null) {
                object = "";
            }
            return object;
        }
        if (this.bCQ instanceof JComboBox) {
            return ((JComboBox)this.bCQ).getSelectedItem();
        }
        return null;
    }

    public void hidePopup() {
        if (this.bCT != null) {
            this.bCT.hide();
        }
        this.bCW = false;
        if (this.bCS.isRunning()) {
            this.bCS.stop();
        }
    }

    public void setCheckClassType(boolean checkClassType, Class classtype) {
        this.bDa = checkClassType;
        this.bDb = classtype;
    }

    public void setPromptType(int promptType) {
        this.bCK = promptType;
        this.initFormats();
    }

    public void unregister() {
        if (this.bCQ == null) {
            return;
        }
        if (this.bCQ instanceof JTextField) {
            ((JTextField)this.bCQ).getDocument().removeDocumentListener(this);
        } else if (this.bCQ instanceof JComboBox) {
            ((JComboBox)this.bCQ).removeActionListener(this);
            ((JComboBox)this.bCQ).removePopupMenuListener(this);
        }
        this.bCQ.removeFocusListener(this);
        if (this.bCY != null) {
            this.bCY.removeActionListener(this);
            this.bCY.removePopupMenuListener(this);
        }
        this.bCQ.setBackground(this.bDe);
    }

    public boolean isPopupError() {
        return this.bCR;
    }

    @Override
    public void changedUpdate(DocumentEvent e2) {
        this.Px();
    }

    @Override
    public void insertUpdate(DocumentEvent e2) {
        this.Px();
    }

    @Override
    public void removeUpdate(DocumentEvent e2) {
        this.Px();
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        if (e2.getSource() instanceof JComboBox) {
            this.Px();
        } else {
            this.hidePopup();
        }
    }

    @Override
    public void focusGained(FocusEvent e2) {
        this.Px();
    }

    @Override
    public void focusLost(FocusEvent e2) {
        this.hidePopup();
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e2) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e2) {
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e2) {
        this.hidePopup();
    }

    public void setFormat(Format format) {
        this.bDf = format;
    }
}

