/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.plugins;

import com.inet.config.ConfigKey;
import com.inet.config.ConfigurationManager;
import com.inet.config.ModulePriority;
import com.inet.config.structure.core.CoreSystemStructureProvider;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.error.ErrorCode;
import com.inet.lib.core.OS;
import com.inet.lib.util.EncodingFunctions;
import com.inet.plugin.ApplicationDescription;
import com.inet.plugin.RemoteGuiInformation;
import com.inet.report.BaseUtils;
import com.inet.shared.utils.Version;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class a
implements ApplicationDescription {
    @Nonnull
    private final Version awM = new Version(BaseUtils.getVersion() + Version.getTechnicalBuildSuffix());

    a() {
    }

    @Nonnull
    public Version getVersion() {
        return this.awM;
    }

    @Nonnull
    public String getApplicationName() {
        return "i-net Clear Reports";
    }

    public void appendTrialLicenseParameters(@Nonnull StringBuilder licenseURL, @Nonnull ConfigStructureSettings settings) {
        String string = settings.getValue("license.generateTrial.select");
        if (string == null) {
            string = CoreSystemStructureProvider.isDocker() ? "license.generateTrial.domain" : "license.generateTrial.plus";
        }
        switch (string) {
            case "license.generateTrial.plus": {
                string = "Plus";
                break;
            }
            case "license.generateTrial.domain": {
                string = "Domain";
                String string2 = settings.getValue("license.generateTrial.domain.name");
                if (string2 == null) break;
                licenseURL.append("&domain=").append(EncodingFunctions.encodeUrlParameter((String)string2));
                break;
            }
            case "license.generateTrial.cloud": {
                string = "Cloud";
                licenseURL.append("&fqdn=").append(EncodingFunctions.encodeUrlParameter((String)settings.getValue("license.generateTrial.fqdn")));
                break;
            }
            case "license.generateTrial.privatecloud": {
                try {
                    string = "PrivateCloud";
                    URL uRL = new URL(settings.getValue(ConfigKey.SERVER_URL));
                    licenseURL.append("&cloudhost=").append(EncodingFunctions.encodeUrlParameter((String)uRL.getHost()));
                }
                catch (MalformedURLException malformedURLException) {
                    ErrorCode.throwAny((Throwable)malformedURLException);
                }
                break;
            }
            default: {
                string = "Standard";
            }
        }
        licenseURL.append("&type=").append(string);
    }

    public String getTrialLicenseBrowserURL() {
        InetAddress[] inetAddressArray = ConfigurationManager.getInstance().getAvailableIPAddresses();
        String string = inetAddressArray.length == 0 ? "" : inetAddressArray[0].getHostAddress();
        return "https://www.inetsoftware.de/products/clear-reports/trial-license-request?type=Plus&version=" + this.awM.getMajor() + "&ip=" + EncodingFunctions.encodeUrlParameter((String)string) + "&os=" + EncodingFunctions.encodeUrlParameter((String)OS.OS_NAME);
    }

    @Nonnull
    public String getDefaultSupportAddress() {
        return "clearreports@inetsoftware.de";
    }

    public int getDefaultPort() {
        return 9000;
    }

    public boolean supportsMultipleConfigurations() {
        return true;
    }

    @Nonnull
    public RemoteGuiInformation getRemoteGuiInformation() {
        ModulePriority modulePriority = new ModulePriority();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (ConfigurationManager.isRecoveryMode()) {
            arrayList.add("/configmanager");
            arrayList.add("/maintenance");
            arrayList.add("/datasource");
            arrayList.add("/store");
            arrayList2.add("");
        } else {
            arrayList.add("/remotedesigner");
            arrayList.add("/adhoc");
            arrayList.add("/repositorybrowser");
            arrayList.add("/store");
            arrayList2.add("");
        }
        modulePriority.setPriorityModules(arrayList);
        modulePriority.setOtherModules(arrayList2);
        RemoteGuiInformation remoteGuiInformation = new RemoteGuiInformation(modulePriority);
        remoteGuiInformation.setAuthenticationIconURL(this.getClass().getResource("/com/inet/report/images/crauthentication.png"));
        remoteGuiInformation.setLogoURL(this.getLogoURL(96));
        remoteGuiInformation.setFaviconURL(this.getClass().getResource("/com/inet/report/images/favicon.ico"));
        remoteGuiInformation.setFavIcnsURL(this.getClass().getResource("/com/inet/report/images/favicon.icns"));
        return remoteGuiInformation;
    }

    public URL getLogoURL(int size) {
        if (size <= 16) {
            return this.getClass().getResource("/com/inet/report/images/cricon_16x16.png");
        }
        if (size <= 32) {
            return this.getClass().getResource("/com/inet/report/images/cricon_32x32.png");
        }
        if (size <= 64) {
            return this.getClass().getResource("/com/inet/report/images/cricon_64x64.png");
        }
        if (size <= 96) {
            return this.getClass().getResource("/com/inet/report/images/cricon_96x96.png");
        }
        return this.getClass().getResource("/com/inet/report/images/cricon_128x128.png");
    }

    public int getDefaultNumberOfJobs() {
        Runtime runtime = Runtime.getRuntime();
        int n2 = runtime.availableProcessors();
        int n3 = (int)(runtime.totalMemory() / 1024L / 1024L / 100L);
        return Math.max(5, Math.min(n2, n3));
    }

    @Nullable
    public URL getHelpPrintReport() {
        return a.class.getResource("print/help.rpt");
    }
}

