/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.list;

import com.inet.annotations.InternalApi;
import com.inet.report.BaseUtils;
import com.inet.report.DatabaseField;
import com.inet.report.Field;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

@InternalApi
public final class DatabaseFieldList
implements Externalizable,
Cloneable {
    private boolean awg = false;
    private DatabaseField[] awh;
    private int MY;
    private int awi;

    public DatabaseFieldList() {
        this(10);
    }

    public DatabaseFieldList(Vector v2) {
        this(v2.size());
        v2.copyInto(this.awh);
        this.MY = v2.size();
    }

    public DatabaseFieldList(DatabaseFieldList o2) {
        this(o2.size());
        System.arraycopy(o2.awh, 0, this.awh, 0, o2.MY);
        this.MY = o2.MY;
    }

    public DatabaseFieldList(int capacity) {
        this(capacity, 0);
    }

    public DatabaseFieldList(int capacity, int capacityIncrement) {
        this.awh = new DatabaseField[capacity];
        this.awi = capacityIncrement;
    }

    public void setAllowDuplicatedEntries(boolean allow) {
        this.awg = allow;
    }

    public final DatabaseField elementAt(int idx) {
        if (idx < this.MY) {
            return this.awh[idx];
        }
        throw new ArrayIndexOutOfBoundsException(idx);
    }

    public final void setCapacity(int capacity) {
        if (capacity < this.MY) {
            this.MY = capacity;
        }
        if (capacity != this.awh.length) {
            DatabaseField[] databaseFieldArray = new DatabaseField[capacity];
            System.arraycopy(this.awh, 0, databaseFieldArray, 0, this.MY);
            this.awh = databaseFieldArray;
        }
    }

    private final void et(int n2) {
        int n3 = this.awh.length;
        if (n2 > n3) {
            if (this.awi > 0) {
                while ((n3 += this.awi) < n2) {
                }
            } else {
                if (n3 == 0) {
                    n3 = 1;
                }
                while ((n3 = 2 * n3) < n2) {
                }
            }
        } else if (n3 > 100000 && n3 > 2 * n2) {
            n3 = this.awi > 0 ? n2 + this.awi : n2 * 2;
        }
        int n4 = n3;
        if (n4 != this.awh.length) {
            this.setCapacity(n4);
        }
    }

    public final void addElement(DatabaseField o2) {
        if (o2 == null) {
            throw new NullPointerException();
        }
        if (this.indexOf(o2) == -1 || this.awg) {
            if (this.MY >= this.awh.length) {
                this.et(this.MY + 1);
            }
            this.awh[this.MY] = o2;
            ++this.MY;
        }
    }

    public final void insertElementAt(DatabaseField o2, int index) {
        if (o2 == null) {
            throw new NullPointerException();
        }
        if (index > this.MY) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        this.et(this.MY + 1);
        System.arraycopy(this.awh, index, this.awh, index + 1, this.MY - index);
        this.awh[index] = o2;
        ++this.MY;
    }

    public final DatabaseField removeElementAt(int idx) {
        DatabaseField databaseField = this.awh[idx];
        if (idx < this.MY - 1) {
            System.arraycopy(this.awh, idx + 1, this.awh, idx, this.MY - idx - 1);
        }
        this.awh[--this.MY] = null;
        return databaseField;
    }

    public final int size() {
        return this.MY;
    }

    public final void setSize(int size) {
        for (int i2 = size; i2 < this.MY; ++i2) {
            this.awh[i2] = null;
        }
        this.et(size);
        this.MY = size;
    }

    public final void clear() {
        this.setSize(0);
    }

    @Override
    public final void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.MY);
        for (int i2 = 0; i2 < this.MY; ++i2) {
            out.writeObject(this.awh[i2]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.MY = in.readInt();
        if (this.awh.length < this.MY) {
            this.awh = new DatabaseField[this.MY];
        }
        for (int i2 = 0; i2 < this.MY; ++i2) {
            this.awh[i2] = (DatabaseField)in.readObject();
        }
    }

    public final int indexOf(DatabaseField o2) {
        if (o2 == null) {
            return -1;
        }
        for (int i2 = 0; i2 < this.awh.length; ++i2) {
            if (this.awh[i2] != o2) continue;
            return i2;
        }
        return this.indexOf(o2.getName());
    }

    public final int indexOf(String fieldName) {
        if (fieldName == null) {
            return -1;
        }
        for (int i2 = 0; i2 < this.awh.length; ++i2) {
            if (!fieldName.equalsIgnoreCase(this.awh[i2] != null ? this.awh[i2].getName() : null)) continue;
            return i2;
        }
        return -1;
    }

    public final int indexOfShortName(String fieldName) {
        if (fieldName == null) {
            return -1;
        }
        for (int i2 = 0; i2 < this.awh.length; ++i2) {
            if (!fieldName.equalsIgnoreCase(this.awh[i2] != null ? this.awh[i2].getShortName() : null)) continue;
            return i2;
        }
        return -1;
    }

    public final void removeElement(DatabaseField o2) {
        int n2 = this.indexOf(o2);
        if (n2 < 0) {
            return;
        }
        this.removeElementAt(n2);
    }

    public final Vector toVector() {
        Vector<DatabaseField> vector = new Vector<DatabaseField>(this.MY);
        for (int i2 = 0; i2 < this.MY; ++i2) {
            vector.addElement(this.awh[i2]);
        }
        return vector;
    }

    public final boolean contains(DatabaseField o2) {
        return this.indexOf(o2) >= 0;
    }

    public final boolean contains(String fieldName) {
        return this.indexOf(fieldName) >= 0;
    }

    public final DatabaseField get(String fieldName) {
        int n2 = this.indexOf(fieldName);
        return n2 >= 0 ? this.elementAt(n2) : null;
    }

    public final DatabaseField[] toArray() {
        return this.toArray(new DatabaseField[this.MY]);
    }

    public final List<Field> toFieldList() {
        ArrayList<Field> arrayList = new ArrayList<Field>(this.MY);
        for (int i2 = 0; i2 < this.size(); ++i2) {
            arrayList.add(this.elementAt(i2));
        }
        return arrayList;
    }

    public final DatabaseField[] toArray(DatabaseField[] o2) {
        if (o2 == null || o2.length != this.MY) {
            o2 = new DatabaseField[this.MY];
        }
        System.arraycopy(this.awh, 0, o2, 0, this.MY);
        return o2;
    }

    public final void copyInto(DatabaseField[] o2) {
        if (o2 == null || o2.length != this.MY) {
            throw new RuntimeException();
        }
        System.arraycopy(this.awh, 0, o2, 0, this.MY);
    }

    public final void addAll(DatabaseFieldList o2) {
        this.et(this.MY + o2.MY);
        for (int i2 = 0; i2 < o2.size(); ++i2) {
            this.addElement(o2.elementAt(i2));
        }
    }

    public final void addAll(DatabaseField[] o2) {
        if (o2 == null) {
            return;
        }
        this.et(this.MY + o2.length);
        for (int i2 = 0; i2 < o2.length; ++i2) {
            this.addElement(o2[i2]);
        }
    }

    public final void setElementAt(DatabaseField o2, int index) {
        if (index >= this.MY) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        this.awh[index] = o2;
    }

    public final DatabaseField lastElement() {
        return this.awh[this.MY - 1];
    }

    public final Object clone() {
        DatabaseFieldList databaseFieldList = null;
        try {
            databaseFieldList = (DatabaseFieldList)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException();
        }
        databaseFieldList.awh = new DatabaseField[this.awh.length];
        System.arraycopy(this.awh, 0, databaseFieldList.awh, 0, this.MY);
        return databaseFieldList;
    }

    public final boolean isEmpty() {
        return this.MY == 0;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        for (int i2 = 0; i2 < this.MY; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(',').append(' ');
            }
            stringBuilder.append(this.awh[i2]);
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public final Object getObjectAt(int i2) {
        return this.elementAt(i2);
    }

    public void log() {
        if (BaseUtils.isDebug()) {
            try {
                for (int i2 = 0; i2 < this.size(); ++i2) {
                    DatabaseField databaseField = this.elementAt(i2);
                    int n2 = databaseField.getValueType();
                    String string = databaseField.getShortName();
                    String string2 = databaseField.getName();
                    String string3 = string;
                    if (string2 != null) {
                        string3 = string2;
                    }
                    BaseUtils.debug("FieldList Column: " + i2 + " name: " + string3 + " type: " + n2);
                }
            }
            catch (Throwable throwable) {
                BaseUtils.info(throwable);
            }
        }
    }
}

