/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.layout;

import com.inet.annotations.InternalApi;
import com.inet.font.layout.FontContext;
import com.inet.font.layout.FontLayout;
import com.inet.report.layout.Chunk;

@InternalApi
public class TextChunk
extends Chunk {
    private String mr;
    private FontContext bS;

    public TextChunk(String text, FontContext fontContext) {
        this.chunkType = 1;
        this.mr = text;
        this.bS = fontContext;
    }

    public String toString() {
        return this.mr + "(" + this.getWidth() + ")";
    }

    public String getText() {
        return this.mr;
    }

    public void append(TextChunk chunk) {
        this.mr = this.mr.concat(chunk.mr);
        this.width += chunk.getWidth();
    }

    public void appendTextIgnoreFont(String textToAppend) {
        this.mr = this.mr.concat(textToAppend);
    }

    public FontLayout getFontLayout() {
        return this.bS.getFontLayout();
    }

    public int getColor() {
        return this.bS.getColor();
    }

    public void setText(String text) {
        this.mr = text;
        this.width = this.bS.getFontLayout().stringWidth(text);
    }

    public FontContext getFontContext() {
        return this.bS;
    }

    void vE() {
        if (this.mr.length() > 0 && this.mr.charAt(0) == ' ') {
            this.mr = this.mr.substring(1) + " ";
        }
    }

    public TextChunk convertToTextChunkWithHyperlinkStyle(int fontColor) {
        if (this.bS.isUnderline() && this.bS.getColor() == fontColor) {
            return this;
        }
        int n2 = this.bS.getCcStyle();
        if (!this.bS.isUnderline()) {
            n2 += 4;
        }
        FontContext fontContext = new FontContext(this.bS.getFontLayout(), fontColor, n2);
        TextChunk textChunk = new TextChunk("", fontContext);
        textChunk.setText(this.mr);
        return textChunk;
    }
}

