/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.formula.javafunctions;

import com.inet.report.formula.javafunctions.JSONBasedSignature;
import com.inet.report.formula.javafunctions.MethodProvider;
import com.inet.report.formula.javafunctions.Signature;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class JSONBasedMethodProvider
implements MethodProvider,
Serializable {
    private Map<String, List<Signature>> userDefinedFunctions = new HashMap<String, List<Signature>>();
    private Map<String, List<Signature>> userDefinedFields = new HashMap<String, List<Signature>>();
    private Map<String, List<Signature>> userDefinedFunctionsByClass = new TreeMap<String, List<Signature>>();

    public JSONBasedMethodProvider(List<Signature> signatures) {
        this.addSignatures(signatures);
    }

    public JSONBasedMethodProvider(MethodProvider source) {
        for (List<Signature> list : source.getMethodNames().values()) {
            this.addSignatures(list);
        }
    }

    public void addSignatures(List<Signature> signatures) {
        for (Signature signature : signatures) {
            if (!(signature instanceof JSONBasedSignature)) {
                signature = new JSONBasedSignature(signature);
            }
            String string = signature.getName();
            Map<String, List<Signature>> map = signature.getParameterClasses() != null ? this.userDefinedFunctions : this.userDefinedFields;
            this.getOrCreate(string, map).add(signature);
            this.getOrCreate(signature.getSourceClassName(), this.userDefinedFunctionsByClass).add(signature);
        }
    }

    private List<Signature> getOrCreate(String key, Map<String, List<Signature>> map) {
        List<Signature> list = map.get(key);
        if (list == null) {
            list = new ArrayList<Signature>();
            map.put(key, list);
        }
        return list;
    }

    @Override
    public List<Signature> getMethods(String name) {
        return this.userDefinedFunctions.get(name);
    }

    @Override
    public List<Signature> getFields(String name) {
        return this.userDefinedFields.get(name);
    }

    @Override
    public Map<String, List<Signature>> getMethodNames() {
        return this.userDefinedFunctionsByClass;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MethodProvider)) {
            return false;
        }
        MethodProvider methodProvider = (MethodProvider)obj;
        Map<String, List<Signature>> map = methodProvider.getMethodNames();
        Map<String, List<Signature>> map2 = this.getMethodNames();
        if (map.size() != map2.size()) {
            return false;
        }
        for (Map.Entry<String, List<Signature>> entry : map2.entrySet()) {
            List<Signature> list = entry.getValue();
            List<Signature> list2 = map.get(entry.getKey());
            if (list2 == null || list.size() != list2.size()) {
                return false;
            }
            for (Signature signature : list) {
                if (this.isSignatureInList(signature, list2)) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return "JSON-Method-Provider for: " + Arrays.toString(this.getMethodNames().keySet().toArray());
    }

    private boolean isSignatureInList(Signature toCheck, List<Signature> signatures) {
        for (Signature signature : signatures) {
            if (!toCheck.getName().equals(signature.getName()) || !Arrays.equals(toCheck.getParameterTypes(), signature.getParameterTypes()) || toCheck.getReturnType() != signature.getReturnType()) continue;
            return true;
        }
        return false;
    }
}

