/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.encode;

import com.inet.report.BaseUtils;
import com.inet.report.encode.AbstractDecoder;
import java.awt.image.BufferedImage;

public final class RawDecoder
extends AbstractDecoder {
    static final byte[] agB = "raw".getBytes();
    private int width;
    private int jk;
    private int vU;
    private byte agC;

    @Override
    public void setBuffer(byte[] buffer, int offset, int length) {
        super.setBuffer(buffer, offset, length);
        this.vU = offset;
    }

    @Override
    protected BufferedImage decodeImage(int w2, int h2) {
        BufferedImage bufferedImage = null;
        byte[] byArray = new byte[]{this.buffer[this.pV()], this.buffer[this.pV()], this.buffer[this.pV()]};
        if (byArray[0] != agB[0] || byArray[1] != agB[1] || byArray[2] != agB[2]) {
            BaseUtils.info("wrong image type: " + (char)byArray[0] + (char)byArray[1] + (char)byArray[2]);
        }
        this.agC = this.buffer[this.pV()];
        this.width = this.readInt();
        this.jk = this.readInt();
        int[] nArray = new int[this.width * this.jk];
        switch (this.agC) {
            case 32: {
                for (int i2 = 0; i2 < nArray.length; ++i2) {
                    nArray[i2] = this.pW();
                }
                bufferedImage = new BufferedImage(this.width, this.jk, 2);
                bufferedImage.setRGB(0, 0, this.width, this.jk, nArray, 0, this.width);
                break;
            }
            default: {
                BaseUtils.info("Invalid raw bpp: " + this.agC);
                return null;
            }
        }
        return bufferedImage;
    }

    private int pV() {
        return this.vU++;
    }

    private int readInt() {
        return ((this.buffer[this.pV()] & 0xFF) << 24) + ((this.buffer[this.pV()] & 0xFF) << 16) + ((this.buffer[this.pV()] & 0xFF) << 8) + (this.buffer[this.pV()] & 0xFF);
    }

    private int pW() {
        int n2 = this.buffer[this.pV()] & 0xFF;
        int n3 = this.buffer[this.pV()] & 0xFF;
        int n4 = this.buffer[this.pV()] & 0xFF;
        int n5 = this.buffer[this.pV()] & 0xFF;
        return (n2 << 24) + (n5 << 16) + (n4 << 8) + n3;
    }
}

