/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.config;

import com.inet.annotations.PublicApi;
import com.inet.config.ConfigKeyParser;
import com.inet.config.LicenseInfo;
import com.inet.config.LicenseManager;
import com.inet.plugin.ServerPluginManager;
import com.inet.report.BaseUtils;
import java.util.Objects;
import javax.annotation.Nonnull;

@PublicApi
public final class LicenseKeyInfo {
    private static LicenseKeyInfo aab;
    private LicenseInfo aac;

    public LicenseKeyInfo(String licenseKey) {
        if (licenseKey == null) {
            this.aac = ConfigKeyParser.getCurrent();
            return;
        }
        this.aac = new ConfigKeyParser().getLicenseInfo(licenseKey).getCurrent();
    }

    LicenseKeyInfo(@Nonnull LicenseInfo license) {
        Objects.requireNonNull(license);
        this.aac = license;
    }

    @Nonnull
    public static final LicenseKeyInfo getCurrent() {
        if (aab == null) {
            try {
                if (aab == null && ServerPluginManager.getInstance().getState() != ServerPluginManager.ServerPluginManagerState.INIT) {
                    Class.forName("com.inet.report.Engine").getConstructor(String.class).newInstance("java");
                }
            }
            catch (Throwable throwable) {
                BaseUtils.error(throwable);
            }
            aab = new LicenseKeyInfo(ConfigKeyParser.getCurrent());
        }
        return aab;
    }

    public final boolean isPlus() {
        return this.aac.isValid() && Boolean.parseBoolean((String)this.aac.getAttributes().get("crplus"));
    }

    public final String getLicenseText() {
        return this.aac.getDisplayName();
    }

    public final String getLicensee() {
        return this.aac.getLicensee();
    }

    public final boolean isValid() {
        return this.aac.isValid();
    }

    public final String getErrorMessage() {
        return this.aac.getErrorMessage();
    }

    public final boolean hasExpiredDate() {
        return this.aac.hasExpiredDate();
    }

    public final String getWaterMark() {
        return (String)this.aac.getAttributes().get("watermark");
    }

    public final boolean isSite() {
        return this.aac.isValid() && this.aac.getAttributes().get("ip") == null;
    }

    public final LicenseInfo getLicenseInfo() {
        return this.aac;
    }

    static {
        LicenseManager.getInstance().addLicenseListener(licenseInfo -> {
            aab = new LicenseKeyInfo(licenseInfo);
        });
    }
}

