/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.chart.axis;

import com.inet.annotations.PublicApi;
import com.inet.report.BaseUtils;
import com.inet.report.Chart2;
import com.inet.report.FormulaField;
import com.inet.report.chart.f;
import com.inet.report.i;
import com.inet.report.j;
import java.io.Serializable;
import java.util.Date;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@PublicApi
public class DateRange
implements Serializable {
    private Date Xm;
    private Date Xn;
    private FormulaField Xo;
    private FormulaField Xp;
    private boolean vy;

    public DateRange() {
        this.vy = true;
    }

    public DateRange(Date lower, Date upper) {
        if (lower == null) {
            throw i.d("lower");
        }
        if (upper == null) {
            throw i.d("upper");
        }
        if (lower.after(upper)) {
            throw new IllegalArgumentException("Parameter 'upper' before 'lower'.");
        }
        this.vy = false;
        this.Xm = (Date)lower.clone();
        this.Xn = (Date)upper.clone();
    }

    public boolean isAutoRange() {
        return this.vy;
    }

    public void setAutoRange(boolean autoRange) {
        this.vy = autoRange;
    }

    public Date getLowerBound() {
        if (this.Xm != null) {
            return (Date)this.Xm.clone();
        }
        return null;
    }

    public void setLowerBound(Date lower) {
        if (this.Xn != null && this.Xn.before(lower)) {
            throw new IllegalArgumentException("Parameter 'lower' greater than upper bound.");
        }
        this.Xm = lower != null ? (Date)lower.clone() : null;
    }

    public FormulaField getLowerBoundFormula() {
        return this.Xo;
    }

    public void setLowerBoundFormula(FormulaField lowerBoundFormula) {
        this.Xo = lowerBoundFormula;
    }

    public Date getUpperBound() {
        if (this.Xn != null) {
            return (Date)this.Xn.clone();
        }
        return null;
    }

    public void setUpperBound(Date upper) {
        if (this.Xm != null && this.Xm.after(upper)) {
            throw new IllegalArgumentException("Parameter 'upper' less than 'lower'.");
        }
        this.Xn = upper != null ? (Date)upper.clone() : null;
    }

    public FormulaField getUpperBoundFormula() {
        return this.Xp;
    }

    public void setUpperBoundFormula(FormulaField upperBoundFormula) {
        this.Xp = upperBoundFormula;
    }

    boolean mW() {
        return !(this.getUpperBound() == null && this.getUpperBoundFormula() == null || this.getLowerBound() == null && this.getLowerBoundFormula() == null);
    }

    void saveProperties(StringBuilder buffer, int depth) {
        if (!this.isAutoRange() && this.mW()) {
            buffer.append(BaseUtils.getIndent(depth));
            buffer.append("<");
            buffer.append("RangeDate");
            buffer.append(' ');
            if (this.Xm != null) {
                f.b(buffer, "lowerBound", Long.toString(this.Xm.getTime()));
            }
            if (this.Xn != null) {
                f.b(buffer, "upperBound", Long.toString(this.Xn.getTime()));
            }
            buffer.append(">\n");
            if (this.Xo != null) {
                j.a(buffer, depth, this.Xo, "chartAxisMinDateFormula");
            }
            if (this.Xp != null) {
                j.a(buffer, depth, this.Xp, "chartAxisMaxDateFormula");
            }
            buffer.append("<");
            buffer.append("/");
            buffer.append("RangeDate");
            buffer.append(">\n");
        }
    }

    void readProperties(Element element, Chart2 chart) {
        NodeList nodeList;
        FormulaField formulaField;
        this.setAutoRange(false);
        String string = element.getAttribute("lowerBound");
        if (string.length() > 0) {
            long l2 = Long.valueOf(string);
            this.setLowerBound(new Date(l2));
        }
        if ((formulaField = j.a(nodeList = element.getChildNodes(), chart, "chartAxisMinDateFormula")) != null) {
            this.setLowerBoundFormula(formulaField);
        }
        if ((string = element.getAttribute("upperBound")).length() > 0) {
            long l3 = Long.valueOf(string);
            this.setUpperBound(new Date(l3));
        }
        if ((formulaField = j.a(nodeList, chart, "chartAxisMaxDateFormula")) != null) {
            this.setUpperBoundFormula(formulaField);
        }
    }
}

