/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.chart;

import com.inet.annotations.PublicApi;
import com.inet.lib.util.ColorUtils;
import com.inet.report.BaseUtils;
import com.inet.report.BySummaryOrder;
import com.inet.report.Chart2;
import com.inet.report.DChartUtilities;
import com.inet.report.Engine;
import com.inet.report.Field;
import com.inet.report.FormulaField;
import com.inet.report.Group;
import com.inet.report.Section;
import com.inet.report.SummaryField;
import com.inet.report.ValueProperties;
import com.inet.report.aj;
import com.inet.report.by;
import com.inet.report.chart.ChartTitle;
import com.inet.report.chart.Legend;
import com.inet.report.chart.LegendPlacement;
import com.inet.report.chart.axis.AbstractMarker;
import com.inet.report.chart.axis.AxisPosition;
import com.inet.report.chart.axis.BaseAxis;
import com.inet.report.chart.axis.ContinuousDateAxis;
import com.inet.report.chart.axis.ContinuousNumberAxis;
import com.inet.report.chart.axis.DiscreteNumberAxis;
import com.inet.report.chart.axis.GroupAxis;
import com.inet.report.chart.axis.LineMarker;
import com.inet.report.chart.axis.NumberRange;
import com.inet.report.chart.dataset.AbstractDataset;
import com.inet.report.chart.dataset.BaseDataset;
import com.inet.report.chart.dataset.ForAllRecordsDataset;
import com.inet.report.chart.dataset.ForEachRecordDataset;
import com.inet.report.chart.dataset.GanttForEachRecordDataset;
import com.inet.report.chart.dataset.GanttOneGroupDataset;
import com.inet.report.chart.dataset.GanttTwoGroupsDataset;
import com.inet.report.chart.dataset.OneGroupDataset;
import com.inet.report.chart.dataset.PieDataset;
import com.inet.report.chart.dataset.StandardDataset;
import com.inet.report.chart.dataset.StockDataset;
import com.inet.report.chart.dataset.StockForAllRecordsDataset;
import com.inet.report.chart.dataset.StockForEachRecordDataset;
import com.inet.report.chart.dataset.StockOneGroupDataset;
import com.inet.report.chart.dataset.TwoGroupsDataset;
import com.inet.report.chart.dataset.XYDataset;
import com.inet.report.chart.dataset.XYForAllRecordsDataset;
import com.inet.report.chart.dataset.XYForEachRecordDataset;
import com.inet.report.chart.dataset.XYOneGroupDataset;
import com.inet.report.chart.format.Abbreviation;
import com.inet.report.chart.format.ChartFormat;
import com.inet.report.chart.format.FixedNumberFormat;
import com.inet.report.chart.format.PatternNumberFormat;
import com.inet.report.chart.plot.AbstractPlot;
import com.inet.report.chart.plot.AreaPlot;
import com.inet.report.chart.plot.AreaStyle;
import com.inet.report.chart.plot.BarPlot;
import com.inet.report.chart.plot.BarStyle;
import com.inet.report.chart.plot.Chart3DPlot;
import com.inet.report.chart.plot.Chart3DStyle;
import com.inet.report.chart.plot.DrawOutOfScale;
import com.inet.report.chart.plot.GanttPlot;
import com.inet.report.chart.plot.GanttStyle;
import com.inet.report.chart.plot.ItemShape;
import com.inet.report.chart.plot.LinePlot;
import com.inet.report.chart.plot.LineStyle;
import com.inet.report.chart.plot.MultiplePiePlot;
import com.inet.report.chart.plot.MultiplePieStyle;
import com.inet.report.chart.plot.PieLegendLayout;
import com.inet.report.chart.plot.PiePlot;
import com.inet.report.chart.plot.PieStyle;
import com.inet.report.chart.plot.PolarPlot;
import com.inet.report.chart.plot.PolarStyle;
import com.inet.report.chart.plot.StandardPlot;
import com.inet.report.chart.plot.StockPlot;
import com.inet.report.chart.plot.StockStyle;
import com.inet.report.chart.plot.XYPlot;
import com.inet.report.chart.plot.XYStyle;
import com.inet.report.i;
import com.inet.report.util.EngineUtils;
import java.awt.Color;
import java.awt.Font;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;

@PublicApi
public class ChartConverter {
    public static void replaceChart(aj oldChart) {
        Section section = (Section)oldChart.getParent();
        if (section == null) {
            return;
        }
        Chart2 chart2 = section.addChart2(BarStyle.BAR2D, oldChart.getX(), oldChart.getY(), oldChart.getWidth(), oldChart.getHeight());
        ChartConverter.convertChartToChart2(oldChart, chart2);
        section.remove(oldChart);
    }

    public static void convertChartToChart2(aj oldChart, Chart2 newChart) {
        int n2;
        Font font;
        Serializable serializable;
        newChart.setSuppress(oldChart.isSuppress());
        newChart.setSuppressFormula(oldChart.getSuppressFormula());
        newChart.setSuppressIfDuplicated(oldChart.isSuppressIfDuplicated());
        newChart.setSuppressIfDuplicatedFormula(oldChart.getSuppressIfDuplicatedFormula());
        newChart.setToolTipsText(oldChart.getToolTipsText());
        newChart.setToolTipsTextFormula(oldChart.getToolTipsTextFormula());
        newChart.setLeftLineStyle(oldChart.getLeftLineStyle());
        newChart.setLeftLineStyleFormula(oldChart.getLeftLineStyleFormula());
        newChart.setTopLineStyle(oldChart.getTopLineStyle());
        newChart.setTopLineStyleFormula(oldChart.getTopLineStyleFormula());
        newChart.setRightLineStyle(oldChart.getRightLineStyle());
        newChart.setRightLineStyleFormula(oldChart.getRightLineStyleFormula());
        newChart.setBottomLineStyle(oldChart.getBottomLineStyle());
        newChart.setBottomLineStyleFormula(oldChart.getBottomLineStyleFormula());
        newChart.setForeColor(oldChart.getForeColor());
        newChart.setForeColorFormula(oldChart.getForeColorFormula());
        newChart.setBackColor(oldChart.getBackColor());
        newChart.setBackColorFormula(oldChart.getBackColorFormula());
        newChart.setDropShadow(oldChart.isDropShadow());
        newChart.setDropShadowFormula(oldChart.getDropShadowFormula());
        newChart.setHyperlinkUrl(oldChart.getHyperlinkUrl());
        newChart.setHyperlinkUrlFormula(oldChart.getHyperlinkUrlFormula());
        if (oldChart.en()) {
            newChart.setPlotOrientation("PlotOrientation.HORIZONTAL");
        } else {
            newChart.setPlotOrientation("PlotOrientation.VERTICAL");
        }
        Legend legend = new Legend();
        LegendPlacement legendPlacement = LegendPlacement.NONE;
        if (oldChart.ex()) {
            int n3;
            switch (oldChart.ey()) {
                case 0: 
                case 3: {
                    legendPlacement = LegendPlacement.RIGHT;
                    break;
                }
                case 4: {
                    legendPlacement = LegendPlacement.LEFT;
                    break;
                }
                case 1: 
                case 2: {
                    legendPlacement = LegendPlacement.BOTTOM;
                    break;
                }
                default: {
                    legendPlacement = LegendPlacement.RIGHT;
                }
            }
            serializable = oldChart.dS();
            if (serializable != null) {
                legend.setLegendFont((Font)serializable);
            }
            if ((n3 = oldChart.ap(10447)) != -1) {
                legend.setLegendColor(n3);
            }
        }
        legend.setLegendPlacement(legendPlacement);
        newChart.setLegend(legend);
        serializable = newChart.getHeaderTitle();
        ((ChartTitle)serializable).setTitle(oldChart.getTitle());
        ((ChartTitle)serializable).setShowAutoTitle(oldChart.eC());
        if (oldChart.eC()) {
            ((ChartTitle)serializable).aH(oldChart.getTitle());
        }
        if ((font = oldChart.dP()) != null) {
            ((ChartTitle)serializable).setFont(font);
        }
        if ((n2 = oldChart.ap(10440)) != -1) {
            ((ChartTitle)serializable).setColor(n2);
        }
        newChart.setHeaderTitle((ChartTitle)serializable);
        ChartTitle chartTitle = newChart.getSubtitle();
        chartTitle.setShowAutoTitle(oldChart.eD());
        if (!oldChart.eD()) {
            chartTitle.setTitle(oldChart.eo());
        }
        font = oldChart.dQ();
        if (font != null) {
            chartTitle.setFont(font);
        }
        if ((n2 = oldChart.ap(10441)) != -1) {
            chartTitle.setColor(n2);
        }
        newChart.setSubtitle(chartTitle);
        ChartTitle chartTitle2 = newChart.getFootnote();
        chartTitle2.setTitle(oldChart.ep());
        chartTitle2.setShowAutoTitle(oldChart.eE());
        if (oldChart.eE()) {
            chartTitle2.aH(oldChart.ep());
        }
        if ((font = oldChart.dR()) != null) {
            chartTitle2.setFont(font);
        }
        if ((n2 = oldChart.ap(10442)) != -1) {
            chartTitle2.setColor(n2);
        }
        newChart.setFootnote(chartTitle2);
        switch (oldChart.em()) {
            case 0: {
                ChartConverter.a(oldChart, newChart, (BarPlot)BarStyle.BAR2D.getDefaultPlot());
                break;
            }
            case 1: {
                ChartConverter.a(oldChart, newChart, (BarPlot)BarStyle.BAR2D_STACKED.getDefaultPlot());
                break;
            }
            case 2: {
                ChartConverter.a(oldChart, newChart, (BarPlot)BarStyle.BAR2D_PERCENT.getDefaultPlot());
                break;
            }
            case 3: {
                ChartConverter.a(oldChart, newChart, (BarPlot)BarStyle.BAR3D.getDefaultPlot());
                break;
            }
            case 4: {
                ChartConverter.a(oldChart, newChart, (BarPlot)BarStyle.BAR3D_STACKED.getDefaultPlot());
                break;
            }
            case 5: {
                ChartConverter.a(oldChart, newChart, (BarPlot)BarStyle.BAR3D_PERCENT.getDefaultPlot());
                break;
            }
            case 532: {
                ChartConverter.a(oldChart, newChart, (AreaPlot)AreaStyle.AREA2D_STACKED.getDefaultPlot());
                break;
            }
            case 533: {
                ChartConverter.a(oldChart, newChart, (AreaPlot)AreaStyle.AREA2D_PERCENT.getDefaultPlot());
                break;
            }
            case 534: {
                ChartConverter.a(oldChart, newChart, (AreaPlot)AreaStyle.AREA3D_STACKED.getDefaultPlot());
                break;
            }
            case 535: {
                ChartConverter.a(oldChart, newChart, (AreaPlot)AreaStyle.AREA3D_PERCENT.getDefaultPlot());
                break;
            }
            case 266: {
                ChartConverter.a(oldChart, newChart, (LinePlot)LineStyle.LINE.getDefaultPlot());
                break;
            }
            case 267: {
                ChartConverter.a(oldChart, newChart, (LinePlot)LineStyle.LINE_STACKED.getDefaultPlot());
                break;
            }
            case 268: {
                ChartConverter.a(oldChart, newChart, (LinePlot)LineStyle.LINE_PERCENT.getDefaultPlot());
                break;
            }
            case 269: {
                ChartConverter.a(oldChart, newChart, (LinePlot)LineStyle.LINE_MARKER.getDefaultPlot());
                break;
            }
            case 270: {
                ChartConverter.a(oldChart, newChart, (LinePlot)LineStyle.LINE_MARKER_STACKED.getDefaultPlot());
                break;
            }
            case 271: {
                ChartConverter.a(oldChart, newChart, (LinePlot)LineStyle.LINE_MARKER_PERCENT.getDefaultPlot());
                break;
            }
            case 798: {
                ChartConverter.a(oldChart, newChart, (PiePlot)PieStyle.PIE2D.getDefaultPlot());
                break;
            }
            case 40: 
            case 799: {
                ChartConverter.a(oldChart, newChart, (PiePlot)PieStyle.PIE3D.getDefaultPlot());
                break;
            }
            case 800: 
            case 801: {
                ChartConverter.a(oldChart, newChart, (MultiplePiePlot)MultiplePieStyle.PIE3D_MULTIPLE.getDefaultPlot());
                break;
            }
            case 1063: 
            case 1065: 
            case 1066: {
                ChartConverter.a(oldChart, newChart, (PiePlot)PieStyle.RING2D.getDefaultPlot());
                break;
            }
            case 1064: {
                ChartConverter.a(oldChart, newChart, (PiePlot)PieStyle.RING3D.getDefaultPlot());
                break;
            }
            case 1331: {
                ChartConverter.a(oldChart, newChart, (Chart3DPlot)Chart3DStyle.PYRAMID.getDefaultPlot());
                break;
            }
            case 1332: {
                ChartConverter.a(oldChart, newChart, (Chart3DPlot)Chart3DStyle.OCTAGON.getDefaultPlot());
                break;
            }
            case 1333: {
                ChartConverter.a(oldChart, newChart, (Chart3DPlot)Chart3DStyle.CUTCORNER.getDefaultPlot());
                break;
            }
            case 160: 
            case 1330: {
                ChartConverter.a(oldChart, newChart, (Chart3DPlot)Chart3DStyle.BAR.getDefaultPlot());
                break;
            }
            case 1598: {
                ChartConverter.a(oldChart, newChart, (Chart3DPlot)Chart3DStyle.SURFACE_HONEYCOMB.getDefaultPlot());
                break;
            }
            case 1597: {
                ChartConverter.a(oldChart, newChart, (Chart3DPlot)Chart3DStyle.SURFACE_SOLID.getDefaultPlot());
                break;
            }
            case 1596: {
                ChartConverter.a(oldChart, newChart, (Chart3DPlot)Chart3DStyle.SURFACE.getDefaultPlot());
                break;
            }
            case 5000: {
                ChartConverter.a(oldChart, newChart, (Chart3DPlot)Chart3DStyle.AREA_CONNECTED_SERIES.getDefaultPlot());
                break;
            }
            case 5001: {
                ChartConverter.a(oldChart, newChart, (Chart3DPlot)Chart3DStyle.AREA_CONNECTED_GROUPS.getDefaultPlot());
                break;
            }
            case 5002: {
                ChartConverter.a(oldChart, newChart, (Chart3DPlot)Chart3DStyle.FLOATING_CUBES.getDefaultPlot());
                break;
            }
            case 2128: {
                ChartConverter.a(oldChart, newChart, (PolarPlot)PolarStyle.POLAR.getDefaultPlot());
                break;
            }
            case 2129: {
                ChartConverter.a(oldChart, newChart, (PolarPlot)PolarStyle.POLAR_STACKED.getDefaultPlot());
                break;
            }
            case 1862: {
                ChartConverter.b(oldChart, newChart, (XYPlot)XYStyle.SCATTER.getDefaultPlot());
                break;
            }
            case 2394: {
                ChartConverter.b(oldChart, newChart, (XYPlot)XYStyle.BUBBLE.getDefaultPlot());
                break;
            }
            case 2660: {
                ChartConverter.b(oldChart, newChart, (StockPlot)StockStyle.STOCK_HIGH_LOW.getDefaultPlot());
                break;
            }
            case 2661: {
                if (oldChart.eU() < 4) {
                    ChartConverter.b(oldChart, newChart, (StockPlot)StockStyle.STOCK_HIGH_LOW.getDefaultPlot());
                    break;
                }
                ChartConverter.b(oldChart, newChart, (StockPlot)StockStyle.STOCK_HIGH_LOW_OPEN_CLOSE.getDefaultPlot());
                break;
            }
            case 3458: {
                ChartConverter.b(oldChart, newChart, (GanttPlot)GanttStyle.GANTT.getDefaultPlot());
                break;
            }
            default: {
                ChartConverter.a(oldChart, newChart, (BarPlot)BarStyle.BAR2D.getDefaultPlot());
            }
        }
    }

    private static void a(aj aj2, AbstractPlot abstractPlot) {
        Object object;
        Object[] objectArray;
        if (aj2.eK() && (objectArray = aj2.eL()) != null && objectArray.length != 0) {
            object = new Color[objectArray.length];
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                object[i2] = ColorUtils.toJavaColor((int)objectArray[i2]);
            }
            abstractPlot.setColorSequence((Color[])object);
        }
        if (aj2.eJ()) {
            objectArray = (Color[])DChartUtilities.getDefaultBlackAndWhiteColorSequence();
            abstractPlot.setColorSequence((Color[])objectArray);
        }
        abstractPlot.setColorFormula(aj2.getColorFormula());
        abstractPlot.setSameColorsForSameGroups(aj2.eI());
        if (aj2.eH()) {
            float f2 = 0.5f;
            object = abstractPlot.getStyle();
            if (object instanceof BarStyle) {
                f2 = 0.75f;
            } else if (object instanceof XYStyle) {
                f2 = 0.65f;
            }
            abstractPlot.setForegroundAlpha(f2);
        }
        abstractPlot.setShowLabel(aj2.eP() == 1);
        abstractPlot.setShowValue(aj2.eP() == 2 || aj2.eP() == 3);
        ItemShape itemShape = new ItemShape();
        switch (aj2.ez()) {
            case 1: {
                itemShape.setShapeType(1);
                break;
            }
            case 4: {
                itemShape.setShapeType(2);
                break;
            }
            case 5: {
                itemShape.setShapeType(3);
                break;
            }
            case 8: {
                itemShape.setShapeType(4);
            }
        }
        double d2 = i.y(aj2.eA());
        itemShape.setShapeSize(d2);
        abstractPlot.setItemShape(itemShape);
        int n2 = aj2.eQ();
        aj.a a2 = aj2.dN();
        ChartFormat chartFormat = ChartConverter.a(n2, a2, aj2);
        abstractPlot.setItemLabelFormat(chartFormat);
    }

    private static void a(aj aj2, StandardPlot standardPlot) {
        standardPlot.setShowCumulativeValues(aj2.eP() == 2);
        BaseAxis baseAxis = standardPlot.getCategoryAxis();
        ChartConverter.a(aj2, baseAxis);
        standardPlot.setCategoryAxis(baseAxis);
        DiscreteNumberAxis discreteNumberAxis = standardPlot.getDataAxis();
        ChartConverter.a(aj2, discreteNumberAxis);
        int n2 = aj2.em();
        if (i.s(n2) || i.r(n2) || i.q(n2)) {
            discreteNumberAxis.setRange(new NumberRange(0.0, 1.0));
        }
        standardPlot.setDataAxis(discreteNumberAxis);
        switch (aj2.el()) {
            case 0: {
                standardPlot.setItemLabelPosition(10);
                break;
            }
            case 1: {
                standardPlot.setItemLabelPosition(11);
                break;
            }
            case 2: {
                standardPlot.setItemLabelPosition(12);
                break;
            }
            case 3: {
                standardPlot.setItemLabelPosition(13);
                break;
            }
            default: {
                standardPlot.setItemLabelPosition(10);
            }
        }
    }

    private static ChartFormat a(int n2, aj.a a2, aj aj2) {
        NumberFormat numberFormat = new FixedNumberFormat(0);
        switch (n2) {
            case 13: {
                numberFormat = null;
                break;
            }
            case 3: 
            case 4: 
            case 11: 
            case 12: {
                numberFormat = new FixedNumberFormat(2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                numberFormat = new FixedNumberFormat(1);
                break;
            }
            case 8: {
                if (a2 == null) break;
                numberFormat = new PatternNumberFormat();
                try {
                    String string = ChartConverter.a(a2, aj2.getEngine().getLocale());
                    ((PatternNumberFormat)numberFormat).setPattern(string);
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        switch (n2) {
            case 9: 
            case 11: {
                ((FixedNumberFormat)numberFormat).setAbbreviation(Abbreviation.ABBREVIATION_THOUSANDS);
                ((FixedNumberFormat)numberFormat).setNumberOfDecimalPlaces(0);
                break;
            }
            case 10: 
            case 12: {
                ((FixedNumberFormat)numberFormat).setAbbreviation(Abbreviation.ABBREVIATION_MILLIONS);
                ((FixedNumberFormat)numberFormat).setNumberOfDecimalPlaces(0);
                break;
            }
            case 0: 
            case 3: 
            case 5: {
                ((FixedNumberFormat)numberFormat).setNumberOfDecimalPlaces(0);
                break;
            }
            case 1: 
            case 6: {
                ((FixedNumberFormat)numberFormat).setNumberOfDecimalPlaces(1);
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                ((FixedNumberFormat)numberFormat).setNumberOfDecimalPlaces(2);
            }
        }
        return numberFormat;
    }

    private static void a(aj aj2, BaseAxis baseAxis) {
        int n2;
        Font font;
        ChartTitle chartTitle = new ChartTitle(new Font("SansSerif", 1, 14), 0);
        chartTitle.setTitle(aj2.eq());
        chartTitle.setShowAutoTitle(aj2.eF());
        if (aj2.eF()) {
            chartTitle.aH(aj2.eq());
        }
        if ((font = aj2.dT()) != null) {
            chartTitle.setFont(font);
        }
        if ((n2 = aj2.ap(10443)) != -1) {
            chartTitle.setColor(n2);
        }
        baseAxis.setTitle(chartTitle);
        Font font2 = new Font("SansSerif", 0, 12);
        if (aj2.dV() != null) {
            font2 = aj2.dV();
        }
        baseAxis.setTickLabelFont(font2);
        int n3 = aj2.ap(10445);
        if (n3 != -1) {
            baseAxis.setTickLabelColor(n3);
        }
        baseAxis.setInverseOrder(aj2.ej());
        AxisPosition axisPosition = AxisPosition.NONE;
        if (aj2.ei()) {
            axisPosition = AxisPosition.ON_MIN;
        }
        if (aj2.eh()) {
            axisPosition = AxisPosition.ON_MAX;
        }
        baseAxis.setAxisPosition(axisPosition);
        baseAxis.setGridlinesVisible(aj2.ek());
        if (baseAxis instanceof GroupAxis) {
            if (aj2.ed() != 0.0 || aj2.ec() != 100 && aj2.ec() != 0) {
                ((GroupAxis)baseAxis).setAutoFitTickLabel(false);
                ((GroupAxis)baseAxis).setTickLabelRotationAngle(new Double(Math.PI * aj2.ed() / 180.0));
                ((GroupAxis)baseAxis).setTickLabelWidthRatio(new Float((float)aj2.ec() / 100.0f));
                ((GroupAxis)baseAxis).setTickLabelMaximumLines(1);
            } else {
                ((GroupAxis)baseAxis).setAutoFitTickLabel(true);
            }
        }
    }

    private static void a(aj aj2, DiscreteNumberAxis discreteNumberAxis) {
        Serializable serializable;
        int n2;
        Font font;
        ChartTitle chartTitle = new ChartTitle(new Font("SansSerif", 1, 14), 0);
        chartTitle.setTitle(aj2.er());
        chartTitle.setShowAutoTitle(aj2.eG());
        if (aj2.eG()) {
            chartTitle.aH(aj2.er());
        }
        if ((font = aj2.dU()) != null) {
            chartTitle.setFont(font);
        }
        if ((n2 = aj2.ap(10444)) != -1) {
            chartTitle.setColor(n2);
        }
        discreteNumberAxis.setTitle(chartTitle);
        Font font2 = new Font("SansSerif", 0, 12);
        if (aj2.dW() != null) {
            font2 = aj2.dW();
        }
        discreteNumberAxis.setTickLabelFont(font2);
        int n3 = aj2.ap(10446);
        if (n3 != -1) {
            discreteNumberAxis.setTickLabelColor(n3);
        }
        int n4 = aj2.eR();
        aj.a a2 = aj2.dO();
        ChartFormat chartFormat = ChartConverter.a(n4, a2, aj2);
        discreteNumberAxis.setTickLabelFormat(chartFormat);
        discreteNumberAxis.setInverseOrder(aj2.eb());
        AxisPosition axisPosition = AxisPosition.NONE;
        if (aj2.en()) {
            if (aj2.dZ()) {
                axisPosition = AxisPosition.ON_MAX;
            }
            if (aj2.ea()) {
                axisPosition = AxisPosition.ON_MIN;
            }
        } else {
            if (aj2.dZ()) {
                axisPosition = AxisPosition.ON_MIN;
            }
            if (aj2.ea()) {
                axisPosition = AxisPosition.ON_MAX;
            }
        }
        discreteNumberAxis.setAxisPosition(axisPosition);
        discreteNumberAxis.setGridlinesVisible(aj2.ee());
        if (aj2.dY()) {
            discreteNumberAxis.setStepWidth(new Double(aj2.dX()));
        }
        if (aj2.es()) {
            serializable = null;
            if (aj2.et() > 0) {
                serializable = Integer.valueOf(aj2.et());
            }
            discreteNumberAxis.setNumberOfDivisions((Integer)serializable);
        }
        if (aj2.eu()) {
            discreteNumberAxis.getRange().setAutoRange(true);
        } else {
            discreteNumberAxis.getRange().setAutoRange(false);
            discreteNumberAxis.getRange().setUpperBound(new Double(aj2.ev()));
            discreteNumberAxis.getRange().setLowerBound(new Double(aj2.ew()));
        }
        if (discreteNumberAxis instanceof ContinuousNumberAxis) {
            ((ContinuousNumberAxis)discreteNumberAxis).setAutomaticScale(aj2.eM());
            if (aj2.ef()) {
                serializable = new LineMarker();
                ((LineMarker)serializable).setValue(aj2.eg());
                ((ContinuousNumberAxis)discreteNumberAxis).addMarker((AbstractMarker)serializable);
            }
        }
    }

    private static void a(aj aj2, ContinuousDateAxis continuousDateAxis) {
        int n2;
        Font font;
        ChartTitle chartTitle = new ChartTitle(new Font("SansSerif", 1, 14), 0);
        chartTitle.setTitle(aj2.er());
        chartTitle.setShowAutoTitle(aj2.eG());
        if (aj2.eG()) {
            chartTitle.aH(aj2.er());
        }
        if ((font = aj2.dU()) != null) {
            chartTitle.setFont(font);
        }
        if ((n2 = aj2.ap(10444)) != -1) {
            chartTitle.setColor(n2);
        }
        continuousDateAxis.setTitle(chartTitle);
        Font font2 = new Font("SansSerif", 0, 12);
        if (aj2.dW() != null) {
            font2 = aj2.dW();
        }
        continuousDateAxis.setTickLabelFont(font2);
        int n3 = aj2.ap(10446);
        if (n3 != -1) {
            continuousDateAxis.setTickLabelColor(n3);
        }
        continuousDateAxis.setTickLabelFormat(null);
        continuousDateAxis.setInverseOrder(aj2.eb());
        AxisPosition axisPosition = AxisPosition.NONE;
        if (aj2.dZ()) {
            axisPosition = AxisPosition.ON_MIN;
        }
        if (aj2.ea()) {
            axisPosition = AxisPosition.ON_MAX;
        }
        continuousDateAxis.setAxisPosition(axisPosition);
    }

    private static void a(aj aj2, Chart2 chart2, AbstractPlot abstractPlot) {
        AbstractDataset abstractDataset = null;
        SummaryField summaryField = null;
        try {
            block31: {
                boolean bl2;
                int n2 = aj2.eT();
                int n3 = -1;
                boolean bl3 = bl2 = aj2.getDataType() == 43;
                if (aj2.getDataType() == 44) {
                    n3 = aj2.eU();
                } else if (bl2) {
                    n3 = 1;
                    n2 = aj2.eS() ? 2 : 1;
                }
                if (n3 <= 0) break block31;
                int n4 = 2;
                if (aj2.getDataType() == 44) {
                    n4 = aj2.eW();
                }
                if (n2 > 0) {
                    n4 = 2;
                }
                block2 : switch (n4) {
                    case 0: {
                        abstractDataset = new ForAllRecordsDataset(chart2);
                        for (int i2 = 0; i2 < n3; ++i2) {
                            summaryField = aj2.aw(i2);
                            ((ForAllRecordsDataset)abstractDataset).addDataField(summaryField.getSummaryOperation(), summaryField.getField(), summaryField.getField2nd(), summaryField.getSummaryNth());
                            ((ForAllRecordsDataset)abstractDataset).getDataField(i2).setShowPercentVal(summaryField.getShowPercentVal());
                        }
                        break;
                    }
                    case 1: {
                        abstractDataset = new ForEachRecordDataset(chart2);
                        for (int i3 = 0; i3 < n3; ++i3) {
                            summaryField = aj2.aw(i3);
                            ((ForEachRecordDataset)abstractDataset).addDataField(summaryField.getSummaryOperation(), summaryField.getField(), summaryField.getField2nd(), summaryField.getSummaryNth());
                            ((ForEachRecordDataset)abstractDataset).getDataField(i3).setShowPercentVal(summaryField.getShowPercentVal());
                        }
                        if (!(abstractPlot.getStyle() instanceof BarStyle) || n3 != 1) break;
                        abstractPlot.setColorBySeries(false);
                        break;
                    }
                    case 2: {
                        switch (n2) {
                            case 1: {
                                abstractDataset = new OneGroupDataset(chart2);
                                for (int i4 = 0; i4 < n3; ++i4) {
                                    summaryField = bl2 ? (SummaryField)aj2.av(i4) : aj2.aw(i4);
                                    ((OneGroupDataset)abstractDataset).addDataField(summaryField.getSummaryOperation(), summaryField.getField(), summaryField.getField2nd(), summaryField.getSummaryNth());
                                    ((OneGroupDataset)abstractDataset).getDataField(i4).setShowPercentVal(summaryField.getShowPercentVal());
                                }
                                if (bl2) {
                                    Group group = ((SummaryField)aj2.av(0)).getGroup();
                                    ((OneGroupDataset)abstractDataset).setCategoryGroup(group.getField());
                                    Group group2 = ((OneGroupDataset)abstractDataset).getCategoryGroup();
                                    ChartConverter.a(group, group2, chart2.getEngine(), (BaseDataset)((Object)abstractDataset));
                                } else {
                                    ((OneGroupDataset)abstractDataset).setCategoryGroup(aj2.av(0));
                                    Group group = ((OneGroupDataset)abstractDataset).getCategoryGroup();
                                    ChartConverter.a(aj2.getGroup(0), group, chart2.getEngine(), (BaseDataset)((Object)abstractDataset));
                                }
                                if (abstractPlot.getStyle() instanceof BarStyle && n3 == 1) {
                                    abstractPlot.setColorBySeries(false);
                                    break block2;
                                }
                                break block31;
                            }
                            case 2: {
                                abstractDataset = abstractPlot instanceof PiePlot && !(abstractPlot instanceof MultiplePiePlot) ? new OneGroupDataset(chart2) : new TwoGroupsDataset(chart2);
                                summaryField = bl2 ? (SummaryField)aj2.av(0) : aj2.aw(0);
                                if (abstractDataset instanceof OneGroupDataset) {
                                    ((OneGroupDataset)abstractDataset).addDataField(summaryField.getSummaryOperation(), summaryField.getField(), summaryField.getField2nd(), summaryField.getSummaryNth());
                                    ((OneGroupDataset)abstractDataset).getDataField(0).setShowPercentVal(summaryField.getShowPercentVal());
                                    if (bl2) {
                                        Group group = ((SummaryField)aj2.av(0)).getGroup();
                                        ((OneGroupDataset)abstractDataset).setCategoryGroup(group.getField());
                                        Group group3 = ((OneGroupDataset)abstractDataset).getCategoryGroup();
                                        ChartConverter.a(group, group3, chart2.getEngine(), (BaseDataset)((Object)abstractDataset));
                                        break block2;
                                    }
                                    ((OneGroupDataset)abstractDataset).setCategoryGroup(aj2.av(1));
                                    Group group = ((OneGroupDataset)abstractDataset).getCategoryGroup();
                                    ChartConverter.a(aj2.getGroup(1), group, chart2.getEngine(), (BaseDataset)((Object)abstractDataset));
                                    break block2;
                                }
                                ((TwoGroupsDataset)abstractDataset).setDataField(summaryField.getSummaryOperation(), summaryField.getField(), summaryField.getField2nd(), summaryField.getSummaryNth());
                                ((TwoGroupsDataset)abstractDataset).getDataField().setShowPercentVal(summaryField.getShowPercentVal());
                                if (bl2) {
                                    Group group = ((SummaryField)aj2.av(0)).getGroup();
                                    try {
                                        Group group4 = i.a(group, aj2.getEngine());
                                        ((TwoGroupsDataset)abstractDataset).setCategoryGroup(group4.getField());
                                        Group group5 = ((TwoGroupsDataset)abstractDataset).getCategoryGroup();
                                        ChartConverter.a(group4, group5, chart2.getEngine(), (BaseDataset)((Object)abstractDataset));
                                        ((TwoGroupsDataset)abstractDataset).setSeriesGroup(group.getField());
                                        group5 = ((TwoGroupsDataset)abstractDataset).getSeriesGroup();
                                        ChartConverter.a(group, group5, chart2.getEngine(), (BaseDataset)((Object)abstractDataset));
                                    }
                                    catch (Exception exception) {
                                        abstractDataset = new OneGroupDataset(chart2);
                                        ((OneGroupDataset)abstractDataset).addDataField(summaryField.getSummaryOperation(), summaryField.getField(), summaryField.getField2nd(), summaryField.getSummaryNth());
                                        ((OneGroupDataset)abstractDataset).getDataField(0).setShowPercentVal(summaryField.getShowPercentVal());
                                        ((OneGroupDataset)abstractDataset).setCategoryGroup(group.getField());
                                        Group group6 = ((OneGroupDataset)abstractDataset).getCategoryGroup();
                                        ChartConverter.a(group, group6, chart2.getEngine(), (BaseDataset)((Object)abstractDataset));
                                    }
                                } else {
                                    ((TwoGroupsDataset)abstractDataset).setCategoryGroup(aj2.av(0));
                                    Group group = ((TwoGroupsDataset)abstractDataset).getCategoryGroup();
                                    ChartConverter.a(aj2.getGroup(0), group, chart2.getEngine(), (BaseDataset)((Object)abstractDataset));
                                    ((TwoGroupsDataset)abstractDataset).setSeriesGroup(aj2.av(1));
                                    group = ((TwoGroupsDataset)abstractDataset).getSeriesGroup();
                                    ChartConverter.a(aj2.getGroup(1), group, chart2.getEngine(), (BaseDataset)((Object)abstractDataset));
                                }
                            }
                        }
                    }
                }
            }
            if (abstractPlot instanceof StandardPlot) {
                ((StandardPlot)abstractPlot).setDataset((StandardDataset)((Object)abstractDataset));
                return;
            }
            if (abstractPlot instanceof MultiplePiePlot) {
                ((MultiplePiePlot)abstractPlot).setDataset((StandardDataset)((Object)abstractDataset));
                return;
            }
            if (abstractPlot instanceof PiePlot) {
                ((PiePlot)abstractPlot).setDataset((PieDataset)((Object)abstractDataset));
                return;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            BaseUtils.error(EngineUtils.CHART_MSG.getMsg("DatasetCorrupt", new Object[0]));
            BaseUtils.error(illegalArgumentException);
        }
    }

    private static void a(aj aj2, Chart2 chart2, XYPlot xYPlot) {
        XYDataset xYDataset = null;
        SummaryField summaryField = null;
        try {
            int n2;
            int n3 = aj2.eT();
            int n4 = aj2.eU();
            if (n4 > 0) {
                int n5 = aj2.eW();
                switch (n5) {
                    case 0: {
                        xYDataset = new XYForAllRecordsDataset(chart2);
                        break;
                    }
                    case 1: {
                        xYDataset = new XYForEachRecordDataset(chart2);
                        break;
                    }
                    case 2: {
                        xYDataset = new XYOneGroupDataset(chart2);
                    }
                }
                for (n2 = 0; n2 < n4; ++n2) {
                    summaryField = aj2.aw(n2);
                    if (((XYForAllRecordsDataset)xYDataset).getXField() == null) {
                        ((XYForAllRecordsDataset)xYDataset).setXField(summaryField.getSummaryOperation(), summaryField.getField(), summaryField.getField2nd(), summaryField.getSummaryNth());
                        ((XYForAllRecordsDataset)xYDataset).getXField().setShowPercentVal(summaryField.getShowPercentVal());
                        continue;
                    }
                    if (((XYForAllRecordsDataset)xYDataset).getYField() == null) {
                        ((XYForAllRecordsDataset)xYDataset).setYField(summaryField.getSummaryOperation(), summaryField.getField(), summaryField.getField2nd(), summaryField.getSummaryNth());
                        ((XYForAllRecordsDataset)xYDataset).getYField().setShowPercentVal(summaryField.getShowPercentVal());
                        continue;
                    }
                    if (((XYForAllRecordsDataset)xYDataset).getSizeField() != null) continue;
                    ((XYForAllRecordsDataset)xYDataset).setSizeField(summaryField.getSummaryOperation(), summaryField.getField(), summaryField.getField2nd(), summaryField.getSummaryNth());
                    ((XYForAllRecordsDataset)xYDataset).getSizeField().setShowPercentVal(summaryField.getShowPercentVal());
                }
                if (xYDataset instanceof XYOneGroupDataset) {
                    switch (n3) {
                        case 1: {
                            ((XYOneGroupDataset)xYDataset).setCategoryGroup(aj2.av(0));
                            Group group = ((XYOneGroupDataset)xYDataset).getCategoryGroup();
                            ChartConverter.a(aj2.getGroup(0), group, chart2.getEngine(), xYDataset);
                            break;
                        }
                        case 2: {
                            ((XYOneGroupDataset)xYDataset).setCategoryGroup(aj2.av(1));
                            Group group = ((XYOneGroupDataset)xYDataset).getCategoryGroup();
                            ChartConverter.a(aj2.getGroup(1), group, chart2.getEngine(), xYDataset);
                        }
                    }
                }
            }
            if (xYDataset.getYField() == null || xYPlot.getStyle().equals(XYStyle.BUBBLE) && xYDataset.getSizeField() == null) {
                Field field = null;
                n2 = 0;
                if (n3 > 0 && aj2.av(0) != null) {
                    field = aj2.av(0);
                } else if (n4 > 0 && aj2.aw(0) != null) {
                    field = aj2.aw(0).getField();
                }
                if (field.getValueType() != 6 && field.getValueType() != 7) {
                    n2 = 6;
                }
                if (field != null) {
                    xYDataset.setYField(n2, field, null, 0);
                    if (xYPlot.getStyle().equals(XYStyle.BUBBLE) && xYDataset.getSizeField() == null) {
                        xYDataset.setSizeField(n2, field, null, 0);
                    }
                }
            }
            xYPlot.setDataset(xYDataset);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            BaseUtils.error(EngineUtils.CHART_MSG.getMsg("DatasetCorrupt", new Object[0]));
            BaseUtils.error(illegalArgumentException);
        }
    }

    private static void a(aj aj2, Chart2 chart2, StockPlot stockPlot) {
        StockDataset stockDataset = null;
        SummaryField summaryField = null;
        try {
            int n2;
            int n3 = aj2.eT();
            int n4 = aj2.eU();
            if (n4 > 0) {
                int n5 = aj2.eW();
                switch (n5) {
                    case 0: {
                        stockDataset = new StockForAllRecordsDataset(chart2);
                        break;
                    }
                    case 1: {
                        stockDataset = new StockForEachRecordDataset(chart2);
                        break;
                    }
                    case 2: {
                        stockDataset = new StockOneGroupDataset(chart2);
                    }
                }
                for (n2 = 0; n2 < n4; ++n2) {
                    summaryField = aj2.aw(n2);
                    if (((StockForAllRecordsDataset)stockDataset).getLowField() == null) {
                        ((StockForAllRecordsDataset)stockDataset).setLowField(summaryField.getSummaryOperation(), summaryField.getField(), summaryField.getField2nd(), summaryField.getSummaryNth());
                        ((StockForAllRecordsDataset)stockDataset).getLowField().setShowPercentVal(summaryField.getShowPercentVal());
                        continue;
                    }
                    if (((StockForAllRecordsDataset)stockDataset).getHighField() == null) {
                        ((StockForAllRecordsDataset)stockDataset).setHighField(summaryField.getSummaryOperation(), summaryField.getField(), summaryField.getField2nd(), summaryField.getSummaryNth());
                        ((StockForAllRecordsDataset)stockDataset).getHighField().setShowPercentVal(summaryField.getShowPercentVal());
                        continue;
                    }
                    if (((StockForAllRecordsDataset)stockDataset).getOpenField() == null) {
                        ((StockForAllRecordsDataset)stockDataset).setOpenField(summaryField.getSummaryOperation(), summaryField.getField(), summaryField.getField2nd(), summaryField.getSummaryNth());
                        ((StockForAllRecordsDataset)stockDataset).getOpenField().setShowPercentVal(summaryField.getShowPercentVal());
                        continue;
                    }
                    if (((StockForAllRecordsDataset)stockDataset).getCloseField() != null) continue;
                    ((StockForAllRecordsDataset)stockDataset).setCloseField(summaryField.getSummaryOperation(), summaryField.getField(), summaryField.getField2nd(), summaryField.getSummaryNth());
                    ((StockForAllRecordsDataset)stockDataset).getCloseField().setShowPercentVal(summaryField.getShowPercentVal());
                }
                if (stockDataset instanceof StockOneGroupDataset) {
                    switch (n3) {
                        case 1: {
                            ((StockOneGroupDataset)stockDataset).setCategoryGroup(aj2.av(0));
                            Group group = ((StockOneGroupDataset)stockDataset).getCategoryGroup();
                            ChartConverter.a(aj2.getGroup(0), group, chart2.getEngine(), stockDataset);
                            break;
                        }
                        case 2: {
                            ((StockOneGroupDataset)stockDataset).setCategoryGroup(aj2.av(1));
                            Group group = ((StockOneGroupDataset)stockDataset).getCategoryGroup();
                            ChartConverter.a(aj2.getGroup(1), group, chart2.getEngine(), stockDataset);
                        }
                    }
                }
            }
            if (stockDataset.getHighField() == null || stockPlot.getStyle().equals(StockStyle.STOCK_HIGH_LOW_OPEN_CLOSE) && (stockDataset.getOpenField() == null || stockDataset.getCloseField() == null)) {
                Field field = null;
                n2 = 0;
                if (n3 > 0 && aj2.av(0) != null) {
                    field = aj2.av(0);
                } else if (n4 > 0 && aj2.aw(0) != null) {
                    field = aj2.aw(0).getField();
                }
                if (field.getValueType() != 6 && field.getValueType() != 7) {
                    n2 = 6;
                }
                if (field != null) {
                    stockDataset.setHighField(n2, field, null, 0);
                    if (stockPlot.getStyle().equals(StockStyle.STOCK_HIGH_LOW_OPEN_CLOSE)) {
                        if (stockDataset.getOpenField() == null) {
                            stockDataset.setOpenField(n2, field, null, 0);
                        }
                        if (stockDataset.getCloseField() == null) {
                            stockDataset.setCloseField(n2, field, null, 0);
                        }
                    }
                }
            }
            stockPlot.setDataset(stockDataset);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            BaseUtils.error(EngineUtils.CHART_MSG.getMsg("DatasetCorrupt", new Object[0]));
            BaseUtils.error(illegalArgumentException);
        }
    }

    private static void a(aj aj2, Chart2 chart2, GanttPlot ganttPlot) {
        GanttForEachRecordDataset ganttForEachRecordDataset = null;
        SummaryField summaryField = null;
        try {
            int n2 = aj2.eT();
            int n3 = aj2.eU();
            if (n3 > 0) {
                int n4 = aj2.eW();
                block1 : switch (n4) {
                    case 0: 
                    case 1: {
                        ganttForEachRecordDataset = new GanttForEachRecordDataset(chart2);
                        break;
                    }
                    case 2: {
                        switch (n2) {
                            case 1: {
                                ganttForEachRecordDataset = new GanttOneGroupDataset(chart2);
                                break block1;
                            }
                            case 2: {
                                ganttForEachRecordDataset = new GanttTwoGroupsDataset(chart2);
                            }
                        }
                    }
                }
                for (int i2 = 0; i2 < n3; ++i2) {
                    summaryField = aj2.aw(i2);
                    if (ganttForEachRecordDataset.getStartField() == null) {
                        ganttForEachRecordDataset.setStartField(20, summaryField.getField(), summaryField.getField2nd(), summaryField.getSummaryNth());
                        ganttForEachRecordDataset.getStartField().setShowPercentVal(summaryField.getShowPercentVal());
                        continue;
                    }
                    if (ganttForEachRecordDataset.getEndField() == null) {
                        ganttForEachRecordDataset.setEndField(20, summaryField.getField(), summaryField.getField2nd(), summaryField.getSummaryNth());
                        ganttForEachRecordDataset.getEndField().setShowPercentVal(summaryField.getShowPercentVal());
                        continue;
                    }
                    if (ganttForEachRecordDataset.getProgressField() != null) continue;
                    ganttForEachRecordDataset.setProgressField(summaryField.getSummaryOperation(), summaryField.getField(), summaryField.getField2nd(), summaryField.getSummaryNth());
                    ganttForEachRecordDataset.getProgressField().setShowPercentVal(summaryField.getShowPercentVal());
                }
                if (ganttForEachRecordDataset instanceof GanttOneGroupDataset && n2 > 0) {
                    ((GanttOneGroupDataset)ganttForEachRecordDataset).setCategoryGroup(aj2.av(0));
                    Group group = ((GanttOneGroupDataset)ganttForEachRecordDataset).getCategoryGroup();
                    ChartConverter.a(aj2.getGroup(0), group, chart2.getEngine(), ganttForEachRecordDataset);
                    if (n2 == 2) {
                        ((GanttTwoGroupsDataset)ganttForEachRecordDataset).setSeriesGroup(aj2.av(1));
                        group = ((GanttTwoGroupsDataset)ganttForEachRecordDataset).getSeriesGroup();
                        ChartConverter.a(aj2.getGroup(1), group, chart2.getEngine(), ganttForEachRecordDataset);
                    }
                }
            }
            ganttPlot.setDataset(ganttForEachRecordDataset);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            BaseUtils.error(EngineUtils.CHART_MSG.getMsg("DatasetCorrupt", new Object[0]));
            BaseUtils.error(illegalArgumentException);
        }
    }

    private static void a(aj aj2, Chart2 chart2, BarPlot barPlot) {
        ChartConverter.a(aj2, (AbstractPlot)barPlot);
        ChartConverter.a(aj2, barPlot);
        ChartConverter.a(aj2, chart2, (AbstractPlot)barPlot);
        barPlot.setBarMarginPercent(0.1);
        chart2.setPlot(barPlot);
    }

    private static void a(aj aj2, Chart2 chart2, AreaPlot areaPlot) {
        ChartConverter.a(aj2, (AbstractPlot)areaPlot);
        ChartConverter.a(aj2, areaPlot);
        ChartConverter.a(aj2, chart2, (AbstractPlot)areaPlot);
        areaPlot.setDrawOutline(true);
        chart2.setPlot(areaPlot);
    }

    private static void a(aj aj2, Chart2 chart2, LinePlot linePlot) {
        ChartConverter.a(aj2, (AbstractPlot)linePlot);
        ChartConverter.a(aj2, linePlot);
        ChartConverter.a(aj2, chart2, (AbstractPlot)linePlot);
        DrawOutOfScale drawOutOfScale = DrawOutOfScale.DO_NOT_DRAW;
        if (aj2.eN()) {
            drawOutOfScale = DrawOutOfScale.DRAW_ON_MAX;
        }
        linePlot.setDrawOutOfScale(drawOutOfScale);
        linePlot.setDrawConnectedLines(aj2.eO());
        chart2.setPlot(linePlot);
    }

    private static void a(aj aj2, Chart2 chart2, PiePlot piePlot) {
        ChartConverter.a(aj2, piePlot);
        ChartConverter.a(aj2, chart2, (AbstractPlot)piePlot);
        PieLegendLayout pieLegendLayout = PieLegendLayout.SHOW_LABEL;
        switch (aj2.eB()) {
            case 1: {
                pieLegendLayout = PieLegendLayout.SHOW_LABEL_AND_AMOUNT;
                break;
            }
            case 0: {
                pieLegendLayout = PieLegendLayout.SHOW_LABEL_AND_PERCENTAGE;
                break;
            }
            case 2: {
                pieLegendLayout = PieLegendLayout.SHOW_LABEL_AND_AMOUNT_AND_PERCENTAGE;
            }
        }
        piePlot.setLegendLayout(pieLegendLayout);
        if (aj2.eP() == 3) {
            piePlot.setShowLabel(true);
            piePlot.setShowValue(true);
        }
        if (!piePlot.isShowLabel() && !piePlot.isShowValue() && aj2.eB() != 3) {
            FixedNumberFormat fixedNumberFormat = null;
            switch (aj2.eB()) {
                case 0: {
                    fixedNumberFormat = new FixedNumberFormat(1);
                    break;
                }
                default: {
                    fixedNumberFormat = new FixedNumberFormat(0);
                }
            }
            fixedNumberFormat.setNumberOfDecimalPlaces(2);
            piePlot.setItemLabelFormat(fixedNumberFormat);
        }
        piePlot.setItemLabelFont(aj2.dV());
        if (aj2.ap(10445) != -1) {
            piePlot.setItemLabelColor(aj2.ap(10445));
        }
        piePlot.setItemLabelGap(0.02);
        chart2.setPlot(piePlot);
    }

    private static void a(aj aj2, Chart2 chart2, Chart3DPlot chart3DPlot) {
        ChartConverter.a(aj2, (AbstractPlot)chart3DPlot);
        ChartConverter.a(aj2, chart3DPlot);
        ChartConverter.a(aj2, chart2, (AbstractPlot)chart3DPlot);
        BaseAxis baseAxis = chart3DPlot.getSeriesAxis();
        AxisPosition axisPosition = AxisPosition.NONE;
        if (aj2.ei()) {
            axisPosition = AxisPosition.ON_MIN;
        }
        if (aj2.eh()) {
            axisPosition = AxisPosition.ON_MAX;
        }
        baseAxis.setAxisPosition(axisPosition);
        ChartTitle chartTitle = baseAxis.getTitle();
        chartTitle.setTitle("");
        chartTitle.setShowAutoTitle(false);
        baseAxis.setTitle(chartTitle);
        Font font = new Font("SansSerif", 0, 12);
        baseAxis.setTickLabelFont(font);
        baseAxis.setTickLabelColor(0);
        chart3DPlot.setSeriesAxis(baseAxis);
        DiscreteNumberAxis discreteNumberAxis = chart3DPlot.getDataAxis();
        chartTitle = discreteNumberAxis.getTitle();
        chartTitle.setColor(0);
        discreteNumberAxis.setTitle(chartTitle);
        font = new Font("SansSerif", 0, 12);
        discreteNumberAxis.setTickLabelFont(font);
        discreteNumberAxis.setTickLabelColor(0);
        chart3DPlot.setDataAxis(discreteNumberAxis);
        BaseAxis baseAxis2 = chart3DPlot.getCategoryAxis();
        chartTitle = baseAxis2.getTitle();
        chartTitle.setColor(0);
        int n2 = aj2.getHeight() / 15 / 25;
        if (n2 < 10) {
            n2 = 10;
        }
        Font font2 = chartTitle.getFont();
        chartTitle.setFont(new Font(font2.getName(), font2.getStyle(), n2));
        baseAxis2.setTitle(chartTitle);
        font = baseAxis2.getTickLabelFont();
        font = new Font(font.getName(), 0, 12);
        baseAxis2.setTickLabelFont(font);
        baseAxis2.setTickLabelColor(0xFF0000);
        chart3DPlot.setCategoryAxis(baseAxis2);
        chart2.setPlot(chart3DPlot);
    }

    private static void a(aj aj2, Chart2 chart2, PolarPlot polarPlot) {
        ChartConverter.a(aj2, (AbstractPlot)polarPlot);
        ChartConverter.a(aj2, polarPlot);
        ChartConverter.a(aj2, chart2, (AbstractPlot)polarPlot);
        int n2 = ColorUtils.toCcColor((Color)Color.gray);
        BaseAxis baseAxis = polarPlot.getCategoryAxis();
        baseAxis.setAxisLineColor(n2);
        baseAxis.setGridlineColor(n2);
        DiscreteNumberAxis discreteNumberAxis = polarPlot.getDataAxis();
        discreteNumberAxis.setAxisLineColor(n2);
        discreteNumberAxis.setGridlineColor(n2);
        chart2.setPlot(polarPlot);
    }

    private static void b(aj aj2, Chart2 chart2, XYPlot xYPlot) {
        int n2;
        Font font;
        ChartConverter.a(aj2, xYPlot);
        ChartConverter.a(aj2, chart2, xYPlot);
        ContinuousNumberAxis continuousNumberAxis = xYPlot.getCategoryAxis();
        ChartTitle chartTitle = new ChartTitle(new Font("SansSerif", 1, 14), 0);
        chartTitle.setTitle(aj2.eq());
        chartTitle.setShowAutoTitle(aj2.eF());
        if (aj2.eF()) {
            chartTitle.aH(aj2.eq());
        }
        if ((font = aj2.dT()) != null) {
            chartTitle.setFont(font);
        }
        if ((n2 = aj2.ap(10443)) != -1) {
            chartTitle.setColor(n2);
        }
        continuousNumberAxis.setTitle(chartTitle);
        Font font2 = new Font("SansSerif", 0, 12);
        if (aj2.dV() != null) {
            font2 = aj2.dV();
        }
        continuousNumberAxis.setTickLabelFont(font2);
        int n3 = aj2.ap(10445);
        if (n3 != -1) {
            continuousNumberAxis.setTickLabelColor(n3);
        }
        continuousNumberAxis.setGridlinesVisible(aj2.ek());
        continuousNumberAxis.setAutomaticScale(true);
        AxisPosition axisPosition = AxisPosition.NONE;
        if (aj2.ei()) {
            axisPosition = AxisPosition.ON_MIN;
        }
        if (aj2.eh()) {
            axisPosition = AxisPosition.ON_MAX;
        }
        continuousNumberAxis.setAxisPosition(axisPosition);
        xYPlot.setCategoryAxis(continuousNumberAxis);
        ContinuousNumberAxis continuousNumberAxis2 = xYPlot.getDataAxis();
        ChartConverter.a(aj2, continuousNumberAxis2);
        continuousNumberAxis2.setAutomaticScale(true);
        xYPlot.setDataAxis(continuousNumberAxis2);
        double d2 = i.x(aj2.eA());
        xYPlot.setSizeCoefficient(d2);
        chart2.setPlot(xYPlot);
    }

    private static void b(aj aj2, Chart2 chart2, StockPlot stockPlot) {
        ChartConverter.a(aj2, stockPlot);
        ChartConverter.a(aj2, chart2, stockPlot);
        GroupAxis groupAxis = stockPlot.getCategoryAxis();
        ChartConverter.a(aj2, groupAxis);
        stockPlot.setCategoryAxis(groupAxis);
        ContinuousNumberAxis continuousNumberAxis = stockPlot.getDataAxis();
        ChartConverter.a(aj2, continuousNumberAxis);
        stockPlot.setDataAxis(continuousNumberAxis);
        chart2.setPlot(stockPlot);
    }

    private static void b(aj aj2, Chart2 chart2, GanttPlot ganttPlot) {
        ChartConverter.a(aj2, ganttPlot);
        ChartConverter.a(aj2, chart2, ganttPlot);
        GroupAxis groupAxis = ganttPlot.getCategoryAxis();
        ChartConverter.a(aj2, groupAxis);
        ganttPlot.setCategoryAxis(groupAxis);
        ContinuousDateAxis continuousDateAxis = ganttPlot.getDataAxis();
        ChartConverter.a(aj2, continuousDateAxis);
        ganttPlot.setDataAxis(continuousDateAxis);
        ganttPlot.setForegroundAlpha(1.0f);
        chart2.setPlot(ganttPlot);
    }

    private static void a(Group group, Group group2, Engine engine, BaseDataset baseDataset) {
        group2.setSort(group.getSort());
        if (group.getCustomizeGroupNameField() == 1) {
            group2.setCustomizeGroupNameField(1);
            group2.setGroupNameDbField(group.getGroupNameDbField());
        } else if (group.getCustomizeGroupNameField() == 2) {
            group2.setCustomizeGroupNameField(2);
            FormulaField formulaField = group.getGroupNameFormula();
            if (formulaField == null) {
                group2.setGroupNameFormula(null);
            } else {
                FormulaField formulaField2 = by.j(engine).getFields().addFormulaField("group name", formulaField.getFormula(), 3);
                group2.setGroupNameFormula(formulaField2);
            }
        } else {
            group2.setCustomizeGroupNameField(0);
        }
        group2.setSectionWillBePrinted(group.getSectionWillBePrinted());
        if (group.getSpecifiedOrder() != null) {
            group2.setSpecifiedOrder(group.getSpecifiedOrder());
        }
        if (group.getBySummaryOrder() != null) {
            group2.setBySummaryOrder(group.getBySummaryOrder().copy());
        }
        if ((group.getSort() == 3 || group.getSort() == 4) && group.getSpecifiedOrder() == null && group.getBySummaryOrder() == null) {
            group2.setSort(0);
        }
        ChartConverter.a(group2, baseDataset);
    }

    private static void a(Group group, BaseDataset baseDataset) {
        if (group.getSort() == 4 && group.getBySummaryOrder() != null) {
            BySummaryOrder bySummaryOrder = group.getBySummaryOrder();
            SummaryField summaryField = bySummaryOrder.getSummaryField(0);
            SummaryField summaryField2 = null;
            if (summaryField != null) {
                List list = baseDataset.getDataFields();
                for (Object e2 : list) {
                    if (!ChartConverter.compareSummaryFields(summaryField, (SummaryField)e2)) continue;
                    summaryField2 = (SummaryField)e2;
                    bySummaryOrder.removeSummaryField(0);
                    bySummaryOrder.addSummaryField(summaryField2);
                    break;
                }
            }
            if (summaryField2 == null) {
                group.setBySummaryOrder(null);
                group.setSort(0);
                return;
            }
        }
    }

    public static boolean compareSummaryFields(SummaryField first, SummaryField second) {
        if (first.getSummaryOperation() != second.getSummaryOperation()) {
            return false;
        }
        if (!ChartConverter.a(first.getField(), second.getField())) {
            return false;
        }
        if (!ChartConverter.a(first.getField2nd(), second.getField2nd())) {
            return false;
        }
        if (first.getField2nd() != null && first.getSummaryNth() != second.getSummaryNth()) {
            return false;
        }
        return first.getShowPercentVal() == second.getShowPercentVal();
    }

    private static boolean a(Field field, Field field2) {
        if (field != null) {
            if (field2 == null) {
                return false;
            }
            String string = field.getName();
            if (!string.equals(field2.getName())) {
                return false;
            }
        } else if (field2 != null) {
            return false;
        }
        return true;
    }

    private static String a(ValueProperties valueProperties, Locale locale) {
        StringBuilder stringBuilder = new StringBuilder();
        if (valueProperties.getNumberFormatType() == 2) {
            if (valueProperties.getCurrencySymbolType() == 0) {
                DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getIntegerInstance(locale);
                stringBuilder.append(decimalFormat.toPattern());
                if (valueProperties.getNDecimalPlaces() > 0) {
                    stringBuilder.append('.');
                    for (int i2 = 0; i2 < valueProperties.getNDecimalPlaces(); ++i2) {
                        stringBuilder.append('0');
                    }
                }
            } else {
                stringBuilder.append(((DecimalFormat)NumberFormat.getCurrencyInstance(locale)).toPattern());
            }
        } else {
            if (valueProperties.getUseThousandsSeparator()) {
                if (valueProperties.getUseLeadingZero()) {
                    stringBuilder.append("#,##0");
                } else {
                    stringBuilder.append("#,###");
                }
            } else if (valueProperties.getUseLeadingZero()) {
                stringBuilder.append("###0");
            } else {
                stringBuilder.append("####");
            }
            if (valueProperties.getNDecimalPlaces() > 0) {
                stringBuilder.append('.');
                for (int i3 = 0; i3 < valueProperties.getNDecimalPlaces(); ++i3) {
                    stringBuilder.append('0');
                }
            }
            if (valueProperties.getCurrencySymbolType() == 0) {
                StringBuilder stringBuilder2 = null;
                switch (valueProperties.getNegativeType()) {
                    case 0: {
                        stringBuilder2 = new StringBuilder();
                        stringBuilder2.append((CharSequence)stringBuilder);
                        stringBuilder2.append(';');
                        stringBuilder2.append((CharSequence)stringBuilder);
                        stringBuilder = stringBuilder2;
                        break;
                    }
                    case 1: {
                        stringBuilder2 = new StringBuilder();
                        stringBuilder2.append((CharSequence)stringBuilder);
                        stringBuilder2.append(';');
                        stringBuilder2.append('-');
                        stringBuilder2.append((CharSequence)stringBuilder);
                        stringBuilder = stringBuilder2;
                        break;
                    }
                    case 2: {
                        stringBuilder2 = new StringBuilder();
                        stringBuilder2.append((CharSequence)stringBuilder);
                        stringBuilder2.append(';');
                        stringBuilder2.append((CharSequence)stringBuilder);
                        stringBuilder2.append('-');
                        stringBuilder = stringBuilder2;
                        break;
                    }
                    case 3: {
                        stringBuilder2 = new StringBuilder();
                        stringBuilder2.append((CharSequence)stringBuilder);
                        stringBuilder2.append(';');
                        stringBuilder2.append('(');
                        stringBuilder2.append((CharSequence)stringBuilder);
                        stringBuilder2.append(')');
                        stringBuilder = stringBuilder2;
                    }
                }
            } else {
                StringBuilder stringBuilder3 = null;
                switch (valueProperties.getNegativeType()) {
                    case 0: {
                        if (valueProperties.getCurrencyPosition() == 0 || valueProperties.getCurrencyPosition() == 1) {
                            StringBuilder stringBuilder4 = new StringBuilder();
                            stringBuilder4.append(valueProperties.getCurrencySymbol()).append(valueProperties.getCurrencySeparator());
                            stringBuilder4.append((CharSequence)stringBuilder);
                            stringBuilder = stringBuilder4;
                        } else {
                            StringBuilder stringBuilder5 = new StringBuilder();
                            stringBuilder5.append((CharSequence)stringBuilder);
                            stringBuilder5.append(valueProperties.getCurrencySeparator()).append(valueProperties.getCurrencySymbol());
                            stringBuilder = stringBuilder5;
                        }
                        stringBuilder3 = new StringBuilder();
                        stringBuilder3.append((CharSequence)stringBuilder);
                        stringBuilder3.append(';');
                        stringBuilder3.append((CharSequence)stringBuilder);
                        stringBuilder = stringBuilder3;
                        break;
                    }
                    case 1: {
                        StringBuilder stringBuilder6;
                        if (valueProperties.getCurrencyPosition() == 0) {
                            stringBuilder6 = new StringBuilder();
                            stringBuilder6.append(valueProperties.getCurrencySymbol()).append(valueProperties.getCurrencySeparator());
                            stringBuilder6.append((CharSequence)stringBuilder);
                            StringBuilder stringBuilder7 = new StringBuilder();
                            stringBuilder7.append(valueProperties.getCurrencySymbol()).append(valueProperties.getCurrencySeparator());
                            stringBuilder7.append('-');
                            stringBuilder7.append((CharSequence)stringBuilder);
                            stringBuilder = stringBuilder6;
                            stringBuilder.append(';');
                            stringBuilder.append((CharSequence)stringBuilder7);
                        }
                        if (valueProperties.getCurrencyPosition() == 1) {
                            stringBuilder6 = new StringBuilder();
                            stringBuilder6.append(valueProperties.getCurrencySymbol()).append(valueProperties.getCurrencySeparator());
                            stringBuilder6.append((CharSequence)stringBuilder);
                            stringBuilder = stringBuilder6;
                            stringBuilder3 = new StringBuilder();
                            stringBuilder3.append((CharSequence)stringBuilder);
                            stringBuilder3.append(';');
                            stringBuilder3.append('-');
                            stringBuilder3.append((CharSequence)stringBuilder);
                            stringBuilder = stringBuilder3;
                        }
                        if (valueProperties.getCurrencyPosition() == 2 || valueProperties.getCurrencyPosition() == 3) {
                            stringBuilder.append(valueProperties.getCurrencySeparator()).append(valueProperties.getCurrencySymbol());
                            stringBuilder3 = new StringBuilder();
                            stringBuilder3.append((CharSequence)stringBuilder);
                            stringBuilder3.append(';');
                            stringBuilder3.append('-');
                            stringBuilder3.append((CharSequence)stringBuilder);
                            stringBuilder = stringBuilder3;
                        }
                        break;
                    }
                    case 2: {
                        StringBuilder stringBuilder8;
                        if (valueProperties.getCurrencyPosition() == 0 || valueProperties.getCurrencyPosition() == 1) {
                            stringBuilder8 = new StringBuilder();
                            stringBuilder8.append(valueProperties.getCurrencySymbol()).append(valueProperties.getCurrencySeparator());
                            stringBuilder8.append((CharSequence)stringBuilder);
                            stringBuilder = stringBuilder8;
                            stringBuilder3 = new StringBuilder();
                            stringBuilder3.append((CharSequence)stringBuilder);
                            stringBuilder3.append(';');
                            stringBuilder3.append((CharSequence)stringBuilder);
                            stringBuilder3.append('-');
                            stringBuilder = stringBuilder3;
                        }
                        if (valueProperties.getCurrencyPosition() == 3) {
                            stringBuilder.append(valueProperties.getCurrencySeparator()).append(valueProperties.getCurrencySymbol());
                            stringBuilder3 = new StringBuilder();
                            stringBuilder3.append((CharSequence)stringBuilder);
                            stringBuilder3.append(';');
                            stringBuilder3.append((CharSequence)stringBuilder);
                            stringBuilder3.append('-');
                            stringBuilder = stringBuilder3;
                        }
                        if (valueProperties.getCurrencyPosition() != 2) break;
                        stringBuilder8 = new StringBuilder();
                        stringBuilder8.append((CharSequence)stringBuilder);
                        stringBuilder8.append(valueProperties.getCurrencySeparator()).append(valueProperties.getCurrencySymbol());
                        StringBuilder stringBuilder9 = new StringBuilder();
                        stringBuilder9.append((CharSequence)stringBuilder);
                        stringBuilder9.append('-');
                        stringBuilder9.append(valueProperties.getCurrencySeparator()).append(valueProperties.getCurrencySymbol());
                        stringBuilder = stringBuilder8;
                        stringBuilder.append(';');
                        stringBuilder.append((CharSequence)stringBuilder9);
                        break;
                    }
                    case 3: {
                        StringBuilder stringBuilder10;
                        StringBuilder stringBuilder11;
                        if (valueProperties.getCurrencyPosition() == 1) {
                            stringBuilder11 = new StringBuilder();
                            stringBuilder11.append(valueProperties.getCurrencySymbol()).append(valueProperties.getCurrencySeparator());
                            stringBuilder11.append((CharSequence)stringBuilder);
                            stringBuilder = stringBuilder11;
                            stringBuilder3 = new StringBuilder();
                            stringBuilder3.append((CharSequence)stringBuilder);
                            stringBuilder3.append(';');
                            stringBuilder3.append('(');
                            stringBuilder3.append((CharSequence)stringBuilder);
                            stringBuilder3.append(')');
                            stringBuilder = stringBuilder3;
                        }
                        if (valueProperties.getCurrencyPosition() == 3) {
                            stringBuilder.append(valueProperties.getCurrencySeparator()).append(valueProperties.getCurrencySymbol());
                            stringBuilder3 = new StringBuilder();
                            stringBuilder3.append((CharSequence)stringBuilder);
                            stringBuilder3.append(';');
                            stringBuilder3.append('(');
                            stringBuilder3.append((CharSequence)stringBuilder);
                            stringBuilder3.append(')');
                            stringBuilder = stringBuilder3;
                        }
                        if (valueProperties.getCurrencyPosition() == 0) {
                            stringBuilder11 = new StringBuilder();
                            stringBuilder11.append(valueProperties.getCurrencySymbol()).append(valueProperties.getCurrencySeparator());
                            stringBuilder11.append((CharSequence)stringBuilder);
                            stringBuilder10 = new StringBuilder();
                            stringBuilder11.append(valueProperties.getCurrencySymbol()).append(valueProperties.getCurrencySeparator());
                            stringBuilder11.append('(').append((CharSequence)stringBuilder).append(')');
                            stringBuilder = stringBuilder11;
                            stringBuilder.append(';');
                            stringBuilder.append((CharSequence)stringBuilder10);
                        }
                        if (valueProperties.getCurrencyPosition() != 2) break;
                        stringBuilder11 = new StringBuilder();
                        stringBuilder11.append((CharSequence)stringBuilder);
                        stringBuilder11.append(valueProperties.getCurrencySeparator()).append(valueProperties.getCurrencySymbol());
                        stringBuilder10 = new StringBuilder();
                        stringBuilder11.append('(').append((CharSequence)stringBuilder).append(')');
                        stringBuilder11.append(valueProperties.getCurrencySeparator()).append(valueProperties.getCurrencySymbol());
                        stringBuilder = stringBuilder11;
                        stringBuilder.append(';');
                        stringBuilder.append((CharSequence)stringBuilder10);
                    }
                }
            }
        }
        return stringBuilder.toString();
    }
}

