/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.certificate;

import com.inet.annotations.PublicApi;
import com.inet.lib.util.Encryption;
import com.inet.lib.util.IOFunctions;
import com.inet.report.BaseUtils;
import com.inet.report.br;
import com.inet.report.certificate.b;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.interfaces.DSAKey;
import java.security.interfaces.RSAKey;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.SuppressFBWarnings;

@PublicApi
public class CertificateInfo {
    private String Wi;
    @Nonnull
    private String Wj;
    private String Wk;
    private String Wl;
    private String Wm;
    private String Wn;
    private b Wo;
    private static HashMap<Integer, CertificateInfo> Wp = new HashMap();

    private CertificateInfo(String keyStoreType, @Nonnull String keyStorePathOrUrl, String keyStorePassword, String keyAlias, String keyPassword, String digestAlgorithmName) {
        this.Wi = keyStoreType;
        this.Wj = keyStorePathOrUrl;
        this.Wk = keyStorePassword;
        this.Wl = keyAlias;
        this.Wm = keyPassword;
        this.Wn = digestAlgorithmName;
    }

    public static CertificateInfo getInstance(@Nonnull String keyStoreType, @Nonnull String keyStorePathOrUrl, @Nonnull String keyStorePassword, String keyAlias, String keyPassword, String digestAlgorithmName) throws IllegalArgumentException {
        Integer n2;
        CertificateInfo certificateInfo;
        String string = null;
        if (keyStoreType == null || keyStoreType.length() == 0) {
            string = "keystore type is not defined";
        } else if (keyStorePathOrUrl == null || keyStorePathOrUrl.length() == 0) {
            string = "keystore file is not defined";
        } else if (keyStorePassword == null || keyStorePassword.length() == 0) {
            string = "keystore password is not defined";
        } else if (keyPassword == null || keyPassword.length() == 0) {
            keyPassword = keyStorePassword;
            if (BaseUtils.isDebug()) {
                BaseUtils.debug("key password is not defined: keystore password will be used");
            }
        }
        if (string != null) {
            throw new IllegalArgumentException("sign pdf failed: " + string);
        }
        if (digestAlgorithmName == null || digestAlgorithmName.length() == 0) {
            digestAlgorithmName = "SHA1";
        }
        if ((certificateInfo = Wp.get(n2 = CertificateInfo.b(keyStoreType, keyStorePathOrUrl, keyStorePassword, keyAlias, keyPassword, digestAlgorithmName))) == null) {
            Integer n3 = null;
            if (keyPassword == null || keyPassword.length() == 0) {
                keyPassword = keyStorePassword;
                if (BaseUtils.isDebug()) {
                    BaseUtils.debug("key password is not defined: keystore password will be used");
                }
                n3 = CertificateInfo.b(keyStoreType, keyStorePathOrUrl, keyStorePassword, keyAlias, keyPassword, digestAlgorithmName);
            }
            try {
                keyStorePassword = Encryption.decrypt((String)keyStorePassword);
                keyPassword = Encryption.decrypt((String)keyPassword);
                if (keyPassword.length() == 0) {
                    keyPassword = keyStorePassword;
                }
                certificateInfo = new CertificateInfo(keyStoreType, keyStorePathOrUrl, keyStorePassword, keyAlias, keyPassword, digestAlgorithmName);
                certificateInfo.mo();
                Wp.put(n2, certificateInfo);
                if (n3 != null) {
                    Wp.put(n3, certificateInfo);
                }
                return certificateInfo;
            }
            catch (Throwable throwable) {
                throw new IllegalArgumentException("sign pdf failed: " + throwable.getMessage(), throwable);
            }
        }
        return certificateInfo;
    }

    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="only static conetnt is load")
    private void mo() {
        Object object;
        Object object2;
        KeyStore keyStore = null;
        try {
            keyStore = KeyStore.getInstance(this.Wi);
        }
        catch (KeyStoreException keyStoreException) {
            throw new RuntimeException("invalid or unknown type of keyStore: " + this.Wi, keyStoreException);
        }
        try {
            object2 = IOFunctions.getURLFromString((String)this.Wj).openStream();
            try {
                object = this.Wk.toCharArray();
                keyStore.load((InputStream)object2, (char[])object);
                if (!keyStore.aliases().hasMoreElements()) {
                    throw new RuntimeException("Key store has no entries");
                }
            }
            finally {
                if (object2 != null) {
                    ((InputStream)object2).close();
                }
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException("file " + this.Wj + " not found", fileNotFoundException);
        }
        catch (Exception exception) {
            throw new RuntimeException("key store loading from  " + this.Wj + " failed:" + exception.getMessage(), exception);
        }
        object2 = BaseUtils.getSignatureData(keyStore, this.Wk, this.Wl, this.Wm, this.Wj, this.Wi, false);
        object = ((br)object2).jL();
        try {
            String string = object.getAlgorithm();
            int n2 = 0;
            if ("RSA".equals(string)) {
                RSAKey rSAKey = (RSAKey)object;
                n2 = rSAKey.getModulus().bitLength();
            } else if ("DSA".equals(string)) {
                DSAKey dSAKey = (DSAKey)object;
                BigInteger bigInteger = dSAKey.getParams().getP();
                n2 = bigInteger.bitLength();
            } else {
                throw new RuntimeException("Signature encryption with " + string + " is not supported");
            }
            if (n2 != 0) {
                this.Wo = new b(n2, (PrivateKey)object, ((br)object2).getCertificate(), ((br)object2).jM());
            } else if (BaseUtils.isDebug()) {
                BaseUtils.debug("key string is empty: no signature will be  set");
            }
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Key size can not be determned: " + throwable.getMessage(), throwable);
        }
    }

    private static Integer b(String string, String string2, String string3, String string4, String string5, String string6) {
        if (string == null) {
            throw new IllegalArgumentException("keyStoreType is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("keyStorePath is null");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("keyStorePassword is null");
        }
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (string6 == null ? 0 : string6.hashCode());
        n3 = 31 * n3 + (string4 == null ? 0 : string4.hashCode());
        n3 = 31 * n3 + (string5 == null ? 0 : string5.hashCode());
        n3 = 31 * n3 + string3.hashCode();
        n3 = 31 * n3 + string2.hashCode();
        n3 = 31 * n3 + string.hashCode();
        return n3;
    }

    public b getSignatureProcessor(String digestAlgorithmName) {
        if (this.Wo == null) {
            throw new IllegalStateException("processor is not initialized");
        }
        if (digestAlgorithmName == null) {
            digestAlgorithmName = this.Wn;
        }
        return this.Wo.aG(digestAlgorithmName);
    }

    public Certificate getCertificate() {
        if (this.Wo != null) {
            return this.Wo.getCertificate();
        }
        return null;
    }
}

