/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.PublicApi;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.lib.list.StringIntMap;
import com.inet.lib.util.LocaleUtils;
import com.inet.report.Area;
import com.inet.report.BaseUtils;
import com.inet.report.DatabaseTables;
import com.inet.report.Engine;
import com.inet.report.Group;
import com.inet.report.ReportException;
import com.inet.report.Section;
import com.inet.report.at;
import com.inet.report.ba;
import com.inet.report.bi;
import com.inet.report.bm;
import com.inet.report.k;
import com.inet.report.parser.FatalParserException;
import com.inet.report.parser.NodeParser;
import com.inet.report.parser.XMLTag;
import com.inet.report.y;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;

@PublicApi
public class ReportProperties
implements NodeParser,
Serializable {
    public static final int DEFAULT_PAPER_ORIENTATION = 0;
    public static final int PORTRAIT = 1;
    public static final int LANDSCAPE = 2;
    public static final int DEFAULT_PAPERSIZE = 0;
    public static final int PAPER_LETTER = 1;
    public static final int PAPER_LETTER_SMALL = 2;
    public static final int PAPER_TABLOID = 3;
    public static final int PAPER_LEDGER = 4;
    public static final int PAPER_LEGAL = 5;
    public static final int PAPER_STATEMENT = 6;
    public static final int PAPER_EXECUTIVE = 7;
    public static final int PAPER_A3 = 8;
    public static final int PAPER_A4 = 9;
    public static final int PAPER_A4_SMALL = 10;
    public static final int PAPER_A5 = 11;
    public static final int PAPER_B4 = 12;
    public static final int PAPER_B5 = 13;
    public static final int PAPER_FOLIO = 14;
    public static final int PAPER_QUATRO = 15;
    public static final int PAPER_10_X_14 = 16;
    public static final int PAPER_11_X_17 = 17;
    public static final int PAPER_NOTE = 18;
    public static final int PAPER_ENVELOPE_9 = 19;
    public static final int PAPER_ENVELOPE_10 = 20;
    public static final int PAPER_ENVELOPE_11 = 21;
    public static final int PAPER_ENVELOPE_12 = 22;
    public static final int PAPER_ENVELOPE_14 = 23;
    public static final int PAPER_C_SHEET = 24;
    public static final int PAPER_D_SHEET = 25;
    public static final int PAPER_E_SHEET = 26;
    public static final int PAPER_ENVELOPE_DL = 27;
    public static final int PAPER_ENVELOPE_C5 = 28;
    public static final int PAPER_ENVELOPE_C3 = 29;
    public static final int PAPER_ENVELOPE_C4 = 30;
    public static final int PAPER_ENVELOPE_C6 = 31;
    public static final int PAPER_ENVELOPE_C65 = 32;
    public static final int PAPER_ENVELOPE_B4 = 33;
    public static final int PAPER_ENVELOPE_B5 = 34;
    public static final int PAPER_ENVELOPE_B6 = 35;
    public static final int PAPER_ENVELOPE_ITALY = 36;
    public static final int PAPER_ENVELOPE_MONARCH = 37;
    public static final int PAPER_ENVELOPE_PERSONAL = 38;
    public static final int PAPER_FANFOLD_US = 39;
    public static final int PAPER_FANFOLD_STD_GERMAN = 40;
    public static final int PAPER_FANFOLD_LEGAL_GERMAN = 41;
    public static final int PAPER_B4_ISO = 42;
    public static final int PAPER_JAPANESE_POSTCARD = 43;
    public static final int PAPER_9_X_11 = 44;
    public static final int PAPER_10_X_11 = 45;
    public static final int PAPER_15_X_11 = 46;
    public static final int PAPER_MAX = 132;
    public static final int[] pageSizes = new int[]{12240, 15840, 12240, 15840, 15840, 24480, 24480, 15840, 12240, 20160, 7920, 12240, 10440, 15120, 16839, 23814, 11907, 16839, 11907, 16839, 8419, 11907, 14571, 20638, 10319, 14571, 12240, 18720, 12190, 15592, 14400, 20160, 15840, 24480, 12240, 15840, 5580, 12780, 5940, 13680, 6480, 14940, 6840, 15840, 7200, 16560, 24480, 31680, 31680, 48960, 48960, 63360, 6237, 12474, 9185, 12984, 18370, 25968, 12984, 18370, 6463, 9185, 6463, 12984, 14175, 20015, 9979, 14175, 9979, 7087, 6237, 13041, 5580, 10800, 5220, 9360, 21420, 15840, 12240, 17280, 12240, 18720, 23814, 33679, 5670, 8391, 12960, 15840, 14400, 15840, 21600, 15840, 12474, 12474, 12240, 15840, 12240, 15840, 13680, 17280, 13680, 21600, 16833, 25920, 13348, 16833, 12240, 15840, 11907, 16839, 13680, 17280, 12870, 20185, 17293, 27612, 12240, 18273, 11907, 18711, 8391, 11907, 10319, 14571, 18257, 25231, 9865, 13324, 11396, 15649, 23814, 33679, 16839, 23814, 18257, 25231, 11340, 8391, 5953, 8391, 12240, 15840, 12240, 15840, 12240, 15840, 12240, 15840, 15840, 12240, 23814, 16839, 16839, 11907, 11907, 8419, 1927, 14571, 14571, 10319, 8391, 567, 8391, 11340, 8391, 5953, 12240, 15840, 12240, 15840, 12240, 15840, 12240, 15840, 7257, 10319, 10319, 7257, 17280, 15840, 12240, 15840, 12240, 15840, 8278, 12190, 5499, 8561, 5499, 8561, 5783, 9355, 5783, 9979, 7087, 9979, 6237, 11793, 6237, 12474, 6804, 13041, 9072, 13041, 6804, 17520, 12984, 18370, 18370, 25968, 12240, 15840, 12240, 15840, 12240, 15840, 9355, 5783, 9979, 5783, 9979, 7087, 11793, 6237, 12474, 6237, 13041, 6804, 13041, 9072, 17520, 6804, 18370, 12984, 25968, 18370, 3600, 4800, 3600, 6000, 3600, 6480, 4800, 7200, 7200, 12000, 7200, 12810, 9600, 14400, 15360, 11520, 19200, 10800, 28800, 16200, 5669, 8504, 5760, 8640, 5953, 8391, 7937, 8504};
    public static final int PAPER_A2 = 66;
    public static final int USERDEFINED_PAPER = 256;
    static final ConfigValue<Integer> JP = new ConfigValue(ConfigKey.DEFAULT_PAPERSIZE);
    static final ConfigValue<Integer> JQ = new ConfigValue(ConfigKey.DEFAULT_ORIENTATION);
    private final DatabaseTables wv;
    Engine bm;
    private boolean JR;
    private boolean JS;
    private boolean JT;
    private int JU;
    private boolean JV = true;
    private boolean JW;
    private boolean JX;
    boolean JY;
    String JZ = "";
    String Ka = "";
    int AQ;
    int Kb;
    int Kc;
    int Kd;
    boolean Ke;
    boolean Kf;
    boolean Kg;
    private int bi = 11907;
    private int Kh = 16839;
    private int Ki = 256;
    private int Kj = 0;
    private int Kk = 720;
    private int Kl = 720;
    private int Km = 720;
    private int Kn = 720;
    private boolean Ko;
    private boolean Kp = true;
    private String[] Kq;
    private boolean Kr = true;
    private boolean Ks = true;
    private boolean Kt = true;
    private Locale Ku;
    private boolean Kv = true;
    private int Kw;
    private int Kx;
    private int Ky = Engine.getMajorVersion();
    private int Kz;
    private boolean KA = true;

    ReportProperties(DatabaseTables dbTables, Engine engine) {
        this.wv = dbTables;
        this.bm = engine;
    }

    public boolean isSuppressIfNoRows() {
        return this.JR;
    }

    public void setSuppressIfNoRows(boolean suppressIfNoRows) {
        this.JR = suppressIfNoRows;
    }

    public void setDistinct(boolean distinct) {
        this.JS = distinct;
    }

    public boolean isDistinct() {
        return this.JS;
    }

    public boolean isConvertNullValuesToDefault() {
        return this.JT;
    }

    public void setConvertNullValuesToDefault(boolean convertNullValuesToDefault) {
        this.JT = convertNullValuesToDefault;
    }

    public boolean isShowSuppressedGroupTreeNodes() {
        return this.JV;
    }

    public void setShowSuppressedGroupTreeNodes(boolean showSuppressedGroupTreeNodes) {
        this.JV = showSuppressedGroupTreeNodes;
    }

    public void setRowBufferSize(int rowCount) {
        this.JU = rowCount;
    }

    public int getRowBufferSize() {
        return this.JU;
    }

    public boolean isValidForRowBuffer() {
        return com.inet.report.bm.c(this.wv);
    }

    public void setPaperOrient(int paperOrientation, int paperSize) throws ReportException {
        if (paperSize != 256 && (paperSize < 0 || paperSize > 132)) {
            throw y.b("paperSize", paperSize, null);
        }
        this.Ki = paperSize;
        this.setPaperSize(paperOrientation, paperSize);
    }

    public int getPaperOrient() {
        if (this.Kj == 0) {
            return this.bi > this.Kh ? 2 : 1;
        }
        return this.Kj;
    }

    public int getPaperHeight() {
        return this.Kh;
    }

    public void setPaperHeight(int height) {
        if (height < 0) {
            throw y.a("height", height, null);
        }
        if (height < this.bm.bB.getReportProperties().getMarginTop() + this.bm.bB.getReportProperties().getMarginBottom()) {
            throw y.a("page height is lesser than margin top and margin bottom", height - this.bm.bB.getReportProperties().getMarginTop() - this.bm.bB.getReportProperties().getMarginBottom(), null);
        }
        this.Kh = height;
        this.Ki = 256;
    }

    public int getPaperWidth() {
        return this.bi;
    }

    public void setPaperWidth(int width) throws ReportException {
        if (width < 0) {
            throw y.a("width", width, null);
        }
        this.bt(width - this.bm.bB.getReportProperties().getMarginLeft() - this.bm.bB.getReportProperties().getMarginRight());
        this.bi = width;
        this.Ki = 256;
    }

    void bt(int n2) throws ReportException {
        if (n2 < 0) {
            throw y.a("page width lesser than margins", n2, null);
        }
        Group[] groupArray = this.bm.bB.jg();
        if (groupArray != null) {
            for (Group group : groupArray) {
                if (group == null) continue;
                this.a(group.sp, n2);
                this.a(group.sq, n2);
            }
        }
    }

    private void a(Area area, int n2) throws ReportException {
        if (area != null) {
            for (Section section : area.gc) {
                section.width = n2;
            }
        }
    }

    public int getPaperFormat() {
        int n2;
        int n3;
        int n4;
        if (this.Ki != 256) {
            return this.Ki;
        }
        int n5 = 1;
        for (n4 = 0; n4 < pageSizes.length; n4 += 2) {
            n3 = pageSizes[n4];
            n2 = pageSizes[n4 + 1];
            if (n3 == this.bi && n2 == this.Kh) {
                return n5;
            }
            if (n3 == this.Kh && n2 == this.bi) {
                return n5;
            }
            ++n5;
        }
        n5 = 1;
        for (n4 = 0; n4 < pageSizes.length; n4 += 2) {
            n3 = pageSizes[n4];
            n2 = pageSizes[n4 + 1];
            double d2 = (double)n3 * 0.99;
            double d3 = (double)n3 * 1.01;
            double d4 = (double)n2 * 0.99;
            double d5 = (double)n2 * 1.01;
            if (d2 < (double)this.bi && d3 > (double)this.bi && d4 < (double)this.Kh && d5 > (double)this.Kh) {
                this.Ki = n5;
                return n5;
            }
            if (d2 < (double)this.Kh && d3 > (double)this.Kh && d4 < (double)this.bi && d5 > (double)this.bi) {
                this.Ki = n5;
                return n5;
            }
            ++n5;
        }
        return 256;
    }

    public static int findPaperFormat(int x2, int y2, boolean isLandscape) {
        int n2 = 9;
        if (x2 <= 0 || y2 <= 0) {
            throw new IllegalArgumentException("args must be positive values");
        }
        if (isLandscape) {
            int n3 = x2;
            x2 = y2;
            y2 = n3;
        }
        double d2 = x2 * x2 + y2 * y2;
        float f2 = x2;
        float f3 = y2;
        for (int i2 = 0; i2 < pageSizes.length; i2 += 2) {
            if (x2 == pageSizes[i2 + 0] && y2 == pageSizes[i2 + 1]) {
                n2 = i2 / 2 + 1;
                break;
            }
            f2 = x2 - pageSizes[i2 + 0];
            f3 = y2 - pageSizes[i2 + 1];
            double d3 = f2 * f2 + f3 * f3;
            if (!(d3 < d2)) continue;
            d2 = d3;
            n2 = i2 / 2 + 1;
        }
        return n2;
    }

    public int getLabelWidth() {
        return this.AQ;
    }

    public void setLabelWidth(int labelWidth) {
        if (labelWidth < 0) {
            throw y.a("labelWidth", labelWidth, null);
        }
        this.AQ = labelWidth;
    }

    public int getLabelHeight() {
        return this.Kb;
    }

    public void setLabelHeight(int labelHeight) {
        if (labelHeight < 0) {
            throw y.a("labelHeight", labelHeight, null);
        }
        this.Kb = labelHeight;
    }

    public int getHorizontal() {
        return this.Kc;
    }

    public void setHorizontal(int horizontal) {
        if (horizontal < 0) {
            throw y.a("horizontal", horizontal, null);
        }
        this.Kc = horizontal;
    }

    public int getVertical() {
        return this.Kd;
    }

    public void setVertical(int vertical) {
        if (vertical < 0) {
            throw y.a("vertical", vertical, null);
        }
        this.Kd = vertical;
    }

    public void setLabelName(String s2) {
        this.JZ = s2;
    }

    public String getLabelName() {
        return this.JZ;
    }

    public boolean isAcrossThenDown() {
        return this.Ke;
    }

    public void setAcrossThenDown(boolean acrossThenDown) {
        this.Ke = acrossThenDown;
    }

    public boolean isFormatGroupsWithMultipleColumn() {
        return this.Kf;
    }

    public void setFormatGroupsWithMultipleColumn(boolean formatGroupsWithMultipleColumn) {
        this.Kf = formatGroupsWithMultipleColumn;
    }

    public void setMarginTop(int margin) {
        if (margin < 0) {
            throw y.a("margin", margin, null);
        }
        if (this.Kh < margin + this.bm.bB.getReportProperties().getMarginBottom()) {
            throw y.a("page height is lesser than margin top and margin bottom", this.Kh - margin - this.bm.bB.getReportProperties().getMarginBottom(), null);
        }
        this.Km = margin;
    }

    public int getMarginTop() {
        return this.Km;
    }

    public void setMarginBottom(int margin) {
        if (margin < 0) {
            throw y.a("margin", margin, null);
        }
        if (this.Kh < margin + this.bm.bB.getReportProperties().getMarginTop()) {
            throw y.a("page height lesser than margin top and margin bottom", this.Kh - margin - this.bm.bB.getReportProperties().getMarginTop(), null);
        }
        this.Kn = margin;
    }

    public int getMarginBottom() {
        return this.Kn;
    }

    public void setMarginLeft(int margin) throws ReportException {
        if (margin < 0) {
            throw y.a("margin", margin, null);
        }
        this.bt(this.bi - margin - this.bm.bB.getReportProperties().getMarginRight());
        this.Kk = margin;
    }

    public int getMarginLeft() {
        return this.Kk;
    }

    public void setMarginRight(int margin) throws ReportException {
        if (margin < 0) {
            throw y.a("margin", margin, null);
        }
        this.bt(this.bi - margin - this.bm.bB.getReportProperties().getMarginLeft());
        this.Kl = margin;
    }

    public int getMarginRight() {
        return this.Kl;
    }

    public boolean isFormatWithMultipleColumns() {
        return this.JY;
    }

    public void setFormatWithMultipleColumns(boolean val) {
        this.JY = val;
    }

    void w(PrintWriter printWriter, int n2) {
        String string = BaseUtils.getIndent(n2);
        StringBuilder stringBuilder = new StringBuilder();
        k.a(stringBuilder, ++n2, a.KD.name(), k.z(this.bi));
        k.a(stringBuilder, n2, a.KE.name(), k.z(this.Kh));
        k.a(stringBuilder, n2, a.KF.name(), k.z(this.Kj));
        k.a(stringBuilder, n2, a.KG.name(), k.z(this.bm.bB.getReportProperties().getMarginLeft()));
        k.a(stringBuilder, n2, a.KH.name(), k.z(this.bm.bB.getReportProperties().getMarginRight()));
        k.a(stringBuilder, n2, a.KI.name(), k.z(this.bm.bB.getReportProperties().getMarginTop()));
        k.a(stringBuilder, n2, a.KJ.name(), k.z(this.bm.bB.getReportProperties().getMarginBottom()));
        if (this.JZ != null) {
            k.a(stringBuilder, n2, a.KK.name(), this.JZ);
        }
        if (this.Ka != null) {
            k.a(stringBuilder, n2, a.KL.name(), this.Ka);
        }
        k.a(stringBuilder, n2, a.KY.name(), k.g(this.JY));
        k.a(stringBuilder, n2, a.KM.name(), k.z(this.AQ));
        k.a(stringBuilder, n2, a.KN.name(), k.z(this.Kb));
        k.a(stringBuilder, n2, a.KP.name(), k.z(this.Kd));
        k.a(stringBuilder, n2, a.KO.name(), k.z(this.Kc));
        k.a(stringBuilder, n2, a.KQ.name(), k.g(this.Ke));
        k.a(stringBuilder, n2, a.KR.name(), k.g(this.Kf));
        k.a(stringBuilder, n2, a.KS.name(), k.g(this.JS));
        k.a(stringBuilder, n2, a.Li.name(), k.g(this.JV));
        k.a(stringBuilder, n2, a.KT.name(), k.g(this.isIgnoreFiltering()));
        k.a(stringBuilder, n2, a.KU.name(), k.g(this.isIgnoreSorting()));
        if (this.JU != 0 && this.isValidForRowBuffer()) {
            k.a(stringBuilder, n2, a.KV.name(), k.z(this.JU));
        }
        k.a(stringBuilder, n2, a.KZ.name(), k.g(this.JR));
        k.a(stringBuilder, n2, a.La.name(), k.g(this.JT));
        k.a(stringBuilder, n2, a.Lb.name(), k.g(this.Kg));
        k.a(stringBuilder, n2, a.Lc.name(), k.g(this.Ko));
        if (this.Kq != null && this.Kq.length > 0) {
            StringBuilder stringBuilder2 = new StringBuilder();
            for (int i2 = 0; i2 < this.Kq.length; ++i2) {
                if (i2 != 0) {
                    stringBuilder2.append(' ');
                }
                stringBuilder2.append(this.Kq[i2]);
            }
            k.a(stringBuilder, n2, a.Ld.name(), stringBuilder2.toString());
        }
        k.a(stringBuilder, n2, a.Le.name(), k.g(this.Kp));
        k.a(stringBuilder, n2, a.Lf.name(), k.g(this.Kr));
        k.a(stringBuilder, n2, a.Lg.name(), k.g(this.Ks));
        k.a(stringBuilder, n2, a.Lh.name(), k.g(this.Kt));
        if (this.Ku != null) {
            k.a(stringBuilder, n2, a.Lj.name(), this.Ku.toString());
        }
        k.a(stringBuilder, n2, a.Lk.name(), k.g(this.KA));
        if (stringBuilder.length() > 0) {
            printWriter.print(string + "<ReportProperties>\n");
            printWriter.print(stringBuilder);
            printWriter.print(string + "</ReportProperties>\n");
        }
    }

    void b(int n2, String string, at at2) throws ReportException {
        switch (n2) {
            case 231: {
                this.bi = Integer.parseInt(string);
                break;
            }
            case 232: {
                this.Kh = Integer.parseInt(string);
                break;
            }
            case 102223: {
                this.Kj = Integer.parseInt(string);
                break;
            }
            case 233: {
                this.Kk = Integer.parseInt(string);
                break;
            }
            case 234: {
                this.Kl = Integer.parseInt(string);
                break;
            }
            case 235: {
                this.Km = Integer.parseInt(string);
                break;
            }
            case 236: {
                this.Kn = Integer.parseInt(string);
                break;
            }
            case 238: {
                this.JZ = string;
                break;
            }
            case 239: {
                this.Ka = string;
                break;
            }
            case 240: {
                this.AQ = Integer.parseInt(string);
                break;
            }
            case 241: {
                this.Kb = Integer.parseInt(string);
                break;
            }
            case 243: {
                if (at2.xv >= 6) {
                    this.Kc = Integer.parseInt(string);
                    break;
                }
                this.Kd = Integer.parseInt(string);
                break;
            }
            case 242: {
                if (at2.xv >= 6) {
                    this.Kd = Integer.parseInt(string);
                    break;
                }
                this.Kc = Integer.parseInt(string);
                break;
            }
            case 244: {
                this.Ke = Boolean.valueOf(string);
                break;
            }
            case 2600: {
                this.Kf = Boolean.valueOf(string);
                break;
            }
            case 245: {
                this.bm.bB.getSummaryInfo().setReportTitle(string);
                break;
            }
            case 246: {
                this.bm.bB.getSummaryInfo().setAuthor(string);
                break;
            }
            case 247: {
                this.bm.bB.getSummaryInfo().setKeywords(string);
                break;
            }
            case 248: {
                this.bm.bB.getSummaryInfo().setSubject(string);
                break;
            }
            case 249: {
                this.bm.bB.getSummaryInfo().setTemplate(string);
                break;
            }
            case 250: {
                this.bm.bB.getSummaryInfo().setComments(string);
                break;
            }
            case 251: {
                this.bm.bB.getSummaryInfo().setLastSaved(at2.S(string));
                break;
            }
            case 252: {
                this.bm.bB.getSummaryInfo().setCreated(at2.S(string));
                break;
            }
            case 254: {
                this.JS = Boolean.valueOf(string);
                break;
            }
            case 2543: {
                this.JV = Boolean.valueOf(string);
                break;
            }
            case 2542: {
                this.setIgnoreFiltering(Boolean.valueOf(string));
                break;
            }
            case 2541: {
                this.setIgnoreSorting(Boolean.valueOf(string));
                break;
            }
            case 255: {
                this.JU = Integer.parseInt(string);
                break;
            }
            case 237: {
                this.JY = Boolean.valueOf(string);
                break;
            }
            case 2601: {
                this.JR = Boolean.valueOf(string);
                break;
            }
            case 2602: {
                this.JT = Boolean.valueOf(string);
                break;
            }
            case 2603: {
                this.Kg = Boolean.valueOf(string);
                break;
            }
            case 2604: {
                this.Ko = Boolean.valueOf(string);
                break;
            }
            case 2605: {
                this.Kq = string.split(" ");
                break;
            }
            case 2606: {
                this.Kp = Boolean.valueOf(string);
                break;
            }
            case 2607: {
                this.Kr = Boolean.valueOf(string);
                break;
            }
            case 2608: {
                this.Ks = Boolean.valueOf(string);
                break;
            }
            case 2609: {
                this.Kt = Boolean.valueOf(string);
                break;
            }
            case 2610: {
                this.setReportLocale(this.ai(string));
                break;
            }
            case 2611: {
                this.KA = Boolean.parseBoolean(string);
            }
        }
    }

    static void a(StringIntMap stringIntMap) {
        stringIntMap.put("major_version", 227);
        stringIntMap.put("minor_version", 228);
        stringIntMap.put("major_xml_version", 229);
        stringIntMap.put("minor_xml_version", 230);
        stringIntMap.put("page width", 231);
        stringIntMap.put("page height", 232);
        stringIntMap.put("page orientation", 102223);
        stringIntMap.put("page margin left", 233);
        stringIntMap.put("page margin right", 234);
        stringIntMap.put("page margin top", 235);
        stringIntMap.put("page margin bottom", 236);
        stringIntMap.put("format with multiple columns", 237);
        stringIntMap.put("format groups with multiple columns", 2600);
        stringIntMap.put("mailing label type 1", 238);
        stringIntMap.put("mailing label type 2", 239);
        stringIntMap.put("mailing label width", 240);
        stringIntMap.put("mailing label height", 241);
        stringIntMap.put("mailing label distance vertical", 242);
        stringIntMap.put("mailing label distance horizontal", 243);
        stringIntMap.put("across then down", 244);
        stringIntMap.put("report title", 245);
        stringIntMap.put("report author", 246);
        stringIntMap.put("report keywords", 247);
        stringIntMap.put("report subject", 248);
        stringIntMap.put("report template", 249);
        stringIntMap.put("report comments", 250);
        stringIntMap.put("report last saved", 251);
        stringIntMap.put("report created", 252);
        stringIntMap.put("distinct", 254);
        stringIntMap.put("show suppressed nodes", 2543);
        stringIntMap.put("ignore sorting", 2541);
        stringIntMap.put("ignore filtering", 2542);
        stringIntMap.put("rowbuffer", 255);
        stringIntMap.put("data source", 258);
        stringIntMap.put("data source desc", 259);
        stringIntMap.put("suppress if no rows", 2601);
        stringIntMap.put("convert null values to default", 2602);
        stringIntMap.put("hide PageFooter inside ReportHeader", 2603);
        stringIntMap.put("form print", 2604);
        stringIntMap.put("enabled formats", 2605);
        stringIntMap.put("printing enabled", 2606);
        stringIntMap.put("clipboard enabled", 2607);
        stringIntMap.put("export enabled", 2608);
        stringIntMap.put("group tree visible", 2609);
        stringIntMap.put("report locale", 2610);
        stringIntMap.put("save datasource", 2611);
    }

    public void setPaperSize(int paperOrient, int paperFormat) throws ReportException {
        int n2;
        if (paperFormat > 0 && paperFormat < pageSizes.length / 2 + 1) {
            this.bi = pageSizes[2 * (paperFormat - 1)];
            this.bt(this.bi - this.bm.bB.getReportProperties().getMarginLeft() - this.bm.bB.getReportProperties().getMarginRight());
            this.Kh = pageSizes[2 * (paperFormat - 1) + 1];
            this.Ki = paperFormat;
        } else if (paperFormat != 256) {
            if (paperFormat == 0) {
                n2 = (Integer)JP.get();
                if (n2 <= 0 || n2 >= pageSizes.length / 2 + 1) {
                    if (BaseUtils.isWarning()) {
                        BaseUtils.warning("The value for \"default_PaperSize\" in the i-net Clear Reports configuration is invalid: " + n2);
                    }
                    n2 = 1;
                }
                this.bi = pageSizes[2 * (n2 - 1)];
                this.bt(this.bi - this.bm.bB.getReportProperties().getMarginLeft() - this.bm.bB.getReportProperties().getMarginRight());
                this.Kh = pageSizes[2 * (n2 - 1) + 1];
                this.Ki = n2;
            } else {
                BaseUtils.warning("Unsupported paper size: " + paperFormat + "! Use Letter instead.\n");
                this.bi = 12240;
                this.Kh = 15840;
                this.Ki = 1;
            }
        }
        this.Kj = paperOrient;
        if (paperOrient == 2) {
            n2 = this.bi;
            this.bi = this.Kh;
            this.Kh = n2;
        }
    }

    public boolean isHidePageFooterInsideReportHeader() {
        return this.Kg;
    }

    public void setHidePageFooterInsideReportHeader(boolean hidePageFooterInsideReportHeader) {
        this.Kg = hidePageFooterInsideReportHeader;
    }

    public void setFormPrint(boolean value) {
        this.Ko = value;
    }

    public boolean isFormPrint() {
        return this.Ko;
    }

    public void setPrintingEnabled(boolean value) {
        this.Kp = value;
    }

    public boolean isPrintingEnabled() {
        return this.Kp;
    }

    public void setEnabledFormats(String[] formats) {
        this.Kq = formats;
    }

    public String[] getEnabledFormats() {
        return this.Kq;
    }

    public void setClipboardEnabled(boolean value) {
        this.Kr = value;
    }

    public boolean isClipboardEnabled() {
        return this.Kr;
    }

    public void setExportEnabled(boolean value) {
        this.Ks = value;
    }

    public boolean isExportEnabled() {
        return this.Ks;
    }

    public void setGroupTreeVisible(boolean value) {
        this.Kt = value;
    }

    public boolean isGroupTreeVisible() {
        return this.Kt;
    }

    @Deprecated
    public boolean isIgnoreSorting() {
        return this.JW;
    }

    @Deprecated
    public void setIgnoreSorting(boolean ignoreSorting) {
        this.JW = ignoreSorting;
    }

    @Deprecated
    public boolean isIgnoreFiltering() {
        return this.JX;
    }

    @Deprecated
    public void setIgnoreFiltering(boolean ignoreFiltering) {
        this.JX = ignoreFiltering;
    }

    @Override
    public NodeParser parseElement(XMLTag group, String tag, Attributes atts, Map<String, Object> parserMap) throws FatalParserException {
        String string = atts.getValue("value");
        if (string == null) {
            return null;
        }
        a a2 = a.aj(tag);
        if (a2 == a.Ll) {
            return null;
        }
        switch (a2) {
            case KD: {
                this.bi = Integer.parseInt(string);
                break;
            }
            case KE: {
                this.Kh = Integer.parseInt(string);
                break;
            }
            case KF: {
                this.Kj = Integer.parseInt(string);
                break;
            }
            case KG: {
                this.Kk = Integer.parseInt(string);
                break;
            }
            case KH: {
                this.Kl = Integer.parseInt(string);
                break;
            }
            case KI: {
                this.Km = Integer.parseInt(string);
                break;
            }
            case KJ: {
                this.Kn = Integer.parseInt(string);
                break;
            }
            case KK: {
                this.JZ = string;
                break;
            }
            case KL: {
                this.Ka = string;
                break;
            }
            case KM: {
                this.AQ = Integer.parseInt(string);
                break;
            }
            case KN: {
                this.Kb = Integer.parseInt(string);
                break;
            }
            case KO: {
                this.Kc = Integer.parseInt(string);
                break;
            }
            case KP: {
                this.Kd = Integer.parseInt(string);
                break;
            }
            case KQ: {
                this.Ke = Boolean.valueOf(string);
                break;
            }
            case KR: {
                this.Kf = Boolean.valueOf(string);
                break;
            }
            case KS: {
                this.JS = Boolean.valueOf(string);
                break;
            }
            case KT: {
                this.setIgnoreFiltering(Boolean.valueOf(string));
                break;
            }
            case KU: {
                this.setIgnoreSorting(Boolean.valueOf(string));
                break;
            }
            case KV: {
                this.JU = Integer.parseInt(string);
                break;
            }
            case KY: {
                this.JY = Boolean.valueOf(string);
                break;
            }
            case KZ: {
                this.JR = Boolean.valueOf(string);
                break;
            }
            case La: {
                this.JT = Boolean.valueOf(string);
                break;
            }
            case Lb: {
                this.Kg = Boolean.valueOf(string);
                break;
            }
            case Lc: {
                this.Ko = Boolean.valueOf(string);
                break;
            }
            case Ld: {
                this.Kq = string.split(" ");
                break;
            }
            case Le: {
                this.Kp = Boolean.valueOf(string);
                break;
            }
            case Lf: {
                this.Kr = Boolean.valueOf(string);
                break;
            }
            case Lg: {
                this.Ks = Boolean.valueOf(string);
                break;
            }
            case Lh: {
                this.Kt = Boolean.valueOf(string);
                break;
            }
            case Li: {
                this.JV = Boolean.valueOf(string);
                break;
            }
            case Lj: {
                this.setReportLocale(this.ai(string));
                break;
            }
            case Lk: {
                this.KA = Boolean.parseBoolean(string);
            }
        }
        return null;
    }

    @Override
    public void parseText(String text, Map<String, Object> parserMap) {
    }

    @Override
    public void parseEndElement(XMLTag group, String tag, Map<String, Object> parserMap) throws FatalParserException {
    }

    @Override
    public boolean isDOMParser() {
        return false;
    }

    @Override
    public void parseDOM(Node node, Map<String, Object> parserMap) throws FatalParserException {
    }

    public void setReportLocale(Locale reportLocale) {
        Object object;
        if (BaseUtils.isInfo() && reportLocale != Locale.getDefault()) {
            BaseUtils.info("Set server locale for the current report: " + String.valueOf(reportLocale != null ? reportLocale : String.valueOf(Locale.getDefault()) + " (VM default)"));
        }
        if (reportLocale != null && reportLocale != Locale.getDefault() && BaseUtils.isWarning() && (object = LocaleUtils.checkLocale((Locale)reportLocale)) != null) {
            BaseUtils.warning("setReportLocale: " + (String)object);
        }
        this.Ku = reportLocale;
        if (this.bm != null && this.bm.bB != null) {
            object = this.bm.bB;
            if (reportLocale != null) {
                if (((bi)object).Jc == ((bi)object).Jd) {
                    ((bi)object).a(reportLocale, false);
                }
                ((bi)object).Jc = reportLocale;
                if (((bi)object).IL != null) {
                    for (int i2 = 0; i2 < ((bi)object).IL.size(); ++i2) {
                        ba<?> ba2 = ((bi)object).IL.get(i2);
                        ba2.Jc = reportLocale;
                    }
                }
            } else {
                this.setReportLocale(Locale.getDefault());
                this.Ku = null;
            }
        }
    }

    public Locale getReportLocale() {
        return this.Ku;
    }

    private Locale ai(String string) {
        if (string != null && string.length() > 0) {
            String string2;
            if (BaseUtils.isWarning() && (string2 = LocaleUtils.checkLocaleString((String)string)) != null) {
                BaseUtils.warning("parseLocaleFromString: " + string2);
            }
            return LocaleUtils.valueOf((String)string);
        }
        return null;
    }

    public boolean isCCFormat() {
        return this.Kv;
    }

    void W(boolean bl2) {
        this.Kv = bl2;
    }

    int jo() {
        return this.Kw;
    }

    void bu(int n2) {
        this.Kw = n2;
    }

    int jp() {
        return this.Kx;
    }

    void bv(int n2) {
        this.Kx = n2;
    }

    public int getXMLMajorVersion() {
        return this.Ky;
    }

    void bw(int n2) {
        this.Ky = n2;
    }

    public int getXMLMinorVersion() {
        return this.Kz;
    }

    void bx(int n2) {
        this.Kz = n2;
    }

    public void setSaveDatasource(boolean save) {
        this.KA = save;
    }

    public boolean isSaveDatasource() {
        return this.KA;
    }

    private static final class a
    extends Enum<a> {
        public static final /* enum */ a KC = new a();
        public static final /* enum */ a KD = new a();
        public static final /* enum */ a KE = new a();
        public static final /* enum */ a KF = new a();
        public static final /* enum */ a KG = new a();
        public static final /* enum */ a KH = new a();
        public static final /* enum */ a KI = new a();
        public static final /* enum */ a KJ = new a();
        public static final /* enum */ a KK = new a();
        public static final /* enum */ a KL = new a();
        public static final /* enum */ a KM = new a();
        public static final /* enum */ a KN = new a();
        public static final /* enum */ a KO = new a();
        public static final /* enum */ a KP = new a();
        public static final /* enum */ a KQ = new a();
        public static final /* enum */ a KR = new a();
        public static final /* enum */ a KS = new a();
        public static final /* enum */ a KT = new a();
        public static final /* enum */ a KU = new a();
        public static final /* enum */ a KV = new a();
        public static final /* enum */ a KW = new a();
        public static final /* enum */ a KX = new a();
        public static final /* enum */ a KY = new a();
        public static final /* enum */ a KZ = new a();
        public static final /* enum */ a La = new a();
        public static final /* enum */ a Lb = new a();
        public static final /* enum */ a Lc = new a();
        public static final /* enum */ a Ld = new a();
        public static final /* enum */ a Le = new a();
        public static final /* enum */ a Lf = new a();
        public static final /* enum */ a Lg = new a();
        public static final /* enum */ a Lh = new a();
        public static final /* enum */ a Li = new a();
        public static final /* enum */ a Lj = new a();
        public static final /* enum */ a Lk = new a();
        public static final /* enum */ a Ll = new a();
        private static HashMap<String, a> gx;
        private static final /* synthetic */ a[] Lm;

        public static a[] values() {
            return (a[])Lm.clone();
        }

        public static a valueOf(String name) {
            return Enum.valueOf(a.class, name);
        }

        private static a aj(String string) {
            a a2 = gx.get(string);
            if (a2 == null) {
                a2 = Ll;
            }
            return a2;
        }

        private static /* synthetic */ a[] jq() {
            return new a[]{KC, KD, KE, KF, KG, KH, KI, KJ, KK, KL, KM, KN, KO, KP, KQ, KR, KS, KT, KU, KV, KW, KX, KY, KZ, La, Lb, Lc, Ld, Le, Lf, Lg, Lh, Li, Lj, Lk, Ll};
        }

        static {
            Lm = a.jq();
            gx = new HashMap();
            gx.put("DefaultAttribute", KC);
            gx.put("PageWidth", KD);
            gx.put("PageHeight", KE);
            gx.put("PageOrientation", KF);
            gx.put("PageMarginLeft", KG);
            gx.put("PageMarginRight", KH);
            gx.put("PageMarginTop", KI);
            gx.put("PageMarginBottom", KJ);
            gx.put("MailingLabelType1", KK);
            gx.put("MailingLabelType2", KL);
            gx.put("MailingLabelWidth", KM);
            gx.put("MailingLabelHeight", KN);
            gx.put("MailingLabelDistanceHorizontal", KO);
            gx.put("MailingLabelDistanceVertical", KP);
            gx.put("AcrossThenDown", KQ);
            gx.put("FormatGroupsWithMultipleColumns", KR);
            gx.put("Distinct", KS);
            gx.put("IgnoreFiltering", KT);
            gx.put("IgnoreSorting", KU);
            gx.put("Rowbuffer", KV);
            gx.put("DataSource", KW);
            gx.put("DataSourceDesc", KX);
            gx.put("FormatWithMultipleColumns", KY);
            gx.put("SuppressIfNoRows", KZ);
            gx.put("ConvertNullValuesToDefault", La);
            gx.put("HidePageFooterInsideReportHeader", Lb);
            gx.put("FormPrint", Lc);
            gx.put("EnabledFormats", Ld);
            gx.put("PrintingEnabled", Le);
            gx.put("ClipboardEnabled", Lf);
            gx.put("ExportEnabled", Lg);
            gx.put("GroupTreeVisible", Lh);
            gx.put("ShowSuppressedNodes", Li);
            gx.put("ReportLocale", Lj);
            gx.put("SaveDatasource", Lk);
        }
    }
}

