/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.PublicApi;
import com.inet.logging.LogManager;
import com.inet.report.BaseUtils;
import com.inet.report.CascadingSource;
import com.inet.report.Datasource;
import com.inet.report.Engine;
import com.inet.report.Field;
import com.inet.report.HasCascadingParent;
import com.inet.report.PromptField;
import com.inet.report.ReportException;
import com.inet.report.SQLValueProvider;
import com.inet.report.database.DataFactory;
import com.inet.report.database.sql.PromptPlaceholderReplacer;
import com.inet.report.database.sql.SqlSyntax;
import com.inet.report.parser.FatalParserException;
import com.inet.report.parser.NodeParser;
import com.inet.report.parser.XMLTag;
import java.util.Map;
import org.xml.sax.Attributes;

@PublicApi
public class QueryValueProvider
extends SQLValueProvider
implements CascadingSource,
HasCascadingParent {
    private PromptField hr;
    private String zW;
    private Datasource qU;
    private String zX;

    public QueryValueProvider(String query, Datasource datasource) {
        if (query == null) {
            throw new IllegalArgumentException("query was null");
        }
        if (datasource == null) {
            throw new IllegalArgumentException("datasource was null");
        }
        this.zW = query;
        this.qU = datasource;
    }

    QueryValueProvider() {
    }

    public void setDatasource(Datasource datasource) {
        if (datasource == null) {
            throw new IllegalArgumentException("datasource was null");
        }
        this.qU = datasource;
    }

    @Override
    public Datasource getDatasource() {
        return this.qU;
    }

    @Deprecated
    public void setSQL(String query) {
        LogManager.deprecatedMessage();
        this.setQuery(query);
    }

    public void setQuery(String query) {
        if (query == null) {
            throw new IllegalArgumentException("query was null");
        }
        this.zW = query;
    }

    public String getQuery() {
        return this.zW;
    }

    @Override
    public String getSQL() throws ReportException {
        Datasource datasource = this.getDatasource();
        DataFactory dataFactory = datasource.getDataFactory();
        SqlSyntax sqlSyntax = dataFactory.getSqlSyntax();
        return new PromptPlaceholderReplacer(sqlSyntax).replace(this.zW, datasource.getEngine().bB.getFields());
    }

    @Override
    public String getFieldRefName() {
        return this.zX;
    }

    public void setFieldRefName(String refName) {
        this.zX = refName;
    }

    @Override
    public NodeParser parseElement(XMLTag group, String tag, Attributes atts, Map<String, Object> parserMap) throws FatalParserException {
        Engine engine = (Engine)parserMap.get(PromptField.b.zL.name());
        String string = atts.getValue("value");
        switch (a.valueOf(tag)) {
            case Ab: {
                try {
                    int n2 = engine.getDatabaseTables().getDatasourceCount();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        Datasource datasource = engine.getDatabaseTables().getDatasource(i2);
                        if (!datasource.getDataSourceConfigurationName().equals(string)) continue;
                        this.setDatasource(datasource);
                        return null;
                    }
                    break;
                }
                catch (ReportException reportException) {
                    BaseUtils.printStackTrace(reportException);
                    break;
                }
            }
            case zZ: {
                this.setQuery(string);
                break;
            }
            case Aa: {
                this.setFieldRefName(string);
                break;
            }
            case Ad: {
                String string2 = atts.getValue("name");
                if (!"cascading parent".equals(string2)) break;
                try {
                    String string3 = atts.getValue("value");
                    Field field = engine.bM().a(false, string3);
                    PromptField promptField = (PromptField)field;
                    this.setParent(promptField);
                    break;
                }
                catch (ReportException reportException) {
                    BaseUtils.error(reportException);
                }
            }
        }
        return null;
    }

    @Override
    public PromptField getParent() {
        return this.hr;
    }

    @Override
    public void setParent(PromptField parent) {
        this.hr = parent;
    }

    private static final class a
    extends Enum<a> {
        public static final /* enum */ a zZ = new a();
        public static final /* enum */ a Aa = new a();
        public static final /* enum */ a Ab = new a();
        public static final /* enum */ a Ac = new a();
        public static final /* enum */ a Ad = new a();
        private static final /* synthetic */ a[] Ae;

        public static a[] values() {
            return (a[])Ae.clone();
        }

        public static a valueOf(String name) {
            return Enum.valueOf(a.class, name);
        }

        private static /* synthetic */ a[] fJ() {
            return new a[]{zZ, Aa, Ab, Ac, Ad};
        }

        static {
            Ae = a.fJ();
        }
    }
}

