/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.PublicApi;
import com.inet.error.ErrorCode;
import com.inet.report.BaseUtils;
import com.inet.report.CascadingValueProvider;
import com.inet.report.Datasource;
import com.inet.report.DefaultValue;
import com.inet.report.DynamicValueProvider;
import com.inet.report.Engine;
import com.inet.report.Field;
import com.inet.report.FieldValueProvider;
import com.inet.report.Fields;
import com.inet.report.FormulaDefaultValue;
import com.inet.report.FormulaField;
import com.inet.report.FormulaRange;
import com.inet.report.PromptRequestWarning;
import com.inet.report.QueryValueProvider;
import com.inet.report.ReferenceHolder;
import com.inet.report.ReferencedObject;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.SQLValueProvider;
import com.inet.report.TableSource;
import com.inet.report.at;
import com.inet.report.ba;
import com.inet.report.bf;
import com.inet.report.formula.Evaluable;
import com.inet.report.formula.e;
import com.inet.report.i18n.ReportErrorCode;
import com.inet.report.k;
import com.inet.report.parser.FatalParserException;
import com.inet.report.parser.NodeParser;
import com.inet.report.parser.XMLTag;
import com.inet.report.r;
import com.inet.report.util.PromptUtils;
import com.inet.report.y;
import com.inet.viewer.PromptValue;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Map;
import org.xml.sax.Attributes;

@PublicApi
public class PromptField
extends Field
implements ReferenceHolder {
    transient boolean valueSet;
    private ArrayList<DefaultValue> yW;
    private DynamicValueProvider yX;
    String yY;
    TableSource yZ;
    String promptText;
    boolean za;
    int zb;
    boolean range;
    Object zc;
    Object zd;
    String editMask = "";
    boolean ze;
    int zf;
    boolean zg;
    boolean zh;
    private boolean zi = true;
    private boolean descOnly;
    Integer zj;
    int zk;
    Object value;
    private Evaluable zl;
    public static final int DISCRETE_VALUE = 0;
    public static final int RANGE_VALUE = 1;
    public static final int DISCRETE_AND_RANGE_VALUE = 2;
    private r qj = new r(this);

    PromptField(ba ren) {
        this.type = 16;
        this.bB = ren;
        this.zi = true;
        this.zg = true;
    }

    @Override
    public final void setName(String name) {
        if (name != null) {
            name = name.trim();
        }
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("The name of a prompt field cannot be empty");
        }
        if (name.equals(this.name)) {
            return;
        }
        if (name.equalsIgnoreCase(this.name)) {
            try {
                this.rename(name);
            }
            catch (ReportException reportException) {
                throw new IllegalArgumentException("Name not allowed", reportException);
            }
            return;
        }
        if (this.bB == null) {
            return;
        }
        if (Fields.a((Field[])this.bB.iZ(), name)) {
            throw y.b("PromptField", name, null);
        }
        try {
            this.rename(name);
        }
        catch (ReportException reportException) {
            throw new IllegalArgumentException("Name not allowed", reportException);
        }
    }

    public final String getPromptText() {
        return this.promptText;
    }

    public final void setPromptText(String promptText) {
        this.promptText = promptText;
    }

    public final Object getPromptValue() {
        return this.getValue();
    }

    void e(Object object) throws ReportException {
        Object object2;
        if (!this.range) {
            return;
        }
        if (this.zc == null && this.zd == null) {
            return;
        }
        if (object instanceof FormulaRange) {
            FormulaRange formulaRange = (FormulaRange)object;
            this.e(formulaRange.getFrom());
            this.e(formulaRange.getTo());
            return;
        }
        if (object instanceof Object[]) {
            for (int i2 = 0; i2 < ((Object[])object).length; ++i2) {
                this.e(((Object[])object)[i2]);
            }
            return;
        }
        switch (this.getPromptType()) {
            case 11: {
                if (!(object instanceof String) || this.zc != null && !((double)((String)object).length() >= ((Number)this.zc).doubleValue()) || this.zd != null && !((double)((String)object).length() <= ((Number)this.zd).doubleValue())) break;
                return;
            }
            case 6: 
            case 7: {
                if (!(object instanceof Number)) break;
                object2 = (Number)object;
                if (this.zc != null && !(((Number)object2).doubleValue() >= ((Number)this.zc).doubleValue()) || this.zd != null && !(((Number)object2).doubleValue() <= ((Number)this.zd).doubleValue())) break;
                return;
            }
            case 8: {
                return;
            }
            case 9: 
            case 10: 
            case 15: {
                if (!(object instanceof java.util.Date)) break;
                object2 = (java.util.Date)object;
                if (this.zc != null && !((java.util.Date)this.zc).before((java.util.Date)object2) && !this.zc.equals(object2) || this.zd != null && !((java.util.Date)this.zd).after((java.util.Date)object2) && !this.zd.equals(object2)) break;
                return;
            }
        }
        String string = switch (this.getPromptType()) {
            case 6, 7, 9, 10, 15 -> {
                e var4_5 = this.bB.dC().qS();
                object2 = ReportErrorCode.valueNoBetweenMinMax;
                yield object2.getMsg(new Object[]{var4_5.b(this.zc, true), var4_5.b(this.zd, true)});
            }
            case 11 -> {
                object2 = ReportErrorCode.valueNoBetweenMinMaxLength;
                yield object2.getMsg(new Object[]{this.zc, this.zd});
            }
            case 8 -> {
                object2 = ReportErrorCode.rangeOnBoolean;
                yield object2.getMsg(new Object[0]);
            }
            default -> {
                object2 = ReportErrorCode.wrongPromptType;
                yield object2.getMsg(new Object[]{this.getPromptType()});
            }
        };
        int n2 = ((ReportErrorCode)((Object)object2)).getErrorCodeNumber();
        throw new PromptRequestWarning(string, n2, Engine.p(this.bB));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void setPromptValue(Object prompt) throws ReportException {
        if (prompt == null) {
            this.e(prompt);
            this.value = prompt;
            this.valueSet = true;
            return;
        }
        if (prompt instanceof PromptValue) {
            this.setPromptValueAsFormula("formula:" + ((PromptValue)prompt).getStringRepresentation());
            return;
        }
        if (this.za) {
            if (!(prompt instanceof Object[])) {
                throw ReportExceptionFactory.createReportException(ReportErrorCode.WrongMultipleDiscreteValue, String.valueOf(this.za));
            }
            Object[] objectArray = (Object[])prompt;
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                Object object = objectArray[i2];
                PromptField.a(object, this.valueType, this.name, this.getValueTypeString());
                if (object instanceof FormulaRange) {
                    if (this.zb == 0) {
                        throw ReportExceptionFactory.createReportException(ReportErrorCode.WrongRangeValue, String.valueOf(this.zb));
                    }
                    this.e(object);
                    continue;
                }
                if (this.zb == 1) {
                    throw ReportExceptionFactory.createReportException(ReportErrorCode.WrongRangeValue, String.valueOf(this.zb));
                }
                this.e(object);
            }
            if (objectArray.length == 0) {
                this.e(null);
            }
            this.valueSet = true;
            this.value = prompt;
            return;
        } else if (this.zb == 0) {
            if (prompt instanceof Object[] || prompt instanceof FormulaRange) throw ReportExceptionFactory.createReportException(ReportErrorCode.WrongDiscreteValue, "Object");
            PromptField.a(prompt, this.valueType, this.name, this.getValueTypeString());
            this.e(prompt);
            this.valueSet = true;
            this.value = prompt;
            return;
        } else if (this.zb == 1) {
            if (!(prompt instanceof FormulaRange)) throw ReportExceptionFactory.createReportException(ReportErrorCode.WrongDiscreteValue, "FormulaRange");
            PromptField.a(prompt, this.valueType, this.name, this.getValueTypeString());
            this.e(prompt);
            this.valueSet = true;
            this.value = prompt;
            return;
        } else {
            if (this.zb != 2) return;
            throw ReportExceptionFactory.createReportException(ReportErrorCode.WrongMultipleDiscreteValue, String.valueOf(this.za));
        }
    }

    public void setPromptValueAsFormula(String formula) throws ReportException {
        this.bB.getEngine().a(this, formula);
    }

    public final int getPromptType() {
        if (this.valueType == -1) {
            return this.valueType;
        }
        return this.valueType % 128;
    }

    public final void setPromptType(int valueType) {
        if (this.valueType == valueType) {
            return;
        }
        this.valueType = valueType;
        this.zc = null;
        this.zd = null;
        if (valueType % 128 != 6 && valueType % 128 != -1 && valueType % 128 != 7 && valueType % 128 != 8 && valueType % 128 != 9 && valueType % 128 != 10 && valueType % 128 != 15 && valueType % 128 != 11 && valueType % 128 != 14) {
            throw new IllegalArgumentException("illegal prompt value type " + valueType + "! Must be one of the Field value type constants!");
        }
        this.bB.getFields().a(this, 2);
    }

    public final void setUseRange(boolean newValue) {
        this.range = newValue;
    }

    public final boolean getUseRange() {
        return this.range;
    }

    public final void setDescriptionOnly(boolean descOnly) {
        this.descOnly = descOnly;
    }

    public final boolean isDescriptionOnly() {
        return this.descOnly;
    }

    public final void setEditable(boolean isEditable) {
        if (!isEditable && this.isPasswordField()) {
            throw new UnsupportedOperationException("password fields must be editable!");
        }
        this.zi = isEditable;
    }

    public final boolean isEditable() {
        return this.zi;
    }

    public boolean isValueSet() {
        return this.valueSet;
    }

    public final boolean isPasswordField() {
        return "password".equals(this.editMask);
    }

    public final void setPasswordField(boolean isPasswordField) {
        if (isPasswordField) {
            this.editMask = "password";
            this.setDefaultValues(null);
            this.setEditable(true);
            this.setAllowMultipleValues(false);
            this.setDiscreteOrRangeType(0);
        } else {
            this.editMask = "";
        }
    }

    public void setDiscreteOrRangeType(int newValue) throws IllegalArgumentException {
        if (newValue != 0 && this.isPasswordField()) {
            throw new UnsupportedOperationException("A password field must have the discrete type DISCRETE_VALUE");
        }
        if (newValue < 0 || newValue > 2) {
            throw y.a(newValue, "DiscreteOrRangeType", (ErrorCode)ReportErrorCode.outOfRange2);
        }
        this.zb = newValue;
    }

    public int getDiscreteOrRangeType() {
        return this.zb;
    }

    public void setAllowMultipleValues(boolean newValue) {
        if (this.isPasswordField() && newValue) {
            throw new UnsupportedOperationException("Password Fields can not be set to allow multiple values.");
        }
        this.za = newValue;
    }

    public boolean getAllowMultipleValues() {
        return this.za;
    }

    public int getValuesCount() {
        if (this.getValue() == null) {
            return 0;
        }
        if (this.getValue() instanceof Object[]) {
            return ((Object[])this.getValue()).length;
        }
        return 1;
    }

    public void setMinRangeValue(Object min) throws ReportException {
        if (!this.range) {
            throw new IllegalStateException("Range is disabled");
        }
        if (min == null) {
            this.zc = null;
        } else {
            this.setMinMaxRangeValues(min, this.zd);
        }
    }

    public void setMaxRangeValue(Object max) throws ReportException {
        if (!this.range) {
            throw new IllegalStateException("Range is disabled");
        }
        if (max == null) {
            this.zd = null;
        } else {
            this.setMinMaxRangeValues(this.zc, max);
        }
    }

    public void setMinMaxRangeValues(Object min, Object max) throws ReportException {
        if (this.range) {
            switch (this.getPromptType()) {
                case 11: {
                    double d2;
                    if (min instanceof Number) {
                        d2 = ((Number)min).doubleValue();
                        if (d2 < 0.0) {
                            Object[] objectArray = new Object[]{min};
                            throw ReportExceptionFactory.createReportException(ReportErrorCode.MinNegativeForString, objectArray);
                        }
                        if (d2 - Math.floor(d2) > 0.0) {
                            Object[] objectArray = new Object[]{min};
                            throw ReportExceptionFactory.createReportException(ReportErrorCode.StringLimitIsFractional, objectArray);
                        }
                    }
                    if (max instanceof Number) {
                        d2 = ((Number)max).doubleValue();
                        if (d2 < 0.0) {
                            Object[] objectArray = new Object[]{max};
                            throw ReportExceptionFactory.createReportException(ReportErrorCode.MaxNegativeForString, objectArray);
                        }
                        if (d2 - Math.floor(d2) > 0.0) {
                            Object[] objectArray = new Object[]{max};
                            throw ReportExceptionFactory.createReportException(ReportErrorCode.StringLimitIsFractional, objectArray);
                        }
                    }
                }
                case 6: 
                case 7: {
                    if (min instanceof Number && max instanceof Number) {
                        if (((Number)min).doubleValue() > ((Number)max).doubleValue()) {
                            Object[] objectArray = new Object[]{max, min};
                            throw ReportExceptionFactory.createReportException(ReportErrorCode.MaxLessThanMin, objectArray);
                        }
                    } else if (!(min == null && max instanceof Number || min instanceof Number && max == null || min == null && max == null)) {
                        Object[] objectArray = new Object[]{};
                        throw ReportExceptionFactory.createReportException(ReportErrorCode.MinMaxNotNumber, objectArray);
                    }
                    this.zc = min;
                    this.zd = max;
                    break;
                }
                case 8: {
                    Object[] objectArray = new Object[]{};
                    throw ReportExceptionFactory.createReportException(ReportErrorCode.rangeOnBoolean, objectArray);
                }
                case 9: {
                    if (min instanceof Date && max instanceof Date) {
                        if (((Date)min).getTime() > ((Date)max).getTime()) {
                            Object[] objectArray = new Object[]{min, max};
                            throw ReportExceptionFactory.createReportException(ReportErrorCode.MaxLessThanMin, objectArray);
                        }
                    } else if (!(min == null && max instanceof Date || min instanceof Date && max == null || min == null && max == null)) {
                        Object[] objectArray = new Object[]{};
                        throw ReportExceptionFactory.createReportException(ReportErrorCode.noDateInstance, objectArray);
                    }
                    this.zc = min;
                    this.zd = max;
                    break;
                }
                case 15: {
                    if (min instanceof Timestamp && max instanceof Timestamp) {
                        if (((Timestamp)min).getTime() > ((Timestamp)max).getTime()) {
                            Object[] objectArray = new Object[]{min, max};
                            throw ReportExceptionFactory.createReportException(ReportErrorCode.MaxLessThanMin, objectArray);
                        }
                    } else if (!(min == null && max instanceof Timestamp || min instanceof Timestamp && max == null || min == null && max == null)) {
                        Object[] objectArray = new Object[]{};
                        throw ReportExceptionFactory.createReportException(ReportErrorCode.noTimeStampInstance, objectArray);
                    }
                    this.zc = min;
                    this.zd = max;
                    break;
                }
                case 10: {
                    if (min instanceof Time && max instanceof Time) {
                        if (((Time)min).getTime() > ((Time)max).getTime()) {
                            Object[] objectArray = new Object[]{min, max};
                            throw ReportExceptionFactory.createReportException(ReportErrorCode.MaxLessThanMin, objectArray);
                        }
                    } else if (!(min == null && max instanceof Time || min instanceof Time && max == null || min == null && max == null)) {
                        Object[] objectArray = new Object[]{};
                        throw ReportExceptionFactory.createReportException(ReportErrorCode.noTimeInstance, objectArray);
                    }
                    this.zc = min;
                    this.zd = max;
                    break;
                }
                default: {
                    Object[] objectArray = new Object[]{this.name};
                    throw ReportExceptionFactory.createReportException(ReportErrorCode.wrongPromptType, objectArray);
                }
            }
        } else {
            Object[] objectArray = new Object[]{};
            throw ReportExceptionFactory.createReportException(ReportErrorCode.disabledRange, objectArray);
        }
    }

    public Object getMinRangeValue() throws ReportException {
        if (this.range) {
            switch (this.getPromptType()) {
                case 6: 
                case 7: 
                case 11: {
                    return this.zc;
                }
                case 8: {
                    Object[] objectArray = new Object[]{};
                    throw ReportExceptionFactory.createReportException(ReportErrorCode.rangeOnBoolean, objectArray);
                }
                case 9: {
                    return this.zc;
                }
                case 15: {
                    return this.zc;
                }
                case 10: {
                    return this.zc;
                }
            }
            Object[] objectArray = new Object[]{this.name};
            throw ReportExceptionFactory.createReportException(ReportErrorCode.wrongPromptType, objectArray);
        }
        Object[] objectArray = new Object[]{};
        throw ReportExceptionFactory.createReportException(ReportErrorCode.disabledRange, objectArray);
    }

    public Object getMaxRangeValue() throws ReportException {
        if (this.range) {
            switch (this.getPromptType()) {
                case 6: 
                case 7: 
                case 11: {
                    return this.zd;
                }
                case 8: {
                    Object[] objectArray = new Object[]{};
                    throw ReportExceptionFactory.createReportException(ReportErrorCode.rangeOnBoolean, objectArray);
                }
                case 9: {
                    return this.zd;
                }
                case 15: {
                    return this.zd;
                }
                case 10: {
                    return this.zd;
                }
            }
            Object[] objectArray = new Object[]{this.name};
            throw ReportExceptionFactory.createReportException(ReportErrorCode.wrongPromptType, objectArray);
        }
        Object[] objectArray = new Object[]{};
        throw ReportExceptionFactory.createReportException(ReportErrorCode.disabledRange, objectArray);
    }

    public void setPromptValueDescriptions(String[] descr) {
        if (descr == null) {
            throw new NullPointerException("description array is null");
        }
        int n2 = this.getDefaultValueCount();
        if (n2 != descr.length) {
            throw new IllegalArgumentException("description array's length(" + descr.length + ") does not match default value count (" + n2 + ")");
        }
        for (int i2 = 0; i2 < descr.length; ++i2) {
            String string = descr[i2];
            this.getDefaultValue(i2).setDescription(string);
        }
    }

    public String[] getPromptValueDescriptions() {
        if (this.yX != null) {
            DefaultValue[] defaultValueArray = this.yX.getDefaultValues();
            String[] stringArray = new String[defaultValueArray.length];
            for (int i2 = 0; i2 < defaultValueArray.length; ++i2) {
                DefaultValue defaultValue = defaultValueArray[i2];
                stringArray[i2] = defaultValue.getDescription();
            }
            return stringArray;
        }
        if (this.yW == null) {
            return new String[0];
        }
        String[] stringArray = new String[this.getDefaultValueCount()];
        for (int i3 = 0; i3 < this.getDefaultValueCount(); ++i3) {
            stringArray[i3] = this.getDefaultValue(i3).getDescription();
        }
        return stringArray;
    }

    @Override
    Field[] D(int n2) {
        return new PromptField[n2];
    }

    void fC() throws ReportException {
        this.value = null;
        this.valueSet = false;
        int n2 = this.getDefaultValueCount();
        if (this.yW == null || n2 == 0) {
            return;
        }
        if (this.za) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object = this.getDefaultValue(i2).getValue();
                if (!(object instanceof FormulaRange) && this.getDiscreteOrRangeType() == 1) continue;
                arrayList.add(object);
            }
            this.setPromptValue(arrayList.toArray());
        } else if (this.getDiscreteOrRangeType() != 0) {
            for (int i3 = 0; i3 < n2; ++i3) {
                Object object = this.getDefaultValue(i3).getValue();
                if (!(object instanceof FormulaRange)) continue;
                this.setPromptValue(object);
            }
        } else {
            this.setPromptValue(this.getDefaultValue(0).getValue());
        }
    }

    @Override
    public void setValueType(int newValue) {
        if (PromptUtils.isArray(newValue)) {
            newValue ^= 0x100;
            this.setAllowMultipleValues(true);
        }
        if (PromptUtils.isRange(newValue)) {
            newValue ^= 0x80;
            this.setDiscreteOrRangeType(1);
        }
        super.setValueType(newValue);
    }

    @Override
    public int getValueType() {
        int n2 = this.valueType;
        if (n2 == -1) {
            return n2;
        }
        if (this.za && !PromptUtils.isArray(n2)) {
            n2 += 256;
        }
        if (this.zb != 0 && !PromptUtils.isRange(n2)) {
            n2 += 128;
        }
        return n2;
    }

    @Override
    public String paramString() {
        StringBuilder stringBuilder = new StringBuilder(super.toString());
        stringBuilder.append("\n\tText: ").append(this.promptText);
        stringBuilder.append("\n\tType: ").append(this.valueType);
        stringBuilder.append("\n\tValue:").append(this.getValue());
        stringBuilder.append("\n\tLink: ").append(this.zj);
        return stringBuilder.toString();
    }

    public String getPromptValueAsFormula() {
        return PromptUtils.defaultPrompt(this.value, this.valueType);
    }

    public void setDefaultValueProvider(DynamicValueProvider provider) {
        if (provider instanceof CascadingValueProvider && this.a((CascadingValueProvider)provider)) {
            throw new IllegalArgumentException("Circular dependency: this prompt is already an ancestor of the prompt being set as parent!");
        }
        this.yX = provider;
        this.resetReferences();
        this.setReferences();
        if (provider != null) {
            this.yW = null;
        }
    }

    private boolean a(CascadingValueProvider cascadingValueProvider) {
        PromptField promptField = cascadingValueProvider.getParent();
        ArrayList<PromptField> arrayList = new ArrayList<PromptField>();
        while (true) {
            if (arrayList.contains(promptField)) {
                return true;
            }
            arrayList.add(promptField);
            if (promptField == this) {
                return true;
            }
            DynamicValueProvider dynamicValueProvider = promptField.getDefaultValueProvider();
            if (!(dynamicValueProvider instanceof CascadingValueProvider)) break;
            promptField = ((CascadingValueProvider)dynamicValueProvider).getParent();
        }
        return false;
    }

    public DynamicValueProvider getDefaultValueProvider() {
        return this.yX;
    }

    public DefaultValue[] getDefaultValues() {
        if (this.yX != null) {
            DefaultValue[] defaultValueArray;
            for (DefaultValue defaultValue : defaultValueArray = this.yX.getDefaultValues()) {
                if (PromptUtils.checkValueType(defaultValue.getValue(), this.valueType)) continue;
                BaseUtils.error("Dynamic default values were not the correct type: " + defaultValue.getValue().getClass().getCanonicalName() + " for value type " + this.getValueTypeString());
                return new DefaultValue[0];
            }
            if (this.yX instanceof SQLValueProvider && defaultValueArray.length == 1000) {
                this.setEditable(true);
            }
            return defaultValueArray;
        }
        if (this.yW == null) {
            return null;
        }
        return this.yW.toArray(new DefaultValue[0]);
    }

    public void setDefaultValues(DefaultValue[] values) {
        DefaultValue defaultValue;
        int n2;
        if (this.yW != null) {
            for (n2 = 0; n2 < this.yW.size(); ++n2) {
                defaultValue = this.yW.get(n2);
                if (!(defaultValue instanceof FormulaDefaultValue)) continue;
                FormulaField.d(((FormulaDefaultValue)defaultValue).getUnderlyingFormulaField());
            }
        }
        if (values == null || values.length == 0 || values[0] == null) {
            this.yW = null;
            this.yX = null;
            return;
        }
        if (this.isPasswordField()) {
            throw new UnsupportedOperationException("A password field can not have default values");
        }
        this.yW = new ArrayList();
        this.yX = null;
        for (n2 = 0; n2 < values.length; ++n2) {
            if (values[n2] instanceof FormulaDefaultValue) continue;
            try {
                this.e(values[n2].getValue());
                continue;
            }
            catch (ReportException reportException) {
                throw new IllegalArgumentException("The default value '" + String.valueOf(values[n2].getValue()) + "' is not in the allowed value range.");
            }
        }
        this.yW.clear();
        for (n2 = 0; n2 < values.length; ++n2) {
            defaultValue = values[n2];
            this.yW.add(defaultValue);
        }
        this.fD();
        this.resetReferences();
        this.setReferences();
    }

    public String getDefaultPromptValuesAsString() {
        DefaultValue[] defaultValueArray = this.getDefaultValues();
        if (defaultValueArray == null) {
            return "";
        }
        return PromptUtils.parsePrompt(defaultValueArray, this.valueType);
    }

    public void addDefaultValue(DefaultValue value) {
        this.a(value);
        this.fD();
    }

    private void fD() {
        if (this.bB != null && this.bB.gz > 0 || ((Boolean)bf.Dl.get()).booleanValue()) {
            try {
                this.fC();
            }
            catch (ReportException reportException) {
                BaseUtils.printStackTrace(reportException);
                throw new IllegalArgumentException("could not set default value as prompt's value:" + reportException.getMessage());
            }
        }
    }

    private void a(DefaultValue defaultValue) {
        FormulaField formulaField;
        if (this.isPasswordField()) {
            throw new UnsupportedOperationException("Password prompts can not have default values.");
        }
        try {
            this.e(defaultValue.getValue());
        }
        catch (ReportException reportException) {
            try {
                throw new IllegalArgumentException("default value (" + String.valueOf(defaultValue.getValue()) + ") was not in the allowed range (" + String.valueOf(this.getMinRangeValue()) + " to " + String.valueOf(this.getMaxRangeValue()) + ").");
            }
            catch (ReportException reportException2) {
                BaseUtils.printStackTrace(reportException2);
            }
        }
        if (this.yW == null) {
            this.yW = new ArrayList();
        }
        if (this.yX != null) {
            this.yX = null;
        }
        this.yW.add(defaultValue);
        if (defaultValue instanceof FormulaDefaultValue && (formulaField = ((FormulaDefaultValue)defaultValue).getUnderlyingFormulaField()) != null) {
            this.addReferencedObject(formulaField);
        }
    }

    public void removeDefaultValue(int index) {
        if (this.yW == null) {
            throw new IndexOutOfBoundsException("trying to remove a default value when there are none!");
        }
        this.yW.remove(index);
        if (this.yW.size() == 0) {
            this.yW = null;
        }
    }

    public int getDefaultValueCount() {
        if (this.yW == null) {
            return 0;
        }
        return this.yW.size();
    }

    public void setDefaultValue(int index, DefaultValue defaultValue) {
        try {
            this.e(defaultValue.getValue());
        }
        catch (ReportException reportException) {
            throw new IllegalArgumentException("trying to set illegal default value: " + reportException.getMessage());
        }
        if (this.yW == null) {
            throw new IndexOutOfBoundsException(index + " >= 0");
        }
        this.yW.set(index, defaultValue);
        this.fD();
    }

    @Override
    void a(int n2, String string, at at2) {
        try {
            switch (n2) {
                case 210: {
                    this.range = Boolean.valueOf(string);
                    break;
                }
                case 7701: {
                    this.editMask = string;
                    break;
                }
                case 216: {
                    this.zd = this.V(string);
                    break;
                }
                case 215: {
                    this.zc = this.V(string);
                    break;
                }
                case 208: {
                    this.zb = Integer.parseInt(string);
                    break;
                }
                case 209: {
                    this.promptText = string;
                    break;
                }
                case 223: {
                    if (at2.xM < this.getDefaultValueCount()) {
                        this.getDefaultValue(at2.xM).setDescription(string);
                        ++at2.xM;
                        break;
                    }
                    BaseUtils.warning("truncated prompt descriptions for prompt field " + this.getName() + " - the number of prompt values did not match the number of prompt descriptions!");
                    break;
                }
                case 221: {
                    Datasource datasource;
                    this.yY = string;
                    if (this.yY.trim().length() == 0) {
                        this.yY = this.name;
                    }
                    if (this.yY != null && (datasource = at2.wT.bM().jc().getDatasource(0)).getTableSourceCount() > 0 && this.yZ == null) {
                        this.yZ = datasource.getTableSource(0);
                    }
                    break;
                }
                case 207: {
                    this.zi = Boolean.valueOf(string);
                    break;
                }
                case 229: {
                    this.descOnly = Boolean.valueOf(string);
                    break;
                }
                case 206: {
                    this.za = Boolean.valueOf(string);
                    break;
                }
                case 214: {
                    this.zj = new Integer(Integer.parseInt(string));
                    break;
                }
                case 228: {
                    try {
                        this.yZ = at2.wT.bM().jc().getTablesource(string);
                    }
                    catch (ReportException reportException) {
                        BaseUtils.error(reportException);
                    }
                    break;
                }
                default: {
                    super.a(n2, string, at2);
                }
            }
        }
        catch (Throwable throwable) {
            BaseUtils.printStackTrace(throwable);
        }
    }

    private Object V(String string) {
        Comparable<java.util.Date> comparable = null;
        switch (this.getPromptType()) {
            case 6: 
            case 7: 
            case 11: {
                comparable = new Double(string);
                break;
            }
            case 9: {
                comparable = Date.valueOf(string);
                break;
            }
            case 10: {
                comparable = Time.valueOf(string);
                break;
            }
            case 15: {
                comparable = Timestamp.valueOf(string);
            }
        }
        return comparable;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    public boolean isParameterOfStoredProcedure() {
        return this.yY != null && this.yZ != null;
    }

    public TableSource[] getTableSources() {
        if (this.yZ == null) {
            return null;
        }
        return new TableSource[]{this.yZ};
    }

    public String[] getStoredProceduresParameterNames() {
        if (this.yY == null) {
            return null;
        }
        return new String[]{this.yY};
    }

    public boolean isSubreportLink() {
        return this.zk > 0;
    }

    @Override
    public boolean isUsed() {
        if (this.yZ != null || this.yY != null && this.yY.trim().length() > 0) {
            return true;
        }
        if (!super.isUsed()) {
            ReferenceHolder[] referenceHolderArray = this.getReferenceHolders();
            for (int i2 = 0; i2 < referenceHolderArray.length; ++i2) {
                if (!(referenceHolderArray[i2] instanceof PromptField) || !((PromptField)referenceHolderArray[i2]).isUsed()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    boolean f(TableSource tableSource) {
        if (super.isUsed()) {
            return false;
        }
        return this.yZ == tableSource;
    }

    public DefaultValue getDefaultValue(int i2) {
        if (this.yW == null) {
            throw new IndexOutOfBoundsException("trying to retrieve a default value when there are none!");
        }
        return this.yW.get(i2);
    }

    @Override
    protected void p(PrintWriter printWriter, int n2) {
        Object object;
        Object object2;
        String string = BaseUtils.getIndent(n2);
        StringBuilder stringBuilder = new StringBuilder();
        k.a(stringBuilder, n2, a.zp.name(), k.g(this.za));
        k.a(stringBuilder, n2, a.zq.name(), k.z(this.zb));
        k.a(stringBuilder, n2, a.zx.name(), k.g(this.zi));
        k.a(stringBuilder, n2, a.zr.name(), k.g(this.descOnly));
        k.a(stringBuilder, n2, a.zs.name(), this.editMask);
        if (this.range) {
            object2 = "";
            int n3 = this.getPromptType();
            if ((n3 == 6 || n3 == 7 || n3 == 11) && this.zc != null) {
                object2 = k.e(((Number)this.zc).doubleValue());
            } else if (n3 == 9 && this.zc != null) {
                object2 = this.zc.toString();
            } else if (n3 == 10 && this.zc != null) {
                object2 = this.zc.toString();
            } else if (n3 == 15 && this.zc != null) {
                object2 = this.zc.toString();
            }
            if (((String)object2).length() != 0) {
                k.a(stringBuilder, n2, a.zv.name(), (String)object2);
            }
            object = "";
            if ((n3 == 6 || n3 == 7 || n3 == 11) && this.zd != null) {
                object = k.e(((Number)this.zd).doubleValue());
            } else if (n3 == 9 && this.zd != null) {
                object = this.zd.toString();
            } else if (n3 == 10 && this.zd != null) {
                object = this.zd.toString();
            } else if (n3 == 15 && this.zd != null) {
                object = this.zd.toString();
            }
            if (((String)object).length() != 0) {
                k.a(stringBuilder, n2, a.zw.name(), (String)object);
            }
        }
        k.a(stringBuilder, n2, a.zt.name(), this.promptText);
        k.a(stringBuilder, n2, a.zu.name(), k.g(this.range));
        if (this.zj != null) {
            k.a(stringBuilder, n2, a.zz.name(), k.z(this.zj));
        }
        k.a(stringBuilder, n2, a.zB.name(), this.yY);
        if (this.yZ != null) {
            k.a(stringBuilder, n2, a.zA.name(), this.yZ.getAlias());
        }
        if (this.yX != null) {
            stringBuilder.append(string).append("<").append("DefaultValueProvider");
            if (this.yX instanceof QueryValueProvider) {
                PromptField promptField;
                String string2;
                object2 = (QueryValueProvider)this.yX;
                k.a(stringBuilder, "type", "sql");
                stringBuilder.append(">\n");
                stringBuilder.append(string);
                k.a(stringBuilder, n2, a.zE.name(), ((QueryValueProvider)object2).getQuery().replaceAll("\r\n", "\n"));
                String string3 = ((QueryValueProvider)object2).getFieldRefName();
                if (string3 != null) {
                    stringBuilder.append(string);
                    k.a(stringBuilder, n2, a.zF.name(), string3);
                }
                if ((string2 = ((Datasource)(object = ((QueryValueProvider)object2).getDatasource())).getDataSourceConfigurationName()) != null) {
                    stringBuilder.append(string);
                    k.a(stringBuilder, n2, a.zG.name(), string2);
                }
                if ((promptField = ((QueryValueProvider)object2).getParent()) != null) {
                    k.a(stringBuilder, n2, promptField, "cascading parent");
                }
            } else if (this.yX instanceof CascadingValueProvider) {
                k.a(stringBuilder, "type", "cascading");
                stringBuilder.append(">\n");
                object2 = (CascadingValueProvider)this.yX;
                stringBuilder.append(string);
                k.a(stringBuilder, n2, a.zy.name(), k.z(((FieldValueProvider)object2).getSortType()));
                stringBuilder.append(string);
                k.a(stringBuilder, n2, ((FieldValueProvider)object2).getValues(), "dynamic value field");
                if (((FieldValueProvider)object2).getDescriptions() != null) {
                    stringBuilder.append(string);
                    k.a(stringBuilder, n2, ((FieldValueProvider)object2).getDescriptions(), "dynamic description field");
                }
                stringBuilder.append(string);
                k.a(stringBuilder, n2, ((CascadingValueProvider)object2).getParent(), "cascading parent");
            } else if (this.yX instanceof FieldValueProvider) {
                k.a(stringBuilder, "type", "field");
                stringBuilder.append(">\n");
                object2 = (FieldValueProvider)this.yX;
                stringBuilder.append(string);
                k.a(stringBuilder, n2, a.zy.name(), k.z(((FieldValueProvider)object2).getSortType()));
                stringBuilder.append(string);
                k.a(stringBuilder, n2, ((FieldValueProvider)object2).getValues(), "dynamic value field");
                if (((FieldValueProvider)object2).getDescriptions() != null) {
                    stringBuilder.append(string);
                    k.a(stringBuilder, n2, ((FieldValueProvider)object2).getDescriptions(), "dynamic description field");
                }
            } else {
                stringBuilder.append(">\n");
                if (BaseUtils.isDebug()) {
                    BaseUtils.debug("could not save dynamic value provider");
                }
            }
            stringBuilder.append(string + "</DefaultValueProvider>\n");
        } else if (this.yW != null) {
            int n4 = this.getDefaultValueCount();
            stringBuilder.append(string + "<DefaultPromptValues>\n");
            String[] stringArray = this.getPromptValueDescriptions();
            for (int i2 = 0; i2 < n4; ++i2) {
                DefaultValue defaultValue;
                stringBuilder.append(string + string + "<DefaultValue");
                if (stringArray != null && stringArray.length > i2 && stringArray[i2] != null && !stringArray[i2].equals("")) {
                    stringBuilder.append(k.l("description", stringArray[i2]));
                }
                if ((defaultValue = this.getDefaultValue(i2)) instanceof FormulaDefaultValue) {
                    stringBuilder.append(">\n");
                    stringBuilder.append(string + string + string + k.h(((FormulaDefaultValue)defaultValue).getFormulaText()) + "\n");
                    stringBuilder.append(string + string + string);
                    k.a(stringBuilder, 0, FormulaField.a.se.name(), k.z(((FormulaDefaultValue)defaultValue).isBasicSyntax() ? 1002 : 1001));
                    stringBuilder.append(string + string + "</DefaultValue>\n");
                    continue;
                }
                stringBuilder.append(k.l("value", PromptUtils.parsePrompt(defaultValue.getValue(), this.getPromptType())));
                stringBuilder.append("/>\n");
            }
            stringBuilder.append(string + "</DefaultPromptValues>\n");
        }
        if (stringBuilder.length() > 0) {
            printWriter.print(stringBuilder);
        }
    }

    @Override
    public void parseText(String text, Map<String, Object> parserMap) {
        if ("formula".equals(parserMap.get("defaultvaluetype"))) {
            parserMap.put("defaultvalueformulatext", text);
        } else {
            super.parseText(text, parserMap);
        }
    }

    @Override
    public NodeParser parseElement(XMLTag group, String tag, Attributes atts, Map<String, Object> parserMap) throws FatalParserException {
        try {
            a a2 = a.valueOf(tag);
            String string = atts.getValue("value");
            switch (a2) {
                case zn: {
                    if (group != XMLTag.DefaultPromptValues) break;
                    String string2 = atts.getValue("value");
                    String string3 = atts.getValue("description");
                    if (string2 != null) {
                        DefaultValue defaultValue = DefaultValue.createDefaultValueFromFormula(string2, string3, this.bB.getEngine());
                        this.a(defaultValue);
                        break;
                    }
                    parserMap.put("defaultvaluetype", "formula");
                    parserMap.put("defaultvaluedescription", string3);
                    break;
                }
                case zI: {
                    parserMap.put("defaultvalueformulasyntax", Integer.valueOf(string));
                    break;
                }
                case zo: {
                    this.setName(string);
                    break;
                }
                case zt: {
                    this.setPromptText(string);
                    break;
                }
                case zp: {
                    this.setAllowMultipleValues(Boolean.valueOf(string));
                    break;
                }
                case zq: {
                    this.setDiscreteOrRangeType(Integer.valueOf(string));
                    break;
                }
                case zr: {
                    this.setDescriptionOnly(Boolean.valueOf(string));
                    break;
                }
                case zu: {
                    this.setUseRange(Boolean.valueOf(string));
                    break;
                }
                case zs: {
                    this.editMask = string;
                    break;
                }
                case zx: {
                    this.setEditable(Boolean.valueOf(string));
                    break;
                }
                case zz: {
                    this.zj = Integer.valueOf(string);
                    break;
                }
                case zA: {
                    try {
                        this.yZ = this.bB.jc().getTablesource(string);
                    }
                    catch (ReportException reportException) {
                        BaseUtils.error(reportException);
                    }
                    break;
                }
                case zB: {
                    this.yY = string;
                    if (this.yY.trim().length() != 0) break;
                    this.yY = this.name;
                    break;
                }
                case zv: {
                    this.zc = this.V(string);
                    break;
                }
                case zw: {
                    this.zd = this.V(string);
                    break;
                }
                case zD: {
                    String string4 = atts.getValue("type");
                    parserMap.put(b.zL.name(), this.bB.getEngine());
                    SQLValueProvider sQLValueProvider = null;
                    if ("sql".equals(string4)) {
                        sQLValueProvider = new QueryValueProvider();
                    } else if ("cascading".equals(string4)) {
                        sQLValueProvider = new CascadingValueProvider();
                    } else if ("field".equals(string4)) {
                        sQLValueProvider = new FieldValueProvider();
                    }
                    parserMap.put(b.zM.name(), sQLValueProvider);
                    return sQLValueProvider;
                }
            }
        }
        catch (ReportException reportException) {
            BaseUtils.printStackTrace(reportException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            BaseUtils.printStackTrace(illegalArgumentException);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseEndElement(XMLTag group, String tag, Map<String, Object> parserMap) throws FatalParserException {
        if (XMLTag.DefaultValue.name().equals(tag)) {
            String string = (String)parserMap.get("defaultvalueformulatext");
            Integer n2 = (Integer)parserMap.get("defaultvalueformulasyntax");
            String string2 = (String)parserMap.get("defaultvaluedescription");
            if (string != null && n2 != null && "formula".equals(parserMap.get("defaultvaluetype"))) {
                try {
                    FormulaField formulaField = this.bB.getEngine().getFields().addFormulaField("defaultvalueformula", string, 3);
                    formulaField.setSyntax(n2);
                    FormulaDefaultValue formulaDefaultValue = DefaultValue.createFormulaFieldDefaultValueFromFormula(formulaField, string2, this.getValueType(), this.bB.getEngine());
                    this.a(formulaDefaultValue);
                }
                catch (ReportException reportException) {
                    BaseUtils.printStackTrace(reportException);
                }
            }
            parserMap.remove("defaultvalueformulatext");
            parserMap.remove("defaultvaluedescription");
            parserMap.remove("defaultvalueformulasyntax");
            parserMap.remove("defaultvaluetype");
            super.parseEndElement(group, tag, parserMap);
            return;
        }
        DynamicValueProvider dynamicValueProvider = (DynamicValueProvider)parserMap.get(b.zM.name());
        if (dynamicValueProvider != null) {
            try {
                QueryValueProvider queryValueProvider;
                if (dynamicValueProvider instanceof CascadingValueProvider) {
                    CascadingValueProvider cascadingValueProvider = (CascadingValueProvider)dynamicValueProvider;
                    if (cascadingValueProvider.getParent() == null || cascadingValueProvider.getParent().getDefaultValueProvider() == null || cascadingValueProvider.getValues() == null) {
                        BaseUtils.warning("could not read cascading prompt: parent - " + String.valueOf(cascadingValueProvider.getParent()) + "; values - " + String.valueOf(cascadingValueProvider.getValues()));
                        return;
                    }
                } else if (dynamicValueProvider instanceof FieldValueProvider) {
                    FieldValueProvider fieldValueProvider = (FieldValueProvider)dynamicValueProvider;
                    if (fieldValueProvider.getValues() == null) {
                        BaseUtils.warning("could not read dynamic prompt: values - " + String.valueOf(fieldValueProvider.getValues()));
                        return;
                    }
                } else if (dynamicValueProvider instanceof QueryValueProvider && ((queryValueProvider = (QueryValueProvider)dynamicValueProvider).getQuery() == null || queryValueProvider.getDatasource() == null)) {
                    BaseUtils.warning("could not read dynamic query-based prompt: sql - " + queryValueProvider.getQuery() + "; datasource - " + String.valueOf(queryValueProvider.getDatasource()));
                    return;
                }
                this.setDefaultValueProvider(dynamicValueProvider);
            }
            finally {
                parserMap.remove(b.zM.name());
            }
        }
        this.fD();
        super.parseEndElement(group, tag, parserMap);
    }

    @Override
    public void addReferencedObject(ReferencedObject reference) {
        this.qj.addReferencedObject(reference);
    }

    @Override
    public void removeReferencedObject(ReferencedObject reference) {
        this.qj.removeReferencedObject(reference);
    }

    @Override
    public int getReferencedObjectCount() {
        return this.qj.getReferencedObjectCount();
    }

    @Override
    public ReferencedObject[] getReferencedObjects() {
        return this.qj.getReferencedObjects();
    }

    @Override
    public void resetReferences() {
        this.qj.resetReferences();
        if (this.yW != null) {
            for (int i2 = 0; i2 < this.yW.size(); ++i2) {
                FormulaField formulaField;
                DefaultValue defaultValue = this.yW.get(i2);
                if (!(defaultValue instanceof FormulaDefaultValue) || (formulaField = ((FormulaDefaultValue)defaultValue).getUnderlyingFormulaField()) == null) continue;
                formulaField.resetReferences();
            }
        }
    }

    @Override
    public final int getRealReferencedObjectCount() {
        return this.qj.getRealReferencedObjectCount();
    }

    @Override
    public void setReferences() {
        Field field;
        Serializable serializable;
        NodeParser nodeParser;
        DynamicValueProvider dynamicValueProvider = this.getDefaultValueProvider();
        if (dynamicValueProvider != null && dynamicValueProvider instanceof CascadingValueProvider) {
            nodeParser = ((CascadingValueProvider)dynamicValueProvider).getParent();
            ((Field)nodeParser).addReferenceHolder(this);
        }
        if (dynamicValueProvider != null && dynamicValueProvider instanceof FieldValueProvider) {
            nodeParser = (FieldValueProvider)dynamicValueProvider;
            serializable = ((FieldValueProvider)nodeParser).getValues();
            serializable.addReferenceHolder(this);
            field = ((FieldValueProvider)nodeParser).getDescriptions();
            if (field != null) {
                field.addReferenceHolder(this);
            }
        }
        if (this.yW != null) {
            for (int i2 = 0; i2 < this.yW.size(); ++i2) {
                serializable = this.yW.get(i2);
                if (!(serializable instanceof FormulaDefaultValue) || (field = ((FormulaDefaultValue)serializable).getUnderlyingFormulaField()) == null) continue;
                ((FormulaField)field).resetReferences();
                ((FormulaField)field).setReferences();
                field.addReferenceHolder(this);
            }
        }
    }

    @Override
    public Field duplicate(String name) {
        PromptField promptField;
        try {
            promptField = this.bB.getFields().addPromptField(name, this.getPromptText(), this.getPromptType());
            promptField.setAllowMultipleValues(this.getAllowMultipleValues());
            promptField.setDescriptionOnly(this.isDescriptionOnly());
            promptField.setDiscreteOrRangeType(this.getDiscreteOrRangeType());
            promptField.setEditable(this.isEditable());
            promptField.setUseRange(this.getUseRange());
            if (this.getUseRange()) {
                promptField.setMaxRangeValue(this.getMaxRangeValue());
                promptField.setMinRangeValue(this.getMinRangeValue());
            }
            if (this.getDefaultValueProvider() == null) {
                DefaultValue[] defaultValueArray = this.getDefaultValues();
                if (defaultValueArray != null) {
                    for (DefaultValue defaultValue : defaultValueArray) {
                        try {
                            promptField.addDefaultValue((DefaultValue)defaultValue.clone());
                        }
                        catch (CloneNotSupportedException cloneNotSupportedException) {
                            BaseUtils.printStackTrace(cloneNotSupportedException);
                        }
                    }
                }
            } else if (this.yX instanceof QueryValueProvider) {
                QueryValueProvider queryValueProvider = (QueryValueProvider)this.getDefaultValueProvider();
                promptField.setDefaultValueProvider(new QueryValueProvider(queryValueProvider.getQuery(), queryValueProvider.getDatasource()));
            } else if (this.yX instanceof CascadingValueProvider) {
                CascadingValueProvider cascadingValueProvider = (CascadingValueProvider)this.getDefaultValueProvider();
                promptField.setDefaultValueProvider(new CascadingValueProvider(cascadingValueProvider.getParent(), cascadingValueProvider.getParentSource(), cascadingValueProvider.getValues(), cascadingValueProvider.getDescriptions(), cascadingValueProvider.getSortType()));
            } else if (this.yX instanceof FieldValueProvider) {
                FieldValueProvider fieldValueProvider = (FieldValueProvider)this.getDefaultValueProvider();
                promptField.setDefaultValueProvider(new FieldValueProvider(fieldValueProvider.getValues(), fieldValueProvider.getDescriptions(), fieldValueProvider.getSortType()));
            } else {
                BaseUtils.warning("cannot duplicate default value provider while duplicating " + this.getName() + " - using no default value provider instead...");
            }
        }
        catch (ReportException reportException) {
            throw new IllegalArgumentException("cannot duplicate prompt field with name " + name, reportException);
        }
        return promptField;
    }

    void a(Evaluable evaluable) {
        this.zl = evaluable;
    }

    public Evaluable getFormulaAst() {
        return this.zl;
    }

    static void a(Object object, int n2, String string, String string2) throws ReportException {
        if (object == null) {
            return;
        }
        switch (n2 %= 128) {
            case 6: 
            case 7: {
                if (object instanceof Number) {
                    return;
                }
                if (object instanceof FormulaRange && (((FormulaRange)object).getFrom() instanceof Number && ((FormulaRange)object).getTo() instanceof Number || ((FormulaRange)object).getFrom() instanceof String || ((FormulaRange)object).getTo() instanceof String || ((FormulaRange)object).getFrom() == null || ((FormulaRange)object).getTo() == null)) {
                    return;
                }
                if (!(object instanceof Object[])) break;
                for (int i2 = 0; i2 < ((Object[])object).length; ++i2) {
                    PromptField.a(((Object[])object)[i2], n2, string, string2);
                }
                return;
            }
            case 8: {
                if (object instanceof Boolean) {
                    return;
                }
                if (object instanceof FormulaRange && ((((FormulaRange)object).getFrom() instanceof Boolean || ((FormulaRange)object).getFrom() == null) && ((FormulaRange)object).getTo() instanceof Boolean || ((FormulaRange)object).getTo() == null)) {
                    return;
                }
                if (!(object instanceof Object[])) break;
                for (int i3 = 0; i3 < ((Object[])object).length; ++i3) {
                    PromptField.a(((Object[])object)[i3], n2, string, string2);
                }
                return;
            }
            case 9: {
                if (object instanceof java.util.Date) {
                    return;
                }
                if (object instanceof FormulaRange && ((((FormulaRange)object).getFrom() instanceof java.util.Date || ((FormulaRange)object).getFrom() == null) && ((FormulaRange)object).getTo() instanceof java.util.Date || ((FormulaRange)object).getTo() == null)) {
                    return;
                }
                if (!(object instanceof Object[])) break;
                for (int i4 = 0; i4 < ((Object[])object).length; ++i4) {
                    PromptField.a(((Object[])object)[i4], n2, string, string2);
                }
                return;
            }
            case 10: {
                if (object instanceof java.util.Date) {
                    return;
                }
                if (object instanceof FormulaRange && ((((FormulaRange)object).getFrom() instanceof java.util.Date || ((FormulaRange)object).getFrom() == null) && ((FormulaRange)object).getTo() instanceof java.util.Date || ((FormulaRange)object).getTo() == null)) {
                    return;
                }
                if (!(object instanceof Object[])) break;
                for (int i5 = 0; i5 < ((Object[])object).length; ++i5) {
                    PromptField.a(((Object[])object)[i5], n2, string, string2);
                }
                return;
            }
            case 11: {
                if (object instanceof String) {
                    return;
                }
                if (object instanceof FormulaRange && ((((FormulaRange)object).getFrom() instanceof String || ((FormulaRange)object).getFrom() == null) && ((FormulaRange)object).getTo() instanceof String || ((FormulaRange)object).getTo() == null)) {
                    return;
                }
                if (!(object instanceof Object[])) break;
                for (int i6 = 0; i6 < ((Object[])object).length; ++i6) {
                    PromptField.a(((Object[])object)[i6], n2, string, string2);
                }
                return;
            }
            case 15: {
                if (object instanceof java.util.Date) {
                    return;
                }
                if (object instanceof FormulaRange) {
                    if ((!(((FormulaRange)object).getFrom() instanceof java.util.Date) && ((FormulaRange)object).getFrom() != null || !(((FormulaRange)object).getTo() instanceof java.util.Date)) && ((FormulaRange)object).getTo() != null) break;
                    return;
                }
                if (!(object instanceof Object[])) break;
                for (int i7 = 0; i7 < ((Object[])object).length; ++i7) {
                    PromptField.a(((Object[])object)[i7], n2, string, string2);
                }
                return;
            }
            case 14: {
                if (!(object instanceof byte[])) break;
                return;
            }
        }
        throw ReportExceptionFactory.createReportException(ReportErrorCode.WrongPromptData, string, object, object.getClass().getName(), string2);
    }

    public void copySPParametersTo(PromptField toField) {
        if (this.yY != null) {
            toField.yY = this.yY;
        }
        if (this.yZ != null) {
            try {
                TableSource tableSource = toField.bB.jc().getTablesource(this.yZ.getAlias());
                if (tableSource != null) {
                    toField.yZ = tableSource;
                }
            }
            catch (ReportException reportException) {
                BaseUtils.warning(reportException);
            }
        }
    }

    private static final class a
    extends Enum<a> {
        public static final /* enum */ a zn = new a();
        public static final /* enum */ a zo = new a();
        public static final /* enum */ a zp = new a();
        public static final /* enum */ a zq = new a();
        public static final /* enum */ a zr = new a();
        public static final /* enum */ a zs = new a();
        public static final /* enum */ a zt = new a();
        public static final /* enum */ a zu = new a();
        public static final /* enum */ a zv = new a();
        public static final /* enum */ a zw = new a();
        public static final /* enum */ a zx = new a();
        public static final /* enum */ a zy = new a();
        public static final /* enum */ a zz = new a();
        public static final /* enum */ a zA = new a();
        public static final /* enum */ a zB = new a();
        public static final /* enum */ a zC = new a();
        public static final /* enum */ a zD = new a();
        public static final /* enum */ a zE = new a();
        public static final /* enum */ a zF = new a();
        public static final /* enum */ a zG = new a();
        public static final /* enum */ a zH = new a();
        public static final /* enum */ a zI = new a();
        public static final /* enum */ a zJ = new a();
        private static final /* synthetic */ a[] zK;

        public static a[] values() {
            return (a[])zK.clone();
        }

        public static a valueOf(String name) {
            return Enum.valueOf(a.class, name);
        }

        private static /* synthetic */ a[] fE() {
            return new a[]{zn, zo, zp, zq, zr, zs, zt, zu, zv, zw, zx, zy, zz, zA, zB, zC, zD, zE, zF, zG, zH, zI, zJ};
        }

        static {
            zK = a.fE();
        }
    }

    static final class b
    extends Enum<b> {
        public static final /* enum */ b zL = new b();
        public static final /* enum */ b zM = new b();
        private static final /* synthetic */ b[] zN;

        public static b[] values() {
            return (b[])zN.clone();
        }

        public static b valueOf(String name) {
            return Enum.valueOf(b.class, name);
        }

        private static /* synthetic */ b[] fF() {
            return new b[]{zL, zM};
        }

        static {
            zN = b.fF();
        }
    }
}

