/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.report.BaseUtils;
import com.inet.report.DefaultValue;
import com.inet.report.FormulaField;
import com.inet.report.PropertyConstants;
import com.inet.report.ReportException;

public class FormulaDefaultValue
extends DefaultValue {
    private FormulaField ru;

    protected FormulaDefaultValue(FormulaField formulaField, String description, int type) {
        super(description, type);
        this.ru = formulaField;
        PropertyConstants.setPropertyDefault(this.ru, null, type);
    }

    public boolean isBasicSyntax() {
        return this.ru.getSyntax() == 1002;
    }

    @Override
    public Object getValue() {
        try {
            return this.ru.bB.dC().a(this.getFormulaText(), this.isBasicSyntax(), null, null);
        }
        catch (ReportException reportException) {
            BaseUtils.printStackTrace(reportException);
            return null;
        }
    }

    @Override
    public void setValue(Object value) {
        if (!(value instanceof FormulaField)) {
            throw new IllegalArgumentException("can not set anything but a formula field as a FormulaDefaultValue's value: " + String.valueOf(value));
        }
        this.ru.setFormula(((FormulaField)value).getFormula());
    }

    public String toString() {
        try {
            String string = "<html><b>formula:</b>&nbsp;<i>" + this.getFormulaText().replaceAll("\\s", "&nbsp;") + "</i>";
            return string;
        }
        catch (Exception exception) {
            return this.ru.getFormula();
        }
    }

    public String getFormulaText() {
        return this.ru.getFormula();
    }

    public FormulaField getUnderlyingFormulaField() {
        return this.ru;
    }

    public void setUnderlyingFormulaField(FormulaField underlying) {
        this.ru = underlying;
    }
}

