/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.InternalApi;
import com.inet.report.DatabaseField;
import com.inet.report.DatabaseReportData;
import com.inet.report.Datasource;
import com.inet.report.Engine;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.TableSource;
import com.inet.report.TablesourceList;
import com.inet.report.ba;
import com.inet.report.by;
import com.inet.report.database.BaseDataFactory;
import com.inet.report.database.ColumnInfo;
import com.inet.report.database.TableSourceInfo;
import com.inet.report.database.coredata.CoreData;
import com.inet.report.database.coredata.a;
import com.inet.report.database.coredata.b;
import com.inet.report.database.coredata.c;
import com.inet.report.database.fetch.DataCollector;
import com.inet.report.database.fetch.FetchTables;
import com.inet.report.event.EngineFinishEvent;
import com.inet.report.event.EngineFinishListener;
import com.inet.report.l;
import com.inet.report.prompt.Prompt;
import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import javax.annotation.SuppressFBWarnings;

@InternalApi
public class DatabaseCore
extends BaseDataFactory {
    private static WeakHashMap<ba<?>, c> kP = new WeakHashMap();
    private static WeakHashMap<ba<?>, a> kQ = new WeakHashMap();

    @Override
    public boolean getReportDataPerInstance() {
        return true;
    }

    @Override
    public void fetchData(Engine engine, FetchTables fetchTables, DataCollector collector) throws ReportException {
        ba<?> ba2 = engine.bB;
        ba2.jd().log();
        DatabaseCore.k(ba2).fetchData(engine, fetchTables, collector);
    }

    @Override
    public List<ColumnInfo> getColumns(TableSource ts) throws ReportException {
        try {
            a a2 = DatabaseCore.k(ts.getDatasource().getEngine().bM());
            return a2.k(ts.getDatabaseIdentifier());
        }
        catch (IOException iOException) {
            throw ReportExceptionFactory.createReportExceptionWithCause(iOException);
        }
    }

    @Override
    @Nonnull
    public Map<String, TableSourceInfo> getTableSourceInfos(Datasource ds, String catalog) throws ReportException {
        return Collections.emptyMap();
    }

    static void a(Engine engine, Properties properties) throws ReportException {
        if ("Core".equals(engine.getDatabaseTables().getDatasource(0).getDataSourceConfigurationName()) || engine.bM() instanceof DatabaseReportData.b) {
            return;
        }
        ba<?> ba2 = by.j(engine);
        Prompt[] promptArray = Engine.p(ba2);
        if (properties == null) {
            properties = new Properties();
        }
        for (Prompt prompt : promptArray) {
            properties.put("prompt" + prompt.getName(), "formula:" + prompt.getValue());
        }
        try {
            c c2 = c.O(ba2);
            if (c2 != null) {
                c2.g(properties);
                kP.put(ba2, c2);
            }
        }
        catch (IOException iOException) {
            throw ReportExceptionFactory.createReportExceptionWithCause(iOException);
        }
    }

    static void i(ba<?> ba2) throws ReportException {
        if (ba2 instanceof DatabaseReportData.b) {
            return;
        }
        try {
            c c2 = DatabaseCore.j(ba2);
            if (c2 == null) {
                return;
            }
            c2.P(ba2);
            TablesourceList tablesourceList = ba2.getEngine().getDatabaseTables().bL();
            for (int i2 = 0; i2 < tablesourceList.size(); ++i2) {
                TableSource tableSource = (TableSource)tablesourceList.get(i2);
                String string = CoreData.createTableFileName(tableSource.getDatabaseIdentifier());
                if (c2.aX(string)) continue;
                Properties properties = new Properties();
                for (DatabaseField databaseField : tableSource.getDatabaseFields()) {
                    properties.put(databaseField.getShortName(), Integer.toString(databaseField.getValueType()));
                }
                c2.b(string, properties);
            }
        }
        catch (IOException iOException) {
            throw ReportExceptionFactory.createReportExceptionWithCause(iOException);
        }
    }

    private static c j(ba<?> ba2) throws ReportException {
        Object var1_1 = ba2.isOnDemand() ? null : ba2.gH();
        return kP.get(var1_1 == null ? ba2 : var1_1);
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="path is not user specified")
    private static a k(ba<?> ba2) throws ReportException {
        final ba<?> ba3 = ba2.gH() == null ? ba2 : ba2.gH();
        a a2 = kQ.get(ba3);
        if (a2 == null) {
            try {
                File file = new File(URLDecoder.decode(ba3.getEngine().getReportFile().getFile(), "UTF-8"));
                a2 = CoreData.isCoreDataFile(file) ? new b(file) : new l(ba2);
                ba3.getEngine().addFinishListener(new EngineFinishListener(){

                    @Override
                    public void engineFinish(EngineFinishEvent event) {
                        a a2 = kQ.remove(ba3);
                        if (a2 != null) {
                            a2.close();
                        }
                    }
                });
                kQ.put(ba3, a2);
            }
            catch (IOException iOException) {
                throw ReportExceptionFactory.createReportExceptionWithCause(iOException);
            }
        }
        return a2;
    }
}

