/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.PublicApi;
import com.inet.classloader.LoaderUtils;
import com.inet.graphics.GraphicsBase;
import com.inet.jfree.chart.JFreeChart;
import com.inet.jfree.data.general.Dataset;
import com.inet.report.BaseUtils;
import com.inet.report.BorderProperties;
import com.inet.report.DChartUtilities;
import com.inet.report.Datasource;
import com.inet.report.Element;
import com.inet.report.Engine;
import com.inet.report.Field;
import com.inet.report.FormulaField;
import com.inet.report.Group;
import com.inet.report.HyperlinkProperties;
import com.inet.report.ReferenceHolder;
import com.inet.report.ReferencedObject;
import com.inet.report.ReportComponent;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.Section;
import com.inet.report.SpecifiedOrder;
import com.inet.report.SummaryField;
import com.inet.report.at;
import com.inet.report.chart.ChartTitle;
import com.inet.report.chart.Legend;
import com.inet.report.chart.LegendPlacement;
import com.inet.report.chart.a;
import com.inet.report.chart.b;
import com.inet.report.chart.dataset.BaseDataset;
import com.inet.report.chart.plot.AbstractPlot;
import com.inet.report.chart.plot.BarPlot;
import com.inet.report.chart.plot.BarStyle;
import com.inet.report.chart.plot.Chart3DStyle;
import com.inet.report.chart.plot.ChartPlot;
import com.inet.report.chart.plot.ChartStyle;
import com.inet.report.chart.plot.CombinedPlot;
import com.inet.report.chart.plot.StockStyle;
import com.inet.report.i;
import com.inet.report.i18n.Msg;
import com.inet.report.i18n.ReportErrorCode;
import com.inet.report.k;
import com.inet.report.parser.FatalParserException;
import com.inet.report.parser.XMLTag;
import com.inet.report.parser.d;
import com.inet.report.renderer.f;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.SuppressFBWarnings;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jfree.JCommon;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@PublicApi
public class Chart2
extends Element
implements BorderProperties,
HyperlinkProperties {
    public static final ChartStyle DEFAULT_CHART_STYLE = BarStyle.BAR2D;
    public static final String DEFAULT_FONT_NAME = "SansSerif";
    public static final ChartTitle DEFAULT_HEADER_TITLE = new ChartTitle(new Font("SansSerif", 2, 18), 255);
    public static final ChartTitle DEFAULT_SUBTITLE_TITLE = new ChartTitle(new Font("SansSerif", 1, 14), 0xFF0000);
    public static final ChartTitle DEFAULT_FOOTNOTE_TITLE = new ChartTitle(new Font("SansSerif", 2, 12), 0);
    public static final String PLOT_ORIENTATION_VERTICAL = "PlotOrientation.VERTICAL";
    public static final String PLOT_ORIENTATION_HORIZONTAL = "PlotOrientation.HORIZONTAL";
    private static boolean hD;
    private String hE;
    private ChartPlot hF;
    private ChartTitle hG;
    private ChartTitle hH;
    private ChartTitle hI;
    private Legend hJ;
    private transient at hK;
    private HashMap<Comparable<?>, Color> hL;
    private int hM;

    Chart2(Section parentSection, Engine engine) {
        this(DEFAULT_CHART_STYLE, parentSection, engine);
    }

    Chart2(ChartStyle style, Section parentSection, Engine engine) {
        super(42, engine.bB, parentSection);
        boolean bl2;
        if (style == null) {
            throw i.d("style");
        }
        this.hE = PLOT_ORIENTATION_VERTICAL;
        this.hF = style.getDefaultPlot();
        this.hG = DEFAULT_HEADER_TITLE.clone();
        this.hH = DEFAULT_SUBTITLE_TITLE.clone();
        this.hI = DEFAULT_FOOTNOTE_TITLE.clone();
        this.hJ = new Legend();
        boolean bl3 = bl2 = style instanceof StockStyle || style instanceof Chart3DStyle;
        if (bl2) {
            this.hJ.setLegendPlacement(LegendPlacement.NONE);
        }
    }

    at av() {
        return this.hK;
    }

    public String getPlotOrientation() {
        return this.hE;
    }

    public void setPlotOrientation(String plotOrientation) {
        if (plotOrientation == null) {
            throw i.d("plotOrientation");
        }
        if (!plotOrientation.equals(PLOT_ORIENTATION_HORIZONTAL) && !plotOrientation.equals(PLOT_ORIENTATION_VERTICAL)) {
            throw new IllegalArgumentException("Wrong plot orientation: " + plotOrientation);
        }
        this.hE = plotOrientation;
    }

    public ChartTitle getHeaderTitle() {
        return this.hG;
    }

    public void setHeaderTitle(ChartTitle headerTitle) {
        if (headerTitle == null) {
            throw i.d("headerTitle");
        }
        this.hG = headerTitle;
    }

    public ChartTitle getSubtitle() {
        return this.hH;
    }

    public void setSubtitle(ChartTitle subtitle) {
        if (subtitle == null) {
            throw i.d("subtitle");
        }
        this.hH = subtitle;
    }

    public ChartTitle getFootnote() {
        return this.hI;
    }

    public void setFootnote(ChartTitle footnote) {
        if (footnote == null) {
            throw i.d("footnote");
        }
        this.hI = footnote;
    }

    public ChartPlot getPlot() {
        return this.hF;
    }

    public void setPlot(ChartPlot plot) {
        if (plot == null) {
            throw i.d("plot");
        }
        this.hF = plot;
        this.updateReferences();
    }

    public Legend getLegend() {
        return this.hJ;
    }

    public void setLegend(Legend legend) {
        if (legend == null) {
            throw i.d("legend");
        }
        this.hJ = legend;
    }

    void a(Graphics2D graphics2D, Dataset[] datasetArray, Rectangle2D rectangle2D) {
        a a2 = null;
        try {
            this.az();
            a2 = new a(this);
            a2.a(this.isValid(), datasetArray);
        }
        catch (ReportException reportException) {
            graphics2D.dispose();
            BaseUtils.error(reportException);
        }
        if (a2 != null) {
            this.a(graphics2D, rectangle2D, true, a2);
        }
    }

    void b(Graphics2D graphics2D) throws ReportException {
        try {
            this.az();
        }
        catch (ReportException reportException) {
            graphics2D.dispose();
            throw reportException;
        }
        a a2 = new a(this);
        this.a(graphics2D, null, false, a2);
        BaseUtils.debugMemory("JFreeChart end");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(Graphics2D graphics2D, Rectangle2D rectangle2D, boolean bl2, a a2) throws UnsupportedOperationException {
        try {
            Rectangle2D rectangle2D2;
            if (this.isValid()) {
                if (bl2) {
                    this.aw();
                } else {
                    this.refreshAutoTitles();
                }
            }
            if (rectangle2D != null) {
                rectangle2D2 = rectangle2D;
            } else {
                double d2 = 15.0;
                if (graphics2D instanceof GraphicsBase) {
                    AffineTransform affineTransform = AffineTransform.getTranslateInstance((double)(this.ji + this.bB.gR() + this.bB.gT()) / 15.0, (double)(this.jj + this.bB.gS() + this.bB.gU()) / 15.0);
                    GraphicsBase graphicsBase = (GraphicsBase)graphics2D;
                    Shape shape = new Rectangle2D.Double(0.0, 0.0, (double)this.getWidth() / 15.0, (double)this.getHeight() / 15.0);
                    if (!graphicsBase.isSupportLocalCoordinates()) {
                        shape = affineTransform.createTransformedShape(shape);
                        graphicsBase.transform(affineTransform);
                    }
                    graphicsBase.setDeviceClip(shape);
                }
                rectangle2D2 = new Rectangle2D.Double(0.0, 0.0, (double)this.getWidth() / 15.0, (double)this.getHeight() / 15.0);
            }
            if (this.bB.gb()) {
                graphics2D = new f(graphics2D, rectangle2D2.getWidth());
            }
            a2.b(graphics2D, rectangle2D2);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw unsupportedOperationException;
        }
        catch (Throwable throwable) {
            String string = Msg.getMsg("UsingChartFailed", new Object[0]);
            super.getEngine().setErrorMsg(string);
            BaseUtils.error(string);
            BaseUtils.error(throwable);
        }
        finally {
            graphics2D.dispose();
            a2 = null;
        }
    }

    private boolean isValid() {
        if (this.getPlot() instanceof AbstractPlot) {
            AbstractPlot abstractPlot = (AbstractPlot)this.getPlot();
            return this.getPlot().getDataset() != null && this.getPlot().getDataset().verify(abstractPlot.getStyle()).length() == 0;
        }
        if (this.getPlot() instanceof CombinedPlot) {
            CombinedPlot combinedPlot = (CombinedPlot)this.getPlot();
            for (int i2 = 0; i2 < combinedPlot.size(); ++i2) {
                AbstractPlot abstractPlot = combinedPlot.getPlot(i2);
                BaseDataset baseDataset = abstractPlot.getDataset();
                if (baseDataset != null && baseDataset.verify(abstractPlot.getStyle()).length() == 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void refreshAutoTitles() {
        this.hF.refreshAutoTitles(this);
        a.setAutoTitle(this.hH, DChartUtilities.getGroupNameSubtitle(this, false));
    }

    private void aw() {
        this.hF.refreshAutoTitles(this);
        a.setAutoTitle(this.hH, DChartUtilities.getGroupNameSubtitle(this, true));
    }

    HashMap<Comparable<?>, Color> ax() {
        if (this.hL == null) {
            this.hL = new HashMap();
        }
        return this.hL;
    }

    int ay() {
        return this.hM++;
    }

    @Override
    void changeAllAliases(String oldAlias, String newAlias, Datasource dc) throws ReportException {
        List<Object> list = this.getReferencedObject();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (list.get(i2) instanceof Field) {
                ((Field)list.get(i2)).changeAllAliases(oldAlias, newAlias, dc);
                continue;
            }
            if (!(list.get(i2) instanceof Group)) continue;
            ((Group)list.get(i2)).changeAllAliases(oldAlias, newAlias, dc);
        }
        super.changeAllAliases(oldAlias, newAlias, dc);
    }

    @Override
    public List<FormulaField> getPropertyFormulas() {
        List<FormulaField> list = super.getPropertyFormulas();
        List<Object> list2 = this.getReferencedObject();
        for (Object object : list2) {
            if (object instanceof FormulaField && ((FormulaField)object).getFormulaType() == 3) {
                list.add((FormulaField)object);
                continue;
            }
            if (!(object instanceof Group)) continue;
            Group group = (Group)object;
            list.add(group.getGroupDirectionFormula());
            list.add(group.getGroupNameFormula());
            SpecifiedOrder specifiedOrder = group.getSpecifiedOrder();
            if (specifiedOrder == null || specifiedOrder.getCount() <= 0) continue;
            for (int i2 = 0; i2 < specifiedOrder.getCount(); ++i2) {
                list.add(specifiedOrder.getFormulaField(i2));
            }
        }
        for (FormulaField formulaField : list) {
            formulaField.rP = this;
        }
        return list;
    }

    @Override
    public void resetReferences() {
        super.resetReferences();
        List<Object> list = this.getReferencedObject();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Object object = list.get(i2);
            if (object instanceof ReferencedObject) {
                if (!(object instanceof SummaryField) && !(object instanceof Group)) {
                    ((ReferencedObject)object).removeReferenceHolder(this);
                }
                if (object instanceof ReferenceHolder) {
                    ((ReferenceHolder)object).resetReferences();
                }
            }
            if (!(object instanceof SpecifiedOrder)) continue;
            SpecifiedOrder specifiedOrder = (SpecifiedOrder)object;
            for (int i3 = 0; i3 < specifiedOrder.getCount(); ++i3) {
                specifiedOrder.getFormulaField(i3).resetReferences();
            }
        }
    }

    @Override
    public void setReferences() {
        super.setReferences();
        List<Object> list = this.getReferencedObject();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Object object = list.get(i2);
            if (!(object instanceof ReferencedObject)) continue;
            if (!(object instanceof SummaryField) && !(object instanceof Group)) {
                ((ReferencedObject)object).addReferenceHolder(this);
            }
            if (!(object instanceof ReferenceHolder)) continue;
            ((ReferenceHolder)object).setReferences();
        }
    }

    public void updateReferences() {
        this.resetReferences();
        this.setReferences();
    }

    private List<Object> getReferencedObject() {
        ChartTitle[] chartTitleArray;
        ArrayList<Object> arrayList = new ArrayList();
        if (this.getPlot() != null) {
            arrayList = this.getPlot().getReferencedObject();
        }
        for (ChartTitle chartTitle : chartTitleArray = new ChartTitle[]{this.getHeaderTitle(), this.getSubtitle(), this.getFootnote()}) {
            if (chartTitle == null || chartTitle.getTitleFormula() == null) continue;
            arrayList.add(chartTitle.getTitleFormula());
        }
        return arrayList;
    }

    @Override
    void k(PrintWriter printWriter, int n2) {
        String string = BaseUtils.getIndent(n2);
        printWriter.print(string + "<Element" + k.l("type", this.getTypeAsString()) + k.l("subtype", "extended") + this.cf() + ">\n");
        this.saveProperties(printWriter, ++n2);
        this.b(printWriter, n2, Element.ma);
        this.a(printWriter, n2, Element.ma);
        this.r(printWriter, n2);
        printWriter.print(string + "</Element>\n");
    }

    private void saveProperties(PrintWriter out, int depth) {
        String string = BaseUtils.getIndent(depth);
        ++depth;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.getPlotOrientation().equals(PLOT_ORIENTATION_HORIZONTAL)) {
            com.inet.report.chart.f.b(stringBuilder, depth, "Orientation", this.getPlotOrientation());
        }
        if (!this.hG.isEqualToDefault(DEFAULT_HEADER_TITLE)) {
            this.hG.saveProperties(stringBuilder, "Header", depth);
        }
        if (!this.hI.isEqualToDefault(DEFAULT_FOOTNOTE_TITLE)) {
            this.hI.saveProperties(stringBuilder, "Footnote", depth);
        }
        if (!this.hH.isEqualToDefault(DEFAULT_SUBTITLE_TITLE)) {
            this.hH.saveProperties(stringBuilder, "Subtitle", depth);
        }
        com.inet.report.chart.f.a(out, string, "Chart2Properties", null, false);
        if (stringBuilder.length() > 0) {
            out.print(stringBuilder.toString());
        }
        this.hJ.saveProperties(out, depth);
        this.hF.saveProperties(out, depth);
        com.inet.report.chart.f.a(out, string, "Chart2Properties", null, true);
    }

    @SuppressFBWarnings(value={"XXE_DOCUMENT"}, justification="DTD is already disabled in the factory")
    void a(BufferedReader bufferedReader, at at2) {
        this.hK = at2;
        DocumentBuilderFactory documentBuilderFactory = LoaderUtils.newDocumentBuilderFactory();
        b b2 = new b("Chart2Properties");
        Document document = null;
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(new InputSource(b2.a(bufferedReader)));
        }
        catch (SAXException sAXException) {
            BaseUtils.error("Exception was occurs while parsing chart XML.");
            BaseUtils.printStackTrace(sAXException);
            return;
        }
        catch (IOException iOException) {
            BaseUtils.error("Exception was occurs while reading chart XML.");
            BaseUtils.printStackTrace(iOException);
            return;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            BaseUtils.error("Exception was occurs while parsing chart XML by wrong parser configuration.");
            BaseUtils.printStackTrace(parserConfigurationException);
            return;
        }
        this.a(document.getDocumentElement());
    }

    void a(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            if (!(nodeList.item(i2) instanceof org.w3c.dom.Element)) continue;
            org.w3c.dom.Element element = (org.w3c.dom.Element)nodeList.item(i2);
            try {
                Object object;
                if (element.getNodeName().equals("Orientation")) {
                    if (element.getAttribute("value").equals(PLOT_ORIENTATION_HORIZONTAL)) {
                        this.setPlotOrientation(PLOT_ORIENTATION_HORIZONTAL);
                    } else if (element.getAttribute("value").equals(PLOT_ORIENTATION_VERTICAL)) {
                        this.setPlotOrientation(PLOT_ORIENTATION_VERTICAL);
                    }
                }
                if (element.getNodeName().equals("Header")) {
                    this.getHeaderTitle().readProperties(element, this);
                }
                if (element.getNodeName().equals("Subtitle")) {
                    this.getSubtitle().readProperties(element, this);
                }
                if (element.getNodeName().equals("Footnote")) {
                    this.getFootnote().readProperties(element, this);
                }
                if (element.getNodeName().equals("Legend")) {
                    this.getLegend().readProperties(element);
                }
                if (element.getNodeName().equals("Plot")) {
                    object = element.getAttribute("style");
                    if (((String)object).length() > 0) {
                        if (!((String)object).equals(BarPlot.DEFAULT_STYLE.toString())) {
                            AbstractPlot abstractPlot = com.inet.report.chart.f.aJ((String)object).getDefaultPlot();
                            this.setPlot(abstractPlot);
                        }
                    } else {
                        throw new IllegalArgumentException("Chart style name missing.");
                    }
                    this.getPlot().readProperties(element, this);
                }
                if (!element.getNodeName().equals("CombinedPlot")) continue;
                object = new CombinedPlot();
                this.setPlot((ChartPlot)object);
                ((CombinedPlot)object).readProperties(element, this);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                BaseUtils.error("Parsing Chart2 failed!");
                BaseUtils.error(illegalArgumentException);
            }
        }
    }

    @Override
    public boolean isDOMParser() {
        return true;
    }

    @Override
    public void parseDOM(Node node, Map<String, Object> parserMap) throws FatalParserException {
        Node node2 = node.getFirstChild();
        this.a(node2);
        node.removeChild(node2);
        if (node.hasChildNodes()) {
            this.b(node);
        }
    }

    private void b(Node node) {
        try {
            int n2;
            TransformerFactory transformerFactory = LoaderUtils.newTransformerFactory();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "yes");
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            DOMSource dOMSource = new DOMSource(node);
            transformer.transform(dOMSource, streamResult);
            Object object = stringWriter.toString();
            String string = XMLTag.Element.name();
            if (string.equals(node.getNodeName()) && (n2 = ((String)object).indexOf(">")) > 0) {
                object = d.bV(string) + ((String)object).substring(n2 + 1);
            }
            com.inet.report.parser.b b2 = new com.inet.report.parser.b();
            b2.a(this, XMLTag.Element, ((String)object).getBytes());
        }
        catch (TransformerException transformerException) {
            BaseUtils.error("Parsing Chart2 failed!");
        }
        catch (ReportException reportException) {
            BaseUtils.error("Parsing Chart2 failed!");
        }
    }

    private void az() throws ReportException {
        if (hD) {
            return;
        }
        try {
            LoaderUtils.classForName((String)"org.jfree.JCommon", (Object)this);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Object[] objectArray = new Object[]{classNotFoundException};
            throw ReportExceptionFactory.createReportException(ReportErrorCode.JCommonNotFound, objectArray);
        }
        if (BaseUtils.isDebug()) {
            BaseUtils.debug("JCommon: " + JCommon.INFO.getName() + " " + JCommon.INFO.getVersion());
        }
        try {
            LoaderUtils.classForName((String)"org.jfree.chart.JFreeChart", (Object)this);
            BaseUtils.warning("Original version of JFreeChart found in the classpath, this may cause a problem.");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            LoaderUtils.classForName((String)"com.inet.jfree.chart.JFreeChart", (Object)this);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Object[] objectArray = new Object[]{classNotFoundException};
            throw ReportExceptionFactory.createReportException(ReportErrorCode.JFreeChartCCNotFound, objectArray);
        }
        if (!JFreeChart.INFO.getName().equals("JFreeChart for i-net Clear Reports") || !JFreeChart.INFO.getVersion().equals("1.0.13.3")) {
            Object[] objectArray = new Object[]{JFreeChart.INFO.getName(), JFreeChart.INFO.getVersion(), "JFreeChart for i-net Clear Reports", "1.0.13.3"};
            throw ReportExceptionFactory.createReportException(ReportErrorCode.JFreeChartWrongVersion, objectArray);
        }
        if (BaseUtils.isDebug()) {
            BaseUtils.debug("The inet version of JFreeChart found.");
        }
        hD = true;
    }

    @Override
    public List<? extends ReportComponent> getSubComponents() {
        return null;
    }
}

