/*
 * Decompiled with CFR 0.152.
 */
package com.inet.problemfinder.i18n;

import com.inet.report.AbstractFontElement;
import com.inet.report.Area;
import com.inet.report.BaseUtils;
import com.inet.report.Element;
import com.inet.report.Field;
import com.inet.report.FieldPart;
import com.inet.report.Group;
import com.inet.report.Paragraph;
import com.inet.report.ReportException;
import com.inet.report.Section;
import com.inet.report.Subreport;
import com.inet.report.Text;
import com.inet.report.TextPart;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class Msg {
    private static final ResourceBundle bc = ResourceBundle.getBundle("com.inet.problemfinder.i18n.LanguageResources");

    public static String getMsg(String msgID, Object param0, Object param1, Object param2, Object param3) {
        return Msg.getMsg(msgID, new Object[]{param0, param1, param2, param3});
    }

    public static String getMsg(String msgID, Object param0, Object param1, Object param2) {
        return Msg.getMsg(msgID, new Object[]{param0, param1, param2});
    }

    public static String getMsg(String msgID, Object param0, Object param1) {
        return Msg.getMsg(msgID, new Object[]{param0, param1});
    }

    public static String getMsg(String msgID, Object param0) {
        return Msg.getMsg(msgID, new Object[]{param0});
    }

    public static String getMsg(String msgID) {
        Object object;
        try {
            object = bc.getString(msgID);
        }
        catch (Throwable throwable) {
            object = "$" + msgID + "$";
        }
        return object;
    }

    public static boolean existsMsg(String msgID) {
        try {
            bc.getString(msgID);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static String getMsgColon(String msgID) {
        String string;
        try {
            string = bc.getString(msgID);
        }
        catch (Throwable throwable) {
            return "$" + msgID + "$";
        }
        return string + ":";
    }

    public static String getMsg(String msgID, Object[] msgParameter) {
        int n2;
        StringBuffer stringBuffer;
        Object object;
        try {
            object = bc.getString(msgID);
        }
        catch (Throwable throwable) {
            stringBuffer = new StringBuffer();
            stringBuffer.append(msgID);
            stringBuffer.append('(');
            for (n2 = 0; n2 < msgParameter.length; ++n2) {
                if (n2 > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append('{');
                stringBuffer.append(n2);
                stringBuffer.append('}');
            }
            stringBuffer.append(')');
            object = "$" + MessageFormat.format(stringBuffer.toString(), msgParameter) + "$";
        }
        try {
            object = MessageFormat.format((String)object, msgParameter);
        }
        catch (Throwable throwable) {
            stringBuffer = new StringBuffer();
            stringBuffer.append('$').append(throwable.toString()).append('_').append(msgID).append('(');
            for (n2 = 0; n2 < msgParameter.length; ++n2) {
                if (n2 > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(msgParameter[n2]);
            }
            stringBuffer.append(')').append('$');
            object = stringBuffer.toString();
        }
        return object;
    }

    public static ResourceBundle getLanguageResources() {
        return bc;
    }

    public static String getElementDisplayName(Element e2) {
        String string = Msg.getElementTypeName(e2.getType());
        switch (e2.getType()) {
            case 35: {
                Text text = (Text)e2;
                Object object = Msg.getTotalText(text);
                if (((String)object).length() > 13) {
                    object = ((String)object).substring(0, 10) + "...";
                }
                return string + " \"" + (String)object + "\"";
            }
            case 36: {
                return Msg.getFieldDisplayName(e2.getField());
            }
            case 39: {
                Subreport subreport = (Subreport)e2;
                try {
                    return string + " \"" + subreport.getEngine().getReportTitle() + "\"";
                }
                catch (ReportException reportException) {
                    if (!BaseUtils.isDebug()) break;
                    BaseUtils.debug(reportException);
                }
            }
        }
        return string;
    }

    public static String getTotalText(Text text) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < text.getParagraphCount(); ++i2) {
            Paragraph paragraph = text.getParagraph(i2);
            for (int i3 = 0; i3 < paragraph.getPartCount(); ++i3) {
                AbstractFontElement abstractFontElement = (AbstractFontElement)paragraph.getPart(i3);
                if (abstractFontElement instanceof FieldPart) {
                    stringBuilder.append(abstractFontElement.getField().getPlaceholderName());
                }
                if (!(abstractFontElement instanceof TextPart)) continue;
                stringBuilder.append(((TextPart)abstractFontElement).getText());
            }
        }
        return stringBuilder.toString();
    }

    public static String getFieldDisplayName(Field f2) {
        StringBuilder stringBuilder = new StringBuilder(Msg.getLocalizedFieldTypeName(f2.getType()));
        stringBuilder.append(" \"");
        stringBuilder.append(f2.getName());
        stringBuilder.append("\" ");
        return stringBuilder.toString();
    }

    public static String getLocalizedFieldTypeName(int fieldType) {
        switch (fieldType) {
            case 10: {
                return Msg.getMsg("Special_Field");
            }
            case 11: {
                return Msg.getMsg("Summary_Field");
            }
            case 12: {
                return Msg.getMsg("Group_Name_Field");
            }
            case 13: {
                return Msg.getMsg("Formula_Field");
            }
            case 14: {
                return Msg.getMsg("Database_Field");
            }
            case 15: {
                return Msg.getMsg("Sort_Field");
            }
            case 16: {
                return Msg.getMsg("prompt.field");
            }
            case 17: {
                return Msg.getMsg("SQL_Expression_Field");
            }
        }
        return Msg.getMsg("Unknown");
    }

    public static final String getElementTypeName(int elementtype) {
        switch (elementtype) {
            case 38: {
                return Msg.getMsg("Box");
            }
            case 42: {
                return Msg.getMsg("Chart");
            }
            case 49: {
                return Msg.getMsg("CrossTab");
            }
            case 68: {
                return Msg.getMsg("JavaBean");
            }
            case 37: {
                return Msg.getMsg("Line");
            }
            case 46: {
                return Msg.getMsg("Picture");
            }
            case 39: {
                return Msg.getMsg("Subreport");
            }
            case 35: {
                return Msg.getMsg("TextObject");
            }
            case 70: {
                return Msg.getMsg("Signature");
            }
            case 48: {
                return Msg.getMsg("Database_Picture");
            }
        }
        return Msg.getMsg("Unknown");
    }

    public static String getAreaName(Area area) {
        switch (area.getType()) {
            case 0: {
                return Msg.getMsg("Report_Header");
            }
            case 3: {
                return Msg.getMsg("Report_Footer");
            }
            case 1: {
                return Msg.getMsg("Page_Header");
            }
            case 4: {
                return Msg.getMsg("Page_Footer");
            }
            case 2: {
                return Msg.getMsg("Detail");
            }
            case 5: {
                Group group = (Group)area.getParent();
                return Msg.getMsg("groupHeader", new Integer(group.indexOf()));
            }
            case 6: {
                Group group = (Group)area.getParent();
                return Msg.getMsg("groupFooter", new Integer(group.indexOf()));
            }
        }
        return Msg.getMsg("Utils.Unknown_Area");
    }

    public static String getValueTypeString(int valueType) {
        switch (valueType) {
            case 6: {
                return "NUMBER";
            }
            case 7: {
                return "CURRENCY";
            }
            case 8: {
                return "BOOLEAN";
            }
            case 9: {
                return "DATE";
            }
            case 10: {
                return "TIME";
            }
            case 11: {
                return "STRING";
            }
            case 14: {
                return "BINARY";
            }
            case 15: {
                return "DATETIME";
            }
            case -10: {
                return "CURSOR";
            }
        }
        return "UNKNOWN";
    }

    public static String getSectionName(Section section) throws IllegalStateException, ReportException {
        return Msg.getAreaName((Area)section.getParent()) + " - " + section.getSectionNameByNumber(section.indexOf());
    }
}

