/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jfree.chart.title;

import com.inet.jfree.chart.LegendItem;
import com.inet.jfree.chart.MultiColumnLegendItem;
import com.inet.jfree.chart.block.Arrangement;
import com.inet.jfree.chart.block.Block;
import com.inet.jfree.chart.block.BlockContainer;
import com.inet.jfree.chart.block.BorderArrangement;
import com.inet.jfree.chart.block.CenterArrangement;
import com.inet.jfree.chart.block.LabelBlock;
import com.inet.jfree.chart.block.RectangleConstraint;
import com.inet.jfree.chart.title.LegendGraphic;
import com.inet.jfree.chart.title.LegendItemBlockContainer;
import com.inet.jfree.chart.title.LegendTitle;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.Size2D;

public class MultiColumnLegendTitle
extends LegendTitle {
    public MultiColumnLegendTitle(LegendTitle legend) {
        super(legend.getSources()[0]);
        super.setMargin(legend.getMargin());
        super.setFrame(legend.getFrame());
        super.setBackgroundPaint(legend.getBackgroundPaint());
        super.setPosition(legend.getPosition());
    }

    @Override
    protected Block createLegendItemBlock(LegendItem item) {
        BlockContainer result = null;
        LegendGraphic lg = new LegendGraphic(item.getShape(), item.getFillPaint());
        lg.setShapeFilled(item.isShapeFilled());
        lg.setLine(item.getLine());
        lg.setLineStroke(item.getLineStroke());
        lg.setLinePaint(item.getLinePaint());
        lg.setLineVisible(item.isLineVisible());
        lg.setShapeVisible(item.isShapeVisible());
        lg.setShapeOutlineVisible(item.isShapeOutlineVisible());
        lg.setOutlinePaint(item.getOutlinePaint());
        lg.setOutlineStroke(item.getOutlineStroke());
        lg.setPadding(this.getLegendItemGraphicPadding());
        LegendItemBlockContainer legendItem = new LegendItemBlockContainer((Arrangement)new BorderArrangement(), item.getDataset(), item.getSeriesKey());
        lg.setShapeAnchor(this.getLegendItemGraphicAnchor());
        lg.setShapeLocation(this.getLegendItemGraphicLocation());
        legendItem.add(lg, this.getLegendItemGraphicEdge());
        if (item instanceof MultiColumnLegendItem) {
            List labels = ((MultiColumnLegendItem)item).getLabels();
            LegendItemBlockContainer currentLegendItem = legendItem;
            if (!labels.isEmpty()) {
                for (int i = labels.size() - 1; i >= 0; --i) {
                    LegendItemBlockContainer tempLegendItem = null;
                    if (i == labels.size() - 1) {
                        tempLegendItem = currentLegendItem;
                    } else {
                        tempLegendItem = new LegendItemBlockContainer((Arrangement)new BorderArrangement(), item.getDataset(), item.getSeriesKey());
                        currentLegendItem.add(tempLegendItem);
                    }
                    String key = (String)labels.get(i);
                    LabelBlock labelBlock = new LabelBlock(key, this.getItemFont(), this.getItemPaint());
                    labelBlock.setPadding(this.getItemLabelPadding());
                    if (i == 0) {
                        tempLegendItem.add(labelBlock);
                        continue;
                    }
                    tempLegendItem.add(labelBlock, RectangleEdge.RIGHT);
                    currentLegendItem = tempLegendItem;
                }
            }
        } else {
            LabelBlock labelBlock = new LabelBlock(item.getLabel(), this.getItemFont(), this.getItemPaint());
            labelBlock.setPadding(this.getItemLabelPadding());
            legendItem.add(labelBlock);
        }
        legendItem.setToolTipText(item.getToolTipText());
        legendItem.setURLText(item.getURLText());
        result = new BlockContainer(new CenterArrangement());
        result.add(legendItem);
        return result;
    }

    @Override
    public Size2D arrange(Graphics2D g2, RectangleConstraint constraint) {
        double newRigthPadding;
        RectangleInsets padding;
        Rectangle2D rec;
        LegendItemBlockContainer legendItem;
        BlockContainer block;
        int i;
        Size2D result = new Size2D();
        this.fetchLegendItems();
        if (this.getItemContainer().isEmpty()) {
            return result;
        }
        BlockContainer container = this.getItemContainer();
        RectangleConstraint c = null;
        c = this.getMaxWidth() != 0.0 ? this.toMaxConstraint(constraint, this.getPosition(), this.getMaxWidth()) : this.toContentConstraint(constraint);
        Size2D size = container.arrange(g2, c);
        result.height = this.calculateTotalHeight(size.height);
        result.width = this.calculateTotalWidth(size.width);
        BlockContainer blockContainer = this.getItemContainer();
        double maxWidth = 0.0;
        List blocks = blockContainer.getBlocks();
        for (i = 0; i < blocks.size(); ++i) {
            block = (BlockContainer)blocks.get(i);
            legendItem = this.getInternLegendItemBlockContainer(block, 2, 0);
            if (legendItem == null || !(maxWidth < legendItem.getBounds().getWidth())) continue;
            maxWidth = legendItem.getBounds().getWidth();
        }
        for (i = 0; i < blocks.size(); ++i) {
            block = (BlockContainer)blocks.get(i);
            legendItem = this.getInternLegendItemBlockContainer(block, 2, 0);
            if (legendItem == null) continue;
            rec = legendItem.getBounds();
            padding = legendItem.getPadding();
            newRigthPadding = padding.getRight() + maxWidth - rec.getWidth() + 10.0;
            padding = new RectangleInsets(padding.getUnitType(), padding.getTop(), padding.getLeft(), padding.getBottom(), newRigthPadding);
            legendItem.setPadding(padding);
        }
        size = container.arrange(g2, c);
        maxWidth = 0.0;
        for (i = 0; i < blocks.size(); ++i) {
            block = (BlockContainer)blocks.get(i);
            legendItem = this.getInternLegendItemBlockContainer(block, 1, 0);
            if (legendItem == null || !(maxWidth < legendItem.getBounds().getWidth())) continue;
            maxWidth = legendItem.getBounds().getWidth();
        }
        for (i = 0; i < blocks.size(); ++i) {
            block = (BlockContainer)blocks.get(i);
            legendItem = this.getInternLegendItemBlockContainer(block, 1, 0);
            if (legendItem == null) continue;
            rec = legendItem.getBounds();
            padding = legendItem.getPadding();
            newRigthPadding = padding.getRight() + maxWidth - rec.getWidth() + 10.0;
            padding = new RectangleInsets(padding.getUnitType(), padding.getTop(), padding.getLeft(), padding.getBottom(), newRigthPadding);
            legendItem.setPadding(padding);
        }
        size = container.arrange(g2, c);
        result.height = this.calculateTotalHeight(size.height);
        result.width = this.calculateTotalWidth(size.width);
        return result;
    }

    private LegendItemBlockContainer getInternLegendItemBlockContainer(BlockContainer blockContainer, int depth, int currentDepth) {
        if (blockContainer == null) {
            throw new IllegalArgumentException("Null 'blockContainer' argument.");
        }
        for (Block block : blockContainer.getBlocks()) {
            if (!(block instanceof LegendItemBlockContainer)) continue;
            if (depth <= currentDepth) {
                return (LegendItemBlockContainer)block;
            }
            return this.getInternLegendItemBlockContainer((LegendItemBlockContainer)block, depth, currentDepth + 1);
        }
        return null;
    }
}

