/*
 * Decompiled with CFR 0.152.
 */
package com.inet.viewer.client;

import com.inet.annotations.InternalApi;
import com.inet.viewer.ViewerUtils;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class InetCookieHandler
extends CookieHandler {
    private static List<a> bMz;
    private List<a> bMA = new LinkedList<a>();

    public InetCookieHandler() {
        this(bMz);
    }

    private InetCookieHandler(@Nullable List<a> initial) {
        if (initial != null) {
            this.bMA.addAll(initial);
        }
    }

    @Nonnull
    public static InetCookieHandler create(@Nonnull URL url, String cookies) {
        ArrayList<a> arrayList;
        try {
            URI uRI = url.toURI();
            arrayList = InetCookieHandler.a(uRI, cookies);
        }
        catch (URISyntaxException uRISyntaxException) {
            ViewerUtils.error("Invalid url: " + String.valueOf(url) + "\n" + String.valueOf(uRISyntaxException));
            arrayList = null;
        }
        return new InetCookieHandler(arrayList);
    }

    public static void setInitialCookie(URI uri, String cookies) {
        bMz = InetCookieHandler.a(uri, cookies);
    }

    @Nonnull
    private static ArrayList<a> a(URI uRI, String string) {
        ArrayList<a> arrayList = new ArrayList<a>();
        if (string != null) {
            for (String string2 : string.split(";")) {
                string2 = string2.trim();
                try {
                    arrayList.add(new a(uRI, string2));
                }
                catch (RuntimeException runtimeException) {
                    ViewerUtils.error("Invalid cookie: " + string2 + "\n" + String.valueOf(runtimeException));
                }
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List<a> list = this.bMA;
        synchronized (list) {
            this.bMA.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(URI uri, Map<String, List<String>> responseHeaders) throws IOException {
        List<a> list;
        List list2 = null;
        if (responseHeaders != null) {
            for (Map.Entry object : responseHeaders.entrySet()) {
                if (!"Set-Cookie".equalsIgnoreCase((String)object.getKey())) continue;
                list2 = (List)object.getValue();
                break;
            }
        } else {
            list = this.bMA;
            synchronized (list) {
                Iterator<a> iterator = this.bMA.iterator();
                while (iterator.hasNext()) {
                    Object object = iterator.next();
                    if (!uri.getHost().equals(((a)object).Sv().getHost()) || !uri.getScheme().equals(((a)object).Sv().getScheme())) continue;
                    iterator.remove();
                    break;
                }
            }
        }
        if (list2 != null) {
            list = this.bMA;
            synchronized (list) {
                for (Object object : list2) {
                    a a2;
                    try {
                        a2 = new a(uri, (String)object);
                    }
                    catch (RuntimeException runtimeException) {
                        ViewerUtils.error("Invalid cookie: " + (String)object + "\n" + String.valueOf(runtimeException));
                        continue;
                    }
                    Iterator<a> iterator = this.bMA.iterator();
                    while (iterator.hasNext()) {
                        a a3 = iterator.next();
                        if (!a2.getPath().equals(a3.getPath()) || !a2.getName().equals(a3.getName()) || !a2.Sv().getHost().equals(a3.Sv().getHost()) || !a2.Sv().getScheme().equals(a3.Sv().getScheme()) || a2.Sv().getPort() != a3.Sv().getPort()) continue;
                        iterator.remove();
                        break;
                    }
                    this.bMA.add(a2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, List<String>> get(URI uri, Map<String, List<String>> requestHeaders) throws IOException {
        Collection<Object> collection;
        StringBuilder stringBuilder = new StringBuilder();
        Object object = this.bMA;
        synchronized (object) {
            collection = new HashSet();
            Iterator<a> iterator = this.bMA.iterator();
            while (iterator.hasNext()) {
                String string;
                a a2 = iterator.next();
                if (a2 == null) continue;
                if (a2.Su()) {
                    iterator.remove();
                    continue;
                }
                if (!a2.b(uri) || ((HashSet)collection).contains(string = a2.toString())) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(";");
                }
                stringBuilder.append(string);
                ((HashSet)collection).add(string);
            }
        }
        object = new HashMap<String, List<String>>(requestHeaders);
        if (stringBuilder.length() > 0) {
            collection = Collections.singletonList(stringBuilder.toString());
            object.put("Cookie", collection);
        }
        return Collections.unmodifiableMap(object);
    }

    static {
        try {
            URI uRI = new URI("http://localhost/");
            HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
            new a(uRI, "a=b;path=b").toString();
            InetCookieHandler inetCookieHandler = new InetCookieHandler();
            inetCookieHandler.get(uRI, hashMap);
            inetCookieHandler.put(uRI, hashMap);
        }
        catch (Exception exception) {
            ViewerUtils.printStackTrace(exception);
        }
    }

    private static class a {
        private String name;
        private String value;
        private URI bMB;
        private Date bMC;
        private String aLh;
        private static DateFormat bMD = new SimpleDateFormat("E, dd MMM yyyy k:m:s 'GMT'", Locale.US);
        private static DateFormat bME = new SimpleDateFormat("E, dd-MMM-yyyy k:m:s 'GMT'", Locale.US);

        public a(URI uRI, String string) {
            String[] stringArray = string.split(";");
            String string2 = stringArray[0].trim();
            this.bMB = uRI;
            int n2 = string2.indexOf(61);
            this.name = string2.substring(0, n2);
            this.value = string2.substring(n2 + 1);
            this.aLh = "/";
            for (int i2 = 1; i2 < stringArray.length; ++i2) {
                string2 = stringArray[i2].trim();
                int n3 = string2.indexOf(61);
                if (n3 == -1) continue;
                String string3 = string2.substring(0, n3);
                Object object = string2.substring(n3 + 1);
                if (string3.equalsIgnoreCase("domain")) {
                    String string4 = uRI.getHost();
                    if (string4.equals(object)) continue;
                    if (!((String)object).startsWith(".")) {
                        object = "." + (String)object;
                    }
                    if ((string4 = string4.substring(string4.indexOf(46))).equals(object)) continue;
                    throw new IllegalArgumentException("Trying to set foreign cookie");
                }
                if (string3.equalsIgnoreCase("path")) {
                    this.aLh = object;
                    continue;
                }
                if (!string3.equalsIgnoreCase("expires")) continue;
                try {
                    this.bMC = bMD.parse((String)object);
                    continue;
                }
                catch (ParseException parseException) {
                    try {
                        this.bMC = bME.parse((String)object);
                        continue;
                    }
                    catch (ParseException parseException2) {
                        throw new IllegalArgumentException("Bad date format in header: " + (String)object);
                    }
                }
            }
        }

        public boolean Su() {
            if (this.bMC == null) {
                return false;
            }
            Date date = new Date();
            return date.after(this.bMC);
        }

        public String getName() {
            return this.name;
        }

        public URI Sv() {
            return this.bMB;
        }

        public String getPath() {
            return this.aLh;
        }

        public boolean b(URI uRI) {
            int n2;
            if (this.Su()) {
                return false;
            }
            String string = uRI.getHost();
            if (string == null ? this.bMB.getHost() != null : !string.equals(this.bMB.getHost())) {
                return false;
            }
            int n3 = this.c(this.bMB);
            if (n3 != (n2 = this.c(uRI))) {
                return false;
            }
            String string2 = uRI.getPath();
            if (string2 == null) {
                string2 = "/";
            }
            return string2.startsWith(this.aLh);
        }

        private int c(URI uRI) {
            int n2 = uRI.getPort();
            if (n2 == -1) {
                if ("https".equalsIgnoreCase(uRI.getScheme())) {
                    n2 = 443;
                } else if ("http".equalsIgnoreCase(uRI.getScheme())) {
                    n2 = 80;
                }
            }
            return n2;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.name);
            stringBuilder.append("=");
            stringBuilder.append(this.value);
            return stringBuilder.toString();
        }
    }
}

