/*
 * Decompiled with CFR 0.152.
 */
package com.inet.viewer;

import com.inet.annotations.PublicApi;
import com.inet.viewer.ExportProgress;
import com.inet.viewer.JErrorDialog;
import com.inet.viewer.Progress;
import com.inet.viewer.PromptData;
import com.inet.viewer.RenderData;
import com.inet.viewer.ReportView;
import com.inet.viewer.SwingPromptDialog;
import com.inet.viewer.SwingReportView;
import com.inet.viewer.SwingReportViewer;
import com.inet.viewer.ViewerContext;
import com.inet.viewer.ViewerUtils;
import com.inet.viewer.bk;
import com.inet.viewer.bn;
import com.inet.viewer.exportdlg.JExportDialog;
import com.inet.viewer.t;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.SwingUtilities;

@PublicApi
public class SwingViewerContext
implements ViewerContext {
    private Component bAR;

    public SwingViewerContext(SwingReportViewer viewer) {
        this.setViewer(viewer);
    }

    public SwingViewerContext(Component parent) {
        this.bAR = parent;
    }

    @Override
    public void showInfo() {
        Window window = bn.b(this.getViewer());
        final t t2 = window instanceof Frame ? new t((Frame)window) : new t((Dialog)window);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                t2.setVisible(true);
            }
        });
    }

    @Override
    public void showError(final Throwable e2, Object source) {
        SwingReportView swingReportView;
        if (this.bAR == null) {
            ViewerUtils.error("can not show error dialog because ViewerContext does not have a reference to the viewer! When creating a SwingViewerContext, you should pass in the Report Viewer in the constructor!");
            ViewerUtils.printStackTrace(e2);
            return;
        }
        if (!this.bAR.isVisible()) {
            ViewerUtils.printStackTrace(e2);
            return;
        }
        if (source instanceof SwingReportView && ((bk)(swingReportView = (SwingReportView)source).Rw()).Rb()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JErrorDialog.showError(SwingViewerContext.this.bAR, e2);
            }
        });
    }

    @Override
    public ExportProgress export(ReportView view) {
        return view.export();
    }

    public ExportProgress export(Component parent, RenderData data, PropertyChangeListener changeListener) {
        JExportDialog jExportDialog = new JExportDialog((Frame)parent, (ViewerContext)this, null, null, new Properties(), Integer.MAX_VALUE);
        jExportDialog.setVisible(true);
        if (jExportDialog.getStatus() == 200) {
            return null;
        }
        Properties properties = jExportDialog.getExportProperties();
        String string = ((String)properties.get("export_fmt")).toLowerCase();
        if (string.equals("data")) {
            string = "csv";
        } else if (string.startsWith("ps")) {
            string = "ps";
        }
        properties.put("export_fmt", string);
        ExportProgress exportProgress = new ExportProgress(null, this, data, properties);
        if (changeListener != null) {
            exportProgress.addPropertyChangeListener(changeListener);
        }
        exportProgress.startProgress();
        return exportProgress;
    }

    public ExportProgress export(Component parent, RenderData data) {
        return this.export(parent, data, null);
    }

    @Override
    public Progress print(ReportView view) {
        return view.print(1, -1, true);
    }

    @Override
    public void showStatusMessage(ReportView view, String message, boolean isError) {
        view.getStatusBar().setStatusMessage(message, isError);
    }

    @Override
    public void showUrl(String url, Properties props) throws MalformedURLException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(url);
        if (props != null && props.size() > 0) {
            String string = (String)props.remove("stacktrace");
            stringBuilder.append('?');
            Enumeration<Object> enumeration = props.keys();
            this.a(stringBuilder, props, enumeration);
            while (enumeration.hasMoreElements()) {
                stringBuilder.append('&');
                this.a(stringBuilder, props, enumeration);
            }
            if (string != null) {
                stringBuilder.append("&stacktrace=");
                try {
                    stringBuilder.append(URLEncoder.encode(string, "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
        }
        try {
            if (stringBuilder.length() > 2048) {
                stringBuilder.setLength(2048);
                int n2 = stringBuilder.lastIndexOf("%");
                if (n2 > stringBuilder.length() - 3) {
                    stringBuilder.setLength(n2);
                }
            }
            this.a(new URI(stringBuilder.toString()));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw (MalformedURLException)new MalformedURLException(uRISyntaxException.getMessage()).initCause(uRISyntaxException);
        }
    }

    private void a(StringBuilder stringBuilder, Properties properties, Enumeration enumeration) {
        String string = (String)enumeration.nextElement();
        String string2 = null;
        try {
            string2 = URLEncoder.encode(properties.getProperty(string), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        stringBuilder.append(string);
        stringBuilder.append('=');
        stringBuilder.append(string2);
    }

    private void a(URI uRI) {
        try {
            if (ViewerUtils.useDesktopMethod("browse", uRI)) {
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            ViewerUtils.showDocumentOldMethod(uRI);
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public void setViewer(SwingReportViewer viewer) {
        this.bAR = viewer;
    }

    public SwingReportViewer getViewer() {
        return this.bAR instanceof SwingReportViewer ? (SwingReportViewer)this.bAR : null;
    }

    @Override
    public boolean showPrompts(PromptData[] prompts, RenderData data) {
        SwingPromptDialog swingPromptDialog = new SwingPromptDialog();
        swingPromptDialog.execute(this.getViewer(), this.getViewer(), prompts, data);
        return !swingPromptDialog.wasCanceled();
    }

    @Override
    public void showHelp(String helpPageKey, Component comp) {
        String string = helpPageKey;
        URL uRL = ViewerUtils.class.getResource("images/save.gif");
        try {
            uRL = "jar".equals(uRL.getProtocol()) ? ((JarURLConnection)uRL.openConnection()).getJarFileURL() : new URL(uRL, "../../../../");
            URL uRL2 = new URL(uRL, "../help/#/" + helpPageKey);
            this.showUrl(uRL2.toString(), null);
        }
        catch (IOException iOException) {
            this.showError(iOException, this);
        }
    }
}

