/*
 * Decompiled with CFR 0.152.
 */
package com.inet.viewer;

import com.inet.annotations.PublicApi;
import com.inet.viewer.ReportView;
import com.inet.viewer.ViewerContext;
import com.inet.viewer.ViewerException;
import com.inet.viewer.ViewerUtils;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

@PublicApi
public abstract class Progress
implements Runnable {
    public static final int TYPE_PAGELOADER = 0;
    public static final int TYPE_PRINT = 1;
    public static final int TYPE_EXPORT = 2;
    public static final int TYPE_SEARCH = 3;
    public static final int TYPE_INVISIBLE = 4;
    public static final int STATUS_NOT_INITIALIZED = -1;
    public static final int STATUS_INITIALIZED = 0;
    public static final int STATUS_RUNNING = 1;
    public static final int STATUS_COMPLETED = 2;
    public static final int STATUS_CANCELED = 3;
    public static final int STATUS_ERROR = 4;
    public static final int STATUS_IDLE = 5;
    public static final String PROP_PROGRESS_STATUS = "ProgressStatus";
    public static final String PROP_PROGRESS_TOTAL = "ProgressTotal";
    public static final String PROP_PROGRESS_STEP = "ProgressStep";
    public static final String PROP_PROGRESS_INDETERMINATE = "ProgressIndeterminate";
    private int bxp = -1;
    protected final PropertyChangeSupport bCx = new PropertyChangeSupport(this);
    private int type;
    private int bCy;
    private int progress;
    private boolean bCz = false;
    private String age;
    private ReportView bCA;
    private ViewerContext byQ;
    private Component bAR;
    Thread bCB;

    public Progress(ReportView reportView, int type) {
        this.type = type;
        this.bCA = reportView;
        if (reportView != null) {
            reportView.getReportViewer().getProgressPool().a(this);
            this.bAR = reportView.getComponent();
            this.byQ = reportView.getReportViewer().getViewerContext();
        }
        this.setStatus(0);
    }

    public Progress(Component parent, ViewerContext viewerContext, int type) {
        this.type = type;
        this.byQ = viewerContext;
        this.bAR = parent;
        this.setStatus(0);
    }

    public final void startProgress() {
        if (this.bCB != null && this.bCB.isAlive()) {
            throw new ViewerException("Progress '" + this.getName() + "' is already running");
        }
        this.bCB = new Thread((Runnable)this, this.getName());
        this.bCB.setPriority(5);
        this.setStatus(1);
        this.setErrorMessage(null);
        if (this.bCz) {
            this.bCB.setDaemon(true);
            this.setTotalProgress(1);
        }
        this.bCB.start();
    }

    public abstract String getName();

    public abstract void cancel();

    public int getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilFinished() {
        try {
            Progress progress = this;
            synchronized (progress) {
                while (!this.isFinished()) {
                    this.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean isIndeterminate() {
        return this.bCz;
    }

    public void setIndeterminate(boolean indeterminate) {
        boolean bl2 = this.bCz;
        this.bCz = indeterminate;
        this.bCx.firePropertyChange(PROP_PROGRESS_INDETERMINATE, bl2, indeterminate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(int status) {
        int n2 = this.bxp;
        this.bxp = status;
        this.bCx.firePropertyChange(PROP_PROGRESS_STATUS, n2, this.bxp);
        Progress progress = this;
        synchronized (progress) {
            this.notifyAll();
        }
    }

    public boolean isFinished() {
        boolean bl2 = this.bxp == 3 || this.bxp == 2 || this.bxp == 4;
        return bl2;
    }

    public boolean isCanceled() {
        return this.bxp == 3;
    }

    public boolean isErrored() {
        return this.bxp == 4;
    }

    public void setTotalProgress(int total) {
        int n2 = this.bCy;
        this.bCy = total;
        if (total == 0) {
            this.setStatus(5);
        } else if (this.getStatus() == 5) {
            this.setStatus(1);
        }
        this.bCx.firePropertyChange(PROP_PROGRESS_TOTAL, n2, total);
    }

    public int getTotalProgress() {
        return this.bCy;
    }

    public void setProgress(int step) {
        int n2 = this.progress;
        this.progress = step;
        this.bCx.firePropertyChange(PROP_PROGRESS_STEP, n2, this.progress);
    }

    public int getProgress() {
        return this.progress;
    }

    public ReportView getReportView() {
        return this.bCA;
    }

    public int getStatus() {
        return this.bxp;
    }

    public String getErrorMessage() {
        return this.age;
    }

    public void setErrorMessage(String msg) {
        this.age = msg;
    }

    public void showError(Throwable th) {
        this.setErrorMessage(th.getMessage());
        this.setStatus(4);
        if (this.byQ == null) {
            ViewerUtils.printStackTrace(th);
        } else {
            this.byQ.showError(th, this.bAR);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l2) {
        this.bCx.addPropertyChangeListener(l2);
    }

    public void removePropertyChangeListener(PropertyChangeListener l2) {
        this.bCx.removePropertyChangeListener(l2);
    }

    protected void Pq() {
        PropertyChangeListener[] propertyChangeListenerArray = this.bCx.getPropertyChangeListeners();
        for (int i2 = 0; i2 < propertyChangeListenerArray.length; ++i2) {
            this.bCx.removePropertyChangeListener(propertyChangeListenerArray[i2]);
        }
    }
}

