/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.statistic;

import com.inet.annotations.InternalApi;
import com.inet.report.BaseUtils;
import com.inet.report.i18n.Msg;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Set;

@InternalApi
public class Accumulator {
    private static File axU;
    private static Hashtable<String, Object> bul;
    private static long bum;
    private static long bun;
    private static int buo;
    private static int bup;
    private static int buq;
    private static volatile int bur;
    private static volatile int bus;
    private static Set<Integer> but;
    private static Set<String> buu;
    private static Set<String> buv;
    private static double buw;
    private static int bux;
    private static int buy;
    private static double buz;
    private static double buA;
    private static int buB;
    private static int buC;

    private Accumulator() {
    }

    public static void incTotalRequest() {
        Accumulator.NL();
        ++buo;
    }

    public static void incReportRequest() {
        ++bup;
    }

    public static void incRenderedReports() {
        ++buq;
        bus = Math.max(bus, ++bur);
    }

    public static void decRenderedReports() {
        --bur;
    }

    public static int getCurrentRenderingReports() {
        return bur;
    }

    public static int getMaxRenderingReports() {
        return bus;
    }

    public static void countReportTemplates(URL reportUrl) {
        but.add(reportUrl.hashCode());
    }

    public static void countClientLanguages(Locale locale) {
        buu.add(locale.getLanguage());
    }

    public static void countReportFormats(String format) {
        buv.add(format.startsWith("htm") ? "htm" : format);
    }

    public static void incPageCount(int pages) {
        buw += (double)pages;
        ++bux;
        buy = Math.max(buy, pages);
    }

    public static void countRecords(int fetchedRecord, int discardedRecords) {
        buz += (double)fetchedRecord;
        buA += (double)discardedRecords;
        buB = Math.max(buB, fetchedRecord);
        buC = Math.max(buC, discardedRecords);
    }

    public static void print(Printer printer) {
        DecimalFormat decimalFormat = new DecimalFormat("#.##");
        Accumulator.a("Total Requests", decimalFormat, printer);
        Accumulator.a("Report Requests", decimalFormat, printer);
        Accumulator.a("Rendered Reports", decimalFormat, printer);
        Accumulator.a("Report Templates", decimalFormat, printer);
        Accumulator.a("Client Languages", decimalFormat, printer);
        Accumulator.a("Last used Client Languages", decimalFormat, printer);
        Accumulator.a("Report Formats", decimalFormat, printer);
        Accumulator.a("Last used Report Formats", decimalFormat, printer);
        Accumulator.a("Total Page Count", decimalFormat, printer);
        Accumulator.a("Maximal Page Count", decimalFormat, printer);
        Accumulator.a("Average Page Count", decimalFormat, printer);
        Accumulator.a("Total fetched Records", decimalFormat, printer);
        Accumulator.a("Maximal fetched Records", decimalFormat, printer);
        Accumulator.a("Total discarded Records", decimalFormat, printer);
        Accumulator.a("Maximal discarded Records", decimalFormat, printer);
    }

    public static void print() {
        BaseUtils.info("== Start Statistic Data ==========");
        BaseUtils.info("=== Average per Day ==============");
        Accumulator.print(new Printer(){

            @Override
            public void print(String key, String value, String description) {
                BaseUtils.info(key + ":\t" + value);
            }
        });
        BaseUtils.info("== End Statistic Data ============");
    }

    private static void a(String string, DecimalFormat decimalFormat, Printer printer) {
        Object object = bul.get(string);
        if (object == null) {
            object = "";
        }
        if (object instanceof Number && !Double.isNaN(((Number)object).doubleValue())) {
            object = decimalFormat.format(object);
        }
        String string2 = "Accumulator_" + string.replaceAll(" ", "_");
        printer.print(Msg.getMsg(string2, new Object[0]), object.toString(), Msg.getMsg(string2 + "_description", new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void NL() {
        long l2 = System.currentTimeMillis();
        if (l2 > bum) {
            Class<Accumulator> clazz = Accumulator.class;
            synchronized (Accumulator.class) {
                if (l2 <= bum) return;
                Accumulator.a(bul, "");
                Accumulator.save();
                buo = 0;
                bup = 0;
                buq = 0;
                buw = 0.0;
                buy = 0;
                bux = 0;
                buz = 0.0;
                buB = 0;
                buA = 0.0;
                buC = 0;
                but.clear();
                buu.clear();
                buv.clear();
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return;
            }
        }
        if (l2 <= bun) return;
        Class<Accumulator> clazz = Accumulator.class;
        synchronized (Accumulator.class) {
            if (l2 <= bun) return;
            Accumulator.backup();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static synchronized void backup() {
        if (axU == null) {
            return;
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        Accumulator.a(hashtable, ".saved");
        bul.putAll(hashtable);
        Accumulator.save();
    }

    private static synchronized void a(Hashtable<String, Object> hashtable, String string) {
        Accumulator.a(buo, hashtable, "Total Requests" + string);
        Accumulator.a(bup, hashtable, "Report Requests" + string);
        Accumulator.a(buq, hashtable, "Rendered Reports" + string);
        Accumulator.a(buw, hashtable, "Total Page Count" + string);
        Accumulator.a(buy, hashtable, "Maximal Page Count" + string);
        Accumulator.a(buz, hashtable, "Total fetched Records" + string);
        Accumulator.a(buB, hashtable, "Maximal fetched Records" + string);
        Accumulator.a(buA, hashtable, "Total discarded Records" + string);
        Accumulator.a(buC, hashtable, "Maximal discarded Records" + string);
        if (string.length() == 0) {
            Accumulator.a(but.size(), hashtable, "Report Templates");
            Accumulator.a(buu.size(), hashtable, "Client Languages");
            hashtable.put("Last used Client Languages", buu);
            Accumulator.a(buv.size(), hashtable, "Report Formats");
            hashtable.put("Last used Report Formats", buv);
            Accumulator.a(buw / (double)bux, hashtable, "Average Page Count");
        } else {
            hashtable.put("Report Templates" + string, but);
            hashtable.put("Client Languages" + string, buu);
            hashtable.put("Report Formats" + string, buv);
            hashtable.put("Average Page Count" + string, bux);
        }
        hashtable.put("Next Day", bum);
    }

    private static Hashtable<String, Object> NM() {
        Hashtable<String, Object> hashtable = bul = new Hashtable<String, Object>();
        try {
            axU = new File(System.getProperty("user.home"), ".cc.statistic");
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(axU));
                hashtable = (Hashtable<String, Object>)objectInputStream.readObject();
                objectInputStream.close();
                if (hashtable != null) {
                    bul = hashtable;
                } else {
                    hashtable = bul;
                }
                buo = (int)Accumulator.dH("Total Requests");
                bup = (int)Accumulator.dH("Report Requests");
                buq = (int)Accumulator.dH("Rendered Reports");
                buw = Accumulator.dH("Total Page Count");
                buy = (int)Accumulator.dH("Maximal Page Count");
                bux = (int)Accumulator.dH("Average Page Count");
                buz = Accumulator.dH("Total fetched Records");
                buB = (int)Accumulator.dH("Maximal fetched Records");
                buA = Accumulator.dH("Total discarded Records");
                buC = (int)Accumulator.dH("Maximal discarded Records");
                but = Accumulator.dI("Report Templates");
                buu = Accumulator.dI("Client Languages");
                buv = Accumulator.dI("Report Formats");
                Long l2 = (Long)hashtable.get("Next Day");
                if (l2 != null) {
                    Accumulator.NN();
                    bum = l2;
                    Accumulator.NL();
                }
            }
            catch (Throwable throwable) {
                bul = hashtable;
                but = Collections.synchronizedSet(new HashSet());
                buu = Collections.synchronizedSet(new HashSet());
                buv = Collections.synchronizedSet(new HashSet());
            }
            Accumulator.NN();
        }
        catch (Throwable throwable) {
            BaseUtils.printStackTrace(throwable);
            but = Collections.synchronizedSet(new HashSet());
            buu = Collections.synchronizedSet(new HashSet());
            buv = Collections.synchronizedSet(new HashSet());
        }
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    Accumulator.backup();
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return hashtable;
    }

    private static void NN() {
        Date date = new Date();
        bun = date.getTime() + 3600000L;
        date = new Date(date.getYear(), date.getMonth(), date.getDate() + 1);
        bum = date.getTime();
    }

    private static synchronized void save() {
        if (axU == null) {
            return;
        }
        Accumulator.NN();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(axU));
            objectOutputStream.writeObject(bul);
            objectOutputStream.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static double dH(String string) {
        Number number = (Number)bul.get(string + ".saved");
        if (number != null) {
            return number.doubleValue();
        }
        return 0.0;
    }

    private static Set dI(String string) {
        Set set = (Set)bul.get(string + ".saved");
        if (set != null) {
            return set;
        }
        return Collections.synchronizedSet(new HashSet());
    }

    private static synchronized void a(double d2, Hashtable<String, Object> hashtable, String string) {
        Double d3 = (Double)hashtable.get(string);
        if (Double.isNaN(d2) || Double.isInfinite(d2)) {
            d2 = 0.0;
        }
        if (d3 == null) {
            hashtable.put(string, d2);
        } else {
            double d4 = (d2 + 7.0 * d3) / 8.0;
            hashtable.put(string, d4);
        }
    }

    static {
        bul = Accumulator.NM();
    }

    @InternalApi
    public static interface Printer {
        public void print(String var1, String var2, String var3);
    }
}

