/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.renderer.pdf;

import com.inet.error.ErrorCode;
import com.inet.http.utils.MimeTypes;
import com.inet.report.BaseUtils;
import com.inet.report.ReportException;
import com.inet.report.i18n.ReportErrorCode;
import com.inet.report.renderer.doc.AbstractDocumentWriter;
import com.inet.report.renderer.doc.DocumentMetaData;
import com.inet.report.renderer.doc.Layout;
import com.inet.report.renderer.doc.WriterCapabilities;
import com.inet.report.renderer.pdf.PDFConfig;
import com.inet.report.renderer.pdf.e;
import com.inet.report.renderer.pdf.h;
import com.inet.report.renderer.pdf.i;
import com.inet.report.renderer.pdf.k;
import com.inet.report.renderer.pdf.l;
import com.inet.report.renderer.pdf.m;
import com.inet.report.renderer.pdf.model.aj;
import com.inet.report.renderer.pdf.model.am;
import com.inet.report.renderer.pdf.model.as;
import com.inet.report.renderer.pdf.model.o;
import com.inet.report.renderer.pdf.model.r;
import com.inet.report.renderer.pdf.model.structure.g;
import com.inet.report.renderer.pdf.sec.a;
import com.inet.report.renderer.pdf.sec.b;
import com.inet.report.renderer.pdf.sec.f;
import com.inet.shared.utils.MemoryStream;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PDFDocumentWriter
extends AbstractDocumentWriter {
    public static final String NAVIGATION_OUTLINES = "bookmarks";
    public static final String NAVIGATION_THUMBNAILS = "pages";
    public static final String ALG_TYPE = "algtype";
    public static final String ENCRYPT_METADATA = "encryptmeta";
    private boolean aVu = false;
    private boolean aVv;
    private boolean aVw;
    private Date IU;
    private boolean aVx;
    private MemoryStream CT = null;
    private e aVy;
    private com.inet.report.renderer.pdf.model.m aUv;
    @Nonnull
    private i aVz;
    @Nonnull
    private k aVA;
    private int aVB;
    private h aVC;
    private am aVD;

    public PDFDocumentWriter(PDFConfig config) {
        this.aVy = new e(config);
        this.aUv = this.aVy.GR();
        this.aVz = new i(this.aVy, this.aUv);
        this.aVA = new k(this.aUv.Id(), this.aVz, this.aUv.Ig().isReplaceMissingChars());
    }

    @Override
    @Nonnull
    public Layout getLayout() {
        return this.aVz;
    }

    @Override
    @Nonnull
    public WriterCapabilities getCapabilities() {
        return this.aVA;
    }

    @Override
    public void setUserProperties(@Nullable Properties props) {
        props = props != null ? props : new Properties();
        super.setUserProperties(props);
        this.k(props);
        boolean bl2 = Boolean.parseBoolean(props.getProperty("fastwebview"));
        if (bl2) {
            this.aUv.Ig().setLinear(bl2);
            this.aVC = new h(this.aUv);
        }
    }

    @Override
    public void setMetaData(@Nonnull DocumentMetaData metaData) {
        super.setMetaData(metaData);
        this.aVy.setMetaData(metaData);
        this.aVv = metaData.isClipboardEnabled();
        this.aVx = metaData.isGroupTreeVisible();
        this.aVw = metaData.isPrintingEnabled();
        this.IU = metaData.getPrintTime();
        this.GV();
        PDFConfig pDFConfig = this.aUv.Ig();
        Properties properties = this.getProperties();
        l l2 = FACTUR_X && metaData.getProperty("facturx-level") != null ? l.aWG : l.cQ(properties.getProperty("pdfa"));
        if (l2 != null && this.aVu) {
            ErrorCode.throwAny((Throwable)new ReportException("Documents that are encrypted or restrict access to their content (e.g., printing or copying to the clipboard) cannot be exported in PDF/A format.", ReportErrorCode.InvalidArgument.getErrorCodeNumber()));
        }
        pDFConfig.setPdfA(l2);
        m m2 = m.cR(properties.getProperty("pdfua"));
        if (m2 != null && this.aVu) {
            ErrorCode.throwAny((Throwable)new ReportException("Documents that are encrypted or restrict access to their content (e.g., printing or copying to the clipboard) cannot be exported in PDF/UA format.", ReportErrorCode.InvalidArgument.getErrorCodeNumber()));
        }
        pDFConfig.setPdfUA(m2);
        boolean bl2 = pDFConfig.isCreateStructure();
        String string = properties.getProperty("pdftags");
        if ("true".equalsIgnoreCase(string)) {
            bl2 = true;
        } else if ("false".equalsIgnoreCase(string)) {
            bl2 = false;
        }
        if (bl2) {
            g g2 = new g(this.aUv);
            this.aUv.a(g2);
            this.aVz.a(g2);
        }
        this.aUv.Id().dF();
    }

    @Override
    public void setPageLayout(int width, int height, boolean landscape, int topMargin, int leftMargin, int bottomMargin, int rightMargin) throws ReportException {
        super.setPageLayout(width, height, landscape, topMargin, leftMargin, bottomMargin, rightMargin);
        this.aVy.C(width, height, topMargin, leftMargin);
    }

    @Override
    public void startDocument() throws ReportException {
        super.startDocument();
        this.aVy.start();
        this.aVB = 0;
        g g2 = this.aUv.Ih();
        if (g2 != null) {
            this.aVy.GS().a(g2.JI());
            DocumentMetaData documentMetaData = this.getMetaData();
            if (documentMetaData != null) {
                Locale locale = documentMetaData.getResourceLocale();
                String string = locale.toLanguageTag();
                this.aVy.GS().da(string);
            }
        }
    }

    @Override
    public void startPage() throws ReportException {
        boolean bl2;
        super.startPage();
        boolean bl3 = bl2 = this.CT == null;
        if (!bl2) {
            this.ce(false);
        }
        this.aVD = this.aVz.He();
        this.CT = new MemoryStream();
        if (this.aVC != null) {
            this.aVC.a(this.aVD);
        } else if (bl2) {
            this.aVy.Z(this.CT);
        }
    }

    @Override
    public void endPage() throws ReportException {
        super.endPage();
    }

    private void ce(boolean bl2) throws ReportException {
        if (bl2) {
            this.aVz.Hh();
        }
        this.aVz.endPage();
        if (this.aVC == null) {
            this.aVy.c(this.CT, this.getPages().getPageCount() + 1, this.aVB);
            byte[] byArray = this.CT.toByteArray();
            this.getPages().addPage(byArray);
            this.aVB += byArray.length;
            this.aVD.dispose();
        }
        this.CT = null;
    }

    @Override
    public void endDocument() throws ReportException {
        Object object;
        int n2;
        super.endDocument();
        if (this.CT != null) {
            this.ce(true);
        }
        if (this.aVC != null) {
            n2 = this.aVC.a(this.aVy, this.getPages());
        } else {
            object = new MemoryStream();
            this.aVy.aa((MemoryStream)object);
            byte[] byArray = object.toByteArray();
            this.getPages().addPage(byArray);
            n2 = this.aVB + byArray.length;
        }
        object = this.aVz.Hg();
        if (object != null) {
            ((as)object).a(this.getPages(), n2);
        }
    }

    private void GV() {
        String string;
        boolean bl2 = true;
        Properties properties = this.getProperties();
        if (properties != null && (string = properties.getProperty(ENCRYPT_METADATA, "true")) != null && string.equalsIgnoreCase("false")) {
            bl2 = false;
        }
        int n2 = a.k(this.aVv, this.aVw);
        String[] stringArray = a.l(properties);
        if (stringArray[0] == null) {
            if (!this.aVv || !this.aVw) {
                this.aVu = true;
                stringArray[0] = "DEFAULT_ALG";
            }
        } else {
            this.aVu = true;
        }
        if (this.aVu) {
            byte[] byArray = a.f(this.IU.getTime());
            b b2 = f.a(stringArray[0], stringArray[1], stringArray[2], n2, bl2, this.IU, byArray);
            this.aVy.a(b2, byArray);
        }
    }

    private void k(@Nonnull Properties properties) {
        String string = properties.getProperty("navview", "");
        if (NAVIGATION_OUTLINES.equals(string) || NAVIGATION_THUMBNAILS.equals(string)) {
            BaseUtils.info("PDF Export navigation type: " + string);
            this.aVy.cO(string);
        }
    }

    @Override
    public void addAttchment(@Nonnull String fileName, byte @Nonnull [] data) {
        l l2 = this.aVy.GR().Ig().getPdfA();
        if (l2 == null || l2.Ho() > 1) {
            com.inet.report.renderer.pdf.model.k k2 = this.aVy.GS();
            aj aj2 = k2.Ib();
            if (aj2 == null) {
                aj2 = new aj(this.aUv);
            }
            String string = MimeTypes.getMimeType((String)fileName).split(";")[0];
            o o2 = new o(this.aUv, data, string, this.IU);
            r r2 = new r(this.aUv, o2, fileName, null);
            aj2.a(r2);
            k2.a(aj2);
        }
    }

    @Override
    @Nullable
    public com.inet.report.renderer.doc.i getStructureWriter() {
        return this.aUv.Ih();
    }
}

