/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.renderer.html;

import com.inet.graphics.encode.PNGEncoder;
import com.inet.http.utils.MimeTypes;
import com.inet.lib.json.Json;
import com.inet.lib.util.IOFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.report.BaseUtils;
import com.inet.report.ReportException;
import com.inet.report.layout.richhtml.b;
import com.inet.report.renderer.doc.AbstractDocumentWriter;
import com.inet.report.renderer.doc.DocumentMetaData;
import com.inet.report.renderer.doc.Layout;
import com.inet.report.renderer.doc.WriterCapabilities;
import com.inet.report.renderer.html.d;
import com.inet.report.renderer.html.h;
import com.inet.report.renderer.html.tree.a;
import com.inet.report.renderer.html.tree.e;
import com.inet.shared.utils.MemoryStream;
import java.awt.Image;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

public class HtmlDocumentWriter
extends AbstractDocumentWriter {
    private static final int aLA = ",\"url\":\"".length();
    private final h aLB;
    private final boolean aLC;
    private boolean aLD;
    private boolean aLE;
    private boolean aLF;
    private final MemoryStream aLG;
    private final MemoryStream aLH = new MemoryStream();
    private int bi;
    private int Kh;
    private WriterCapabilities aKu;
    private int aLI;
    private int aLJ;
    private HashMap<String, String> aLK;
    private e aLL;
    private String aLM;
    private int aId;
    private int aIe;
    private int aIf;
    private int aIg;

    public HtmlDocumentWriter() {
        this(false);
    }

    public HtmlDocumentWriter(boolean isZip) {
        this.aLC = isZip;
        this.aLG = new MemoryStream();
        this.aLB = new h(this);
        this.aKu = new d(this.aLD);
        this.aLK = new HashMap();
    }

    @Override
    public void startDocument() throws ReportException {
        b.vF();
        super.startDocument();
    }

    @Override
    @Nonnull
    public Layout getLayout() {
        return this.aLB;
    }

    @Override
    public void startPage() throws ReportException {
        super.startPage();
        if (!this.aLF) {
            this.aLH.setLength(0);
            ++this.aLI;
            this.aLJ = 0;
            this.aLB.refresh();
            this.aLB.startPage();
            if (this.aLE || this.aLD) {
                this.aLF = true;
            }
        }
    }

    @Override
    public void endPage() throws ReportException {
        super.endPage();
        HtmlDocumentWriter.K(null, ".........endPage..........");
        if (this.aLF) {
            this.aLB.DA();
            this.aLB.Dp();
            this.aLB.Dt();
        } else {
            this.De();
        }
        this.aLB.bT(false);
    }

    void De() {
        Object object;
        this.aLB.Dp();
        this.aLB.Dt();
        this.aLG.writeASCII("<!DOCTYPE html>");
        HtmlDocumentWriter.M(this.aLG);
        this.aLG.writeASCII("<html>");
        HtmlDocumentWriter.M(this.aLG);
        this.aLG.writeASCII("<head>");
        HtmlDocumentWriter.M(this.aLG);
        this.Dj();
        this.aLG.writeASCII("<style type=\"text/css\">");
        HtmlDocumentWriter.M(this.aLG);
        this.aLB.R(this.aLG);
        HtmlDocumentWriter.M(this.aLG);
        this.aLG.writeASCII("</style>");
        HtmlDocumentWriter.M(this.aLG);
        this.aLG.writeASCII("<script type=\"text/javascript\">");
        if (this.aLI == 1) {
            object = this.getMetaData();
            HtmlDocumentWriter.M(this.aLG);
            this.aLG.writeASCII("var permissions={allowprint:");
            this.aLG.writeASCII(Boolean.toString(object.isPrintingEnabled()));
            this.aLG.writeASCII(",enabledFormats:");
            String[] stringArray = object.getEnabledFormats();
            try {
                new Json().toJson((Object)stringArray, (OutputStream)this.aLG);
            }
            catch (IOException iOException) {
                BaseUtils.error(iOException.getMessage());
            }
            this.aLG.writeASCII("};");
            HtmlDocumentWriter.M(this.aLG);
        }
        try {
            HtmlDocumentWriter.b("viewer/helper/events.js", this.aLG);
            HtmlDocumentWriter.b("viewer/page.js", this.aLG);
        }
        catch (IOException iOException) {
            BaseUtils.error(iOException.getMessage());
        }
        this.aLG.writeASCII("</script>");
        this.aLG.writeASCII("</head>");
        HtmlDocumentWriter.M(this.aLG);
        this.aLG.writeASCII("<body");
        this.aLG.writeASCII(" class=\"page" + this.aLI + "\">");
        HtmlDocumentWriter.M(this.aLG);
        this.aLB.an().writeTo(this.aLG);
        this.aLB.a(this.aLG, false, true);
        this.aLB.an().reset();
        HtmlDocumentWriter.M(this.aLG);
        this.aLG.writeASCII("</body>");
        HtmlDocumentWriter.M(this.aLG);
        this.aLG.writeASCII("</html>");
        object = this.aLI + ".html";
        HtmlDocumentWriter.a((String)object, this.aLG.toByteArray(), this.aLH);
        this.i(this.aLH, -1);
        this.aLG.reset();
        this.aLB.Du();
        this.aLB.DB();
    }

    @Override
    public void endDocument() throws ReportException {
        Object object;
        if (this.aLF) {
            this.De();
        }
        super.endDocument();
        String string = this.aLL != null ? this.aLL.Ep() : "[]";
        string = this.cq(string);
        String string2 = this.p(string, this.aLI);
        this.aLH.setLength(0);
        HtmlDocumentWriter.a("0.json", BaseUtils.getBytesUTF8(string2), this.aLH);
        try {
            object = new MemoryStream();
            try {
                object.writeASCII("var groupTreeJson=");
                Json json = new Json();
                StringBuilder stringBuilder = new StringBuilder();
                json.toJson((Object)string2, stringBuilder);
                object.write(BaseUtils.getBytesUTF8(stringBuilder.toString()));
                object.writeASCII(";");
                HtmlDocumentWriter.a("0.js", object.toByteArray(), this.aLH);
            }
            finally {
                object.close();
            }
        }
        catch (IOException iOException) {
            throw new ReportException("Memory Stream unexpectedly aborted.", -1);
        }
        if (this.aLC && (object = (Object)this.getMetaData().getThumbnailData()) != null) {
            HtmlDocumentWriter.a("thumbnail.png", (byte[])object, this.aLH);
        }
        this.getPages().setGroupTree(this.aLH.toByteArray());
    }

    @Override
    public void setPageLayout(int width, int height, boolean landscape, int topMargin, int leftMargin, int bottomMargin, int rightMargin) throws ReportException {
        super.setPageLayout(width, height, landscape, topMargin, leftMargin, bottomMargin, rightMargin);
        this.bi = width;
        this.Kh = height;
        this.aId = topMargin;
        this.aIe = leftMargin;
        this.aIf = bottomMargin;
        this.aIg = rightMargin;
    }

    String Df() {
        return String.valueOf(this.aLI);
    }

    public static void M(MemoryStream memoryStream) {
        memoryStream.write(10);
    }

    public int Dg() {
        return this.Kh;
    }

    public int Dh() {
        if (this.aLD || this.aLE) {
            return Math.max(this.aLB.Dy() + this.aId + this.aIf, this.Kh);
        }
        return this.Kh;
    }

    public int Di() {
        return this.bi;
    }

    @Override
    @Nonnull
    public WriterCapabilities getCapabilities() {
        return this.aKu;
    }

    private void Dj() {
        DocumentMetaData documentMetaData = this.getMetaData();
        this.aLG.writeASCII("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"/>");
        if (documentMetaData != null) {
            this.J("title", documentMetaData.getTitle());
            this.J("keywords", documentMetaData.getKeyWords());
            this.J("subject", documentMetaData.getSubject());
            this.J("template", documentMetaData.getTemplate());
            this.J("comments", documentMetaData.getComments());
            this.b("createTime", documentMetaData.getPrintTime());
            this.J("generator", "i-net Clear Reports");
        }
    }

    private void J(String string, String string2) {
        if (string2 == null || string2.trim().length() == 0) {
            return;
        }
        this.aLG.writeASCII("<meta name=\"" + string + "\" content=\"" + string2 + "\" />");
        HtmlDocumentWriter.M(this.aLG);
    }

    private void b(String string, Date date) {
        if (date == null) {
            return;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        String string2 = simpleDateFormat.format(date);
        this.J(string, string2);
    }

    String a(String string, Image image, byte[] byArray) {
        Object object;
        Object object2 = object = string != null ? this.aLK.get(string) : null;
        if (object == null) {
            if (image == null) {
                return "";
            }
            if (byArray == null) {
                byArray = PNGEncoder.getPNGImageData((Image)image);
            }
            if (byArray != null) {
                String string2 = MimeTypes.getMimeTypeFromData((byte[])byArray);
                String string3 = string2 == "image/svg+xml" || string2 == "text/xml; charset=utf-8" ? ".svg" : ".png";
                object = String.valueOf(this.aLI) + "-" + ++this.aLJ + string3;
                HtmlDocumentWriter.a((String)object, byArray, this.aLH);
                if (this.aLM != null) {
                    object = (String)object + this.aLM + (String)object;
                }
                if (string != null) {
                    this.aLK.put(string, (String)object);
                }
            } else {
                return "";
            }
        }
        return object;
    }

    String a(String string, String string2, byte[] byArray) {
        Object object;
        Object object2 = object = string != null ? this.aLK.get(string) : null;
        if (object != null) {
            return object;
        }
        if (byArray == null) {
            return "";
        }
        object = String.valueOf(this.aLI) + "-" + ++this.aLJ + "." + (string2 != null ? string2 : ".png");
        HtmlDocumentWriter.a((String)object, byArray, this.aLH);
        if (this.aLM != null) {
            object = (String)object + this.aLM + (String)object;
        }
        if (string != null) {
            this.aLK.put(string, (String)object);
        }
        return object;
    }

    @Override
    public void addAttchment(@Nonnull String fileName, byte @Nonnull [] data) {
        HtmlDocumentWriter.a(fileName, data, this.aLH);
    }

    private void i(MemoryStream memoryStream, int n2) {
        if (n2 == -1) {
            this.getPages().addPage(memoryStream.toByteArray());
        } else {
            this.getPages().setPageData(memoryStream.toByteArray(), n2);
        }
    }

    private static void a(String string, byte[] byArray, MemoryStream memoryStream) {
        byte[] byArray2 = BaseUtils.getBytesUTF8(string);
        memoryStream.writeInverseInt(byArray2.length);
        memoryStream.write(byArray2);
        memoryStream.writeInverseInt(byArray.length);
        memoryStream.write(byArray);
    }

    @Override
    public void setUserProperties(@Nullable Properties props) {
        super.setUserProperties(props);
        if (props == null) {
            if (BaseUtils.isDebug()) {
                BaseUtils.debug("html export: user properties not defined");
            }
        } else {
            String string = props.getProperty("layout");
            if (string != null) {
                if (string.equals("single")) {
                    this.aLD = true;
                    ((d)this.aKu).bQ(this.aLD);
                    this.aLB.Dz();
                } else if (string.equals("concat")) {
                    this.aLE = true;
                    this.aLB.Dz();
                }
            }
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Report name is provided by user and checked before rendering. Also we're just reading the file name")
    private String p(String string, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{\"grouptreeData\":");
        if (string != null) {
            stringBuilder.append(string);
        }
        stringBuilder.append(',');
        stringBuilder.append(" \"pageCount\":");
        stringBuilder.append('\"');
        stringBuilder.append(String.valueOf(n2));
        stringBuilder.append('\"');
        int n3 = Math.round((float)this.bi / 15.0f);
        int n4 = Math.round((float)this.Kh / 15.0f);
        int n5 = Math.round((float)this.bi / 566.92914f * 10.0f);
        int n6 = Math.round((float)this.Kh / 566.92914f * 10.0f);
        if (this.aLD || this.aLE) {
            n4 = Math.max(Math.round((float)(this.aLB.Dy() + this.aId + this.aIf) / 15.0f * 10.0f), n4);
            n6 = Math.max(Math.round((float)(this.aLB.Dy() + this.aId + this.aIf) / 566.92914f * 10.0f), n6);
        }
        stringBuilder.append(',');
        stringBuilder.append(" \"page\":{\"width\":\"");
        stringBuilder.append(String.valueOf(n3));
        stringBuilder.append('\"');
        stringBuilder.append(',');
        stringBuilder.append(" \"height\":\"");
        stringBuilder.append(String.valueOf(n4));
        stringBuilder.append('\"');
        stringBuilder.append(',');
        stringBuilder.append(" \"print\":{\"width\":\"");
        stringBuilder.append(String.valueOf(n5));
        stringBuilder.append("mm\"");
        stringBuilder.append(',');
        stringBuilder.append(" \"height\":\"");
        stringBuilder.append(String.valueOf(n6));
        stringBuilder.append("mm\"");
        stringBuilder.append(',');
        stringBuilder.append(" \"margin\":{\"left\":\"");
        stringBuilder.append(String.valueOf((float)this.aIe / 566.92914f));
        stringBuilder.append("cm\"");
        stringBuilder.append(',');
        stringBuilder.append(" \"right\":\"");
        stringBuilder.append(String.valueOf((float)this.aIg / 566.92914f));
        stringBuilder.append("cm\"");
        stringBuilder.append(',');
        stringBuilder.append(" \"bottom\":\"");
        stringBuilder.append(String.valueOf((float)this.aIf / 566.92914f));
        stringBuilder.append("cm\"");
        stringBuilder.append(',');
        stringBuilder.append(" \"top\":\"");
        stringBuilder.append(String.valueOf((float)this.aId / 566.92914f));
        stringBuilder.append("cm\"");
        stringBuilder.append('}');
        stringBuilder.append('}');
        stringBuilder.append('}');
        DocumentMetaData documentMetaData = this.getMetaData();
        this.c(stringBuilder, "title", documentMetaData.getTitle());
        this.c(stringBuilder, "author", documentMetaData.getAuthor());
        this.c(stringBuilder, "subject", documentMetaData.getSubject());
        this.c(stringBuilder, "keywords", documentMetaData.getKeyWords());
        this.c(stringBuilder, "comments", documentMetaData.getComments());
        String string2 = HtmlDocumentWriter.j(this.getProperties());
        if (string2 != null) {
            this.c(stringBuilder, "report", string2 + ".rpt");
        } else if (documentMetaData.getReportURL() != null) {
            this.c(stringBuilder, "report", new File(documentMetaData.getReportURL().getFile()).getName());
        }
        if (documentMetaData.getPrintTime() != null) {
            this.c(stringBuilder, "created", "" + documentMetaData.getPrintTime().getTime());
        }
        String string3 = this.getPages() != null && this.getPages().isPageLimitExceeded() ? "true" : "false";
        stringBuilder.append(',');
        stringBuilder.append("\"isPageLimitExceeded\":\"");
        stringBuilder.append(string3);
        stringBuilder.append('\"');
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    private void c(StringBuilder stringBuilder, String string, String string2) {
        if (StringFunctions.isEmpty((String)string2)) {
            return;
        }
        stringBuilder.append(',');
        stringBuilder.append("\"" + string + "\":");
        new Json().toJson((Object)string2, stringBuilder);
    }

    e Dk() {
        if (this.aLL == null) {
            this.aLL = new a();
        }
        return this.aLL;
    }

    int Bl() {
        return this.aIe;
    }

    int Bk() {
        return this.aId;
    }

    int Bn() {
        return this.aIg;
    }

    int Bm() {
        return this.aIf;
    }

    static void b(@Nonnull String string, MemoryStream memoryStream) throws IOException {
        URL uRL = HtmlDocumentWriter.class.getResource(string);
        if (uRL == null) {
            throw new FileNotFoundException("resource: " + string + " not found");
        }
        byte[] byArray = IOFunctions.getFileBuffer((URL)uRL);
        memoryStream.write(byArray);
    }

    private String cq(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = -6;
        int n3 = 0;
        while ((n2 = string.indexOf(",\"url\":\"", n2 + 6)) != -1) {
            int n4 = n2 + aLA;
            if (n4 >= string.length() || string.charAt(n4) != '\"') continue;
            stringBuilder.append(string.substring(n3, n2));
            n3 = n4 + 1;
        }
        if (n3 != 0) {
            stringBuilder.append(string.substring(n3, string.length()));
            string = stringBuilder.toString();
        }
        return string;
    }

    public static void K(String string, String string2) {
    }

    @Nullable
    public static String j(@Nullable Properties properties) {
        if (properties == null) {
            return null;
        }
        String string = properties.getProperty("report");
        if (string != null) {
            int n2 = Math.max(string.lastIndexOf("/"), string.lastIndexOf(92));
            if (n2 != -1 && n2 != string.length() - 1) {
                if ((string = string.substring(n2 + 1)).endsWith(".rpt")) {
                    string = string.substring(0, string.length() - ".rpt".length());
                }
            } else {
                string = null;
            }
        }
        return string;
    }
}

