/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.renderer.doc;

import com.inet.annotations.InternalApi;
import com.inet.plugin.ServerPluginManager;
import com.inet.report.ReportException;
import com.inet.report.output.DocumentOutput;
import com.inet.report.renderer.doc.DocumentMetaData;
import com.inet.report.renderer.doc.DocumentWriter;
import com.inet.report.renderer.doc.i;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public abstract class AbstractDocumentWriter
implements DocumentWriter {
    protected static final boolean FACTUR_X = ServerPluginManager.getInstance().isPluginLoaded("facturx");
    private DocumentOutput nQ;
    private int yD;
    private DocumentMetaData aCY;
    private Properties Vj;
    protected static final int STATE_BEFORE_PAGE = 1;
    protected static final int STATE_IN_PAGE = 2;
    protected static final int STATE_DOC_END = 5;

    @Override
    public void setOutput(DocumentOutput pages) throws ReportException {
        if (pages == null) {
            throw new IllegalArgumentException("parameter pages is null");
        }
        if (this.nQ != null) {
            throw new IllegalStateException("pages already set");
        }
        this.nQ = pages;
        this.yD = 1;
    }

    @Override
    public void setUserProperties(@Nullable Properties props) {
        this.Vj = props;
        this.checkState(1);
    }

    @Override
    public void setMetaData(@Nonnull DocumentMetaData metaData) {
        this.aCY = metaData;
        this.checkState(1);
    }

    protected DocumentMetaData getMetaData() {
        return this.aCY;
    }

    protected Properties getProperties() {
        return this.Vj;
    }

    @Override
    public void setSheetName(String sheetName) {
    }

    @Override
    public void setPageLayout(int width, int height, boolean landscape, int topMargin, int leftMargin, int bottomMargin, int rightMargin) throws ReportException {
        this.checkState(1);
    }

    @Override
    public void setColumnWidths(int[] widths) {
    }

    @Override
    public void startDocument() throws ReportException {
        this.checkState(1);
    }

    @Override
    public void startPage() throws ReportException {
        this.checkState(1);
        this.yD = 2;
    }

    @Override
    public void endPage() throws ReportException {
        this.checkState(2);
        this.yD = 1;
    }

    @Override
    public void endDocument() throws ReportException {
        this.checkState(1);
        this.yD = 5;
    }

    @Override
    public void addAttchment(@Nonnull String fileName, byte @Nonnull [] data) {
    }

    protected void checkState(int neededState) throws IllegalStateException {
        if (this.yD != neededState) {
            throw new IllegalStateException("method is called in an invalid state: " + this.yD);
        }
    }

    protected DocumentOutput getPages() {
        return this.nQ;
    }

    @Override
    public void clean() {
    }

    @Override
    @Nullable
    public i getStructureWriter() {
        return null;
    }
}

