/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.renderer.api.implementation;

import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.cache.Cache;
import com.inet.report.cache.ReportCacheKey;
import com.inet.report.i18n.ReportErrorCode;
import com.inet.report.renderer.api.RendererFactory;
import com.inet.report.renderer.api.RendererFormatCategory;
import com.inet.report.renderer.api.ToClientCmd;
import com.inet.report.renderer.api.commands.a;
import com.inet.report.renderer.doc.DocumentWriter;
import com.inet.report.renderer.html.HtmlDocumentWriter;
import com.inet.report.util.RenderDataUtils;
import com.inet.report.util.WebUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class g
extends a
implements RendererFactory {
    @Nonnull
    public String getExtensionName() {
        return "html";
    }

    @Override
    public List<String> getSupportedFormats() {
        return List.of("html", "htm");
    }

    @Override
    @Nonnull
    public RendererFormatCategory getCategoryName() {
        return new RendererFormatCategory("renderer.category.doc");
    }

    @Override
    @Nullable
    public String getDisplayName(String exportformat) {
        return "html".equals(exportformat) ? "html".toUpperCase() : null;
    }

    @Override
    public boolean isViewer(String exportFormat) {
        return true;
    }

    @Override
    public boolean allowsPartialFormatMatching() {
        return true;
    }

    @Override
    @Nonnull
    public String getEngineExportFormat(@Nonnull String exportFormat) {
        return "htm";
    }

    @Override
    @Nullable
    public String getInitFormat(@Nonnull String exportFormat) {
        return "html";
    }

    @Override
    @Nonnull
    public DocumentWriter getDocumentWriter(@Nonnull String exportFormat) {
        return new HtmlDocumentWriter();
    }

    @Override
    @Nonnull
    public String getMimeType() {
        return "text/html; charset=utf-8";
    }

    @Override
    public void decodeContentTypeAndFormat(@Nonnull String exportFormat, @Nonnull Properties props) throws ReportException {
        String string = props.getProperty("init", "").toLowerCase();
        String string2 = props.getProperty("page", "");
        if (string.length() > 0 && string2.length() == 0) {
            props.put("cmd", string);
        }
        if (string2.endsWith(".png")) {
            props.put("content", "image/png");
        } else if (string2.endsWith(".svg")) {
            props.put("content", "image/svg+xml");
        } else {
            String string3 = props.getProperty("page");
            String string4 = "text/html; charset=utf-8";
            if (string3 != null) {
                if (string3.endsWith(".js")) {
                    string4 = "application/javascript; charset=utf-8";
                } else if (string3.endsWith(".png")) {
                    string4 = "image/png";
                }
            }
            props.put("content", string4);
        }
    }

    @Override
    @Nullable
    public ToClientCmd getToClientCmd(@Nonnull String exportFormat) {
        return this;
    }

    @Override
    public void exportPageToClient(@Nonnull Cache cache, int size, int count, @Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull OutputStream out, @Nonnull ReportCacheKey key, @Nonnull String httpContentType, @Nullable String page, @Nonnull Properties props) throws Exception {
        Object object = props.getProperty("file");
        if (object == null || ((String)object).length() == 0) {
            object = HtmlDocumentWriter.j(props);
            if (object == null || ((String)object).length() == 0) {
                throw ReportExceptionFactory.createReportException(ReportErrorCode.NoExportFile, new Object[0]);
            }
            object = (String)object + ".htm";
        }
        object = ((String)object).substring(((String)object).lastIndexOf("/") + 1);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        RenderDataUtils.writeFileData(byteArrayOutputStream, (String)object, RenderDataUtils.getHtmlViewerData(request, response));
        byte[] byArray = cache.getPageAndWait(key, 0, 600000);
        WebUtils.sendHeader(request, response, props, 200, byteArrayOutputStream.size() + byArray.length + size + 4, httpContentType);
        out.write(byteArrayOutputStream.toByteArray());
        out.write(byArray);
        for (int i2 = 1; i2 <= count; ++i2) {
            byArray = cache.getPageAndWait(key, i2, 600000);
            out.write(byArray);
        }
        out.write(RenderDataUtils.intToByteArray(-1));
    }
}

