/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.plugins.drive;

import com.inet.classloader.I18nMessages;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.DriveFileTypeHandler;
import com.inet.drive.api.feature.Content;
import com.inet.drive.api.feature.MetaData;
import com.inet.drive.api.feature.MetaKey;
import com.inet.drive.api.feature.Thumbnail;
import com.inet.http.servlet.ClientLocale;
import com.inet.lib.io.FastByteArrayInputStream;
import com.inet.lib.util.IOFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.persistence.PersistenceEntry;
import com.inet.plugin.image.PreviewGenerator;
import com.inet.report.BaseUtils;
import com.inet.report.Engine;
import com.inet.report.RDC;
import com.inet.report.ReportException;
import com.inet.report.SummaryInfo;
import com.inet.report.plugins.ReportingServerPlugin;
import com.inet.report.translation.Translations;
import com.inet.report.translation.Translator;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class e
implements DriveFileTypeHandler {
    private static final I18nMessages MSG = new I18nMessages("com.inet.report.plugins.drive.i18n.DriveLabels", e.class);
    private static final MetaKey<String[]> axm = new MetaKey<String[]>("CRFORMATS", false, false){

        public String getLabel() {
            return MSG.getMsg("format", new Object[0]);
        }

        public String d(String[] stringArray) {
            return stringArray != null ? Arrays.asList(stringArray).stream().collect(Collectors.joining(",")) : "";
        }

        public /* synthetic */ String formatValue(Object object) {
            return this.d((String[])object);
        }
    };
    private static final MetaKey<Map<String, String>> axn = new MetaKey<Map<String, String>>("comments", true, true){

        public String getLabel() {
            return MSG.getMsg("comment", new Object[0]);
        }

        public String b(Map<String, String> map) {
            int n2;
            String string = map.get("");
            String string2 = ClientLocale.getThreadLocale().toString();
            String string3 = map.get(string2);
            if (string3 == null && (n2 = string2.lastIndexOf(95)) >= 0) {
                string2 = string2.substring(0, n2);
                string3 = map.get(string2);
            }
            return string3 == null ? string : string3;
        }

        public /* synthetic */ String formatValue(Object object) {
            return this.b((Map)object);
        }
    };
    public static final MetaKey<String> axo = new MetaKey<String>("CRDESCRIPTION", false, false){

        public String getLabel() {
            return ReportingServerPlugin.MSG.getMsg("drive.meta.description", new Object[0]);
        }

        public String bY(String string) {
            return string;
        }

        public /* synthetic */ String formatValue(Object object) {
            return this.bY((String)object);
        }
    };

    @Nonnull
    public String getExtensionName() {
        return "handler.reports";
    }

    private InputStream a(DriveEntry driveEntry) {
        FastByteArrayInputStream fastByteArrayInputStream;
        block10: {
            if (!this.acceptFileTyp(driveEntry)) {
                return null;
            }
            Content content = (Content)driveEntry.getFeature(Content.class);
            if (content == null) {
                return null;
            }
            InputStream inputStream = content.getInputStream();
            try {
                fastByteArrayInputStream = new FastByteArrayInputStream(IOFunctions.readBytes((InputStream)inputStream));
                if (inputStream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    return null;
                }
            }
            inputStream.close();
        }
        return fastByteArrayInputStream;
    }

    @Nullable
    public Object getFileSpecificDiff(@Nonnull DriveEntry previous, @Nonnull DriveEntry after) {
        return null;
    }

    private static void a(@Nonnull Map<MetaKey<?>, Object> map, @Nonnull MetaKey<?> metaKey, @Nullable Object object) {
        if (object != null && !"".equals(object)) {
            map.put(metaKey, object);
        }
    }

    private StringBuilder s(Engine engine) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            Set<String> set = new Translator(engine).listLabels(false);
            for (String object2 : set) {
                stringBuilder.append(object2);
                stringBuilder.append(' ');
            }
            Translations translations = engine.getTranslations();
            List<Locale> list = translations.getAvailableLocales();
            for (Locale locale : list) {
                Properties properties = translations.getTranslation(locale);
                for (Object object : properties.values()) {
                    stringBuilder.append(object);
                    stringBuilder.append(' ');
                }
            }
        }
        catch (ReportException reportException) {
            BaseUtils.error(reportException);
        }
        return stringBuilder;
    }

    public boolean acceptFileTyp(@Nonnull DriveEntry entry) {
        String string;
        switch (string = DriveFileTypeHandler.getSuffix((String)entry.getName())) {
            case "rpt": {
                return true;
            }
        }
        return false;
    }

    @Nonnull
    public DriveFileTypeHandler.FileTypeDriveEntryHandler getFileTypeHandler(final @Nonnull PersistenceEntry persistenceEntry, @Nonnull DriveEntry entry) {
        return new DriveFileTypeHandler.FileTypeDriveEntryHandler(){
            private Map<MetaKey<?>, Object> awW;
            private String awX;

            private boolean wk() {
                boolean bl2;
                block13: {
                    if (this.awW != null) {
                        return true;
                    }
                    InputStream inputStream = persistenceEntry.getInputStream();
                    try {
                        Engine engine = RDC.loadEngine(null, inputStream, null, null);
                        SummaryInfo summaryInfo = engine.getSummaryInfo();
                        this.awW = new HashMap();
                        e.a(this.awW, MetaData.TITLE, summaryInfo.getReportTitle());
                        e.a(this.awW, MetaData.AUTHOR, summaryInfo.getAuthor());
                        e.a(this.awW, MetaData.KEYWORDS, summaryInfo.getKeywords());
                        e.a(this.awW, MetaData.MODIFIED, summaryInfo.getLastSaved().getTime());
                        e.a(this.awW, MetaData.CREATE, summaryInfo.getCreated().getTime());
                        e.a(this.awW, MetaData.FILETYPE, "rpt");
                        String[] stringArray = engine.getReportProperties().getEnabledFormats();
                        if (stringArray != null) {
                            e.a(this.awW, axm, stringArray);
                        }
                        StringBuilder stringBuilder = e.this.s(engine);
                        Translations translations = engine.getTranslations();
                        String string = summaryInfo.getComments();
                        if (!StringFunctions.isEmpty((String)string)) {
                            HashMap<String, String> hashMap = new HashMap<String, String>();
                            hashMap.put("", string);
                            stringBuilder.append(' ').append(string);
                            for (Locale locale : translations.getAvailableLocales()) {
                                Properties properties = translations.getTranslation(locale);
                                String string2 = properties.getProperty(string);
                                if (string2 == null) continue;
                                hashMap.put(locale.toString(), string2);
                                stringBuilder.append(' ').append(string2);
                            }
                            e.a(this.awW, axn, hashMap);
                        }
                        stringBuilder.append(' ').append(summaryInfo.getSubject());
                        this.awX = stringBuilder.toString();
                        bl2 = true;
                        if (inputStream == null) break block13;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Throwable throwable3) {
                            if (BaseUtils.isDebug()) {
                                BaseUtils.debug(throwable3);
                            }
                            return false;
                        }
                    }
                    inputStream.close();
                }
                return bl2;
            }

            @Nullable
            public String getTextForSearch() {
                if (this.wk()) {
                    return this.awX;
                }
                return null;
            }

            @Nullable
            public Map<MetaKey<?>, Object> getMetaData() {
                if (this.wk()) {
                    return this.awW;
                }
                return null;
            }
        };
    }

    public PreviewGenerator.ImagePreview getThumbnail(@Nonnull DriveEntry entry, Thumbnail.Size size, boolean requireExactSize) throws IOException {
        return PreviewGenerator.generatePreviewImage(() -> {
            InputStream inputStream = this.a(entry);
            if (inputStream == null) {
                return null;
            }
            try (ZipInputStream zipInputStream = new ZipInputStream(inputStream);){
                ZipEntry zipEntry = null;
                do {
                    if ((zipEntry = zipInputStream.getNextEntry()) == null) return null;
                } while (!"Thumbnails/thumbnail.png".equals(zipEntry.getName()));
                byte[] byArray = IOFunctions.readBytes((InputStream)zipInputStream);
                FastByteArrayInputStream fastByteArrayInputStream = new FastByteArrayInputStream(byArray);
                return fastByteArrayInputStream;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return null;
        }, (String)"png", (int)size.getSize(), (boolean)true);
    }
}

