/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.output;

import com.inet.annotations.PublicApi;
import com.inet.report.BaseUtils;
import com.inet.report.output.DocumentOutput;
import java.io.IOException;
import java.io.OutputStream;

@PublicApi
public class DocumentOutputStream
implements DocumentOutput {
    private OutputStream awj;
    private boolean awk;
    private int VJ;
    private byte[] awl;

    public DocumentOutputStream(OutputStream output, boolean autoClose) {
        this.awj = output;
        this.awk = autoClose;
    }

    @Override
    public int getPageCount() {
        return this.VJ;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] getPageData(int idx) throws ArrayIndexOutOfBoundsException {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] getGroupTree() {
        return this.awl;
    }

    @Override
    public void addPage(byte[] page) throws IllegalStateException {
        try {
            this.awj.write(page);
            ++this.VJ;
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    @Override
    public void setPageData(byte[] page, int idx) throws IllegalStateException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setGroupTree(byte[] data) throws IllegalStateException {
        this.awl = data;
        this.close();
    }

    private void close() {
        if (this.awk) {
            try {
                this.awj.close();
            }
            catch (IOException iOException) {
                BaseUtils.error(iOException);
            }
        }
    }

    @Override
    public void setErrorData(byte[] error) throws IllegalStateException {
        this.close();
    }

    @Override
    public void stop(String cause) {
        this.close();
    }

    @Override
    public void addFontData(byte[] fontData) throws IllegalStateException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFontData(byte[] fontData, int idx) throws IllegalStateException {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] getFontData(int idx) throws ArrayIndexOutOfBoundsException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getFontCount() {
        return 0;
    }

    @Override
    public void setPageLimitExceeded() {
    }

    @Override
    public boolean isPageLimitExceeded() {
        return false;
    }

    @Override
    public void setUsingTotalPage() {
    }
}

