/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.chart.plot;

import com.inet.annotations.PublicApi;
import com.inet.jfree.chart.labels.BubbleXYItemLabelGenerator;
import com.inet.jfree.chart.labels.StandardXYItemLabelGenerator;
import com.inet.jfree.chart.labels.XYItemLabelGenerator;
import com.inet.report.Chart2;
import com.inet.report.chart.a;
import com.inet.report.chart.axis.ContinuousNumberAxis;
import com.inet.report.chart.dataset.LabelProvider;
import com.inet.report.chart.dataset.XYDataset;
import com.inet.report.chart.f;
import com.inet.report.chart.format.ChartFormat;
import com.inet.report.chart.format.FormatingProperties;
import com.inet.report.chart.plot.AbstractPlot;
import com.inet.report.chart.plot.ChartStyle;
import com.inet.report.chart.plot.XYStyle;
import com.inet.report.i;
import com.inet.report.util.EngineUtils;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@PublicApi
public class XYPlot
extends AbstractPlot {
    public static final XYStyle DEFAULT_STYLE = XYStyle.SCATTER;
    public static final double DEFAULT_SIZE_COEFFICIENT = 0.3;
    private XYStyle ZX;
    private XYDataset ZY;
    private ContinuousNumberAxis ZZ;
    private ContinuousNumberAxis ZW;
    private double aaa;

    public XYPlot() {
        this(DEFAULT_STYLE);
    }

    public XYPlot(XYStyle style) {
        if (style == null) {
            throw i.d("style");
        }
        this.ZX = style;
        this.setCategoryAxis(new ContinuousNumberAxis());
        this.setDataAxis(new ContinuousNumberAxis());
        this.aaa = 0.3;
    }

    @Override
    public XYDataset getDataset() {
        return this.ZY;
    }

    public void setDataset(XYDataset dataset) {
        if (dataset == null) {
            throw i.d("dataset");
        }
        this.ZY = dataset;
        this.ZY.updateReferences();
    }

    public ContinuousNumberAxis getCategoryAxis() {
        return this.ZZ;
    }

    public void setCategoryAxis(ContinuousNumberAxis categoryAxis) {
        if (categoryAxis == null) {
            throw i.d("categoryAxis");
        }
        this.ZZ = categoryAxis;
    }

    public ContinuousNumberAxis getDataAxis() {
        return this.ZW;
    }

    public void setDataAxis(ContinuousNumberAxis dataAxis) {
        if (dataAxis == null) {
            throw i.d("dataAxis");
        }
        this.ZW = dataAxis;
    }

    @Override
    public ChartStyle getStyle() {
        return this.ZX;
    }

    public void setStyle(XYStyle style) {
        if (style == null) {
            throw i.d("style");
        }
        this.ZX = style;
    }

    public double getSizeCoefficient() {
        return this.aaa;
    }

    public void setSizeCoefficient(double sizeCoefficient) {
        if (sizeCoefficient < 0.0 || sizeCoefficient > 1.0) {
            throw new IllegalArgumentException("Coefficient is out of range (0-1).");
        }
        this.aaa = sizeCoefficient;
    }

    @Override
    public void refreshAutoTitles(Chart2 chart) {
        if (this.ZY != null) {
            LabelProvider labelProvider = this.ZY.getLabelProvider();
            if (this.getStyle() == XYStyle.SCATTER) {
                a.setAutoTitle(chart.getHeaderTitle(), EngineUtils.CHART_MSG.getMsg("ScatterChart", new Object[0]));
                a.setAutoTitle(chart.getFootnote(), labelProvider.getLabel(1));
            } else if (this.getStyle() == XYStyle.BUBBLE) {
                a.setAutoTitle(chart.getHeaderTitle(), EngineUtils.CHART_MSG.getMsg("BubbleChart", new Object[0]));
                a.setAutoTitle(chart.getFootnote(), EngineUtils.CHART_MSG.getMsg("BubbleSize", new Object[0]) + " " + labelProvider.getLabel(1));
            }
            a.setAutoTitle(this.getCategoryAxis().getTitle(), labelProvider.getLabel(2));
            a.setAutoTitle(this.getDataAxis().getTitle(), labelProvider.getLabel(4));
        }
    }

    XYItemLabelGenerator e(Locale locale) {
        StandardXYItemLabelGenerator standardXYItemLabelGenerator = null;
        NumberFormat numberFormat = NumberFormat.getInstance(locale);
        ChartFormat chartFormat = this.getItemLabelFormat();
        if (chartFormat instanceof NumberFormat) {
            chartFormat.setFormatingProperties(new FormatingProperties(TimeZone.getDefault(), locale, -1));
            numberFormat = (NumberFormat)((Object)chartFormat);
        }
        if (this.getStyle().equals(XYStyle.SCATTER)) {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.isShowLabel()) {
                stringBuilder.append("{0}");
                if (this.isShowValue()) {
                    stringBuilder.append("  ");
                }
            }
            if (this.isShowValue()) {
                stringBuilder.append("({1}, {2})");
            }
            if (stringBuilder.length() > 0) {
                standardXYItemLabelGenerator = new StandardXYItemLabelGenerator(stringBuilder.toString(), numberFormat, numberFormat);
            }
        } else if (this.getStyle().equals(XYStyle.BUBBLE)) {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.isShowLabel()) {
                stringBuilder.append("{0}");
                if (this.isShowValue()) {
                    stringBuilder.append("  ");
                }
            }
            if (this.isShowValue()) {
                stringBuilder.append("({1}, {2}, {3})");
            }
            if (stringBuilder.length() > 0) {
                standardXYItemLabelGenerator = new BubbleXYItemLabelGenerator(stringBuilder.toString(), numberFormat, numberFormat, numberFormat);
            }
        }
        return standardXYItemLabelGenerator;
    }

    @Override
    protected StringBuilder cs(int n2) {
        StringBuilder stringBuilder = super.cs(n2);
        f.b(stringBuilder, n2, "SizeCoefficient", String.valueOf(this.getSizeCoefficient()));
        return stringBuilder;
    }

    @Override
    protected void B(PrintWriter printWriter, int n2) {
        super.B(printWriter, n2);
        ++n2;
        if (this.ZY != null) {
            com.inet.report.chart.dataset.a.a(this.ZY, printWriter, n2);
        }
        this.ZZ.saveProperties(printWriter, n2, "CategoryAxis");
        this.ZW.saveProperties(printWriter, n2, "DataAxis");
    }

    @Override
    public void readProperties(Element element, Chart2 chart) {
        super.readProperties(element, chart);
        NodeList nodeList = element.getChildNodes();
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            if (!(nodeList.item(i2) instanceof Element)) continue;
            Element element2 = (Element)nodeList.item(i2);
            if (element2.getNodeName().equals("CategoryAxis")) {
                this.ZZ.readProperties(element2, chart);
                continue;
            }
            if (element2.getNodeName().equals("DataAxis")) {
                this.ZW.readProperties(element2, chart);
                continue;
            }
            if (element2.getNodeName().equals("SizeCoefficient")) {
                double d2;
                String string = element2.getAttribute("value");
                if (string.length() <= 0 || !((d2 = Double.valueOf(string).doubleValue()) >= 0.0) || !(d2 <= 1.0)) continue;
                this.setSizeCoefficient(d2);
                continue;
            }
            if (!element2.getNodeName().equals("Dataset")) continue;
            this.setDataset((XYDataset)com.inet.report.chart.dataset.a.b(element2, chart));
        }
    }

    @Override
    public List getReferencedObject() {
        List list = super.getReferencedObject();
        list.addAll(this.ZZ.getReferencedObjects());
        list.addAll(this.ZW.getReferencedObjects());
        return list;
    }
}

