/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.chart.axis;

import com.inet.annotations.PublicApi;
import com.inet.report.BaseUtils;
import com.inet.report.chart.f;
import java.io.Serializable;
import org.w3c.dom.Element;

@PublicApi
public class NumberRange
implements Serializable {
    private Double XI;
    private Double XJ;
    private boolean vy;

    public NumberRange() {
        this.vy = true;
    }

    public NumberRange(double lower, double upper) {
        if (lower > upper) {
            throw new IllegalArgumentException("Parameter 'upper' less than 'lower'.");
        }
        this.vy = false;
        this.XI = new Double(lower);
        this.XJ = new Double(upper);
    }

    public boolean isAutoRange() {
        return this.vy;
    }

    public void setAutoRange(boolean autoRange) {
        this.vy = autoRange;
    }

    public Double getLowerBound() {
        if (this.XI == null) {
            return null;
        }
        return this.XI;
    }

    public void setLowerBound(Double lower) {
        if (this.XJ != null && lower > this.XJ) {
            throw new IllegalArgumentException("Parameter 'lower' greater than upper bound.");
        }
        this.XI = lower;
    }

    public Double getUpperBound() {
        if (this.XJ == null) {
            return null;
        }
        return this.XJ;
    }

    public void setUpperBound(Double upper) {
        if (this.XI != null && upper < this.XI) {
            throw new IllegalArgumentException("Parameter 'upper' less than 'lower'.");
        }
        this.XJ = upper;
    }

    boolean mW() {
        return this.getUpperBound() != null && this.getLowerBound() != null;
    }

    void saveProperties(StringBuilder buffer, int depth) {
        if (!this.isAutoRange()) {
            buffer.append(BaseUtils.getIndent(depth));
            buffer.append("<");
            buffer.append("RangeNumber");
            buffer.append(' ');
            if (this.XI != null) {
                f.b(buffer, "lowerBound", this.XI.toString());
            }
            if (this.XJ != null) {
                f.b(buffer, "upperBound", this.XJ.toString());
            }
            buffer.append("/");
            buffer.append(">\n");
        }
    }

    void readProperties(Element element) {
        this.setAutoRange(false);
        String string = element.getAttribute("lowerBound");
        if (string.length() > 0) {
            this.setLowerBound(new Double(string));
        }
        if ((string = element.getAttribute("upperBound")).length() > 0) {
            this.setUpperBound(new Double(string));
        }
    }
}

