/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.cache;

import com.inet.annotations.PublicApi;
import com.inet.classloader.ObjectStreams;
import com.inet.plugin.ServerPluginManager;
import com.inet.report.BaseUtils;
import com.inet.report.Engine;
import com.inet.report.PropertiesChecker;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.ReportGenerator;
import com.inet.report.cache.EngineFactory;
import com.inet.report.cache.EngineFactoryImpl;
import com.inet.report.cache.KeyNotFoundException;
import com.inet.report.cache.PageOutOfRangeException;
import com.inet.report.cache.ReportCacheKey;
import com.inet.report.cache.store.b;
import com.inet.report.config.datasource.DataSourceConfiguration;
import com.inet.report.config.datasource.DataSourceConfigurationChangeListener;
import com.inet.report.config.datasource.DataSourceConfigurationManager;
import com.inet.report.i18n.ReportErrorCode;
import com.inet.report.util.EngineUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.AccessController;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ForkJoinPool;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PublicApi
public abstract class Cache {
    private static EngineFactory VI = new EngineFactoryImpl();
    private static Cache hi;
    public static final int TYPE_MEMORY = 0;
    public static final int TYPE_DATABASE = 1;
    public static final int TYPE_HARDDISK = 2;

    protected Cache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static Cache getCache() {
        Cache cache = hi;
        if (cache != null) return cache;
        Class<Cache> clazz = Cache.class;
        synchronized (Cache.class) {
            if (hi != null) return hi;
            Cache.dF();
            return hi;
        }
    }

    private static void dF() {
        if (EngineUtils.isDesigner()) {
            return;
        }
        Cache cache = hi;
        if (cache != null) {
            cache.destroy();
        }
        hi = new b();
    }

    public static void shutdown() {
        Cache cache = hi;
        if (cache != null) {
            cache.destroy();
        }
    }

    private void destroy() {
        try {
            this.clear();
        }
        catch (ReportException reportException) {
            // empty catch block
        }
    }

    public static void setEngineFactory(EngineFactory engineFactory) {
        if (engineFactory == null) {
            throw new IllegalArgumentException("EngineFactory should not be null");
        }
        VI = engineFactory;
    }

    public static EngineFactory getEngineFactory() {
        return VI;
    }

    public static PropertiesChecker getPropertiesChecker() {
        return (PropertiesChecker)com.inet.report.servlets.b.buc.get();
    }

    public ReportCacheKey getKey(Properties props) throws ReportException {
        return this.getKey(props, Cache.getPropertiesChecker(), null);
    }

    public ReportCacheKey getKey(Properties props, PropertiesChecker checker, Object req) throws ReportException {
        return this.getKey(props, checker, VI, req);
    }

    @Nonnull
    public abstract ReportCacheKey getKey(Properties var1, PropertiesChecker var2, EngineFactory var3, Object var4) throws ReportException;

    public final byte[] getPageAndWait(ReportCacheKey key, int page) throws PageOutOfRangeException, KeyNotFoundException, ReportException {
        return this.getPageAndWait(key, page, 0);
    }

    public abstract byte[] getPageAndWait(ReportCacheKey var1, int var2, int var3) throws PageOutOfRangeException, KeyNotFoundException, ReportException;

    public final byte[] getGroupTreeAndWait(ReportCacheKey key, int groupNumber, int requestType) throws KeyNotFoundException, ReportException {
        return this.getGroupTreeAndWait(key, groupNumber, requestType, 0);
    }

    public byte[] getGroupTreeAndWait(ReportCacheKey key, int groupNumber, int requestType, int timeout) throws KeyNotFoundException, ReportException {
        byte[] byArray = this.getPageAndWait(key, 0, timeout);
        if (byArray == null && BaseUtils.isDebug()) {
            BaseUtils.debug("group tree is not in the cache.");
        }
        return byArray;
    }

    public final int getPageCountAndWait(ReportCacheKey key) throws KeyNotFoundException, ReportException {
        return this.getPageCountAndWait(key, 0);
    }

    public abstract int getPageCountAndWait(ReportCacheKey var1, int var2) throws KeyNotFoundException, ReportException;

    public final int getTotalPageSizeAndWait(ReportCacheKey key) throws KeyNotFoundException, ReportException {
        return this.getTotalPageSizeAndWait(key, 0);
    }

    public abstract int getTotalPageSizeAndWait(ReportCacheKey var1, int var2) throws KeyNotFoundException, ReportException;

    public abstract boolean isPageLimitExceeded(ReportCacheKey var1) throws KeyNotFoundException, ReportException;

    public abstract void lock(ReportCacheKey var1) throws KeyNotFoundException, ReportException;

    public abstract void unlock(ReportCacheKey var1) throws KeyNotFoundException, ReportException;

    public abstract void clear() throws ReportException;

    public abstract void addEngine(Engine var1, ReportCacheKey var2) throws ReportException;

    public abstract boolean exists(ReportCacheKey var1);

    @Nonnull
    public ReportCacheKey createKey(Properties props) throws ReportException {
        return this.createKey(props, Cache.getPropertiesChecker(), null);
    }

    @Nonnull
    public ReportCacheKey createKey(Properties props, PropertiesChecker checker, Object req) throws ReportException {
        return this.createKey(props, checker, VI, req);
    }

    @Nonnull
    public ReportCacheKey createKey(Properties props, PropertiesChecker checker, EngineFactory factory, Object req) throws ReportException {
        if (checker != null && props.get("PropertyChecker") == null) {
            try {
                checker.checkProperties(props, req);
                props.put("PropertyChecker", "PropertyChecker");
            }
            catch (ReportException reportException) {
                throw reportException;
            }
            catch (Throwable throwable) {
                if (BaseUtils.isWarning()) {
                    BaseUtils.warning("Could not execute checkProperties, reason:");
                }
                BaseUtils.printStackTrace(throwable);
            }
        }
        return factory.getKey(props);
    }

    public abstract void delete(String var1) throws ReportException;

    public abstract void delete(ReportCacheKey var1) throws ReportException;

    public abstract boolean isFinished(ReportCacheKey var1) throws ReportException;

    @Deprecated
    public abstract boolean containsInRAM(ReportCacheKey var1);

    public abstract int getMemoryUsage(ReportCacheKey var1);

    public abstract long getSwapSize(ReportCacheKey var1);

    public abstract long getSwapSize();

    @Nonnull
    public abstract List<ReportCacheKey> getReports() throws ReportException;

    @Deprecated
    public abstract boolean isFinishWrittenToStore(ReportCacheKey var1) throws ReportException, KeyNotFoundException;

    public abstract boolean isFailedReport(ReportCacheKey var1) throws ReportException;

    public Throwable getFailureCause(ReportCacheKey key) throws ReportException {
        if (this.isFailedReport(key)) {
            byte[] byArray = this.getPageAndWait(key, 1, 600000);
            try {
                ObjectStreams.CacheObjectInputStream cacheObjectInputStream = new ObjectStreams.CacheObjectInputStream((InputStream)new ByteArrayInputStream(byArray));
                Throwable throwable = (Throwable)cacheObjectInputStream.readObject();
                cacheObjectInputStream.close();
                return throwable;
            }
            catch (Exception exception) {
                throw ReportExceptionFactory.createReportExceptionWithCause(exception, ReportErrorCode.Cache_getFailureCause, key.getReport());
            }
        }
        return null;
    }

    public abstract int getType();

    public abstract int getMemoryUsage();

    public abstract void resetCacheTimeout(ReportCacheKey var1);

    @Nullable
    public abstract ReportGenerator getEngine(ReportCacheKey var1);

    static {
        ForkJoinPool.commonPool().execute(() -> AccessController.doPrivileged(() -> {
            DataSourceConfigurationManager.addDataSourceConfigurationListener(new DataSourceConfigurationChangeListener(){

                private void clear() {
                    try {
                        Cache cache = hi;
                        if (cache != null) {
                            for (ReportCacheKey reportCacheKey : cache.getReports()) {
                                if (!cache.isFinished(reportCacheKey)) continue;
                                cache.delete(reportCacheKey);
                            }
                        }
                    }
                    catch (ReportException reportException) {
                        BaseUtils.printStackTrace(reportException);
                    }
                }

                @Override
                public void removedDataSourceConfiguration(DataSourceConfiguration dsc) {
                    this.clear();
                }

                @Override
                public void propertyChanged(DataSourceConfiguration dsc, String property, String oldValue, String newValue) {
                    this.clear();
                }

                @Override
                public void addedDataSourceConfiguration(DataSourceConfiguration dsc) {
                    this.clear();
                }
            });
            EngineFactory engineFactory = (EngineFactory)ServerPluginManager.getInstance().getOptionalInstance(EngineFactory.class);
            if (engineFactory != null) {
                VI = engineFactory;
            }
            return null;
        }));
    }
}

