/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.PublicApi;
import com.inet.report.BaseUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import javax.imageio.ImageIO;

@PublicApi
public class SummaryInfo
implements Serializable {
    private String hn;
    private String Pu;
    private String Pv;
    private String Pw;
    private String Px;
    private String Py;
    private Date Pz;
    private Date PA;
    private transient BufferedImage PB;
    private byte[] PC;

    SummaryInfo() {
    }

    public String getAuthor() {
        return this.Pu;
    }

    public void setAuthor(String author) {
        this.Pu = author;
    }

    public String getKeywords() {
        return this.Pv;
    }

    public void setKeywords(String keywords) {
        this.Pv = keywords;
    }

    public String getComments() {
        return this.Py;
    }

    public void setComments(String comments) {
        this.Py = comments;
    }

    public String getReportTitle() {
        return this.hn;
    }

    public void setReportTitle(String title) {
        this.hn = title;
    }

    public String getSubject() {
        return this.Pw;
    }

    public void setSubject(String subject) {
        this.Pw = subject;
    }

    public String getTemplate() {
        return this.Px;
    }

    public void setTemplate(String template) {
        this.Px = template;
    }

    public Date getCreated() {
        return this.PA;
    }

    public void setCreated(Date createTime) {
        this.PA = createTime;
    }

    public Date getLastSaved() {
        return this.Pz;
    }

    public void setLastSaved(Date lastSave) {
        this.Pz = lastSave;
    }

    public void setThumbnail(Image img) {
        this.PC = null;
        if (img == null) {
            this.PB = null;
            return;
        }
        int n2 = img.getWidth(null);
        int n3 = img.getHeight(null);
        int n4 = n2;
        int n5 = n3;
        if (n2 > n3) {
            var6_6 = (double)n2 / 256.0;
            n4 = 256;
            n5 = (int)((double)n5 / var6_6);
        } else {
            var6_6 = (double)n3 / 256.0;
            n5 = 256;
            n4 = (int)((double)n4 / var6_6);
        }
        img = img.getScaledInstance(n4, n5, 4);
        BufferedImage bufferedImage = new BufferedImage(n4, n5, 6);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.drawImage(img, 0, 0, Color.WHITE, null);
        graphics.dispose();
        this.PB = bufferedImage;
        this.getThumbnailData();
    }

    public Image getThumbnail() {
        if (this.PB == null && this.PC != null) {
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.PC);
                this.PB = ImageIO.read(byteArrayInputStream);
            }
            catch (IOException iOException) {
                BaseUtils.printStackTrace(iOException);
                this.PC = null;
            }
        }
        return this.PB;
    }

    public void setThumbnailData(byte[] data) {
        this.PB = null;
        this.PC = data;
    }

    public byte[] getThumbnailData() {
        if (this.PC == null && this.PB != null) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)this.PB, "png", byteArrayOutputStream);
                this.PC = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                BaseUtils.printStackTrace(iOException);
            }
        }
        return this.PC;
    }
}

