/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.PublicApi;
import com.inet.report.BaseUtils;
import com.inet.report.Chart2;
import com.inet.report.CrossTab;
import com.inet.report.DatabaseTables;
import com.inet.report.Field;
import com.inet.report.Fields;
import com.inet.report.FormulaField;
import com.inet.report.Group;
import com.inet.report.GroupField;
import com.inet.report.PromptField;
import com.inet.report.ReferenceHolder;
import com.inet.report.ReferencedObject;
import com.inet.report.ReportDataHandler;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.Validatable;
import com.inet.report.Validity;
import com.inet.report.aj;
import com.inet.report.at;
import com.inet.report.ba;
import com.inet.report.by;
import com.inet.report.i18n.ReportErrorCode;
import com.inet.report.k;
import com.inet.report.parser.FatalParserException;
import com.inet.report.parser.NodeParser;
import com.inet.report.parser.XMLTag;
import com.inet.report.r;
import com.inet.report.y;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Map;
import org.xml.sax.Attributes;

@PublicApi
public class SummaryField
extends Field
implements ReferenceHolder,
Validatable {
    int hW;
    int OB;
    int MZ;
    Object OC;
    Field OD;
    transient int OE;
    Field OF;
    Field OG;
    Group OH;
    private boolean OI = false;
    transient int tb;
    private boolean OJ = false;
    private boolean OK = false;
    public static final int SUM = 0;
    public static final int AVERAGE = 1;
    public static final int SAMPLE_VARIANCE = 2;
    public static final int SAMPLE_STANDARD_DEVIATION = 3;
    public static final int MAXIMUM = 4;
    public static final int MINIMUM = 5;
    public static final int COUNT = 6;
    public static final int POP_VARIANCE = 7;
    public static final int POP_STANDARD_DEVIATION = 8;
    public static final int DISTINCT_COUNT = 9;
    public static final int CORRELATION = 10;
    public static final int COVARIANCE = 11;
    public static final int WEIGHTED_AVERAGE = 12;
    public static final int MEDIAN = 13;
    public static final int PERCENTILE = 14;
    public static final int NTH_LARGEST = 15;
    public static final int NTH_SMALLEST = 16;
    public static final int MODE = 17;
    public static final int NTH_MOST_FREQUENT = 18;
    public static final int PERCENTAGE = 19;
    public static final int NO_SUMMARY_OPERATION = 20;
    public static final int SUMMARY_REPORT = 0;
    public static final int SUMMARY_CROSSTAB = 1;
    public static final int SUMMARY_CHART = 3;
    private static final String[] OL = new String[]{"RESET_NEVER", "RESET_ON_CHANGE_OF_FIELD", "RESET_ON_CHANGE_OF_GROUP", "RESET_USING_FORMULA"};
    private static String[] OM = new String[]{"CHANGE_FOR_EACH_RECORD", "CHANGE_ON_CHANGE_OF_FIELD", "CHANGE_ON_CHANGE_OF_GROUP", "CHANGE_USING_FORMULA"};
    protected r qj = new r(this);

    protected SummaryField(ba ren) {
        this.type = 11;
        this.bB = ren;
        this.valueType = 6;
    }

    @Override
    public void setName(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("The name of a sum field cannot be empty.");
        }
        if (name.equals(this.name)) {
            return;
        }
        if (this.bB == null) {
            return;
        }
        if (Fields.a((Field[])this.bB.Iy, name)) {
            throw y.b("SummaryField", name, null);
        }
        try {
            this.rename(name);
        }
        catch (ReportException reportException) {
            throw new IllegalArgumentException("Name not allowed", reportException);
        }
    }

    String kh() {
        if (this.OJ || this.name == null || this.name.length() == 0) {
            this.OJ = true;
            this.setName(this.ki());
        }
        return this.getName();
    }

    String ki() {
        Object object;
        if (this.getField() != null) {
            String string = SummaryField.getOperationName(this.getSummaryOperation()) + " " + this.getField().getName();
            object = this.getGroup();
            if (object != null) {
                string = string + "," + ((Group)object).getField().getName();
            }
            for (int i2 = 0; i2 < 50; ++i2) {
                String string2;
                String string3 = string2 = i2 == 0 ? string : string + " (" + i2 + ")";
                if (Fields.a((Field[])this.bB.Iy, string2)) continue;
                return string2;
            }
        }
        for (int i3 = 0; i3 < 50; ++i3) {
            object = "sum Field id " + (this.hashCode() + i3);
            if (Fields.a((Field[])this.bB.Iy, (String)object)) continue;
            return object;
        }
        return this.getName();
    }

    public final void setSummaryOperation(int operation) {
        this.MZ = operation;
    }

    public int getSummaryOperation() {
        return this.MZ;
    }

    public static final String getOperationName(int operation) {
        if (operation < 0 || operation >= b.values().length) {
            return b.Ps.name;
        }
        for (int i2 = 0; i2 < b.values().length; ++i2) {
            b b2 = b.values()[operation];
            if (b2.gz != operation) continue;
            return b2.name;
        }
        return "";
    }

    public static final int getSummaryOperation(String operation) {
        try {
            return b.valueOf((String)operation).gz;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return b.Ps.gz;
        }
    }

    public int getSummaryFieldType() {
        return this.qq;
    }

    public void setSummaryFieldType(int type) {
        this.qq = type;
    }

    private void bJ(int n2) {
        if (n2 >= 0 && n2 <= 3) {
            this.hW = this.hW & 0xFF | n2 << 8;
        }
    }

    private int kj() {
        return this.hW >> 8;
    }

    public Field getResetField() {
        int n2 = this.kj();
        switch (n2) {
            case 0: {
                return null;
            }
            case 1: {
                if (this.OG != null && this.OG.type == 14) {
                    return this.OG;
                }
                return null;
            }
            case 2: {
                if (this.OH != null) {
                    return this.OH.sD;
                }
                return null;
            }
            case 3: {
                if (this.OG != null && this.OG.type == 13) {
                    return this.OG;
                }
                return null;
            }
        }
        throw new IllegalStateException("Unknown resetType " + n2);
    }

    public void setResetField(Field rstField) {
        if (rstField == null) {
            this.bJ(0);
            this.OG = null;
            this.OH = null;
            this.updateReferences();
            return;
        }
        switch (rstField.type) {
            case 14: {
                this.bJ(1);
                break;
            }
            case 12: {
                this.bJ(2);
                this.OH = rstField.getGroup();
                break;
            }
            case 13: {
                this.bJ(3);
            }
        }
        this.OG = FormulaField.f(rstField);
        this.setChangeField(this.OF);
        this.updateReferences();
    }

    private void bK(int n2) {
        if (n2 >= 0 && n2 <= 3) {
            this.hW = this.hW & 0xFF00 | n2;
        }
    }

    private int kk() {
        return this.hW & 0xFF;
    }

    public Field getChangeField() {
        int n2 = this.kk();
        switch (n2) {
            case 0: {
                return null;
            }
            case 1: {
                if (this.getRunningTotal()) {
                    if (this.OF != null && this.OF.type == 14) {
                        return this.OF;
                    }
                    return null;
                }
            }
            case 2: {
                if (this.getGroup() != null) {
                    return this.getGroup().sD;
                }
                return null;
            }
            case 3: {
                if (this.OF != null && this.OF.type == 13) {
                    return this.OF;
                }
                return null;
            }
        }
        throw new IllegalStateException("Unknown changeType " + n2);
    }

    public void setChangeField(Field changeField) {
        if (changeField == null) {
            this.setGroup(null);
            if (!this.getRunningTotal()) {
                this.km();
                this.updateReferences();
                return;
            }
            this.bK(0);
            this.km();
            this.updateReferences();
        } else {
            switch (changeField.type) {
                case 13: {
                    this.bK(3);
                    this.setGroup(null);
                    break;
                }
                case 14: {
                    this.bK(1);
                    this.setGroup(null);
                    break;
                }
                case 12: {
                    this.bK(2);
                    this.setGroup(changeField.getGroup());
                }
            }
        }
        this.OF = FormulaField.f(changeField);
        this.km();
        this.updateReferences();
    }

    public int getSummaryNth() {
        return this.OB;
    }

    public void setSummaryNth(int summaryNth) {
        this.OB = summaryNth;
    }

    public void setShowPercentVal(boolean newValue) {
        this.OI = newValue;
    }

    public boolean getShowPercentVal() {
        return this.OI;
    }

    public boolean getRunningTotal() {
        return this.OF != null || this.hW != 1;
    }

    public void setRunningTotal(boolean isRunningTotal) {
        if (isRunningTotal) {
            if (!this.getRunningTotal()) {
                this.hW = 0;
            }
        } else {
            this.OF = null;
            this.OG = null;
            this.hW = 1;
        }
    }

    @Override
    Field[] D(int n2) {
        return new SummaryField[n2];
    }

    @Override
    public int getValueType() {
        try {
            return this.kl();
        }
        catch (ReportException reportException) {
            return -1;
        }
    }

    private int kl() throws ReportException {
        if (this.getField() == null) {
            return -1;
        }
        switch (this.MZ) {
            case 0: 
            case 1: {
                this.valueType = this.getField().getValueType() & 0xF;
                if (this.valueType == 6 || this.valueType == 7) {
                    return this.valueType;
                }
                Object[] objectArray = new Object[]{"NUMBER or CURRENCY", this.getValueTypeString(), this.paramString()};
                throw ReportExceptionFactory.createReportException(ReportErrorCode.WrongValueType, objectArray);
            }
            case 2: 
            case 7: 
            case 8: {
                int n2 = this.getField().getValueType() & 0xF;
                if (n2 == 6 || n2 == 7) {
                    this.valueType = 6;
                    return 6;
                }
                Object[] objectArray = new Object[]{"NUMBER", this.getValueTypeString(), this.paramString()};
                throw ReportExceptionFactory.createReportException(ReportErrorCode.WrongValueType, objectArray);
            }
            case 19: {
                this.valueType = 6;
                return 6;
            }
            case 10: 
            case 11: 
            case 12: {
                if (this.OD == null) {
                    return -1;
                }
                int n3 = this.getField().getValueType() & 0xF;
                int n4 = this.OD.getValueType() & 0xF;
                if (n3 == 6 && (n4 == 6 || n4 == 7)) {
                    this.valueType = n3;
                    return this.valueType;
                }
                if (n3 == 7 && (n4 == 6 || n4 == 7)) {
                    this.valueType = n3;
                    return this.valueType;
                }
                this.valueType = n3 == 6 ? n4 : n3;
                Object[] objectArray = new Object[]{"NUMBER", this.getValueTypeString(), this.paramString()};
                throw ReportExceptionFactory.createReportException(ReportErrorCode.WrongValueType, objectArray);
            }
            case 6: 
            case 9: {
                this.valueType = 6;
                return 6;
            }
            case 3: 
            case 13: 
            case 14: {
                this.valueType = this.getField().getValueType() & 0xF;
                if (this.valueType == 6 || this.valueType == 7) {
                    return this.valueType;
                }
                Object[] objectArray = new Object[]{"NUMBER or CURRENCY", this.getValueTypeString(), this.paramString()};
                throw ReportExceptionFactory.createReportException(ReportErrorCode.WrongValueType, objectArray);
            }
        }
        this.valueType = this.getField().getValueType() & 0xF;
        return this.valueType;
    }

    @Override
    public String paramString() {
        StringBuilder stringBuilder = new StringBuilder(this.getTypeAsString());
        stringBuilder.append(":'").append(this.name).append('\'');
        stringBuilder.append('{');
        if (this.getField() != null) {
            stringBuilder.append(this.getField().getName());
        }
        if (this.getGroup() != null && this.getGroup().getField() != null) {
            stringBuilder.append(',').append(this.getGroup().getField().getName());
        }
        stringBuilder.append("}, ");
        if (this.getRunningTotal()) {
            stringBuilder.append("RT");
        } else {
            stringBuilder.append("SUM");
        }
        stringBuilder.append(' ');
        stringBuilder.append(this.bL(this.hW));
        stringBuilder.append(", ");
        stringBuilder.append("operation: ");
        try {
            stringBuilder.append(this.getSummaryOperation());
        }
        catch (Exception exception) {
            stringBuilder.append("UNK");
        }
        stringBuilder.append(", value type: ").append(this.getValueTypeString());
        return stringBuilder.toString();
    }

    public static String generateName(String field, String group, int sumType) {
        return SummaryField.generateName(field, group, sumType, null);
    }

    public static String generateName(String field, String group, int sumType, String field2) {
        String string = SummaryField.getOperationName(sumType) + " of " + field;
        if (field2 != null) {
            string = string + ", " + field2;
        }
        if (group != null) {
            string = string + ", " + group;
        }
        return string;
    }

    private boolean km() {
        return true;
    }

    private String bL(int n2) {
        int n3 = 0;
        if ((n2 & 0x300) == 768) {
            n3 = 3;
        } else if ((n2 & 0x200) == 512) {
            n3 = 2;
        } else if ((n2 & 0x100) == 256) {
            n3 = 1;
        }
        return OM[n2 & 0xF] + ", " + OL[n3];
    }

    public Field getField2nd() {
        return this.OD;
    }

    public void setField2nd(Field field2nd) {
        String string;
        if (field2nd instanceof FormulaField && (string = by.a((FormulaField)field2nd, "the sum field '" + this.getName() + "'")) != null) {
            BaseUtils.warning(string);
        }
        this.OD = field2nd;
        this.updateReferences();
    }

    @Override
    final void a(int n2, String string, at at2) {
        switch (n2) {
            case 18273: {
                break;
            }
            case 203: {
                this.OE = Integer.parseInt(string);
                break;
            }
            case 220: {
                this.OI = Boolean.valueOf(string);
                break;
            }
            case 202: {
                this.tb = Integer.parseInt(string);
                break;
            }
            case 176: {
                this.MZ = Integer.parseInt(string);
                break;
            }
            case 182: {
                this.OB = Integer.parseInt(string);
                break;
            }
            case 178: {
                this.hW = Integer.parseInt(string);
                break;
            }
            default: {
                super.a(n2, string, at2);
            }
        }
    }

    public void changeAliasName(String oldAlias, String newAlias) {
        int n2 = 0;
        DatabaseTables databaseTables = this.bB.jc();
        while (n2 < databaseTables.getSqlAliasCount() && !(oldAlias = databaseTables.getSqlAliasNames()[n2++]).equals(newAlias)) {
            if (this.getName().indexOf(oldAlias) == -1) continue;
            this.setName(this.getName().substring(0, this.getName().indexOf(oldAlias)) + newAlias + this.getName().substring(this.getName().indexOf(oldAlias) + oldAlias.length()));
            break;
        }
    }

    @Override
    public final void addReferencedObject(ReferencedObject reference) {
        this.qj.addReferencedObject(reference);
    }

    @Override
    public final ReferencedObject[] getReferencedObjects() {
        return this.qj.getReferencedObjects();
    }

    @Override
    public final int getRealReferencedObjectCount() {
        return this.qj.getRealReferencedObjectCount();
    }

    @Override
    public final int getReferencedObjectCount() {
        return this.qj.getReferencedObjectCount();
    }

    @Override
    public final void removeReferencedObject(ReferencedObject reference) {
        this.qj.removeReferencedObject(reference);
    }

    @Override
    public void setReferences() {
        if (this.getField() != null) {
            this.getField().addReferenceHolder(this);
        }
        if (this.getGroup() != null) {
            this.getGroup().addReferenceHolder(this);
        }
        try {
            if (this.getChangeField() != null) {
                this.getChangeField().addReferenceHolder(this);
            }
            if (this.getResetField() != null) {
                this.getResetField().addReferenceHolder(this);
            }
        }
        catch (Exception exception) {
            BaseUtils.printStackTrace(exception);
        }
        if (this.OH != null) {
            this.OH.addReferenceHolder(this);
        }
        if (this.OD != null) {
            this.OD.addReferenceHolder(this);
        }
    }

    @Override
    public void resetReferences() {
        this.qj.resetReferences();
    }

    private final void updateReferences() {
        this.resetReferences();
        this.setReferences();
    }

    @Override
    public void setField(Field newField) {
        String string;
        if (newField instanceof GroupField) {
            newField = ((GroupField)newField).getField();
        }
        if (newField instanceof FormulaField && (string = by.a((FormulaField)newField, "the sum field '" + this.getName() + "'")) != null) {
            BaseUtils.warning(string);
        }
        super.setField(newField);
        this.updateReferences();
    }

    @Override
    public void setGroup(Group group) {
        if (this.getGroup() != null && this.getGroup().getGroupNameField() != null) {
            Fields.a(this.bB, this.getGroup().getGroupNameField(), 2);
        }
        super.setGroup(group);
        this.updateReferences();
        if (group != null && group.getGroupNameField() != null) {
            Fields.a(this.bB, group.getGroupNameField(), 2);
        }
        if (this.OF == this) {
            this.OF = null;
            if (group != null) {
                this.setChangeField(group.getGroupNameField());
            }
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof SummaryField) {
            SummaryField summaryField = (SummaryField)obj;
            if (this.MZ == summaryField.MZ && this.hW == summaryField.hW && this.OB == summaryField.OB && this.tb == summaryField.tb && this.OE == summaryField.OE && this.OI == summaryField.OI && (this.name == summaryField.name || this.name != null && this.name.equals(summaryField.name))) {
                return true;
            }
        }
        return false;
    }

    @Override
    public NodeParser parseElement(XMLTag group, String tag, Attributes atts, Map<String, Object> parserMap) throws FatalParserException {
        try {
            XMLTag xMLTag = XMLTag.getValueOf(tag);
            switch (xMLTag) {
                case Reference: {
                    this.e(atts);
                    break;
                }
                default: {
                    this.d(tag, atts);
                    break;
                }
            }
        }
        catch (ReportException reportException) {
            BaseUtils.printStackTrace(reportException);
        }
        return null;
    }

    private void e(Attributes attributes) throws ReportException {
        String string = attributes.getValue("name");
        String string2 = attributes.getValue("value");
        if (string2 == null || string2.isEmpty()) {
            if (string.equals("change_field")) {
                this.OF = this;
            }
            return;
        }
        string2 = this.F(string2);
        if (string.equals("id")) {
            this.setField(this.bB.a(false, string2));
        } else if (string.equals("2ndField")) {
            this.setField2nd(this.bB.a(false, string2));
        } else if (string.equals("change_field")) {
            this.setChangeField(this.bB.a(false, string2));
        } else if (string.equals("reset_field")) {
            this.setResetField(this.bB.a(false, string2));
        }
    }

    @Override
    void d(String string, Attributes attributes) throws ReportException {
        String string2 = attributes.getValue("value");
        if (string2 == null) {
            return;
        }
        a a2 = a.OO;
        try {
            a2 = a.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        switch (a2) {
            case OP: {
                break;
            }
            case OT: {
                this.tb = Integer.parseInt(string2);
                break;
            }
            case OQ: {
                this.OE = Integer.parseInt(string2);
                break;
            }
            case OS: {
                this.OI = Boolean.valueOf(string2);
                break;
            }
            case OU: {
                this.MZ = Integer.parseInt(string2);
                break;
            }
            case OV: {
                this.OB = Integer.parseInt(string2);
                break;
            }
            case OW: {
                this.hW = Integer.parseInt(string2);
                break;
            }
            default: {
                super.d(string, attributes);
            }
        }
    }

    @Override
    protected void p(PrintWriter printWriter, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        k.a(stringBuilder, n2, a.OU.name(), k.z(this.MZ));
        k.a(stringBuilder, n2, a.OV.name(), k.z(this.OB));
        k.a(stringBuilder, n2, a.OW.name(), k.z(this.hW));
        if (this.OG != null) {
            k.a(stringBuilder, n2, this.OG, "reset_field");
        }
        if (this.OF != null) {
            k.a(stringBuilder, n2, this.OF, "change_field");
        }
        if (this.getGroup() != null) {
            k.a(stringBuilder, n2, a.OT.name(), k.z(this.getGroup().indexOf()));
        }
        if (this.OH != null) {
            k.a(stringBuilder, n2, a.OQ.name(), k.z(this.OH.indexOf()));
        }
        if (this.OD != null) {
            k.a(stringBuilder, n2, this.OD, "2ndField");
        }
        k.a(stringBuilder, n2, Field.a.qv.name(), k.z(this.qq));
        k.a(stringBuilder, n2, a.OS.name(), k.g(this.OI));
        if (stringBuilder.length() > 0) {
            printWriter.print(stringBuilder);
        }
    }

    @Override
    public Field duplicate(String name) {
        try {
            SummaryField summaryField = this.getField2nd() == null ? this.bB.getFields().addSummaryField(this.getField(), this.getSummaryOperation(), name) : this.bB.getFields().addSummaryField(this.getField(), this.getField2nd(), this.getSummaryOperation(), name);
            summaryField.setChangeField(this.getChangeField());
            summaryField.setResetField(this.getResetField());
            summaryField.setRunningTotal(this.getRunningTotal());
            summaryField.setShowPercentVal(this.getShowPercentVal());
            summaryField.setSummaryFieldType(this.getSummaryFieldType());
            summaryField.setSummaryNth(this.getSummaryNth());
            summaryField.setSummaryOperation(this.getSummaryOperation());
            return summaryField;
        }
        catch (ReportException reportException) {
            throw new IllegalArgumentException("problems duplicating SummaryField " + this.getName(), reportException);
        }
    }

    boolean kn() {
        for (ReferenceHolder referenceHolder : this.getReferenceHolders()) {
            if (referenceHolder instanceof CrossTab) {
                return true;
            }
            if (referenceHolder instanceof Chart2) {
                return true;
            }
            if (!(referenceHolder instanceof aj)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Validity validate() {
        Validity validity = null;
        validity = this.getField() == null ? new Validity(Validity.States.ERROR, null) : by.k(this.getField());
        if (!validity.getState().equals((Object)Validity.States.VALID)) {
            return validity;
        }
        try {
            this.kl();
        }
        catch (ReportException reportException) {
            validity = new Validity(Validity.States.ERROR, reportException);
        }
        if (!validity.getState().equals((Object)Validity.States.VALID)) {
            return validity;
        }
        if (this.getField2nd() != null) {
            validity = by.k(this.getField2nd());
        }
        return validity;
    }

    @Override
    Object getValue() throws ReportException {
        ReportDataHandler reportDataHandler = this.bB.gN();
        if (this.getField().type != 16 || this.getField2nd() != null && this.getField2nd().type != 16) {
            if (reportDataHandler.getRowPosition() < 1 || reportDataHandler.getRowPosition() > reportDataHandler.getRowCount()) {
                return null;
            }
            int n2 = this.indexOf();
            int n3 = reportDataHandler.getRowPosition() - 1;
            return reportDataHandler.getSummaryValue(n2, n3);
        }
        PromptField promptField = (PromptField)this.getField();
        if (!promptField.za) {
            return null;
        }
        Object[] objectArray = (Object[])promptField.value;
        Object[] objectArray2 = null;
        if (this.OD != null) {
            if (this.OD.type == 16) {
                if (!((PromptField)this.OD).za) {
                    return null;
                }
                objectArray2 = (Object[])((PromptField)this.OD).value;
            } else {
                return null;
            }
        }
        return this.bB.dC().qS().a(this.MZ, objectArray, objectArray2, 0, Math.min(objectArray.length, objectArray2.length), this.OB);
    }

    void ad(boolean bl2) {
        this.OK = bl2;
    }

    public boolean isInternalField() {
        ArrayList<SummaryField> arrayList = this.bB.dC().qR();
        return this.OK || arrayList != null && arrayList.contains(this);
    }

    public static final class b
    extends Enum<b> {
        public static final /* enum */ b OY = new b(0, "Sum");
        public static final /* enum */ b OZ = new b(1, "Average");
        public static final /* enum */ b Pa = new b(2, "Variance");
        public static final /* enum */ b Pb = new b(3, "StdDeviation");
        public static final /* enum */ b Pc = new b(4, "Maximum");
        public static final /* enum */ b Pd = new b(5, "Minimum");
        public static final /* enum */ b Pe = new b(6, "Count");
        public static final /* enum */ b Pf = new b(7, "PopVariance");
        public static final /* enum */ b Pg = new b(8, "PopStdVariance");
        public static final /* enum */ b Ph = new b(9, "DistinctCount");
        public static final /* enum */ b Pi = new b(10, "Correlation");
        public static final /* enum */ b Pj = new b(11, "Covariance");
        public static final /* enum */ b Pk = new b(12, "WeightedAverage");
        public static final /* enum */ b Pl = new b(13, "Median");
        public static final /* enum */ b Pm = new b(14, "Percentile");
        public static final /* enum */ b Pn = new b(15, "NthLargest");
        public static final /* enum */ b Po = new b(16, "NthSmallest");
        public static final /* enum */ b Pp = new b(17, "Mode");
        public static final /* enum */ b Pq = new b(18, "NthMostFrequent");
        public static final /* enum */ b Pr = new b(19, "Percentage");
        public static final /* enum */ b Ps = new b(20, "NoSummaryOperation");
        private int gz;
        private String name;
        private static final /* synthetic */ b[] Pt;

        public static b[] values() {
            return (b[])Pt.clone();
        }

        public static b valueOf(String name) {
            return Enum.valueOf(b.class, name);
        }

        private b(int n3, String string2) {
            this.gz = n3;
            this.name = string2;
        }

        private static /* synthetic */ b[] kp() {
            return new b[]{OY, OZ, Pa, Pb, Pc, Pd, Pe, Pf, Pg, Ph, Pi, Pj, Pk, Pl, Pm, Pn, Po, Pp, Pq, Pr, Ps};
        }

        static {
            Pt = b.kp();
        }
    }

    public static final class a
    extends Enum<a> {
        public static final /* enum */ a OO = new a();
        public static final /* enum */ a OP = new a();
        public static final /* enum */ a OQ = new a();
        public static final /* enum */ a OS = new a();
        public static final /* enum */ a OT = new a();
        public static final /* enum */ a OU = new a();
        public static final /* enum */ a OV = new a();
        public static final /* enum */ a OW = new a();
        private static final /* synthetic */ a[] OX;

        public static a[] values() {
            return (a[])OX.clone();
        }

        public static a valueOf(String name) {
            return Enum.valueOf(a.class, name);
        }

        private static /* synthetic */ a[] ko() {
            return new a[]{OO, OP, OQ, OS, OT, OU, OV, OW};
        }

        static {
            OX = a.ko();
        }
    }
}

