/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.PublicApi;
import com.inet.lib.list.IntList;
import com.inet.lib.list.StringList;
import com.inet.lib.util.Encryption;
import com.inet.report.BaseUtils;
import com.inet.report.Database;
import com.inet.report.DatabaseField;
import com.inet.report.Datasource;
import com.inet.report.Fields;
import com.inet.report.Join;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.SQLField;
import com.inet.report.TableSource;
import com.inet.report.TablesourceList;
import com.inet.report.at;
import com.inet.report.ba;
import com.inet.report.config.datasource.DataSourceConfigurationManager;
import com.inet.report.database.DataFactory;
import com.inet.report.database.DatabaseUtils;
import com.inet.report.database.JdbcData;
import com.inet.report.database.fetch.CycleDetector;
import com.inet.report.database.fetch.b;
import com.inet.report.i18n.ReportErrorCode;
import com.inet.report.y;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.annotation.Nonnull;

@PublicApi
public class DatabaseTables
implements Serializable {
    public static final int JOINTYPE_INNER = 21;
    public static final int JOINTYPE_RIGHT_OUTER = 22;
    public static final int JOINTYPE_LEFT_OUTER = 23;
    public static final int JOINTYPE_FULL_OUTER = 24;
    public static final int JOINLINK_EQUALS = 1;
    public static final int JOINLINK_GREATER_THAN = 2;
    public static final int JOINLINK_GREATER_EQUALS_THAN = 3;
    public static final int JOINLINK_LESS_THAN = 4;
    public static final int JOINLINK_LESS_EQUALS_THAN = 5;
    public static final int JOINLINK_NOT_EQUALS = 6;
    private final ba<?> bB;
    private ArrayList<Datasource> lh = new ArrayList();
    private final List<Join> li;
    private boolean lj;
    private int lk = 0;

    DatabaseTables(ba renderer) {
        this.bB = renderer;
        this.li = new ArrayList<Join>();
    }

    public void setSavePassword(boolean save) throws ReportException {
        this.bM().getEngine().cq();
        if (BaseUtils.isInfo()) {
            BaseUtils.info("Set Save Password: " + save);
        }
        this.lj = save;
    }

    void i(boolean bl2) {
        this.lj = bl2;
    }

    public boolean isSavePassword() {
        return this.lj;
    }

    public static String changeWhereToNoRows(String sqlStatement) {
        String string = (sqlStatement = sqlStatement.trim()).toLowerCase();
        if (string.startsWith("call") || string.startsWith("exec") || string.startsWith("{call") || string.startsWith("{?=call")) {
            return sqlStatement;
        }
        while (sqlStatement.endsWith(";")) {
            sqlStatement = sqlStatement.substring(0, sqlStatement.length() - 1);
        }
        String string2 = " (){}[]\"'.\n\r\t";
        char c2 = '\u0000';
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(sqlStatement, string2, true);
        while (stringTokenizer.hasMoreTokens()) {
            int n6;
            String string3 = stringTokenizer.nextToken();
            block34: while (true) {
                n6 = string3.length();
                switch (string3) {
                    case " ": {
                        break block34;
                    }
                    case "{": {
                        if (c2 != '\u0000') break block34;
                        ++n2;
                        break block34;
                    }
                    case "}": {
                        if (c2 != '\u0000') break block34;
                        --n2;
                        break block34;
                    }
                    case "(": {
                        if (c2 != '\u0000') break block34;
                        ++n3;
                        break block34;
                    }
                    case ")": {
                        if (c2 != '\u0000') break block34;
                        --n3;
                        break block34;
                    }
                    case "[": {
                        if (c2 != '\u0000') break block34;
                        ++n4;
                        break block34;
                    }
                    case "]": {
                        if (c2 != '\u0000') break block34;
                        --n4;
                        break block34;
                    }
                    case "\"": 
                    case "'": {
                        char c3 = string3.charAt(0);
                        if (c2 == '\u0000') {
                            c2 = c3;
                            break block34;
                        }
                        if (c2 != c3) break block34;
                        c2 = '\u0000';
                        break block34;
                    }
                    default: {
                        if (c2 != '\u0000' || n2 != 0 || n3 != 0 || n4 != 0) break block34;
                        switch (string3.toUpperCase()) {
                            case "WHERE": {
                                return sqlStatement.substring(0, n5) + "WHERE 1=0 AND" + sqlStatement.substring(n5 + n6, sqlStatement.length());
                            }
                            case "HAVING": {
                                return sqlStatement.substring(0, n5) + "WHERE 1=0 " + sqlStatement.substring(n5, sqlStatement.length());
                            }
                            case "ORDER": 
                            case "GROUP": {
                                int n7 = n5;
                                n5 += n6;
                                while (stringTokenizer.hasMoreTokens()) {
                                    string3 = stringTokenizer.nextToken();
                                    if (!string3.trim().isEmpty()) continue block34;
                                    n5 += string3.length();
                                    continue;
                                    if (!string3.equalsIgnoreCase("BY")) continue block34;
                                    return sqlStatement.substring(0, n7) + "WHERE 1=0 " + sqlStatement.substring(n7, sqlStatement.length());
                                }
                                break block34;
                            }
                        }
                    }
                }
                break;
            }
            n5 += n6;
        }
        return sqlStatement + " WHERE 1=0";
    }

    private void a(String string, Datasource datasource, String string2, boolean bl2) throws ReportException {
        ResultSet resultSet = null;
        try {
            int n2;
            int n3;
            int[] nArray;
            String[] stringArray;
            int n4;
            Object object;
            if (bl2) {
                object = datasource.m("QueryTest", "QueryTest");
                ((TableSource)object).setSql(string2);
                ((TableSource)object).setDatasource(datasource);
                ((TableSource)object).refresh();
                n4 = ((TableSource)object).getColumnCount();
                stringArray = new String[n4];
                nArray = new int[n4];
                for (n3 = 0; n3 < n4; ++n3) {
                    stringArray[n3] = ((TableSource)object).getColumnName(n3);
                    if (stringArray[n3].length() == 0) {
                        throw ReportExceptionFactory.createReportException(ReportErrorCode.ColumnsNoName, new Integer(n3));
                    }
                    nArray[n3] = ((TableSource)object).getColumnType(n3);
                }
            } else {
                object = new StringList();
                IntList intList = new IntList();
                for (n2 = 0; n2 < this.getDatasourceCount(); ++n2) {
                    Datasource datasource2 = this.getDatasource(n2);
                    for (int i2 = 0; i2 < datasource2.getTableSourceCount(); ++i2) {
                        TableSource tableSource = datasource2.getTableSource(i2);
                        for (int i3 = 0; i3 < tableSource.getColumnCount(); ++i3) {
                            String string3 = tableSource.getColumnName(i3);
                            int n5 = tableSource.getColumnType(i3);
                            if (object.contains(string3)) continue;
                            object.addElement(string3);
                            intList.addElement(n5);
                        }
                    }
                }
                n4 = object.size();
                stringArray = object.toArray();
                nArray = intList.toArray();
            }
            object = datasource.createTableSource(string, string);
            ((TableSource)object).setSql(string2);
            for (n3 = 0; n3 < n4; ++n3) {
                ((TableSource)object).addColumn(stringArray[n3], nArray[n3]);
            }
            try {
                this.bM().getFields().changeAllAliases(string, datasource);
            }
            catch (ReportException reportException) {
                block30: {
                    try {
                        datasource.removeTableSource((TableSource)object);
                    }
                    catch (ReportException reportException2) {
                        if (!BaseUtils.isDebug()) break block30;
                        BaseUtils.debug(reportException2);
                    }
                }
                throw reportException;
            }
            String[] stringArray2 = this.getSqlAliasNames();
            for (n2 = 0; n2 < stringArray2.length; ++n2) {
                if (stringArray2[n2].equalsIgnoreCase(((TableSource)object).getAlias())) continue;
                this.removeSqlSource(stringArray2[n2]);
            }
        }
        catch (SQLException sQLException) {
            throw ReportExceptionFactory.createReportExceptionWithCause(sQLException);
        }
        finally {
            block33: {
                block32: {
                    if (resultSet != null) {
                        try {
                            if (!resultSet.isClosed()) {
                                resultSet.close();
                            }
                        }
                        catch (SQLException sQLException) {
                            if (!BaseUtils.isDebug()) break block32;
                            BaseUtils.debug(sQLException);
                        }
                    }
                }
                if (this.bB.BD != null) {
                    try {
                        if (!this.bB.BD.isClosed()) {
                            this.bB.BD.close();
                        }
                        this.bB.BD = null;
                    }
                    catch (SQLException sQLException) {
                        if (!BaseUtils.isDebug()) break block33;
                        BaseUtils.debug(sQLException);
                    }
                }
            }
        }
    }

    final String a(String object, DataFactory dataFactory) {
        Object object2;
        int n2;
        String string = object;
        if (dataFactory instanceof Database) {
            Database database = (Database)dataFactory;
            n2 = database.getMaxAliasNameLength();
            if (((String)object).length() > n2) {
                object = ((String)object).substring(((String)object).length() - n2);
            }
        } else {
            n2 = Integer.MAX_VALUE;
        }
        int n3 = dataFactory.getConfiguration().isUseEscapeEverything() ? -1 : ((String)object).lastIndexOf(46);
        if (n3 != -1) {
            object = ((String)object).substring(n3 + 1);
        }
        if (((String)object).length() > 0) {
            if ((((String)object).charAt(0) == '_' || ((String)object).charAt(0) >= '0' && ((String)object).charAt(0) <= '9') && (((String)(object = ((String)object).substring(1))).charAt(0) == '_' || ((String)object).charAt(0) >= '0' && ((String)object).charAt(0) <= '9')) {
                object = "Z" + (String)object;
            }
        } else {
            char[] cArray = String.valueOf(string.hashCode()).toCharArray();
            for (int i2 = 0; i2 < cArray.length; ++i2) {
                if (cArray[i2] == '-') {
                    cArray[i2] = 122;
                    continue;
                }
                int n4 = i2;
                cArray[n4] = (char)(cArray[n4] + 49);
            }
            return this.a(new String(cArray), dataFactory);
        }
        char[] cArray = ((String)object).toCharArray();
        boolean bl2 = false;
        for (int i3 = 0; i3 < cArray.length; ++i3) {
            char c2 = cArray[i3];
            if (c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z' || c2 >= '0' && c2 <= '9' || c2 == '_') continue;
            cArray[i3] = 95;
            bl2 = true;
        }
        Object object3 = object2 = bl2 ? new String(cArray) : object;
        if (cArray.length > 0 && cArray[0] == '_') {
            object2 = "tableAlias";
        }
        Object object4 = object2;
        if (dataFactory instanceof Database && ((Database)dataFactory).isKeyword((String)object2)) {
            if (((String)object2).length() == n2) {
                object2 = ((String)object2).substring(0, ((String)object2).length() - 1);
            }
            object2 = (String)object2 + "_";
        }
        int n5 = 2;
        while (this.s((String)object2)) {
            String string2;
            if ((string2 = String.valueOf(n5++)).length() > n2) {
                throw new IllegalStateException("can not find the alias name for table: modifier=" + string2);
            }
            if (((String)object4).length() + 1 + string2.length() > n2) {
                object4 = ((String)object4).substring(0, n2 - 1 - string2.length());
            }
            object2 = (String)object4 + "_" + string2;
        }
        return object2;
    }

    public void removeSqlSource(String alias) throws ReportException {
        if (!this.s(alias)) {
            Object[] objectArray = new Object[]{alias};
            throw ReportExceptionFactory.createReportException(ReportErrorCode.InvalidAliasOrTableName, objectArray);
        }
        this.t(alias);
    }

    public String[] getSqlSourcesView() {
        StringList stringList = new StringList();
        for (int i2 = 0; i2 < this.lh.size(); ++i2) {
            Datasource datasource = this.lh.get(i2);
            for (int i3 = 0; i3 < datasource.getTableSourceCount(); ++i3) {
                stringList.addElement(datasource.getTableSource(i3).getDatabaseIdentifier());
            }
        }
        return stringList.toArray();
    }

    public boolean areAllTablesJoined() {
        try {
            if (this.getDatasourceCount() == 0) {
                return true;
            }
            int n2 = this.bK();
            if (n2 == 1) {
                return true;
            }
            return new b(this.bB).oC() == n2;
        }
        catch (ReportException reportException) {
            if (BaseUtils.isDebug()) {
                BaseUtils.debug(reportException);
            }
            return true;
        }
    }

    public boolean joinsContainCycle() {
        if (this.bK() < 3 || this.bN().size() < 3) {
            return false;
        }
        CycleDetector.Graph<TableSource, Join> graph = new CycleDetector.Graph<TableSource, Join>(){

            @Override
            public List<Join> getAllEdges() {
                return DatabaseTables.this.bN();
            }

            public TableSource a(Join join) {
                return join.getSourceTableSource();
            }

            public TableSource b(Join join) {
                return join.getTargetTableSource();
            }

            public boolean c(Join join) {
                return join.getJoinType() == 23 || join.getJoinType() == 22;
            }

            @Override
            public /* synthetic */ boolean isUnidirectional(Object object) {
                return this.c((Join)object);
            }

            @Override
            public /* synthetic */ Object getTargetNode(Object object) {
                return this.b((Join)object);
            }

            @Override
            public /* synthetic */ Object getSourceNode(Object object) {
                return this.a((Join)object);
            }
        };
        return CycleDetector.containsUnidirectionalCycle(graph);
    }

    int bK() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.lh.size(); ++i2) {
            n2 += this.lh.get(i2).getTableSourceCount();
        }
        return n2;
    }

    TablesourceList bL() {
        TablesourceList tablesourceList = new TablesourceList();
        for (int i2 = 0; i2 < this.lh.size(); ++i2) {
            tablesourceList.addAll(this.lh.get(i2).bX());
        }
        return tablesourceList;
    }

    public String[] getSqlAliasNames() {
        StringList stringList = new StringList();
        for (int i2 = 0; i2 < this.lh.size(); ++i2) {
            Datasource datasource = this.lh.get(i2);
            for (int i3 = 0; i3 < datasource.getTableSourceCount(); ++i3) {
                stringList.addElement(datasource.getTableSource(i3).getAlias());
            }
        }
        return stringList.toArray();
    }

    public int getSqlAliasCount() {
        return this.bK();
    }

    public String[] getColumnNames(String alias) {
        try {
            TableSource tableSource = this.getTablesource(alias);
            String[] stringArray = new String[tableSource.getColumnCount()];
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                stringArray[i2] = tableSource.getColumnName(i2);
            }
            return stringArray;
        }
        catch (ReportException reportException) {
            return null;
        }
    }

    public int[] getColumnTypes(String alias) {
        try {
            TableSource tableSource = this.getTablesource(alias);
            int[] nArray = new int[tableSource.getColumnCount()];
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                nArray[i2] = tableSource.getColumnType(i2);
            }
            return nArray;
        }
        catch (ReportException reportException) {
            return null;
        }
    }

    public Join addJoin(String fromTableAlias, String fromColumn, String toTableAlias, String toColumn, int joinType, int linkType) throws ReportException {
        if (fromTableAlias != null && fromTableAlias.length() > 0 && toTableAlias != null && toTableAlias.length() > 0 && fromColumn != null && fromColumn.length() > 0 && toColumn != null && toColumn.length() > 0 && !fromTableAlias.equals(toTableAlias)) {
            TableSource tableSource = this.getTablesource(fromTableAlias);
            DatabaseField databaseField = tableSource.getDatabaseField(fromColumn);
            TableSource tableSource2 = this.getTablesource(toTableAlias);
            DatabaseField databaseField2 = tableSource2.getDatabaseField(toColumn);
            return this.addJoin(tableSource, databaseField, tableSource2, databaseField2, joinType, linkType);
        }
        Object[] objectArray = new Object[]{fromTableAlias + "." + fromColumn + "->" + toTableAlias + "." + toColumn};
        throw ReportExceptionFactory.createReportException(ReportErrorCode.databaseTables_invalidJoin, objectArray);
    }

    public Join addJoin(TableSource fromTableSource, DatabaseField fromColumn, TableSource toTableSource, DatabaseField toColumn, int joinType, int linkType) throws ReportException {
        switch (joinType) {
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                break;
            }
            default: {
                throw y.b("joinType", joinType, null);
            }
        }
        switch (linkType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            default: {
                throw y.b("linkType", linkType, null);
            }
        }
        if (fromTableSource != null && toTableSource != null && fromTableSource != toTableSource && fromColumn != null && toColumn != null && fromColumn.kU == fromTableSource && toColumn.kU == toTableSource) {
            for (int i2 = 0; i2 < this.bN().size(); ++i2) {
                Join join = this.bN().get(i2);
                if (join.getSourceTableSource() != fromTableSource || join.getTargetTableSource() != toTableSource) continue;
                DatabaseField[] databaseFieldArray = join.getConditionSourceFields();
                DatabaseField[] databaseFieldArray2 = join.getConditionTargetFields();
                for (int i3 = 0; i3 < databaseFieldArray.length; ++i3) {
                    if (databaseFieldArray[i3] != fromColumn || databaseFieldArray2[i3] != toColumn) continue;
                    throw y.a(fromColumn.getName(), toColumn.getName(), null);
                }
                join.addCondition(fromColumn, toColumn, linkType);
                join.setJoinType(joinType);
                return join;
            }
            Join join = new Join(this.bM(), joinType, fromTableSource, toTableSource);
            join.addCondition(fromColumn, toColumn, linkType);
            this.bN().add(join);
            return join;
        }
        Object[] objectArray = new Object[]{String.valueOf(fromColumn) + "->" + String.valueOf(toColumn)};
        throw ReportExceptionFactory.createReportException(ReportErrorCode.databaseTables_invalidJoin, objectArray);
    }

    public void removeJoin(String fromTableAlias, String fromColumn, String toTableAlias, String toColumn) throws ReportException {
        if (fromTableAlias == null || fromTableAlias.length() <= 0 || toTableAlias == null || toTableAlias.length() <= 0 || fromColumn == null || fromColumn.length() <= 0 || toColumn == null || toColumn.length() <= 0 || fromTableAlias.equals(toTableAlias)) {
            Object[] objectArray = new Object[]{fromTableAlias + "." + fromColumn + "->" + toTableAlias + "." + toColumn};
            throw ReportExceptionFactory.createReportException(ReportErrorCode.databaseTables_invalidJoin, objectArray);
        }
        TableSource tableSource = this.getTablesource(fromTableAlias);
        DatabaseField databaseField = tableSource.getDatabaseField(fromColumn);
        TableSource tableSource2 = this.getTablesource(toTableAlias);
        DatabaseField databaseField2 = tableSource2.getDatabaseField(toColumn);
        this.removeJoin(tableSource, databaseField, tableSource2, databaseField2);
    }

    public void removeJoin(TableSource fromTableSource, DatabaseField fromColumn, TableSource toTableSource, DatabaseField toColumn) {
        if (this.bN() != null) {
            if (fromTableSource == null) {
                throw y.a(null, "fromTableSource", null);
            }
            if (toTableSource == null) {
                throw y.a(null, "toTableSource", null);
            }
            if (fromTableSource == toTableSource) {
                throw y.a((Object)"is same as fromTableSource", "toTableSource", null);
            }
            if (fromColumn == null) {
                throw y.a(null, "fromColumn", null);
            }
            if (toColumn == null) {
                throw y.a(null, "toColumn", null);
            }
            if (fromColumn.kU != fromTableSource) {
                throw y.a((Object)"is not fromTableSource", "fromColumn", null);
            }
            if (toColumn.kU != toTableSource) {
                throw y.a((Object)"is not toTableSource", "toColumn", null);
            }
            for (int i2 = 0; i2 < this.bN().size(); ++i2) {
                Join join = this.bN().get(i2);
                if (join.getSourceTableSource() != fromTableSource || join.getTargetTableSource() != toTableSource) continue;
                DatabaseField[] databaseFieldArray = join.getConditionSourceFields();
                DatabaseField[] databaseFieldArray2 = join.getConditionTargetFields();
                for (int i3 = 0; i3 < databaseFieldArray.length; ++i3) {
                    if (databaseFieldArray[i3] != fromColumn || databaseFieldArray2[i3] != toColumn) continue;
                    if (databaseFieldArray.length == 1) {
                        this.bN().remove(i2);
                    } else {
                        join.removeCondition(i3);
                    }
                    return;
                }
            }
        }
    }

    public Vector<String> getJoinsView() {
        StringList stringList = new StringList();
        if (this.bN() != null) {
            for (int i2 = 0; i2 < this.bN().size(); ++i2) {
                Join join = this.bN().get(i2);
                for (int i3 = 0; i3 < join.getConditionCount(); ++i3) {
                    stringList.addElement(join.getSourceAlias() + "." + join.getConditionSourceColumn(i3) + " " + DatabaseTables.a(join, i3) + " " + join.getTargetAlias() + "." + join.getConditionTargetColumn(i3));
                }
            }
        }
        return stringList.toVector();
    }

    public Vector getJoinsEntries() {
        if (this.bN() == null) {
            return new Vector();
        }
        return new Vector<Join>(this.bN());
    }

    private static String a(Join join, int n2) {
        switch (join.getConditionLinkType(n2)) {
            case 1: {
                if (join.getJoinType() == 23) {
                    return "=(+)";
                }
                if (join.getJoinType() == 22) {
                    return "(+)=";
                }
                return "=";
            }
            case 2: {
                return ">";
            }
            case 4: {
                return "<";
            }
            case 3: {
                return ">=";
            }
            case 5: {
                return "<=";
            }
            case 6: {
                return "!=";
            }
        }
        return "??";
    }

    public static int mapSqlTypeToCCType(int sqlType) {
        switch ((short)sqlType) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return 6;
            }
            case -7: 
            case 16: {
                return 8;
            }
            case -16: 
            case -15: 
            case -11: 
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: 
            case 2005: 
            case 2011: {
                return 11;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return 14;
            }
            case 91: {
                return 9;
            }
            case 92: {
                return 10;
            }
            case -102: 
            case -101: 
            case 93: {
                return 15;
            }
            case -150: 
            case 0: 
            case 70: 
            case 1111: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2006: {
                return 14;
            }
            case 2012: {
                return -10;
            }
        }
        return -1;
    }

    final void k(PrintWriter printWriter, int n2) {
        String string = BaseUtils.getIndent(n2);
        ++n2;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < this.lh.size(); ++i2) {
            this.lh.get(i2).d(stringBuilder, n2);
        }
        stringBuilder.append(string + "<Database>\n");
        string = this.a(n2, string, stringBuilder);
        string = BaseUtils.getIndent(--n2);
        stringBuilder.append(string + "</Database>\n");
        printWriter.print(stringBuilder);
    }

    private String a(int n2, String string, StringBuilder stringBuilder) {
        if (this.bN() != null) {
            for (int i2 = 0; i2 < this.bN().size(); ++i2) {
                Join join = this.bN().get(i2);
                if (i2 != 0) {
                    stringBuilder.append('\n');
                }
                stringBuilder.append(string);
                stringBuilder.append("<Join from=\"" + join.getSourceAlias() + "\" to=\"" + join.getTargetAlias() + "\" type=\"" + DatabaseTables.G(join.getJoinType()) + "\">");
                string = BaseUtils.getIndent(n2 + 1);
                for (int i3 = 0; i3 < join.getConditionCount(); ++i3) {
                    stringBuilder.append('\n');
                    stringBuilder.append(string);
                    stringBuilder.append("<Link from=\"" + join.getConditionSourceColumn(i3) + "\" to=\"" + join.getConditionTargetColumn(i3) + "\" type=\"" + DatabaseTables.H(join.getConditionLinkType(i3)) + "\"/>");
                }
                string = BaseUtils.getIndent(n2);
                stringBuilder.append('\n');
                stringBuilder.append(string);
                stringBuilder.append("</Join>");
                stringBuilder.append('\n');
            }
        }
        return string;
    }

    final void a(Properties properties, at at2, int n2, int n3) {
        if (n2 > 5 || n2 == 5 && n3 > 3) {
            return;
        }
        String string = "";
        String string2 = properties.getProperty("host", string);
        String string3 = properties.getProperty("catalog", string);
        String string4 = properties.getProperty("user", string);
        String string5 = properties.getProperty("password", string);
        if (string5 != null && string5.length() != 0) {
            this.lj = true;
            try {
                string5 = Encryption.decrypt((String)string5);
            }
            catch (Exception exception) {
                at2.a(exception);
            }
        }
        String string6 = properties.getProperty("schema", null);
        String string7 = properties.getProperty("dll", string);
        at2.a(properties, "type", 0);
        try {
            if (n2 == 5 && n3 == 3 && string7 == string && string2 == string) {
                return;
            }
            this.a(string7, string2, string6, string3, string4, string5);
        }
        catch (ReportException reportException) {
            // empty catch block
        }
    }

    public String[] getAllAvailableColumns() {
        StringList stringList = new StringList();
        String[] stringArray = this.getSqlAliasNames();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String[] stringArray2 = this.getColumnNames(stringArray[i2]);
            for (int i3 = 0; i3 < stringArray2.length; ++i3) {
                stringList.addElement(stringArray2[i3]);
            }
        }
        return stringList.toArray();
    }

    private static String G(int n2) {
        switch (n2) {
            case 21: {
                return "inn";
            }
            case 24: {
                return "foj";
            }
            case 23: {
                return "loj";
            }
            case 22: {
                return "roj";
            }
        }
        return "inn";
    }

    static int q(String string) {
        if (string.equalsIgnoreCase("inn")) {
            return 21;
        }
        if (string.equalsIgnoreCase("foj")) {
            return 24;
        }
        if (string.equalsIgnoreCase("loj")) {
            return 23;
        }
        if (string.equalsIgnoreCase("roj")) {
            return 22;
        }
        return 21;
    }

    private static String H(int n2) {
        switch (n2) {
            case 1: {
                return "eq";
            }
            case 3: {
                return "ge";
            }
            case 2: {
                return "gt";
            }
            case 5: {
                return "le";
            }
            case 4: {
                return "lt";
            }
            case 6: {
                return "ne";
            }
        }
        return "eq";
    }

    static int r(String string) {
        if (string.equals("eq")) {
            return 1;
        }
        if (string.equals("gt")) {
            return 2;
        }
        if (string.equals("ge")) {
            return 3;
        }
        if (string.equals("lt")) {
            return 4;
        }
        if (string.equals("le")) {
            return 5;
        }
        if (string.equals("ne")) {
            return 6;
        }
        return 1;
    }

    @Nonnull
    public TableSource getTablesource(String alias) throws ReportException {
        int n2;
        Datasource datasource;
        int n3;
        if (alias == null || alias.length() == 0) {
            throw new ReportException("There is no table source defined with alias \"" + alias + "\"", -1058);
        }
        for (n3 = 0; n3 < this.lh.size(); ++n3) {
            datasource = this.lh.get(n3);
            for (n2 = 0; n2 < datasource.getTableSourceCount(); ++n2) {
                TableSource tableSource = datasource.getTableSource(n2);
                if (!tableSource.getAlias().equals(alias)) continue;
                return tableSource;
            }
        }
        for (n3 = 0; n3 < this.lh.size(); ++n3) {
            datasource = this.lh.get(n3);
            n2 = datasource.getDataFactory().getConfiguration().isUseQuoteLowerCase() ? 1 : 0;
            for (int i2 = 0; n2 == 0 && i2 < datasource.getTableSourceCount(); ++i2) {
                TableSource tableSource = datasource.getTableSource(i2);
                if (!tableSource.getAlias().equalsIgnoreCase(alias)) continue;
                return tableSource;
            }
        }
        throw new ReportException("There is no table source defined with alias \"" + alias + "\"", -1058);
    }

    boolean s(String string) {
        for (int i2 = 0; i2 < this.lh.size(); ++i2) {
            Datasource datasource = this.lh.get(i2);
            for (int i3 = 0; i3 < datasource.getTableSourceCount(); ++i3) {
                TableSource tableSource = datasource.getTableSource(i3);
                if (!tableSource.getAlias().equalsIgnoreCase(string)) continue;
                return true;
            }
        }
        return false;
    }

    private void t(String string) throws ReportException {
        for (int i2 = 0; i2 < this.lh.size(); ++i2) {
            Datasource datasource = this.lh.get(i2);
            for (int i3 = 0; i3 < datasource.getTableSourceCount(); ++i3) {
                TableSource tableSource = datasource.getTableSource(i3);
                if (!tableSource.getAlias().equalsIgnoreCase(string)) continue;
                datasource.removeTableSource(tableSource);
                return;
            }
        }
    }

    void d(Datasource datasource) throws ReportException {
        if (this.bM().Iz != null && this.bM().Iz.length > 0 && this.lh.size() > 0 && (this.lh.size() != 1 || this.lh.get(0).getDataSourceConfigurationName().length() > 0)) {
            Object[] objectArray = new Object[]{};
            throw ReportExceptionFactory.createReportException(ReportErrorCode.deleteSQLs, objectArray);
        }
        this.lh.add(datasource);
    }

    public void removeDatasource(Datasource ds) throws ReportException {
        Fields fields = this.bB.getEngine().getFields();
        for (int i2 = 0; i2 < fields.getSQLExpressionFieldsCount(); ++i2) {
            SQLField sQLField = fields.getSQLExpressionField(i2);
            if (sQLField.getDatasource() != ds || !sQLField.isUsed()) continue;
            throw ReportExceptionFactory.createReportException(ReportErrorCode.connectionUsedSQLField, new Object[0]);
        }
        if (ds.getTableSourceCount() != 0) {
            throw ReportExceptionFactory.createReportException(ReportErrorCode.connectionUsed, new Object[0]);
        }
        this.lh.remove(ds);
    }

    public Datasource getDatasource(int idx) {
        if (idx == 0 && this.lh.size() == 0) {
            try {
                this.createDatasource(null);
            }
            catch (ReportException reportException) {
                // empty catch block
            }
        }
        return this.lh.get(idx);
    }

    public Datasource getDatasource(String name) {
        for (int i2 = 0; i2 < this.getDatasourceCount(); ++i2) {
            Datasource datasource = this.getDatasource(i2);
            if (!datasource.getDataSourceConfigurationName().equals(name)) continue;
            return datasource;
        }
        return null;
    }

    public int getDatasourceCount() {
        return this.lh.size();
    }

    void a(String string, String string2, Datasource datasource, boolean bl2) throws ReportException {
        TableSource tableSource;
        if (datasource.getTableSourceCount() >= 1 && (tableSource = datasource.getTableSource(0)).getSql() != null && tableSource.getSql().length() != 0) {
            tableSource.setSql(string);
            try {
                tableSource.refresh();
            }
            catch (SQLException sQLException) {
                if (BaseUtils.isDebug()) {
                    BaseUtils.debug("Set SQL not successful");
                    BaseUtils.debug(sQLException);
                }
                throw ReportExceptionFactory.createReportExceptionWithCause(sQLException);
            }
            return;
        }
        this.bM().getEngine().cq();
        try {
            if (BaseUtils.isInfo()) {
                BaseUtils.info("Set SQL statement: " + string);
            }
            this.a(string2, datasource, string, bl2);
        }
        catch (Throwable throwable) {
            if (BaseUtils.isDebug()) {
                BaseUtils.debug("Set SQL not successful");
                BaseUtils.debug(throwable);
            }
            throw ReportExceptionFactory.createReportExceptionWithCause(throwable);
        }
    }

    @Deprecated
    TableSource createTableSource(String aDatabaseIdentifier, String anAliasName) {
        try {
            if (this.s(anAliasName)) {
                return this.getTablesource(anAliasName);
            }
        }
        catch (ReportException reportException) {
            // empty catch block
        }
        TableSource tableSource = new TableSource(this.bM().getEngine(), null);
        tableSource.av(aDatabaseIdentifier);
        tableSource.at(anAliasName);
        return tableSource;
    }

    @Deprecated
    Datasource a(String string, String string2, String string3, String string4, String string5, String string6) throws ReportException {
        if (this.lh.size() > 1 && this.getDatasource(0).getDataSourceConfigurationName().length() == 0) {
            Datasource datasource = this.getDatasource(0);
            datasource.v(string);
            datasource.setHost(string2);
            datasource.setSchema(string3);
            datasource.m(false);
            datasource.setCatalog(string4);
            datasource.l(false);
            datasource.setUsername(string5);
            datasource.setPassword(string6);
            return datasource;
        }
        Datasource datasource = new Datasource(string, string2, string3, string4, string5, string6, this.bM().getEngine());
        this.d(datasource);
        return datasource;
    }

    @Nonnull
    public Datasource createDatasource(String dataSourceConfigurationName) throws ReportException {
        if (dataSourceConfigurationName != null && !dataSourceConfigurationName.isEmpty() && !DataSourceConfigurationManager.exists(dataSourceConfigurationName)) {
            throw ReportExceptionFactory.createReportException(ReportErrorCode.dscNotDefined, dataSourceConfigurationName);
        }
        if (this.lh.size() > 1 && this.getDatasource(0).getDataSourceConfigurationName().length() == 0) {
            Datasource datasource = this.getDatasource(0);
            datasource.setDataSourceConfigurationName(dataSourceConfigurationName);
            return datasource;
        }
        Datasource datasource = new Datasource(dataSourceConfigurationName, this.bM().getEngine());
        this.d(datasource);
        return datasource;
    }

    ba<?> bM() {
        return this.bB;
    }

    List<Join> bN() {
        return this.li;
    }

    String[] j(boolean bl2) throws ReportException {
        Datasource datasource = this.getDatasource(0);
        try {
            String[] stringArray;
            block11: {
                Connection connection = datasource.getConnection();
                try {
                    this.lk = 2;
                    b b2 = new b(this.bB);
                    b2.aA(bl2);
                    stringArray = b2.oB().toArray(new String[0]);
                    if (connection == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception exception) {
                        throw ReportExceptionFactory.createReportExceptionWithCause(exception);
                    }
                }
                connection.close();
            }
            return stringArray;
        }
        finally {
            this.lk = 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String a(boolean bl2, Datasource datasource) throws ReportException {
        Object object;
        JdbcData jdbcData;
        block28: {
            DataFactory dataFactory = datasource.k(false);
            if (!DatabaseUtils.useJdbcDriver(dataFactory)) {
                if (!BaseUtils.isDebug()) return "";
                BaseUtils.debug("Call of getDefaultSql from non JDBC database class.");
                return "";
            }
            jdbcData = (JdbcData)dataFactory;
            this.lk = 2;
            if (datasource.getTableSourceCount() == 0) {
                return "";
            }
            if (datasource.getTableSourceCount() == 1) {
                if (datasource.getTableSource(0).getSql() != null) {
                    return datasource.getTableSource(0).getSql();
                }
            } else {
                for (int i2 = 0; i2 < datasource.getTableSourceCount(); ++i2) {
                    if (datasource.getTableSource(i2).getSql() == null) continue;
                    throw ReportExceptionFactory.createReportException(ReportErrorCode.NotOnlyTablesToSQL, datasource.getTableSource(i2).getAlias());
                }
            }
            if (this.bB.jd() == null) {
                return " ";
            }
            try {
                object = datasource.getConnection();
                try {
                    if (object == null) break block28;
                    if (datasource.getTableSourceCount() == 1) {
                        if (datasource.getTableSource(0).getType() == 2) {
                            String string = datasource.getTableSource(0).af(bl2);
                            return string;
                        }
                    } else {
                        for (int i3 = 0; i3 < datasource.getTableSourceCount(); ++i3) {
                            if (datasource.getTableSource(i3).getType() != 2) continue;
                            throw ReportExceptionFactory.createReportException(ReportErrorCode.NotOnlyTablesToSQL, datasource.getTableSource(i3).getAlias());
                        }
                    }
                }
                finally {
                    if (object != null) {
                        object.close();
                    }
                }
            }
            catch (ReportException | SQLException exception) {
                BaseUtils.warning(exception);
            }
        }
        try {
            object = null;
            List<String> list = new b(this.bB).aA(bl2).a(jdbcData, datasource);
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : list) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("\n");
                }
                stringBuilder.append(string);
            }
            object = stringBuilder.toString();
            if (object == null || ((String)object).trim().length() == 0) {
                object = " ";
            }
            Object object2 = object;
            return object2;
        }
        catch (Throwable throwable) {
            throw ReportExceptionFactory.createReportExceptionWithCause(throwable);
        }
        finally {
            this.lk = 0;
        }
    }

    final void bO() throws ReportException {
        BaseUtils.info("Start Execute");
        if (this.lk > 0) {
            return;
        }
        this.bP();
    }

    final void bP() throws ReportException {
        Datasource datasource = this.getDatasource(0);
        try (Connection connection = datasource.getConnection();){
            DataFactory dataFactory = datasource.getDataFactory();
            if (!this.bB.iT()) {
                if (!dataFactory.getReportDataPerInstance()) {
                    b b2 = this.bM().gX();
                    b2.az(true);
                    b2.oA();
                    b2.az(false);
                    this.bM().gN().setFilterLater(true);
                }
            } else {
                DatabaseUtils.getReportData(this.bB.getEngine());
            }
        }
        catch (SQLException sQLException) {
            throw ReportExceptionFactory.createReportExceptionWithCause(sQLException);
        }
    }

    void I(int n2) {
        this.lk = n2;
    }

    int bQ() {
        return this.lk;
    }

    static final class a
    extends Enum<a> {
        public static final /* enum */ a lm = new a();
        public static final /* enum */ a ln = new a();
        public static final /* enum */ a lo = new a();
        public static final /* enum */ a lp = new a();
        private static final /* synthetic */ a[] lq;

        public static a[] values() {
            return (a[])lq.clone();
        }

        public static a valueOf(String name) {
            return Enum.valueOf(a.class, name);
        }

        private static /* synthetic */ a[] bR() {
            return new a[]{lm, ln, lo, lp};
        }

        static {
            lq = a.bR();
        }
    }
}

