/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.PublicApi;
import com.inet.report.CrossTab;
import com.inet.report.CrossTabBodyCell;
import com.inet.report.CrossTabHeader;
import com.inet.report.CrossTabHeaderList;
import com.inet.report.Element;
import com.inet.report.Field;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.SummaryField;
import com.inet.report.i18n.ReportErrorCode;
import com.inet.report.m;
import com.inet.report.parser.NodeParser;
import com.inet.report.y;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PublicApi
public class CrossTabBody
implements Serializable {
    private final CrossTab jc;
    private final List<CrossTabBodyCell> jd;
    private final List<SummaryField> je;

    CrossTabBody(@Nonnull CrossTab crossTab) {
        this.jc = crossTab;
        this.jd = new ArrayList<CrossTabBodyCell>();
        this.je = new ArrayList<SummaryField>();
    }

    public int getCellCount() {
        return this.jd.size();
    }

    public void removeSummaryField(int index) throws ReportException {
        if (index >= this.je.size()) {
            throw ReportExceptionFactory.createReportException(ReportErrorCode.elementNotFound, new Object[0]);
        }
        if (index < 0) {
            throw y.a("index", index, null);
        }
        SummaryField summaryField = this.je.remove(index);
        for (int i2 = 0; i2 < this.jd.size(); ++i2) {
            this.jd.get(i2).remove(index);
        }
        summaryField.getField().removeReferenceHolder(this.jc);
        this.jc.aS().be();
        this.jc.aS().bf();
    }

    public void moveSummaryField(int from, int to) {
        if (from >= this.je.size()) {
            throw y.a(from, "from", null);
        }
        if (to >= this.je.size()) {
            throw y.a(to, "to", null);
        }
        if (from < 0) {
            throw y.a("from", from, null);
        }
        if (to < 0) {
            throw y.a("to", to, null);
        }
        this.je.add(to, this.je.remove(from));
        for (int i2 = 0; i2 < this.jd.size(); ++i2) {
            this.jd.get(i2).move(from, to);
        }
        this.jc.aS().be();
        this.jc.aS().bf();
    }

    @Nonnull
    public SummaryField getSummaryField(int index) {
        return this.je.get(index);
    }

    public int getSummaryFieldsCount() {
        return this.je.size();
    }

    public SummaryField addSummaryField(@Nonnull Field field, int operation) {
        SummaryField summaryField = new SummaryField(this.jc.bB);
        summaryField.setName(field.getName());
        summaryField.setField(field);
        summaryField.setSummaryOperation(operation);
        summaryField.setSummaryFieldType(1);
        this.addSummaryField(summaryField);
        return summaryField;
    }

    void addSummaryField(@Nonnull SummaryField summaryField) {
        this.je.add(summaryField);
        for (int i2 = 0; i2 < this.jd.size(); ++i2) {
            this.jd.get(i2).b(summaryField);
        }
        this.jc.aS().be();
        this.jc.aS().bf();
        Field field = summaryField.getField();
        if (field != null) {
            field.removeReferenceHolder(summaryField);
            field.addReferenceHolder(this.jc);
        }
    }

    void aY() {
        if (this.jd.size() > 0) {
            CrossTabBodyCell crossTabBodyCell = this.jd.get(0);
            for (int i2 = this.je.size(); i2 < crossTabBodyCell.getFieldElementCount(); ++i2) {
                this.je.add((SummaryField)crossTabBodyCell.getFieldElement(i2).getField());
            }
        }
    }

    void setReferences() {
        NodeParser nodeParser;
        int n2;
        this.aY();
        for (n2 = 0; n2 < this.je.size(); ++n2) {
            nodeParser = this.je.get(n2);
            if (((Field)nodeParser).getField() != null) {
                ((Field)nodeParser).getField().addReferenceHolder(this.jc);
            }
            if (((SummaryField)nodeParser).getField2nd() == null) continue;
            ((SummaryField)nodeParser).getField2nd().addReferenceHolder(this.jc);
        }
        for (n2 = 0; n2 < this.jd.size(); ++n2) {
            nodeParser = this.jd.get(n2);
            for (int i2 = 0; i2 < ((CrossTabBodyCell)nodeParser).getFieldElementCount(); ++i2) {
                ((CrossTabBodyCell)nodeParser).getFieldElement(i2).setReferences();
            }
        }
    }

    void resetReferences() {
        NodeParser nodeParser;
        int n2;
        for (n2 = 0; n2 < this.je.size(); ++n2) {
            nodeParser = this.je.get(n2);
            if (((Field)nodeParser).getField() != null) {
                ((Field)nodeParser).getField().removeReferenceHolder(this.jc);
            }
            ((SummaryField)nodeParser).resetReferences();
        }
        for (n2 = 0; n2 < this.jd.size(); ++n2) {
            nodeParser = this.jd.get(n2);
            for (int i2 = 0; i2 < ((CrossTabBodyCell)nodeParser).getFieldElementCount(); ++i2) {
                ((CrossTabBodyCell)nodeParser).getFieldElement(i2).resetReferences();
            }
        }
    }

    @Nonnull
    public CrossTabBodyCell getCell(int idx) {
        return this.jd.get(idx);
    }

    @Nonnull
    public CrossTabBodyCell getCell(int rowIdx, int columnIdx) {
        CrossTabHeader crossTabHeader = this.jc.getRows().get(rowIdx);
        CrossTabHeader crossTabHeader2 = this.jc.getColumns().get(columnIdx);
        int n2 = this.jd.size() - rowIdx - columnIdx * this.jc.getRows().size() - 1;
        CrossTabBodyCell crossTabBodyCell = this.jd.get(n2);
        if (crossTabBodyCell.getRow() == crossTabHeader && crossTabBodyCell.getColumn() == crossTabHeader2) {
            return crossTabBodyCell;
        }
        Collections.sort(this.jd, new a(this.jc));
        crossTabBodyCell = this.jd.get(n2);
        if (crossTabBodyCell.getRow() == crossTabHeader && crossTabBodyCell.getColumn() == crossTabHeader2) {
            return crossTabBodyCell;
        }
        throw new IllegalStateException("Cell not found: " + rowIdx + ", " + columnIdx);
    }

    @Nonnull
    CrossTabBodyCell aZ() {
        return this.a(this.jd.size(), null, null);
    }

    void a(@Nullable CrossTabHeader crossTabHeader) {
        for (int i2 = 0; i2 < this.jd.size(); ++i2) {
            CrossTabBodyCell crossTabBodyCell = this.jd.get(i2);
            if (crossTabBodyCell.getRow() != crossTabHeader && crossTabBodyCell.getColumn() != crossTabHeader) continue;
            this.jd.remove(i2);
            --i2;
        }
    }

    void b(@Nonnull CrossTabHeader crossTabHeader) {
        CrossTabHeaderList crossTabHeaderList = this.jc.getColumns();
        int n2 = crossTabHeaderList.size();
        int n3 = this.jc.getRows().size();
        for (int i2 = 0; i2 < n2; ++i2) {
            CrossTabHeader crossTabHeader2 = crossTabHeaderList.get(i2);
            this.a((i2 + 1) * n3 - 1, crossTabHeader, crossTabHeader2);
        }
    }

    void c(@Nonnull CrossTabHeader crossTabHeader) {
        CrossTabHeaderList crossTabHeaderList = this.jc.getRows();
        int n2 = crossTabHeaderList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            CrossTabHeader crossTabHeader2 = crossTabHeaderList.get(i2);
            this.a(this.jd.size(), crossTabHeader2, crossTabHeader);
        }
    }

    @Nonnull
    private CrossTabBodyCell a(int n2, @Nullable CrossTabHeader crossTabHeader, @Nullable CrossTabHeader crossTabHeader2) {
        CrossTabBodyCell crossTabBodyCell = new CrossTabBodyCell(this.jc, crossTabHeader, crossTabHeader2);
        this.jd.add(n2, crossTabBodyCell);
        if (crossTabHeader != null && crossTabHeader2 != null) {
            int n3 = this.je.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                crossTabBodyCell.b(this.je.get(i2));
            }
        }
        return crossTabBodyCell;
    }

    int b(@Nullable Element element) {
        for (int i2 = this.jd.size() - 1; i2 >= 0; --i2) {
            CrossTabBodyCell crossTabBodyCell = this.jd.get(i2);
            for (int i3 = crossTabBodyCell.getFieldElementCount() - 1; i3 >= 0; --i3) {
                if (element != crossTabBodyCell.getFieldElement(i3)) continue;
                return i2;
            }
        }
        return -1;
    }

    void ba() {
        m m2 = this.jc.aS();
        for (int i2 = 0; i2 < this.jd.size(); ++i2) {
            CrossTabBodyCell crossTabBodyCell = this.jd.get(i2);
            int n2 = crossTabBodyCell.getFieldElementCount();
            for (int i3 = 0; i3 < n2; ++i3) {
                crossTabBodyCell.getFieldElement(i3).addPropertyChangeListener(m2);
            }
        }
    }

    private static class a
    implements Comparator<CrossTabBodyCell> {
        private final CrossTabHeaderList ik;
        private final CrossTabHeaderList ij;

        private a(@Nonnull CrossTab crossTab) {
            this.ik = crossTab.getRows();
            this.ij = crossTab.getColumns();
        }

        public int a(CrossTabBodyCell crossTabBodyCell, CrossTabBodyCell crossTabBodyCell2) {
            int n2;
            int n3 = this.ij.g(crossTabBodyCell.getColumn());
            if (n3 == (n2 = this.ij.g(crossTabBodyCell2.getColumn()))) {
                int n4;
                int n5 = this.ik.g(crossTabBodyCell.getRow());
                return n5 < (n4 = this.ik.g(crossTabBodyCell2.getRow())) ? 1 : (n5 == n4 ? 0 : -1);
            }
            return n3 < n2 ? 1 : -1;
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.a((CrossTabBodyCell)object, (CrossTabBodyCell)object2);
        }
    }
}

