/*
 * Decompiled with CFR 0.152.
 */
package com.inet.viewer;

import com.inet.annotations.PublicApi;
import com.inet.viewer.ReportView;
import com.inet.viewer.ViewerContext;
import com.inet.viewer.ViewerException;
import com.inet.viewer.ViewerUtils;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

@PublicApi
public abstract class Progress
implements Runnable {
    public static final int TYPE_PAGELOADER = 0;
    public static final int TYPE_PRINT = 1;
    public static final int TYPE_EXPORT = 2;
    public static final int TYPE_SEARCH = 3;
    public static final int TYPE_INVISIBLE = 4;
    public static final int STATUS_NOT_INITIALIZED = -1;
    public static final int STATUS_INITIALIZED = 0;
    public static final int STATUS_RUNNING = 1;
    public static final int STATUS_COMPLETED = 2;
    public static final int STATUS_CANCELED = 3;
    public static final int STATUS_ERROR = 4;
    public static final int STATUS_IDLE = 5;
    public static final String PROP_PROGRESS_STATUS = "ProgressStatus";
    public static final String PROP_PROGRESS_TOTAL = "ProgressTotal";
    public static final String PROP_PROGRESS_STEP = "ProgressStep";
    public static final String PROP_PROGRESS_INDETERMINATE = "ProgressIndeterminate";
    private int bwb = -1;
    protected final PropertyChangeSupport bBj = new PropertyChangeSupport(this);
    private int type;
    private int bBk;
    private int progress;
    private boolean bBl = false;
    private String afY;
    private ReportView bBm;
    private ViewerContext bxC;
    private Component bzD;
    Thread bBn;

    public Progress(ReportView reportView, int type) {
        this.type = type;
        this.bBm = reportView;
        if (reportView != null) {
            reportView.getReportViewer().getProgressPool().a(this);
            this.bzD = reportView.getComponent();
            this.bxC = reportView.getReportViewer().getViewerContext();
        }
        this.setStatus(0);
    }

    public Progress(Component parent, ViewerContext viewerContext, int type) {
        this.type = type;
        this.bxC = viewerContext;
        this.bzD = parent;
        this.setStatus(0);
    }

    public final void startProgress() {
        if (this.bBn != null && this.bBn.isAlive()) {
            throw new ViewerException("Progress '" + this.getName() + "' is already running");
        }
        this.bBn = new Thread((Runnable)this, this.getName());
        this.bBn.setPriority(5);
        this.setStatus(1);
        this.setErrorMessage(null);
        if (this.bBl) {
            this.bBn.setDaemon(true);
            this.setTotalProgress(1);
        }
        this.bBn.start();
    }

    public abstract String getName();

    public abstract void cancel();

    public int getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilFinished() {
        try {
            Progress progress = this;
            synchronized (progress) {
                while (!this.isFinished()) {
                    this.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean isIndeterminate() {
        return this.bBl;
    }

    public void setIndeterminate(boolean indeterminate) {
        boolean bl2 = this.bBl;
        this.bBl = indeterminate;
        this.bBj.firePropertyChange(PROP_PROGRESS_INDETERMINATE, bl2, indeterminate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(int status) {
        int n2 = this.bwb;
        this.bwb = status;
        this.bBj.firePropertyChange(PROP_PROGRESS_STATUS, n2, this.bwb);
        Progress progress = this;
        synchronized (progress) {
            this.notifyAll();
        }
    }

    public boolean isFinished() {
        boolean bl2 = this.bwb == 3 || this.bwb == 2 || this.bwb == 4;
        return bl2;
    }

    public boolean isCanceled() {
        return this.bwb == 3;
    }

    public boolean isErrored() {
        return this.bwb == 4;
    }

    public void setTotalProgress(int total) {
        int n2 = this.bBk;
        this.bBk = total;
        if (total == 0) {
            this.setStatus(5);
        } else if (this.getStatus() == 5) {
            this.setStatus(1);
        }
        this.bBj.firePropertyChange(PROP_PROGRESS_TOTAL, n2, total);
    }

    public int getTotalProgress() {
        return this.bBk;
    }

    public void setProgress(int step) {
        int n2 = this.progress;
        this.progress = step;
        this.bBj.firePropertyChange(PROP_PROGRESS_STEP, n2, this.progress);
    }

    public int getProgress() {
        return this.progress;
    }

    public ReportView getReportView() {
        return this.bBm;
    }

    public int getStatus() {
        return this.bwb;
    }

    public String getErrorMessage() {
        return this.afY;
    }

    public void setErrorMessage(String msg) {
        this.afY = msg;
    }

    public void showError(Throwable th) {
        this.setErrorMessage(th.getMessage());
        this.setStatus(4);
        if (this.bxC == null) {
            ViewerUtils.printStackTrace(th);
        } else {
            this.bxC.showError(th, this.bzD);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l2) {
        this.bBj.addPropertyChangeListener(l2);
    }

    public void removePropertyChangeListener(PropertyChangeListener l2) {
        this.bBj.removePropertyChangeListener(l2);
    }

    protected void NL() {
        PropertyChangeListener[] propertyChangeListenerArray = this.bBj.getPropertyChangeListeners();
        for (int i2 = 0; i2 < propertyChangeListenerArray.length; ++i2) {
            this.bBj.removePropertyChangeListener(propertyChangeListenerArray[i2]);
        }
    }
}

