/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.util.image;

import com.inet.annotations.InternalApi;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;

@InternalApi
public class ImageReflection {
    private int bwU = 30;
    private int width = 96;
    private int jm = 96;
    private boolean bwV = false;
    private boolean bwW = false;
    private Color bwX = Color.WHITE;
    private Color bwY = null;
    private int bwZ = 0;
    private CenterMode bxa = CenterMode.baseline;
    private int bxb = 0;
    private Color bxc = Color.GRAY;
    private boolean bxd = true;
    private int bxe = 170;
    private Insets bxf = new Insets(0, 0, 0, 0);

    public void setReflectionSize(int reflectSize, boolean percent) {
        this.bwU = reflectSize;
        this.bwW = percent;
    }

    public void setTargetSize(int width, int height, boolean percent) {
        this.width = width;
        this.jm = height;
        this.bwV = percent;
    }

    public void setReflectionBGColor(Color bgColor) {
        this.bwX = bgColor;
    }

    public void setCenterMode(CenterMode mode) {
        this.bxa = mode;
    }

    public void setBorder(int size, Color color) {
        this.bxb = size;
        this.bxc = color;
    }

    public void setReflectBorder(boolean reflectBorder) {
        this.bxd = reflectBorder;
    }

    public void setLabelBg(Color labelBg, int radius) {
        this.bwY = labelBg;
        this.bwZ = radius;
    }

    private Dimension a(Dimension dimension) {
        int n2 = this.bwV ? dimension.width * this.width / 100 : this.width;
        int n3 = this.bwV ? dimension.height * this.jm / 100 : this.jm;
        return new Dimension(n2, n3);
    }

    private Dimension a(Dimension dimension, Dimension dimension2) {
        if (!this.bwV && this.bxa != CenterMode.autoscale) {
            if (dimension.width == dimension.height) {
                return dimension2;
            }
            if (dimension.width < dimension.height) {
                double d2 = (double)dimension.height / (double)dimension2.height;
                return new Dimension((int)Math.round((double)dimension.width / d2), dimension2.height);
            }
            double d3 = (double)dimension.width / (double)dimension2.width;
            return new Dimension(dimension2.width, (int)Math.round((double)dimension.height / d3));
        }
        return dimension2;
    }

    private int b(Dimension dimension, Dimension dimension2) {
        int n2 = dimension.height - dimension2.height;
        switch (this.bxa) {
            case autoscale: {
                return 0;
            }
            case center: {
                return n2 / 2;
            }
            case baseline: {
                return n2;
            }
        }
        return 0;
    }

    private void a(Rectangle rectangle, Graphics2D graphics2D) {
        if (this.bxb > 0) {
            rectangle.x += this.bxb / 2;
            rectangle.y += this.bxb / 2;
            rectangle.height -= this.bxb;
            rectangle.width -= this.bxb;
            graphics2D.setColor(this.bxc);
            graphics2D.setStroke(new BasicStroke(this.bxb));
            graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public void setStartAlpha(int alpha) {
        this.bxe = alpha < 0 ? 0 : (alpha > 255 ? 255 : alpha);
    }

    public void setMargin(Insets margin) {
        this.bxf = margin;
    }

    private float jh(int n2) {
        int n3 = 255;
        int n4 = n2 >> 16 & n3;
        int n5 = n2 >> 8 & n3;
        int n6 = n2 & n3;
        int n7 = n2 >> 24 & n3;
        float f2 = (0.3f * (float)n4 + 0.59f * (float)n5 + 0.11f * (float)n6) * (float)n7;
        return f2;
    }

    private int a(int n2, float f2) {
        int n3 = n2 >> 24 & 0xFF;
        n3 = (int)((float)n3 * f2);
        return (n3 << 24) + (n2 & 0xFFFFFF);
    }

    public BufferedImage filterGlow(BufferedImage input, int radius, Rectangle clip) {
        BufferedImage bufferedImage = new BufferedImage(input.getWidth(), input.getHeight(), input.getType());
        for (int i2 = clip.x; i2 < clip.width + clip.x; ++i2) {
            for (int i3 = clip.y; i3 < clip.height + clip.y; ++i3) {
                int n2;
                int n3 = 0;
                float f2 = 0.0f;
                float f3 = Float.MAX_VALUE;
                for (n2 = -radius; n2 <= radius; ++n2) {
                    for (int i4 = -radius; i4 <= radius; ++i4) {
                        int n4 = this.a(input, i2 + n2, i3 + i4);
                        float f4 = (float)Math.sqrt(n2 * n2 + i4 * i4);
                        float f5 = this.jh(n4) * (1.0f - f4 / (float)radius);
                        if (!(f5 > f2) || !(f4 <= (float)radius)) continue;
                        n3 = n4;
                        f2 = f5;
                        f3 = f4;
                    }
                }
                if (!(f2 > 0.0f)) continue;
                n2 = this.a(n3, 1.0f - f3 / (float)radius);
                bufferedImage.setRGB(i2, i3, n2);
            }
        }
        return bufferedImage;
    }

    private int a(BufferedImage bufferedImage, int n2, int n3) {
        if (n2 >= 0 && n3 >= 0 && n2 < bufferedImage.getWidth() && n3 < bufferedImage.getHeight()) {
            return bufferedImage.getRGB(n2, n3);
        }
        return 0;
    }

    private void a(String string, Font font, Color color, Graphics2D graphics2D, int n2, int n3) {
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
        Object object = string;
        int n4 = string.length();
        while (fontMetrics.stringWidth((String)object) > n2) {
            object = string.substring(0, --n4) + "...";
        }
        Rectangle2D rectangle2D = fontMetrics.getStringBounds((String)object, graphics2D);
        graphics2D.setFont(font);
        graphics2D.setColor(color);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.drawString((String)object, (int)(((double)n2 - rectangle2D.getWidth()) / 2.0), n3 - (int)(rectangle2D.getHeight() / 2.0) + fontMetrics.getAscent());
    }

    private void a(String string, Font font, Color color, Graphics2D graphics2D, Rectangle rectangle) {
        Rectangle rectangle2 = graphics2D.getClip().getBounds();
        BufferedImage bufferedImage = new BufferedImage(rectangle2.width, rectangle2.height, 2);
        Graphics2D graphics2D2 = (Graphics2D)bufferedImage.getGraphics();
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
        Object object = string;
        int n2 = string.length();
        while (fontMetrics.stringWidth((String)object) > rectangle2.width) {
            object = string.substring(0, --n2) + "...";
        }
        Rectangle2D rectangle2D = fontMetrics.getStringBounds((String)object, graphics2D);
        graphics2D2.setFont(font);
        graphics2D2.setColor(this.bwY);
        graphics2D2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        graphics2D2.drawString((String)object, (int)(((double)rectangle2.width - rectangle2D.getWidth()) / 2.0), (int)(rectangle2D.getHeight() / 2.0) + fontMetrics.getAscent());
        Rectangle rectangle3 = this.bwY.equals(this.bwX) ? new Rectangle((rectangle2.width - rectangle.width) / 2, 0, rectangle.width, rectangle2.height) : rectangle2;
        bufferedImage = this.filterGlow(bufferedImage, this.bwZ, rectangle3);
        graphics2D2 = (Graphics2D)bufferedImage.getGraphics();
        graphics2D2.setFont(font);
        graphics2D2.setColor(color);
        graphics2D2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D2.drawString((String)object, (int)(((double)rectangle2.width - rectangle2D.getWidth()) / 2.0), (int)(rectangle2D.getHeight() / 2.0) + fontMetrics.getAscent());
        graphics2D.drawImage(bufferedImage, rectangle2.x, rectangle2.y, new Color(0, 0, 0, 0), null);
    }

    public Image createReflection(Image img) {
        return this.createReflection(img, null, null, null);
    }

    public Image createReflection(Image img, String label, Color labelColor, Font labelFont) {
        Serializable serializable;
        Object object;
        Dimension dimension = new Dimension(img.getWidth(null), img.getHeight(null));
        Dimension dimension2 = this.a(dimension);
        Dimension dimension3 = this.a(dimension, dimension2);
        int n2 = this.b(dimension2, dimension3) + this.bxf.top;
        dimension2.height += this.bxf.top + this.bxf.bottom;
        dimension2.width += this.bxf.left + this.bxf.right;
        int n3 = (dimension2.width - dimension3.width) / 2;
        int n4 = n2 + dimension3.height;
        int n5 = this.bwW ? this.bwU * dimension2.height / 100 : this.bwU;
        int n6 = dimension2.height + n5;
        BufferedImage bufferedImage = new BufferedImage(dimension2.width, n6, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setColor(this.bwX);
        graphics2D.fillRect(0, 0, dimension2.width, n6);
        graphics2D.drawImage(img, n3, n2, dimension3.width, dimension3.height, this.bwX, null);
        if (n5 > 0) {
            object = graphics2D.getClip();
            if (!this.bxd) {
                serializable = new Rectangle(n3 + this.bxb, n4, dimension3.width - this.bxb * 2, n5);
                graphics2D.setClip((Shape)((Object)serializable));
            }
            graphics2D.drawImage(img, n3, n4, n3 + dimension3.width, n2 + dimension3.height * 2, 0, dimension.height, dimension.width, 0, this.bwX, null);
            graphics2D.setClip((Shape)object);
        }
        this.a(new Rectangle(n3, n2, dimension3.width, dimension3.height), graphics2D);
        if (n5 > 0) {
            if (this.bxd) {
                this.a(new Rectangle(n3, n4 - 1, dimension3.width, dimension3.height), graphics2D);
            }
            object = new Color(this.bwX.getRed(), this.bwX.getGreen(), this.bwX.getBlue(), this.bxe);
            serializable = new Color(this.bwX.getRed(), this.bwX.getGreen(), this.bwX.getBlue(), 255);
            GradientPaint gradientPaint = new GradientPaint(0.0f, n4, (Color)object, 0.0f, n4 + n5, (Color)serializable);
            graphics2D.setPaint(gradientPaint);
            graphics2D.fillRect(0, n4, dimension2.width, n6);
            if (label != null) {
                Rectangle rectangle = new Rectangle(0, n4, (int)dimension2.getWidth(), n5);
                graphics2D.setClip(rectangle);
                if (this.bwY == null || this.bwZ <= 0 || this.bxe == 255) {
                    this.a(label, labelFont, labelColor, graphics2D, (int)dimension2.getWidth(), n4 + n5 / 2);
                } else {
                    this.a(label, labelFont, labelColor, graphics2D, new Rectangle(n3, n2, dimension3.width, dimension3.height));
                }
            }
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    public static void main(String[] args) throws MalformedURLException {
        ImageIcon imageIcon = new ImageIcon(new URL("http://trac/CC/chrome/site/logo.gif"));
        ImageReflection imageReflection = new ImageReflection();
        imageReflection.setReflectionSize(40, false);
        imageReflection.setTargetSize(200, 200, false);
        imageReflection.setCenterMode(CenterMode.baseline);
        imageReflection.setReflectionBGColor(Color.WHITE);
        imageReflection.setBorder(0, Color.GRAY);
        imageReflection.setStartAlpha(70);
        imageReflection.setReflectBorder(false);
        imageReflection.setMargin(new Insets(200, 100, 200, 100));
        imageReflection.setLabelBg(Color.WHITE, 5);
        JFrame jFrame = new JFrame();
        JLabel jLabel = new JLabel(new ImageIcon(imageReflection.createReflection(imageIcon.getImage(), "TestlabelTestlabelTestlabelTestlabelTestlabelTestlabelTestlabelTestlabelTestlabelTestlabelTestlabelTestlabelTestlabelTestlabelTestlabelTestlabelTestlabelTestlabelTestlabelTestlabelTestlabel", Color.BLACK, new Font("SansSerif", 0, 11))));
        jFrame.setBackground(Color.GRAY);
        jLabel.setBackground(Color.GRAY);
        jLabel.setOpaque(false);
        jFrame.setLayout(new BorderLayout());
        jFrame.add((Component)jLabel, "Center");
        jFrame.pack();
        jFrame.setVisible(true);
        jFrame.setDefaultCloseOperation(3);
    }

    @InternalApi
    public static final class CenterMode
    extends Enum<CenterMode> {
        public static final /* enum */ CenterMode center = new CenterMode();
        public static final /* enum */ CenterMode baseline = new CenterMode();
        public static final /* enum */ CenterMode autoscale = new CenterMode();
        private static final /* synthetic */ CenterMode[] bxh;

        public static CenterMode[] values() {
            return (CenterMode[])bxh.clone();
        }

        public static CenterMode valueOf(String name) {
            return Enum.valueOf(CenterMode.class, name);
        }

        private static /* synthetic */ CenterMode[] MD() {
            return new CenterMode[]{center, baseline, autoscale};
        }

        static {
            bxh = CenterMode.MD();
        }
    }
}

