/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.jsonrpc;

import com.inet.http.PluginServlet;
import com.inet.http.error.ServletErrorHandler;
import com.inet.lib.io.UTF8StreamWriter;
import com.inet.lib.json.EncodedReader;
import com.inet.lib.json.LazyEncodedWriter;
import com.inet.permissions.AccessDeniedException;
import com.inet.plugin.ServerPluginManager;
import com.inet.report.BaseUtils;
import com.inet.report.jsonrpc.JsonRpcPacketHandler;
import com.inet.report.jsonrpc.JsonRpcResultError;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Hashtable;
import java.util.List;
import java.util.zip.GZIPInputStream;
import javax.annotation.Nonnull;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class a
extends HttpServlet
implements PluginServlet {
    private static final Hashtable<String, JsonRpcPacketHandler> aqX = new Hashtable();

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            List list = ServerPluginManager.getInstance().get(JsonRpcPacketHandler.class);
            for (JsonRpcPacketHandler jsonRpcPacketHandler : list) {
                aqX.put(jsonRpcPacketHandler.getCommand(), jsonRpcPacketHandler);
            }
        }
        catch (Throwable throwable) {
            BaseUtils.error(throwable);
        }
    }

    @Nonnull
    public String getPathSpec() {
        return "/jsonrpc";
    }

    public void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        try {
            int n2;
            String string = req.getPathInfo();
            if (string != null && string.length() > 1) {
                n2 = string.indexOf(47, 1);
                if (n2 < 0) {
                    n2 = string.length();
                }
            } else {
                a.a(res, "Invalid Json RPC Url: " + string);
                return;
            }
            string = string.substring(1, n2);
            Object object = req.getInputStream();
            String string2 = req.getHeader("Content-Encoding");
            if (string2 != null && string2.equalsIgnoreCase("gzip")) {
                object = new GZIPInputStream((InputStream)object);
            }
            try (EncodedReader encodedReader = new EncodedReader((InputStream)object);){
                JsonRpcPacketHandler jsonRpcPacketHandler = aqX.get(string);
                if (jsonRpcPacketHandler != null) {
                    res.setContentType("application/binary-json");
                    ServletOutputStream servletOutputStream = res.getOutputStream();
                    LazyEncodedWriter lazyEncodedWriter = new LazyEncodedWriter(encodedReader, (OutputStream)servletOutputStream);
                    jsonRpcPacketHandler.handle(req, (Reader)encodedReader, (Writer)lazyEncodedWriter);
                    lazyEncodedWriter.close();
                } else {
                    a.a(res, "The command cannot be found: " + string + "\nAre the required plugins for this interface installed, activated and error-free? See the server's local plugin store for details.");
                }
            }
        }
        catch (AccessDeniedException accessDeniedException) {
            ServletErrorHandler.sendErrorPage((HttpServletRequest)req, (HttpServletResponse)res, (Throwable)accessDeniedException);
        }
        catch (Throwable throwable) {
            BaseUtils.error(throwable);
            a.a(res, "Exception occurred while handling the request on the server: " + throwable.toString());
        }
    }

    private static void a(HttpServletResponse httpServletResponse, String string) throws IOException {
        httpServletResponse.setContentType("application/error-json");
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        UTF8StreamWriter uTF8StreamWriter = new UTF8StreamWriter((OutputStream)servletOutputStream);
        JsonRpcResultError jsonRpcResultError = new JsonRpcResultError(null, 0, string);
        JsonRpcPacketHandler.JSON.toJson((Object)jsonRpcResultError, (Appendable)uTF8StreamWriter);
        uTF8StreamWriter.close();
    }
}

