/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.encode;

import com.inet.report.BaseUtils;
import com.inet.report.encode.AbstractDecoder;
import java.awt.image.BufferedImage;

public final class RawDecoder
extends AbstractDecoder {
    static final byte[] agv = "raw".getBytes();
    private int width;
    private int jm;
    private int vS;
    private byte agw;

    @Override
    public void setBuffer(byte[] buffer, int offset, int length) {
        super.setBuffer(buffer, offset, length);
        this.vS = offset;
    }

    @Override
    protected BufferedImage decodeImage(int w2, int h2) {
        BufferedImage bufferedImage = null;
        byte[] byArray = new byte[]{this.buffer[this.oQ()], this.buffer[this.oQ()], this.buffer[this.oQ()]};
        if (byArray[0] != agv[0] || byArray[1] != agv[1] || byArray[2] != agv[2]) {
            BaseUtils.info("wrong image type: " + (char)byArray[0] + (char)byArray[1] + (char)byArray[2]);
        }
        this.agw = this.buffer[this.oQ()];
        this.width = this.readInt();
        this.jm = this.readInt();
        int[] nArray = new int[this.width * this.jm];
        switch (this.agw) {
            case 32: {
                for (int i2 = 0; i2 < nArray.length; ++i2) {
                    nArray[i2] = this.oR();
                }
                bufferedImage = new BufferedImage(this.width, this.jm, 2);
                bufferedImage.setRGB(0, 0, this.width, this.jm, nArray, 0, this.width);
                break;
            }
            default: {
                BaseUtils.info("Invalid raw bpp: " + this.agw);
                return null;
            }
        }
        return bufferedImage;
    }

    private int oQ() {
        return this.vS++;
    }

    private int readInt() {
        return ((this.buffer[this.oQ()] & 0xFF) << 24) + ((this.buffer[this.oQ()] & 0xFF) << 16) + ((this.buffer[this.oQ()] & 0xFF) << 8) + (this.buffer[this.oQ()] & 0xFF);
    }

    private int oR() {
        int n2 = this.buffer[this.oQ()] & 0xFF;
        int n3 = this.buffer[this.oQ()] & 0xFF;
        int n4 = this.buffer[this.oQ()] & 0xFF;
        int n5 = this.buffer[this.oQ()] & 0xFF;
        return (n2 << 24) + (n5 << 16) + (n4 << 8) + n3;
    }
}

