/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.database;

import com.inet.annotations.PublicApi;
import com.inet.logging.LogManager;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PublicApi
public class TableSourceInfo {
    @Nullable
    private final String aaf;
    private final String abS;
    private final String abT;
    private final String name;
    private final int type;
    public static final int TYPE_TABLE = 0;
    public static final int TYPE_SYSTEM_TABLE = 1;
    public static final int TYPE_VIEW = 10;
    public static final int TYPE_SPROC = 20;

    public TableSourceInfo(@Nullable String catalog, @Nullable String schema, @Nonnull String table, int type) {
        StringBuilder stringBuilder = new StringBuilder();
        if (catalog != null) {
            catalog = catalog.trim();
            stringBuilder.append(catalog);
        }
        if (schema != null) {
            schema = schema.trim();
            if (stringBuilder.length() > 0 && schema.length() > 0) {
                stringBuilder.append('.');
            }
            stringBuilder.append(schema);
        }
        if (table == null) {
            throw new IllegalArgumentException("null argument 'table'");
        }
        table = table.trim();
        if (stringBuilder.length() > 0 && table.length() > 0) {
            stringBuilder.append('.');
        }
        stringBuilder.append(table);
        this.aaf = catalog;
        this.abS = schema;
        this.abT = table;
        this.name = stringBuilder.toString();
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getCatalog() {
        return this.aaf;
    }

    @Nullable
    public String getSchema() {
        return this.abS;
    }

    public String getTable() {
        return this.abT;
    }

    public int getType() {
        return this.type;
    }

    @Deprecated
    public int getProcedureType() {
        LogManager.deprecatedMessage();
        return 0;
    }
}

