/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.config.datasource;

import com.inet.annotations.InternalApi;
import com.inet.classloader.LoaderUtils;
import com.inet.lib.core.OS;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.report.config.datasource.DataSourceConfiguration;
import com.inet.report.config.datasource.widget.DriverProperty;
import com.inet.report.config.datasource.widget.DriverStyleSheet;
import com.inet.report.config.datasource.widget.DriverStyleSheetFactory;
import com.inet.report.database.DataFactory;
import com.inet.report.util.ClassFinder;
import java.sql.Driver;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

@InternalApi
public class DriverFinder {
    private final Locale Yk;
    private static final Map<String, DriverFinder> aat = new HashMap<String, DriverFinder>();

    private DriverFinder(Locale locale) {
        this.Yk = locale;
    }

    public static DriverFinder getInstance(Locale locale) {
        if (aat.get(locale.getLanguage()) == null) {
            aat.put(locale.getLanguage(), new DriverFinder(locale));
        }
        return aat.get(locale.getLanguage());
    }

    public void loadAllDrivers(List<Object[]> rows, Map<String, String> nameToDriver) {
        this.a(rows, nameToDriver);
        this.a(rows, nameToDriver, ClassFinder.getAllDriverClassesWithServiceProvider());
        this.a(rows, nameToDriver, ClassFinder.getAllDriverAndDatabaseClasses());
    }

    private void a(List<Object[]> list, Map<String, String> map) {
        DriverStyleSheet[] driverStyleSheetArray = DriverStyleSheetFactory.getInstance(this.Yk).getDriverStyleSheets();
        for (int i2 = 0; i2 < driverStyleSheetArray.length; ++i2) {
            DriverStyleSheet driverStyleSheet;
            block9: {
                driverStyleSheet = driverStyleSheetArray[i2];
                String string = driverStyleSheet.getDriverClassName();
                String string2 = driverStyleSheet.getDriverCompany();
                if (!StringFunctions.isEmpty((String)string)) {
                    var8_8 = DataSourceConfiguration.getDriverObject(string);
                    if (var8_8 != null) {
                        if (!OS.isWindows() && "File MS Access (*.mdb)".equals(driverStyleSheet.getDisplayName())) continue;
                        list.add(new Object[]{driverStyleSheet.getDisplayName(), string, string2, this.a((Driver)var8_8)});
                    }
                } else {
                    try {
                        var8_8 = null;
                        for (int i3 = 0; i3 < driverStyleSheet.getPropertyCount(); ++i3) {
                            DriverProperty driverProperty = driverStyleSheet.getDriverProperty(i3);
                            if (!driverProperty.getName().equals("databaseClassName") || driverProperty.getDefaultValue().length() == 0) continue;
                            var8_8 = driverProperty.getDefaultValue();
                            break;
                        }
                        if (var8_8 == null) continue;
                        DataFactory dataFactory = null;
                        for (DataFactory dataFactory2 : ServerPluginManager.getInstance().get(DataFactory.class)) {
                            if (!dataFactory2.getClass().getName().equals(var8_8)) continue;
                            dataFactory = dataFactory2;
                            break;
                        }
                        if (dataFactory == null) {
                            dataFactory = (DataFactory)LoaderUtils.classForName((String)var8_8, (Object)this).newInstance();
                        }
                        if (dataFactory == null) break block9;
                        list.add(new Object[]{driverStyleSheet.getDisplayName(), var8_8, string2, Objects.requireNonNull(dataFactory.getVersion())});
                    }
                    catch (Throwable throwable) {
                        continue;
                    }
                }
            }
            map.put(driverStyleSheet.getDisplayName(), driverStyleSheet.getDriverClassName());
        }
    }

    private void a(List<Object[]> list, Map<String, String> map, Class<?>[] classArray) {
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            Driver driver = DataSourceConfiguration.getDriverObject(classArray[i2]);
            if (driver == null) continue;
            String string = driver.getClass().getName();
            list.add(new Object[]{string, string, "", this.a(driver)});
            map.put(string, string);
        }
    }

    private String a(Driver driver) {
        return driver == null ? "" : driver.getMajorVersion() + "." + driver.getMinorVersion();
    }
}

