/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.chart.plot;

import com.inet.annotations.PublicApi;
import com.inet.jfree.chart.labels.CategoryItemLabelGenerator;
import com.inet.report.Chart2;
import com.inet.report.chart.a;
import com.inet.report.chart.axis.ContinuousNumberAxis;
import com.inet.report.chart.axis.GroupAxis;
import com.inet.report.chart.dataset.LabelProvider;
import com.inet.report.chart.dataset.StockDataset;
import com.inet.report.chart.format.FormatingProperties;
import com.inet.report.chart.plot.AbstractPlot;
import com.inet.report.chart.plot.ChartStyle;
import com.inet.report.chart.plot.StockStyle;
import com.inet.report.i;
import java.io.PrintWriter;
import java.util.List;
import java.util.Locale;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@PublicApi
public class StockPlot
extends AbstractPlot {
    public static final StockStyle DEFAULT_STYLE = StockStyle.STOCK_HIGH_LOW;
    private StockStyle ZR;
    private StockDataset ZS;
    private GroupAxis Zm;
    private ContinuousNumberAxis ZT;
    private int YW;
    private int Zo;

    public StockPlot() {
        this(DEFAULT_STYLE);
    }

    public StockPlot(StockStyle style) {
        if (style == null) {
            throw i.d("style");
        }
        this.ZR = style;
        this.setCategoryAxis(new GroupAxis());
        this.setDataAxis(new ContinuousNumberAxis());
        this.YW = 0;
        this.Zo = 10;
    }

    @Override
    public StockDataset getDataset() {
        return this.ZS;
    }

    public void setDataset(StockDataset dataset) {
        if (dataset == null) {
            throw i.d("dataset");
        }
        this.ZS = dataset;
        this.ZS.updateReferences();
    }

    public GroupAxis getCategoryAxis() {
        return this.Zm;
    }

    public void setCategoryAxis(GroupAxis categoryAxis) {
        if (categoryAxis == null) {
            throw i.d("categoryAxis");
        }
        this.Zm = categoryAxis;
    }

    public ContinuousNumberAxis getDataAxis() {
        return this.ZT;
    }

    public void setDataAxis(ContinuousNumberAxis dataAxis) {
        if (dataAxis == null) {
            throw i.d("dataAxis");
        }
        this.ZT = dataAxis;
    }

    @Override
    public ChartStyle getStyle() {
        return this.ZR;
    }

    public void setStyle(StockStyle style) {
        if (style == null) {
            throw i.d("style");
        }
        this.ZR = style;
    }

    public int getItemLabelAlignment() {
        return this.YW;
    }

    public void setItemLabelAlignment(int itemLabelAlignment) {
        i.t(itemLabelAlignment);
        this.YW = itemLabelAlignment;
    }

    public int getItemLabelPosition() {
        return this.Zo;
    }

    public void setItemLabelPosition(int itemLabelPosition) {
        i.u(itemLabelPosition);
        this.Zo = itemLabelPosition;
    }

    @Override
    CategoryItemLabelGenerator b(FormatingProperties formatingProperties) {
        Locale locale = formatingProperties.getLocale();
        return i.a((AbstractPlot)this, locale);
    }

    @Override
    public void refreshAutoTitles(Chart2 chart) {
        if (this.ZS != null) {
            LabelProvider labelProvider = this.ZS.getLabelProvider();
            a.setAutoTitle(chart.getHeaderTitle(), labelProvider.getLabel(0));
        }
    }

    @Override
    protected void B(PrintWriter printWriter, int n2) {
        super.B(printWriter, n2);
        int n3 = ++n2;
        ++n2;
        AbstractPlot.a(printWriter, n3, this.ZS, this.Zm, this.ZT);
    }

    @Override
    protected StringBuilder cl(int n2) {
        return AbstractPlot.a(super.cl(n2), n2, this.getItemLabelAlignment(), this.getItemLabelPosition());
    }

    @Override
    public void readProperties(Element element, Chart2 chart) {
        super.readProperties(element, chart);
        NodeList nodeList = element.getChildNodes();
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            int n2;
            String string;
            if (!(nodeList.item(i2) instanceof Element)) continue;
            Element element2 = (Element)nodeList.item(i2);
            if (element2.getNodeName().equals("CategoryAxis")) {
                this.Zm.readProperties(element2, chart);
                continue;
            }
            if (element2.getNodeName().equals("DataAxis")) {
                this.ZT.readProperties(element2, chart);
                continue;
            }
            if (element2.getNodeName().equals("ItemLabelPosition")) {
                string = element2.getAttribute("value");
                if (string.length() <= 0 || (n2 = Integer.parseInt(string)) != 13 && n2 != 12 && n2 != 11 && n2 != 10) continue;
                this.setItemLabelPosition(n2);
                continue;
            }
            if (element2.getNodeName().equals("ItemLabelAlignment")) {
                string = element2.getAttribute("value");
                if (string.length() <= 0 || (n2 = Integer.parseInt(string)) != 0 && n2 != 2 && n2 != 1) continue;
                this.setItemLabelAlignment(n2);
                continue;
            }
            if (!element2.getNodeName().equals("Dataset")) continue;
            this.setDataset((StockDataset)com.inet.report.chart.dataset.a.b(element2, chart));
        }
    }

    @Override
    public List getReferencedObject() {
        List list = super.getReferencedObject();
        list.addAll(this.Zm.getReferencedObjects());
        list.addAll(this.ZT.getReferencedObjects());
        return list;
    }
}

